/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseFile;
import cgat.DiskFile;
import cgat.UrlFile;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class InfoSegments {
    ArrayList segNameList;
    ArrayList segDirList;

    public InfoSegments() {
        this.clear();
    }

    public void clear() {
        this.segNameList = new ArrayList();
        this.segDirList = new ArrayList();
    }

    public void insert(String name, String dir) {
        this.segNameList.add(name);
        this.segDirList.add(dir);
    }

    public int size() {
        return this.segNameList.size();
    }

    public String getName(int index) {
        if (index < 0 || this.size() <= index) {
            return null;
        }
        return (String)this.segNameList.get(index);
    }

    public String getDir(int index) {
        if (index < 0 || this.size() <= index) {
            return null;
        }
        return (String)this.segDirList.get(index);
    }

    public boolean load(String filename) {
        DiskFile infoSegsFile;
        this.clear();
        if (filename.startsWith("http://")) {
            UrlFile infoSegsFile2;
            try {
                infoSegsFile2 = new UrlFile(filename);
            }
            catch (Exception e) {
                return false;
            }
            return this.parse(infoSegsFile2);
        }
        try {
            infoSegsFile = new DiskFile(filename);
        }
        catch (Exception e) {
            return false;
        }
        return this.parse(infoSegsFile);
    }

    public boolean parse(BaseFile bf) {
        try {
            String buf;
            while ((buf = bf.readLine()) != null && !"".equals(buf)) {
                StringTokenizer token = new StringTokenizer(buf, "\t");
                String name = token.nextToken();
                String dir = token.nextToken();
                this.insert(name, dir);
            }
        }
        catch (Exception e) {
            System.err.println("File read error : InfoSegs");
            return false;
        }
        return true;
    }
}

