/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.MbgdDataMng;
import cgat.RegionInfo;
import cgat.ViewWindow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;

public class InputRegionCommand
implements ActionListener {
    private int dataType;
    private MbgdDataMng mbgdDataMng;
    private ViewWindow viewWin;

    public InputRegionCommand(int type2, MbgdDataMng dataMng, ViewWindow vWin) {
        this.dataType = type2;
        this.mbgdDataMng = dataMng;
        this.viewWin = vWin;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JTextField) {
            JTextField tf = (JTextField)e.getSource();
            try {
                int pos = Integer.valueOf(tf.getText());
                if (0 < pos && pos <= this.mbgdDataMng.getGenomeLength(this.dataType)) {
                    switch (this.dataType) {
                        case 2: {
                            boolean basespec = true;
                            this.viewWin.viewPos(pos);
                            break;
                        }
                        default: {
                            boolean basespec = false;
                        }
                    }
                }
            }
            catch (NumberFormatException nfe) {
                String orfName = tf.getText().toUpperCase();
                switch (this.dataType) {
                    case 2: {
                        boolean basespec = true;
                        RegionInfo r = this.mbgdDataMng.getGeneInfo(basespec, orfName);
                        if (r != null) {
                            int pos = (r.getFrom() + r.getTo()) / 2;
                            this.viewWin.viewPos(pos);
                            break;
                        }
                    }
                    default: {
                        boolean basespec = false;
                        RegionInfo r = this.mbgdDataMng.getGeneInfo(basespec, orfName);
                        if (r != null) {
                            int pos = (r.getFrom() + r.getTo()) / 2;
                            this.viewWin.viewPos(this.viewWin.getRegCenter(!basespec), pos);
                            break;
                        }
                    }
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }
}

