/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseProps;
import cgat.RGB;
import java.applet.Applet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.ArrayList;

public class MbgdData {
    boolean isApplet = false;
    Applet thisApplet = null;
    String basePath = "";
    String serverUrl = "";
    String PropDir = null;
    String PropFile = null;
    BaseProps mbgdProps = new BaseProps();
    static String PROP_BROWSEREXE = "mbgd.browser.executable";
    static String PROP_BROWSEROPT = "mbgd.browser.options";
    static String PROP_DBGETURL = "mbgd.dbget.url";
    static String PROP_DBGETCGI = "mbgd.dbget.cgi";
    static String PROP_DATASERVER = "mbgd.data.server";
    static String PROP_DATAPATH = "mbgd.data.local";
    static String PROP_MAXHIT = "mbgd.search.maxHit";
    ArrayList speclist;
    RGB rgb;
    static MbgdData _instance = null;

    public static MbgdData Instance() {
        return _instance;
    }

    public static MbgdData Instance(String b, Applet a) {
        if (_instance == null) {
            _instance = new MbgdData(b, a);
        }
        return _instance;
    }

    private MbgdData(String b, Applet a) {
        this.setBasePath(b);
        if (b.startsWith("http://")) {
            try {
                URL server = new URL(b);
                String protocol = server.getProtocol();
                String hostname = server.getHost();
                this.serverUrl = protocol + "://" + hostname;
                int port = server.getPort();
                if (0 <= port) {
                    this.serverUrl = this.serverUrl + ":" + port;
                }
            }
            catch (Exception e) {
                this.serverUrl = "";
            }
        }
        this.isApplet = false;
        this.thisApplet = a;
        if (this.thisApplet != null) {
            this.isApplet = true;
        } else {
            this.PropDir = new String(System.getProperty("user.home") + System.getProperty("file.separator") + ".alignmentViewer");
            this.PropFile = new String(this.PropDir + "/properties");
        }
        if (this.isApplet()) {
            this.mbgdProps.setProperty(PROP_DATASERVER, 0, this.getBasePath());
            this.mbgdProps.setProperty(PROP_DBGETURL, 0, "http://www.genome.ad.jp");
            this.mbgdProps.setProperty(PROP_DBGETCGI, 0, "/dbget-bin/www_bget");
        } else {
            File propDir = new File(this.PropDir);
            propDir.mkdir();
            this.loadProps();
        }
        this.speclist = new ArrayList();
    }

    public void loadProps() {
        try {
            this.mbgdProps.load(new FileInputStream(this.PropFile));
        }
        catch (FileNotFoundException e) {
            this.mbgdProps.setProperty(PROP_DATASERVER, 0, "");
            this.mbgdProps.setProperty(PROP_DATASERVER, 1, "");
            this.mbgdProps.setProperty(PROP_DATASERVER, 2, "");
            this.mbgdProps.setProperty(PROP_DATAPATH, 0, "");
            this.mbgdProps.setProperty(PROP_DATAPATH, 1, "");
            this.mbgdProps.setProperty(PROP_DATAPATH, 2, "");
            this.mbgdProps.setProperty(PROP_BROWSEREXE, 0, "");
            this.mbgdProps.setProperty(PROP_BROWSEROPT, 0, "");
            this.mbgdProps.setProperty(PROP_DBGETURL, 0, "");
            this.mbgdProps.setProperty(PROP_DBGETCGI, 0, "");
        }
        catch (Exception e) {
            System.err.println("Error : load properties(" + this.PropFile + ")");
        }
    }

    public void storeProps() {
        try {
            this.mbgdProps.store(new FileOutputStream(this.PropFile), "AlignmentViewer Props");
        }
        catch (Exception e) {
            System.err.println("Error : save properties(" + this.PropFile + ")");
        }
    }

    public void setProps(String key, int idx, String val) {
        this.mbgdProps.setProperty(key, idx, val);
    }

    public String getProps(String key, int idx) {
        return this.mbgdProps.getProperty(key, idx);
    }

    public void setBasePath(String b) {
        this.basePath = new String(b);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getDocBase() {
        return this.basePath;
    }

    public boolean isApplet() {
        return this.isApplet;
    }

    public Applet getApplet() {
        return this.thisApplet;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }
}

