/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.Alignment;
import cgat.AlignmentList;
import cgat.AlignmentListFilter;
import cgat.ColorAssign;
import cgat.ColorTab;
import cgat.DataLoader;
import cgat.GeneAttr;
import cgat.GenomeSequence;
import cgat.MarkEnt;
import cgat.MarkEntList;
import cgat.MbgdData;
import cgat.RGB;
import cgat.RegionInfo;
import cgat.RegionInfoList;
import cgat.SegmentFilter;
import cgat.UrlFile;
import cgat.ViewWindow;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;

public class MbgdDataMng
extends Observable
implements ActionListener,
Observer {
    public static int NUM_SEGS = 2;
    public static final int SIDE0 = 0;
    public static final int SIDE1 = 1;
    public static final boolean BASE_SPEC = true;
    public static final int BASE_ALIGN = 1;
    public static final int BASE_GENE = 2;
    public static final int BASE_GENEATTR = 3;
    public static final int BASE_SEG1 = 4;
    public static final int BASE_SEG2 = 5;
    public static final boolean OPPO_SPEC = false;
    public static final int OPPO_ALIGN = 11;
    public static final int OPPO_GENE = 12;
    public static final int OPPO_GENEATTR = 13;
    public static final int OPPO_SEG1 = 14;
    public static final int OPPO_SEG2 = 15;
    private static MbgdDataMng _instance;
    private int selectedSpec = 0;
    private int oppositeSpec = 1;
    private boolean alignViewerMode;
    private int loadStatus = 0;
    private String spFileName = null;
    private RGB rgb;
    private String[] specName;
    private GenomeSequence[] infoGenome;
    private AlignmentList infoAlign;
    private ColorTab infoAlignColor;
    private RegionInfoList[] infoGene;
    private ColorTab[] infoGeneColor;
    private GeneAttr[] infoGeneAttr;
    private ColorTab[] infoGeneAttrColor;
    private int segNum;
    private RegionInfoList[][] infoSegs;
    private ColorTab[][] infoSegsColor;
    private String[] infoSegsName;
    private MarkEntList[] infoSearchOrf;
    private String infoGeneUrl;
    private String[] infoSegsUrl;

    public static MbgdDataMng Instance(int segNum) {
        if (_instance != null) {
            throw new IllegalArgumentException("already initialized");
        }
        _instance = new MbgdDataMng(segNum);
        return _instance;
    }

    public static MbgdDataMng Instance() {
        if (_instance == null) {
            _instance = new MbgdDataMng(NUM_SEGS);
        }
        return _instance;
    }

    private MbgdDataMng(int n) {
        this._init(n);
    }

    private void _init(int n) {
        int j;
        this.rgb = null;
        this.specName = new String[2];
        this.setSegNum(n);
        this.infoGenome = new GenomeSequence[2];
        this.infoGene = new RegionInfoList[2];
        this.infoGeneColor = new ColorTab[2];
        this.infoGeneAttr = new GeneAttr[2];
        this.infoGeneAttrColor = new ColorTab[2];
        this.infoSegsName = new String[n];
        this.infoSegs = new RegionInfoList[2][n];
        this.infoSegsColor = new ColorTab[2][n];
        this.infoSearchOrf = new MarkEntList[2];
        this.rgb = null;
        this.infoAlign = null;
        this.infoAlignColor = null;
        int i = 0;
        while (i < 2) {
            this.specName[i] = null;
            this.infoGenome[i] = null;
            this.infoGene[i] = null;
            this.infoGeneColor[i] = null;
            this.infoGeneAttr[i] = null;
            this.infoGeneAttrColor[i] = null;
            this.infoSearchOrf[i] = null;
            j = 0;
            while (j < n) {
                this.infoSegsName[j] = null;
                this.infoSegs[i][j] = null;
                this.infoSegsColor[i][j] = null;
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < n) {
            this.infoSegsName[j] = null;
            ++j;
        }
    }

    public boolean isReady() {
        return this.isReady(10);
    }

    public boolean isReady(int sta) {
        return this.loadStatus >= sta;
    }

    public void setReady(int sta) {
        this.loadStatus = sta;
    }

    private void setSpecName(int side, String n) {
        this.specName[side] = n == null ? null : new String(n);
    }

    public String getSpecName(boolean basespec) {
        if (!this.isReady(1)) {
            return "";
        }
        System.out.println(basespec);
        String spname = basespec ? this.specName[this.selectedSpec] : this.specName[this.oppositeSpec];
        System.out.println(spname);
        if (spname == null) {
            return "";
        }
        return new String(spname);
    }

    public String getSpecFullName(boolean basespec) {
        if (!this.isReady()) {
            return "";
        }
        String spname = basespec ? this.infoGenome[this.selectedSpec].getName() : this.infoGenome[this.oppositeSpec].getName();
        if (spname == null) {
            return "";
        }
        return new String(spname);
    }

    public String getSpecName(int type2) {
        if (!this.isReady()) {
            return "";
        }
        switch (type2) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return this.getSpecName(true);
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                return this.getSpecName(false);
            }
        }
        return new String("");
    }

    public String getAlignAttrName(int idx) {
        return this.infoAlign.getAlignAttrName(idx);
    }

    private void setSegNum(int n) {
        this.segNum = n;
    }

    private int getSegNum() {
        return this.segNum;
    }

    public void setSegmentName(boolean basespec, String name) {
        if (basespec) {
            this.infoSegsName[this.selectedSpec] = new String(name);
        } else {
            this.infoSegsName[this.oppositeSpec] = new String(name);
        }
    }

    public String getSegmentName(boolean basespec) {
        if (this.infoSegsName == null) {
            return "";
        }
        if (basespec) {
            if (this.infoSegsName[this.selectedSpec] == null) {
                return "";
            }
            return new String(this.infoSegsName[this.selectedSpec]);
        }
        if (this.infoSegsName[this.oppositeSpec] == null) {
            return "";
        }
        return new String(this.infoSegsName[this.oppositeSpec]);
    }

    public void setSpFileName(String name) {
        this.spFileName = new String(name);
    }

    public String getSpFileName() {
        return new String(this.spFileName);
    }

    private void exchangeBaseSpec() {
        int wk = this.selectedSpec;
        this.selectedSpec = this.oppositeSpec;
        this.oppositeSpec = wk;
        this.setChanged();
        this.notifyObservers("baseSpec");
    }

    public void load(JFrame f, String sp1, String sp2, String url, String falign, String geneAttrDir, String geneAttrColorType, String[] segType, String[] segCgi) {
        this.setSpFileName(falign);
        DataLoader dataLoader = new DataLoader(f, this);
        dataLoader.setInfo(sp1, sp2, url, falign, geneAttrDir, geneAttrColorType, segType, segCgi);
        dataLoader.addObserver(this);
        Thread thread = new Thread(dataLoader);
        thread.start();
    }

    public void makeObj() {
    }

    public void execLoad(String sp1, String sp2, String url, String falign, String geneAttrDir, String geneAttrColorType, String[] segType, String[] segCgi) {
        this.alignViewerMode = true;
        if (sp2 == null) {
            this.alignViewerMode = false;
        }
        this.setReady(0);
        if (this.rgb == null) {
            String fileRgb = new String(url + "rgb.txt");
            this.rgb = new RGB();
            this.rgb.load(fileRgb);
        }
        this.setSpecName(0, sp1);
        this.setSpecName(1, sp2);
        this.setReady(1);
        if (this.infoAlign == null) {
            this.infoAlign = new AlignmentList();
            this.infoAlignColor = new ColorTab(this.rgb);
        }
        if (this.alignViewerMode) {
            String fileAlign = new String(url + "cgi-bin/getAlign.cgi?type=" + falign + "&spec=" + sp1 + "&spec=" + sp2);
            String fileAlignColor = new String(url + "cgi-bin/getColorTab.cgi?type=align");
            String fileAlignSeq = new String(falign);
            this.infoAlign.load(sp1, sp2, fileAlign, fileAlignSeq);
            this.infoAlignColor.load(fileAlignColor);
        }
        this.setReady(2);
        if (this.infoGenome[0] == null) {
            this.infoGenome[0] = new GenomeSequence("", "");
        }
        String fileGenome = new String(url + "cgi-bin/getSequence.cgi?reg=" + sp1);
        this.infoGenome[0].load(fileGenome);
        if (this.infoGenome[1] == null) {
            this.infoGenome[1] = new GenomeSequence("", "");
        }
        if (this.alignViewerMode) {
            fileGenome = new String(url + "cgi-bin/getSequence.cgi?reg=" + sp2);
            this.infoGenome[1].load(fileGenome);
        }
        this.setReady(3);
        String fileGeneUrl = new String(url + "cgi-bin/getRegInfoUrl.cgi?type=gene");
        try {
            this.infoGeneUrl = new String(new UrlFile(fileGeneUrl).readLine().trim());
        }
        catch (Exception e) {
            this.infoGeneUrl = "";
        }
        if (this.infoGene[0] == null) {
            this.infoGene[0] = new RegionInfoList();
            this.infoGeneColor[0] = new ColorTab(this.rgb);
            this.infoSearchOrf[0] = new MarkEntList();
        }
        String fileGene = new String(url + "cgi-bin/getGene.cgi?spec=" + sp1);
        String fileGeneColor = new String(url + "cgi-bin/getColorTab.cgi?type=gene&spec=" + sp1);
        this.infoGene[0].load(fileGene);
        this.infoGene[0].setDataName("gene");
        boolean bSta = this.infoGeneColor[0].load(fileGeneColor);
        if (this.infoGene[1] == null) {
            this.infoGene[1] = new RegionInfoList();
            this.infoGeneColor[1] = new ColorTab(this.rgb);
            this.infoSearchOrf[1] = new MarkEntList();
        }
        if (this.alignViewerMode) {
            fileGene = new String(url + "cgi-bin/getGene.cgi?spec=" + sp2);
            fileGeneColor = new String(url + "cgi-bin/getColorTab.cgi?type=gene&spec=" + sp2);
            this.infoGene[1].load(fileGene);
            this.infoGene[1].setDataName("gene");
            bSta = this.infoGeneColor[1].load(fileGeneColor);
        }
        this.setReady(4);
        if (this.infoGeneAttr[0] == null) {
            this.infoGeneAttr[0] = new GeneAttr();
            this.infoGeneAttrColor[0] = new ColorTab(this.rgb);
        }
        if (this.infoGeneAttr[1] == null) {
            this.infoGeneAttr[1] = new GeneAttr();
            this.infoGeneAttrColor[1] = new ColorTab(this.rgb);
        }
        if (geneAttrDir != null) {
            String fileGeneAttr = new String(url + "cgi-bin/getGeneAttr.cgi?type=" + geneAttrDir + "&spec=" + sp1);
            String fileGeneAttrColor = new String(url + "cgi-bin/getColorTab.cgi?typ=" + geneAttrDir + "&spec=" + sp1);
            this.infoGeneAttr[0].load(fileGeneAttr);
            this.infoGene[0].setDataName(geneAttrDir);
            this.infoGeneAttr[0].setColorType(new String(geneAttrColorType));
            bSta = this.infoGeneAttrColor[0].load(fileGeneAttrColor);
            if (!bSta) {
                this.infoGeneAttrColor[0].setDefaultColorTab(this.infoGeneAttr[0].getMinValue(), this.infoGeneAttr[0].getMaxValue());
                this.infoGene[0].setDataName("float");
            }
            if (this.alignViewerMode) {
                fileGeneAttr = new String(url + "cgi-bin/getGeneAttr.cgi?type=" + geneAttrDir + "&spec=" + sp2);
                fileGeneAttrColor = new String(url + "cgi-bin/getColorTab.cgi?typ=" + geneAttrDir + "&spec=" + sp2);
                this.infoGeneAttr[1].load(fileGeneAttr);
                this.infoGene[1].setDataName(geneAttrDir);
                this.infoGeneAttr[1].setColorType(new String(geneAttrColorType));
                bSta = this.infoGeneAttrColor[1].load(fileGeneAttrColor);
                if (!bSta) {
                    this.infoGeneAttrColor[1].setDefaultColorTab(this.infoGeneAttr[1].getMinValue(), this.infoGeneAttr[1].getMaxValue());
                    this.infoGene[0].setDataName("float");
                }
            }
        } else {
            this.infoGeneAttr[0].clear();
            this.infoGeneAttr[1].clear();
        }
        this.setReady(5);
        this.loadSegment(url, segType, segCgi);
        this.setReady(6);
        this.setReady(10);
        this.setChanged();
        this.notifyObservers();
    }

    public void loadSegment(String url, String[] segType, String[] segCgi) {
        int loopMax = segCgi.length;
        System.out.println("Loop>>" + loopMax);
        int segNo = 0;
        while (segNo < loopMax) {
            System.out.println(">" + segCgi[segNo]);
            String fileSegUrl = new String(url + "cgi-bin/getRegInfoUrl.cgi?type=" + segType[segNo]);
            this.loadSegment0(0, segNo, fileSegUrl, segType[segNo], segCgi[segNo]);
            if (this.alignViewerMode) {
                this.loadSegment0(1, segNo, url, segType[segNo], segCgi[segNo]);
            }
            ++segNo;
        }
    }

    public void loadSegment0(int seqNum, int segNo, String url, String segType, String segCgi) {
        this.infoSegsUrl = new String[2];
        String sp = this.getSpecName(this.isBaseSpec(seqNum));
        if (url == null) {
            url = MbgdData.Instance().getBasePath();
        }
        if (this.infoSegs[seqNum][segNo] == null) {
            this.infoSegs[seqNum][segNo] = new RegionInfoList();
            this.infoSegsColor[seqNum][segNo] = new ColorTab(this.rgb);
        }
        if (segCgi.equals("")) {
            return;
        }
        if (segCgi != null) {
            String fileSeg1Url = new String(url + "cgi-bin/getRegInfoUrl.cgi?type=" + segType);
            try {
                this.infoSegsUrl[segNo] = new String(new UrlFile(fileSeg1Url).readLine().trim());
            }
            catch (Exception e) {
                this.infoSegsUrl[segNo] = "";
            }
            String fileSegment = new String(segCgi);
            if (fileSegment.endsWith(".cgi")) {
                fileSegment = fileSegment + "?";
            }
            fileSegment = fileSegment + "&spec=" + sp;
            String fileSegmentColor = new String(url + "cgi-bin/getColorTab.cgi?type=" + segType + "&spec=" + sp);
            this.infoSegs[seqNum][segNo].load(fileSegment);
            this.infoSegs[seqNum][segNo].setDataName(segType);
            boolean bSta = this.infoSegsColor[seqNum][segNo].load(fileSegmentColor);
            if (!bSta) {
                this.infoSegsColor[seqNum][segNo].load(fileSegmentColor);
            }
        }
        ColorAssign colAssignSeg = new ColorAssign();
        int loopMax = this.infoSegs[seqNum][segNo].size();
        int idx = 0;
        while (idx < loopMax) {
            RegionInfo r = this.infoSegs[seqNum][segNo].getRegionInfo(idx);
            colAssignSeg.countColorType(r.getColor());
            ++idx;
        }
        colAssignSeg.assignColor();
        this.infoSegsColor[seqNum][segNo].setColorAssign(colAssignSeg);
    }

    public void loadAlignmentSeq(int f1, int t1, int f2, int t2) {
        String name1 = this.getSpecName(true);
        String name2 = this.getSpecName(false);
        this.loadAlignmentSeq(name1, f1, t1, name2, f2, t2);
    }

    public void loadAlignmentSeq(String name1, int f1, int t1, String name2, int f2, int t2) {
        MbgdData mbgdData = MbgdData.Instance();
        String server = mbgdData.getServerUrl();
        this.infoAlign.loadAlignSeq(server, this.getSpFileName(), name1, f1, t1, name2, f2, t2);
    }

    public String getAlignmentSeq(int f1, int t1, int f2, int t2, boolean side) {
        String name1 = this.getSpecName(true);
        String name2 = this.getSpecName(false);
        String seq = this.getAlignmentSeq(name1, f1, t1, name2, f2, t2, side);
        return seq;
    }

    public String getAlignmentSeq(String name1, int f1, int t1, String name2, int f2, int t2, boolean side) {
        MbgdData mbgdData = MbgdData.Instance();
        String server = mbgdData.getServerUrl();
        String seq = side ? this.infoAlign.getAlignSeq(name1, f1, t1, name2, f2, t2, this.selectedSpec) : this.infoAlign.getAlignSeq(name1, f1, t1, name2, f2, t2, this.oppositeSpec);
        return seq;
    }

    public String getGenomeSequence(boolean basespec) {
        if (!this.isReady(3)) {
            return "";
        }
        String subSeq = basespec ? this.infoGenome[this.selectedSpec].getSequence() : this.infoGenome[this.oppositeSpec].getSequence();
        return new String(subSeq);
    }

    public String getGenomeSequence(boolean basespec, int from, int to) {
        if (!this.isReady(3)) {
            return "";
        }
        String subSeq = basespec ? this.infoGenome[this.selectedSpec].getSequence(from, to) : this.infoGenome[this.oppositeSpec].getSequence(from, to);
        return new String(subSeq);
    }

    public int getGenomeLength(boolean basespec) {
        if (!this.isReady(3)) {
            return 0;
        }
        if (basespec) {
            return this.infoGenome[this.selectedSpec].getLength();
        }
        return this.infoGenome[this.oppositeSpec].getLength();
    }

    public int getGenomeLength(int type2) {
        boolean side;
        if (!this.isReady(3)) {
            return 0;
        }
        switch (type2) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                side = true;
                break;
            }
            default: {
                side = false;
            }
        }
        return this.getGenomeLength(side);
    }

    public Alignment getAlignment(boolean basespec, String key) {
        if (!this.isReady(2)) {
            return null;
        }
        Alignment info = new Alignment(this.infoAlign.getAlignment(key));
        if (this.selectedSpec != 0) {
            info.exchangeSpec();
        }
        return info;
    }

    public Alignment getAlignment(boolean basespec, int index) {
        Alignment info;
        if (!this.isReady(2)) {
            return null;
        }
        if (basespec) {
            if (this.selectedSpec == 0) {
                info = new Alignment(this.infoAlign.getAlignment1(index));
            } else {
                info = new Alignment(this.infoAlign.getAlignment2(index));
                info.exchangeSpec();
            }
        } else if (this.selectedSpec != 0) {
            info = new Alignment(this.infoAlign.getAlignment1(index));
        } else {
            info = new Alignment(this.infoAlign.getAlignment2(index));
            info.exchangeSpec();
        }
        return info;
    }

    public ArrayList getAlignment(int dataType, ViewWindow viewWin, int from, int to) {
        ArrayList alignList;
        boolean basespec;
        switch (dataType) {
            case 2: 
            case 4: 
            case 5: {
                basespec = true;
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                basespec = false;
                break;
            }
            default: {
                return new ArrayList();
            }
        }
        if (from < to) {
            alignList = AlignmentListFilter.search(this, viewWin, basespec, from, to);
        } else {
            int genomeLength = this.getGenomeLength(basespec);
            ArrayList wk = AlignmentListFilter.search(this, viewWin, basespec, from, genomeLength);
            alignList = AlignmentListFilter.search(this, viewWin, basespec, 0, to);
            alignList.addAll(wk);
        }
        return alignList;
    }

    public int getAlignmentSize() {
        if (!this.isReady(2)) {
            return 0;
        }
        return this.infoAlign.size();
    }

    public boolean getAlignAttrDataType(int idxItem) {
        if (!this.isReady(2)) {
            return false;
        }
        boolean dataType = this.infoAlign.getAttrDataType(idxItem);
        return dataType;
    }

    public RegionInfo getGeneInfo(boolean basespec, int index) {
        if (!this.isReady(4)) {
            return null;
        }
        RegionInfo info = basespec ? new RegionInfo(this.infoGene[this.selectedSpec].getRegionInfo(index)) : new RegionInfo(this.infoGene[this.oppositeSpec].getRegionInfo(index));
        return info;
    }

    public RegionInfo getGeneInfo(boolean basespec, String orfName) {
        if (!this.isReady(4)) {
            return null;
        }
        RegionInfo info = basespec ? this.infoGene[this.selectedSpec].getRegionInfo(orfName) : this.infoGene[this.oppositeSpec].getRegionInfo(orfName);
        if (info == null) {
            return null;
        }
        return new RegionInfo(info);
    }

    public RegionInfo getSegmentInfo(boolean basespec, int segNo, int index) {
        if (!this.isReady(6)) {
            return null;
        }
        RegionInfo info = basespec ? new RegionInfo(this.infoSegs[this.selectedSpec][segNo].getRegionInfo(index)) : new RegionInfo(this.infoSegs[this.oppositeSpec][segNo].getRegionInfo(index));
        return info;
    }

    public RegionInfo getSegmentInfo(int type2, int index) {
        if (!this.isReady(6)) {
            return null;
        }
        switch (type2) {
            case 4: {
                return this.getSegmentInfo(true, 0, index);
            }
            case 5: {
                return this.getSegmentInfo(true, 1, index);
            }
            case 14: {
                return this.getSegmentInfo(false, 0, index);
            }
            case 15: {
                return this.getSegmentInfo(false, 1, index);
            }
        }
        return null;
    }

    public RegionInfo getRegionInfo(int type2, int index) {
        if (!this.isReady(6)) {
            return null;
        }
        switch (type2) {
            case 2: {
                return this.getGeneInfo(true, index);
            }
            case 4: {
                return this.getSegmentInfo(true, 0, index);
            }
            case 5: {
                return this.getSegmentInfo(true, 1, index);
            }
            case 12: {
                return this.getGeneInfo(false, index);
            }
            case 14: {
                return this.getSegmentInfo(false, 0, index);
            }
            case 15: {
                return this.getSegmentInfo(false, 1, index);
            }
        }
        return null;
    }

    public String getSegAttrName(int type2, int idxSeg, int idxItem) {
        String name = "unknown";
        if (!this.isReady(6)) {
            return null;
        }
        switch (type2) {
            case 2: 
            case 4: 
            case 5: {
                return this.infoSegs[this.selectedSpec][idxSeg].getAttrName(idxItem);
            }
            case 12: 
            case 14: 
            case 15: {
                return this.infoSegs[this.oppositeSpec][idxSeg].getAttrName(idxItem);
            }
        }
        return new String(name);
    }

    public boolean getSegAttrDataType(int idxSeg, int idxItem) {
        if (!this.isReady(6)) {
            return false;
        }
        boolean dataType = this.infoSegs[this.selectedSpec][idxSeg].getAttrDataType(idxItem);
        return dataType;
    }

    public void clearFilterAlignment() {
    }

    public void filterAlignment(int cond, int idxAlignItem, String str1) {
    }

    public void filterAlignment(int cond, int idxAlignItem, double val1) {
    }

    public void filterAlignment(int cond, int idxAlignItem, double val1, double val2) {
    }

    public void clearFilterSegment(int idxSeg) {
        if (!this.isReady(6)) {
            return;
        }
        int i = 0;
        while (i < 2) {
            this.infoSegs[i][idxSeg].clearFilter();
            ++i;
        }
    }

    public void filterSegment(int cond, int idxSeg, int idxSegItem, String str1) {
        if (!this.isReady(6)) {
            return;
        }
        switch (cond) {
            case 4: {
                int i = 0;
                while (i < 2) {
                    SegmentFilter.filterEqual(this.infoSegs[i][idxSeg], idxSegItem, str1);
                    ++i;
                }
                break;
            }
        }
    }

    public void filterSegment(int cond, int idxSeg, int idxSegItem, double val1) {
        if (!this.isReady(6)) {
            return;
        }
        switch (cond) {
            case 2: {
                int i = 0;
                while (i < 2) {
                    SegmentFilter.filterLessThan(this.infoSegs[i][idxSeg], idxSegItem, val1);
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < 2) {
                    SegmentFilter.filterLessEqual(this.infoSegs[i][idxSeg], idxSegItem, val1);
                    ++i;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < 2) {
                    SegmentFilter.filterEqual(this.infoSegs[i][idxSeg], idxSegItem, val1);
                    ++i;
                }
                break;
            }
            case 5: {
                int i = 0;
                while (i < 2) {
                    SegmentFilter.filterGreaterEqual(this.infoSegs[i][idxSeg], idxSegItem, val1);
                    ++i;
                }
                break;
            }
            case 6: {
                int i = 0;
                while (i < 2) {
                    SegmentFilter.filterGreaterThan(this.infoSegs[i][idxSeg], idxSegItem, val1);
                    ++i;
                }
                break;
            }
        }
    }

    public void filterSegment(int cond, int idxSeg, int idxSegItem, double val1, double val2) {
        if (!this.isReady(6)) {
            return;
        }
        switch (cond) {
            case 0: {
                int i = 0;
                while (i < 2) {
                    SegmentFilter.filterBetween(this.infoSegs[i][idxSeg], idxSegItem, val1, val2);
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < 2) {
                    SegmentFilter.filterExceptBetween(this.infoSegs[i][idxSeg], idxSegItem, val1, val2);
                    ++i;
                }
                break;
            }
        }
    }

    public int getGeneAttrSize(int type2) {
        if (!this.isReady(5)) {
            return 0;
        }
        switch (type2) {
            case 2: {
                return this.infoGeneAttr[this.selectedSpec].size();
            }
            case 12: {
                return this.infoGeneAttr[this.oppositeSpec].size();
            }
        }
        return 0;
    }

    public float getGeneAttrMin(int type2) {
        if (!this.isReady(5)) {
            return 0.0f;
        }
        switch (type2) {
            case 2: {
                return this.infoGeneAttr[this.selectedSpec].getMinValue();
            }
            case 12: {
                return this.infoGeneAttr[this.oppositeSpec].getMinValue();
            }
        }
        return 0.0f;
    }

    public float getGeneAttrMax(int type2) {
        if (!this.isReady(5)) {
            return 0.0f;
        }
        switch (type2) {
            case 2: {
                return this.infoGeneAttr[this.selectedSpec].getMaxValue();
            }
            case 12: {
                return this.infoGeneAttr[this.oppositeSpec].getMaxValue();
            }
        }
        return 0.0f;
    }

    public int getRegionSize(int type2) {
        if (!this.isReady(6)) {
            return 0;
        }
        switch (type2) {
            case 2: {
                return this.infoGene[this.selectedSpec].size();
            }
            case 3: {
                return this.infoGeneAttr[this.selectedSpec].size();
            }
            case 4: {
                return this.infoSegs[this.selectedSpec][0].size();
            }
            case 5: {
                return this.infoSegs[this.selectedSpec][1].size();
            }
            case 12: {
                return this.infoGene[this.oppositeSpec].size();
            }
            case 13: {
                return this.infoGeneAttr[this.oppositeSpec].size();
            }
            case 14: {
                return this.infoSegs[this.oppositeSpec][0].size();
            }
            case 15: {
                return this.infoSegs[this.oppositeSpec][1].size();
            }
        }
        return 0;
    }

    public String getGeneAttrName(int type2, int idx) {
        String name = "unknown";
        if (!this.isReady(5)) {
            return null;
        }
        switch (type2) {
            case 2: {
                return this.infoGene[this.selectedSpec].getAttrName(idx);
            }
            case 12: {
                return this.infoGene[this.oppositeSpec].getAttrName(idx);
            }
        }
        return new String(name);
    }

    public ColorTab getAlignColor() {
        if (!this.isReady(2)) {
            return null;
        }
        return this.infoAlignColor;
    }

    public String getColorType(int type2) {
        if (!this.isReady(6)) {
            return "";
        }
        switch (type2) {
            case 2: {
                if (this.infoGeneAttr[this.selectedSpec].size() != 0) {
                    return this.infoGeneAttr[this.selectedSpec].getColorType();
                }
                return this.infoGene[this.selectedSpec].getColorType();
            }
            case 4: {
                return this.infoSegs[this.selectedSpec][0].getColorType();
            }
            case 5: {
                return this.infoSegs[this.selectedSpec][1].getColorType();
            }
            case 12: {
                if (this.infoGeneAttr[this.oppositeSpec].size() != 0) {
                    return this.infoGeneAttr[this.oppositeSpec].getColorType();
                }
                return this.infoGene[this.oppositeSpec].getColorType();
            }
            case 14: {
                return this.infoSegs[this.oppositeSpec][0].getColorType();
            }
            case 15: {
                return this.infoSegs[this.oppositeSpec][1].getColorType();
            }
        }
        return null;
    }

    public String getGeneAttr(int type2, String key) {
        if (!this.isReady(5)) {
            return null;
        }
        switch (type2) {
            case 2: {
                return this.infoGeneAttr[this.selectedSpec].get(key);
            }
            case 12: {
                return this.infoGeneAttr[this.oppositeSpec].get(key);
            }
        }
        return null;
    }

    public Color getGeneAttrColor(int type2, String key, String colType) {
        Color c = Color.white;
        if (!this.isReady(5)) {
            return c;
        }
        String colId = this.getGeneAttr(type2, key);
        switch (type2) {
            case 2: {
                c = this.infoGeneAttrColor[this.selectedSpec].getColor(colId, colType);
                break;
            }
            case 12: {
                c = this.infoGeneAttrColor[this.oppositeSpec].getColor(colId, colType);
            }
        }
        return c;
    }

    public Color getGeneAttrColor(int type2, float val) {
        Color c = Color.white;
        if (!this.isReady(5)) {
            return c;
        }
        switch (type2) {
            case 2: {
                c = this.infoGeneAttrColor[this.selectedSpec].getColorFloat(val);
                break;
            }
            case 12: {
                c = this.infoGeneAttrColor[this.oppositeSpec].getColorFloat(val);
            }
        }
        return c;
    }

    public Color getColor(int type2, String colId, String colType) {
        Color c = Color.white;
        if (!this.isReady(6)) {
            return c;
        }
        switch (type2) {
            case 1: {
                c = this.infoAlignColor.getColor(colId, colType);
                break;
            }
            case 2: {
                if (this.infoGeneAttr[this.selectedSpec].size() != 0) {
                    c = this.infoGeneAttrColor[this.selectedSpec].getColorFloat(colId);
                    break;
                }
                c = this.infoGeneColor[this.selectedSpec].getColor(colId, colType);
                break;
            }
            case 4: {
                c = this.infoSegsColor[this.selectedSpec][0].getColor(colId, colType);
                break;
            }
            case 5: {
                c = this.infoSegsColor[this.selectedSpec][1].getColor(colId, colType);
                break;
            }
            case 12: {
                if (this.infoGeneAttr[this.selectedSpec].size() != 0) {
                    c = this.infoGeneAttrColor[this.oppositeSpec].getColorFloat(colId);
                    break;
                }
                c = this.infoGeneColor[this.oppositeSpec].getColor(colId, colType);
                break;
            }
            case 14: {
                c = this.infoSegsColor[this.oppositeSpec][0].getColor(colId, colType);
                break;
            }
            case 15: {
                c = this.infoSegsColor[this.oppositeSpec][1].getColor(colId, colType);
            }
        }
        return c;
    }

    public int getPattern(int type2, String patId, String patType) {
        if (!this.isReady(6)) {
            return 0;
        }
        switch (type2) {
            case 1: {
                return this.infoAlignColor.getPattern(patId, patType);
            }
            case 2: {
                return this.infoGeneColor[this.selectedSpec].getPattern(patId, patType);
            }
            case 4: {
                return this.infoSegsColor[this.selectedSpec][0].getPattern(patId, patType);
            }
            case 5: {
                return this.infoSegsColor[this.selectedSpec][1].getPattern(patId, patType);
            }
            case 12: {
                return this.infoGeneColor[this.oppositeSpec].getPattern(patId, patType);
            }
            case 14: {
                return this.infoSegsColor[this.oppositeSpec][0].getPattern(patId, patType);
            }
            case 15: {
                return this.infoSegsColor[this.oppositeSpec][1].getPattern(patId, patType);
            }
        }
        return 0;
    }

    public String getType(int type2) {
        if (!this.isReady()) {
            return null;
        }
        switch (type2) {
            case 1: {
                return "align";
            }
            case 2: 
            case 12: {
                return this.infoGene[0].getDataName();
            }
            case 4: 
            case 14: {
                return this.infoSegs[0][0].getDataName();
            }
            case 5: 
            case 15: {
                return this.infoSegs[0][1].getDataName();
            }
        }
        return null;
    }

    public Alignment[] selectAlignList(int regStart1, int regWidth1, int regMax1, int regStart, int regWidth, int regMax) {
        boolean baseSpec = this.selectedSpec == 0;
        Alignment[] alignList = this.infoAlign.selectAlignList(baseSpec, regStart1, regWidth1, regMax1, regStart, regWidth, regMax);
        if (this.selectedSpec != 0) {
            int loopMax = alignList.length;
            int i = 0;
            while (i < loopMax) {
                alignList[i].exchangeSpec();
                ++i;
            }
        }
        return alignList;
    }

    public Alignment[] selectAlignList(int regStart1, int regWidth1, int regMax1) {
        boolean baseSpec = this.selectedSpec == 0;
        Alignment[] alignList = this.infoAlign.selectAlignList(baseSpec, regStart1, regWidth1, regMax1);
        if (this.selectedSpec != 0) {
            int loopMax = alignList.length;
            int i = 0;
            while (i < loopMax) {
                alignList[i].exchangeSpec();
                ++i;
            }
        }
        return alignList;
    }

    public boolean isBaseSpec(int specNo) {
        return specNo == this.selectedSpec;
    }

    public void clearMarkEnt() {
        int i = 0;
        while (i < 2) {
            if (this.infoSearchOrf[i] != null) {
                this.infoSearchOrf[i].clearMark();
            }
            ++i;
        }
    }

    public void delMarkEnt(String n) {
        int i = 0;
        while (i < 2) {
            if (this.infoSearchOrf[i] != null) {
                this.infoSearchOrf[i].delMark(n);
            }
            ++i;
        }
    }

    public void addMarkEnt(boolean basespec, MarkEnt ent) {
        if (basespec) {
            this.addMarkEnt(this.selectedSpec, ent);
        } else {
            this.addMarkEnt(this.oppositeSpec, ent);
        }
    }

    public void addMarkEnt(int side, MarkEnt ent) {
        this.infoSearchOrf[side].addMark(ent);
    }

    public MarkEnt getMarkEnt(int side, String orfName) {
        return this.infoSearchOrf[side].getMark(orfName);
    }

    public MarkEnt[] getMarkEntAll(boolean basespec) {
        if (!this.isReady()) {
            return new MarkEnt[0];
        }
        if (basespec) {
            return this.infoSearchOrf[this.selectedSpec].getMarkAll();
        }
        return this.infoSearchOrf[this.oppositeSpec].getMarkAll();
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isReady()) {
            return;
        }
        this.exchangeBaseSpec();
    }

    public String getRegInfoUrl(int dataType) {
        switch (dataType) {
            case 2: 
            case 12: {
                return new String(this.infoGeneUrl);
            }
            case 4: 
            case 14: {
                return new String(this.infoSegsUrl[0]);
            }
            case 5: 
            case 15: {
                return new String(this.infoSegsUrl[1]);
            }
        }
        return "";
    }

    public void update(Observable o, Object arg) {
        if (o instanceof DataLoader) {
            this.update((DataLoader)o, arg);
        }
    }

    public void update(DataLoader dataLoader, Object arg) {
        int i = 0;
        while (i < 2) {
            this.infoSearchOrf[i] = new MarkEntList();
            ++i;
        }
        this.setChanged();
        this.notifyObservers();
    }

    static {
        SIDE0 = 0;
        SIDE1 = 1;
        BASE_SPEC = true;
        BASE_ALIGN = 1;
        BASE_GENE = 2;
        BASE_GENEATTR = 3;
        BASE_SEG1 = 4;
        BASE_SEG2 = 5;
        OPPO_SPEC = false;
        OPPO_ALIGN = 11;
        OPPO_GENE = 12;
        OPPO_GENEATTR = 13;
        OPPO_SEG1 = 14;
        OPPO_SEG2 = 15;
        _instance = null;
    }

    private static interface LOADSTAT {
        public static final int NONE = 0;
        public static final int SPECNAME = 1;
        public static final int ALIGNMENT = 2;
        public static final int GENOME = 3;
        public static final int GENE = 4;
        public static final int GENEATTR = 5;
        public static final int SEGMENT = 6;
        public static final int DONE = 10;

        static {
            NONE = 0;
            SPECNAME = 1;
            ALIGNMENT = 2;
            GENOME = 3;
            GENE = 4;
            GENEATTR = 5;
            SEGMENT = 6;
            DONE = 10;
        }
    }
}

