/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.MbgdData;
import cgat.NumericField;
import cgat.SavePropsCommand;
import cgat.SelectFileCommand;
import cgat.SetPropsCommand;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class MbgdPropsDialog {
    JTextField tfBrowser;
    JTextField tfDbgetUrl;
    JTextField tfDbgetCgi;
    JTextField tfServerList;
    JTextField tfLocalList;
    NumericField tfMaxHit;

    public MbgdPropsDialog(JFrame frame) {
        MbgdData mbgdData = MbgdData.Instance();
        JPanel browserArea = this.inputBrowser(frame);
        JPanel dbgetUrlArea = this.inputDbgetUrl(frame);
        JPanel dataUrlArea = this.inputDataUrl(frame);
        JPanel searchLimitsArea = this.inputSearchLimits(frame);
        Object[] itemList = new Object[]{browserArea, dbgetUrlArea, dataUrlArea, searchLimitsArea};
        JButton set = new JButton("Set");
        SetPropsCommand setCmd = new SetPropsCommand(this);
        set.addActionListener(setCmd);
        JButton save = new JButton("Set & Save");
        SavePropsCommand saveCmd = new SavePropsCommand(this);
        save.addActionListener(saveCmd);
        Object[] buttonList = new Object[]{set, save, "Close"};
        int ret = JOptionPane.showOptionDialog(frame.getContentPane(), itemList, "Dialog", -1, -1, null, buttonList, buttonList[1]);
        if (ret == 0) {
            // empty if block
        }
    }

    public JPanel inputBrowser(JFrame frame) {
        MbgdData mbgdData = MbgdData.Instance();
        JPanel area = new JPanel();
        this.tfBrowser = new JTextField(mbgdData.getProps(MbgdData.PROP_BROWSEREXE, 0));
        this.tfBrowser.setColumns(40);
        this.tfBrowser.setBorder(new TitledBorder("Browser(executable)"));
        JButton button = new JButton("FileList");
        SelectFileCommand buttonAction = new SelectFileCommand(frame, this.tfBrowser);
        button.addActionListener(buttonAction);
        area.add(this.tfBrowser);
        area.add(button);
        return area;
    }

    public JPanel inputDbgetUrl(JFrame frame) {
        MbgdData mbgdData = MbgdData.Instance();
        JPanel area = new JPanel(new GridLayout(2, 1));
        this.tfDbgetUrl = new JTextField(mbgdData.getProps(MbgdData.PROP_DBGETURL, 0));
        this.tfDbgetUrl.setColumns(40);
        this.tfDbgetUrl.setBorder(new TitledBorder("DBGET server(URL)"));
        this.tfDbgetCgi = new JTextField(mbgdData.getProps(MbgdData.PROP_DBGETCGI, 0));
        this.tfDbgetCgi.setColumns(40);
        this.tfDbgetCgi.setBorder(new TitledBorder("CGI command"));
        area.add(this.tfDbgetUrl);
        area.add(this.tfDbgetCgi);
        return area;
    }

    public JPanel inputDataUrl(JFrame frame) {
        MbgdData mbgdData = MbgdData.Instance();
        JPanel area = new JPanel(new GridLayout(2, 1));
        this.tfServerList = new JTextField(mbgdData.getProps(MbgdData.PROP_DATASERVER, 0));
        this.tfServerList.setColumns(40);
        this.tfServerList.setBorder(new TitledBorder("Data server(URL)"));
        this.tfLocalList = new JTextField(mbgdData.getProps(MbgdData.PROP_DATAPATH, 0));
        this.tfLocalList.setColumns(40);
        this.tfLocalList.setBorder(new TitledBorder("Data directory(path)"));
        area.add(this.tfServerList);
        area.add(this.tfLocalList);
        return area;
    }

    public JPanel inputSearchLimits(JFrame frame) {
        MbgdData mbgdData = MbgdData.Instance();
        JPanel area = new JPanel(new GridLayout(1, 1));
        this.tfMaxHit = new NumericField(mbgdData.getProps(MbgdData.PROP_MAXHIT, 0));
        this.tfMaxHit.setColumns(2);
        this.tfMaxHit.setBorder(new TitledBorder("number of maximum hits"));
        area.add(this.tfMaxHit);
        return area;
    }

    public void setProps() {
        MbgdData mbgdData = MbgdData.Instance();
        mbgdData.setProps(MbgdData.PROP_BROWSEREXE, 0, this.tfBrowser.getText());
        mbgdData.setProps(MbgdData.PROP_DBGETURL, 0, this.tfDbgetUrl.getText());
        mbgdData.setProps(MbgdData.PROP_DBGETCGI, 0, this.tfDbgetCgi.getText());
        mbgdData.setProps(MbgdData.PROP_DATASERVER, 0, this.tfServerList.getText());
        mbgdData.setProps(MbgdData.PROP_DATAPATH, 0, this.tfLocalList.getText());
        mbgdData.setProps(MbgdData.PROP_MAXHIT, 0, this.tfMaxHit.getText());
    }
}

