/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class MessageWindow
extends JFrame
implements ActionListener {
    private static final String ERR_type = "text/html";
    private static final String ERR_text = "<h1>ERROR</h1>";
    private static final int MODE_text = 0;
    private static final int MODE_url = 1;
    private static final int MODE_initPage = 2;
    private int mode;
    private String type;
    private String text;
    private String url;
    private URL initPage;
    private JEditorPane ePane;

    public MessageWindow() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(200, 400);
        this.setContents("text/plain", "");
    }

    public void setMode(int m) {
        this.mode = m;
    }

    public int getMode() {
        return this.mode;
    }

    public void setContents(String typ, String tex) {
        this.setMode(0);
        this.type = new String(typ);
        this.text = new String(tex);
    }

    public void setContents(String u) {
        this.setMode(1);
        this.url = new String(u);
    }

    public void setContents(URL page) {
        this.setMode(2);
        try {
            this.initPage = new URL(page.toString());
        }
        catch (Exception e) {
            this.initPage = null;
            this.setErrorContents(page.toString());
        }
    }

    public void setErrorContents(String u) {
        this.setContents(ERR_type, "<h1>ERROR</h1><h3>" + u + "</h3>");
    }

    private String getType() {
        return this.type;
    }

    private String getText() {
        return this.text;
    }

    private String getUrl() {
        return this.url;
    }

    private URL getPage() {
        return this.initPage;
    }

    public void setContents() {
        this.ePane = new JEditorPane();
        switch (this.getMode()) {
            default: {
                this.ePane.setContentType(this.getType());
                this.ePane.setText(this.getText());
                break;
            }
            case 1: {
                try {
                    this.ePane.setPage(this.getUrl());
                    break;
                }
                catch (Exception e) {
                    this.setErrorContents(this.getUrl());
                    this.setContents();
                    return;
                }
            }
            case 2: {
                try {
                    this.ePane.setPage(this.getPage());
                    break;
                }
                catch (Exception e) {
                    this.setErrorContents(this.getPage().toString());
                    this.setContents();
                    return;
                }
            }
        }
        JScrollPane js = new JScrollPane(this.ePane);
        this.getContentPane().add((Component)js, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        this.setContents();
        this.setVisible(true);
    }

    static {
        ERR_type = ERR_type;
        ERR_text = ERR_text;
        MODE_text = 0;
        MODE_url = 1;
        MODE_initPage = 2;
    }
}

