/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.Param;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ParamPanel
extends JDialog
implements ActionListener {
    private JPanel contentPane;
    private GridBagLayout gbl = new GridBagLayout();
    private JLabel labelTitle = new JLabel();
    private JLabel labelItem1 = new JLabel();
    private JTextField textfieldItem1 = new JTextField();
    private JLabel labelItem2 = new JLabel();
    private JTextField textfieldItem2 = new JTextField();
    private JButton buttonOk = new JButton();
    private JButton buttonCancel = new JButton();

    public ParamPanel(Frame parent) {
        super(parent);
        this.enableEvents(64L);
        try {
            this.itemInit();
            this.setDefaultParameter();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void itemInit() throws Exception {
        this.setTitle("CGAT :: Parameter settings");
        this.setSize(600, 300);
        this.contentPane = (JPanel)this.getContentPane();
        this.setResizable(true);
        this.contentPane.setLayout(this.gbl);
        this.labelTitle.setFont(new Font("Dialog", 3, 20));
        this.labelTitle.setHorizontalAlignment(0);
        this.labelTitle.setHorizontalTextPosition(0);
        this.labelTitle.setText("Parameter settings");
        Insets insets = new Insets(0, 0, 0, 0);
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 10, 0, insets, 150, 60);
        this.contentPane.add((Component)this.labelTitle, gbc);
        this.labelItem1.setText("move region size(denominator)");
        insets = new Insets(0, 10, 0, 10);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, insets, 50, 0);
        this.contentPane.add((Component)this.labelItem1, gbc);
        insets = new Insets(10, 0, 10, 0);
        gbc = new GridBagConstraints(1, 1, 4, 1, 0.0, 0.0, 10, 0, insets, 200, 0);
        this.contentPane.add((Component)this.textfieldItem1, gbc);
        this.labelItem2.setText("test");
        insets = new Insets(0, 10, 0, 10);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, insets, 50, 0);
        this.contentPane.add((Component)this.labelItem2, gbc);
        insets = new Insets(10, 0, 10, 0);
        gbc = new GridBagConstraints(1, 2, 4, 1, 0.0, 0.0, 10, 0, insets, 200, 0);
        this.contentPane.add((Component)this.textfieldItem2, gbc);
        this.buttonOk.setPreferredSize(new Dimension(80, 25));
        this.buttonOk.addActionListener(this);
        this.buttonOk.setHorizontalTextPosition(0);
        this.buttonOk.setText("OK");
        this.contentPane.add((Component)this.buttonOk, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(30, 50, 10, 0), 0, 0));
        this.buttonCancel.setPreferredSize(new Dimension(80, 25));
        this.buttonCancel.addActionListener(this);
        this.buttonCancel.setText("Cancel");
        this.contentPane.add((Component)this.buttonCancel, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(30, 0, 10, 0), 0, 0));
    }

    public void setDefaultParameter() {
        Param param = Param.getInstance();
        String txt = String.valueOf(param.getMoveRegSize());
        this.textfieldItem1.setText(txt);
        this.textfieldItem2.setText("123");
    }

    public boolean checkParameter() {
        int intValue;
        Param param = Param.getInstance();
        try {
            intValue = Integer.parseInt(this.textfieldItem1.getText());
        }
        catch (Exception e) {
            String msg = "Wrong number format.\n";
            msg = msg + "FIELD :: move region size(denominator)\n";
            msg = msg + "range :: 0 < value(int) <= 10\n";
            JOptionPane.showMessageDialog(this.getContentPane(), msg);
            return false;
        }
        if (intValue <= 0 || 10 < intValue) {
            String msg = "Wrong range.\n";
            msg = msg + "FIELD :: move region size(denominator)\n";
            msg = msg + "range :: 0 < value(int) <= 10\n";
            JOptionPane.showMessageDialog(this.getContentPane(), msg);
            return false;
        }
        param.setMoveRegSize(intValue);
        try {
            intValue = Integer.parseInt(this.textfieldItem2.getText());
        }
        catch (Exception e) {
            String msg = "Wrong number format.\n";
            msg = msg + "FIELD :: test\n";
            JOptionPane.showMessageDialog(this.getContentPane(), msg);
            return false;
        }
        return true;
    }

    public void updateParameter() {
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(e);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOk) {
            if (this.checkParameter()) {
                this.updateParameter();
                this.dispose();
            }
        } else if (e.getSource() == this.buttonCancel) {
            this.dispose();
        }
    }
}

