/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseFile;
import cgat.BaseMessageDialog;
import cgat.BusyFlag;
import cgat.DiskFile;
import cgat.RegionInfo;
import cgat.UrlFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Observable;
import java.util.StringTokenizer;

public class RegionInfoList
extends Observable {
    public static final boolean TYPE_ATTR_STR = true;
    public static final boolean TYPE_ATTR_VAL = false;
    private String id = "";
    private BusyFlag busy = new BusyFlag();
    private String dataFilename;
    private boolean flagDataLoad = false;
    private String regDataName;
    private String[] attrName;
    private boolean[] attrDataType;
    private RegionInfo[] cRegInfList;
    private String regColorType = null;
    private HashMap hashRegion;

    public RegionInfoList() {
        this.clear();
    }

    public String getAttrName(int i) {
        if (this.attrName[i] != null) {
            return new String(this.attrName[i]);
        }
        return null;
    }

    public void setAttrDataType(int i, boolean sta) {
        this.attrDataType[i] = sta;
    }

    public boolean getAttrDataType(int i) {
        return this.attrDataType[i];
    }

    public String getColorType() {
        return this.regColorType;
    }

    public void setId(String i) {
        this.id = new String(i);
    }

    public void clear() {
        this.cRegInfList = null;
        this.hashRegion = new HashMap();
        this.setDataFilename("");
        this.attrName = new String[5];
        this.attrDataType = new boolean[5];
        int i = 0;
        while (i < 5) {
            this.attrName[i] = null;
            this.attrDataType[i] = false;
            ++i;
        }
    }

    public void setFlagDataLoad(boolean f) {
        this.flagDataLoad = f;
    }

    public boolean getFlagDataLoad() {
        return this.flagDataLoad;
    }

    public void setDataFilename(String name) {
        this.dataFilename = new String(name);
    }

    public int size() {
        if (this.busy.getBusyFlagOwner() != null) {
            return 0;
        }
        try {
            return this.cRegInfList.length;
        }
        catch (NullPointerException np) {
            return 0;
        }
    }

    public RegionInfo getRegionInfo(int index) {
        if (index < 0 || this.size() <= index) {
            return null;
        }
        return this.cRegInfList[index];
    }

    public RegionInfo getRegionInfo(String name) {
        try {
            return (RegionInfo)this.hashRegion.get(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean load(String filename) {
        UrlFile regionFile;
        String fname = "";
        if (this.dataFilename.equals(filename)) {
            this.setFlagDataLoad(false);
            return true;
        }
        this.busy.getBusyFlag();
        this.setFlagDataLoad(true);
        this.clear();
        this.setDataFilename(filename);
        try {
            fname = filename;
            regionFile = new UrlFile(fname);
        }
        catch (Exception e2) {
            String msg = new String("File not found.\nFile : " + fname + "\n");
            BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
            msgDialog.message(msg);
            this.busy.freeBusyFlag();
            return false;
        }
        boolean sta = this.parse(fname, regionFile);
        this.busy.freeBusyFlag();
        return sta;
    }

    public boolean parse(String fname) {
        try {
            DiskFile df = new DiskFile(fname);
            return this.parse(fname, df);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean parse(File f) {
        return this.parse(f.getAbsolutePath());
    }

    public boolean parse(String fname, BaseFile bf) {
        ArrayList<RegionInfo> wkData = new ArrayList<RegionInfo>();
        int lineNo = 0;
        boolean readAttrName = false;
        this.regColorType = "float";
        try {
            while (true) {
                String buf = bf.readLine();
                ++lineNo;
                if (buf == null) break;
                if (buf.startsWith("#")) {
                    if (readAttrName) continue;
                    String bufAttr = null;
                    int i = 0;
                    while (i < buf.length()) {
                        if (buf.charAt(i) != '#') {
                            bufAttr = buf.substring(i + 1).trim();
                            break;
                        }
                        ++i;
                    }
                    if (bufAttr != null) {
                        StringTokenizer tokenAttrName = new StringTokenizer(buf, "\t");
                        int i2 = 0;
                        while (i2 < 5) {
                            tokenAttrName.nextToken();
                            ++i2;
                        }
                        int i3 = 0;
                        while (i3 < 5) {
                            String name;
                            try {
                                name = tokenAttrName.nextToken();
                            }
                            catch (Exception e) {
                                name = new String("");
                            }
                            this.attrName[i3] = name;
                            ++i3;
                        }
                        readAttrName = true;
                        continue;
                    }
                    System.err.println("null");
                    continue;
                }
                StringTokenizer token = new StringTokenizer(buf, "\t");
                String spec = token.nextToken();
                int from = Integer.valueOf(token.nextToken());
                int to = Integer.valueOf(token.nextToken());
                String strDir = token.nextToken();
                byte dir = strDir.equalsIgnoreCase("DIR") ? (byte)1 : (strDir.equalsIgnoreCase("INV") ? (byte)-1 : (byte)Byte.valueOf(strDir));
                String color = token.nextToken();
                try {
                    Float.valueOf(color);
                }
                catch (Exception e) {
                    this.regColorType = "str";
                    System.err.println("DBG :: ColorType = STRING :: " + color);
                }
                if (to < from) {
                    int work = from;
                    from = to;
                    to = work;
                }
                RegionInfo inf = new RegionInfo(from, to, dir, color);
                int i = 0;
                while (i < 5) {
                    try {
                        String attr = token.nextToken();
                        inf.setAttr(i, attr);
                        try {
                            double d = Double.valueOf(attr);
                        }
                        catch (Exception e0) {
                            this.setAttrDataType(i, true);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ++i;
                }
                wkData.add(inf);
                String name = inf.getAttr(0);
                if (name == null) continue;
                name = name.toUpperCase();
                this.hashRegion.put(name, inf);
            }
        }
        catch (Exception e) {
            String msg = new String("Data format error.\nFile : " + fname + "\n" + "Line : " + lineNo + "\n");
            BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
            msgDialog.message(msg);
            System.err.println("File read error : region info");
            return false;
        }
        int lenWkData = wkData.size();
        System.err.println(lenWkData);
        if (lenWkData == 0) {
            return true;
        }
        this.cRegInfList = new RegionInfo[lenWkData];
        int i = 0;
        while (i < lenWkData) {
            this.cRegInfList[i] = (RegionInfo)wkData.get(i);
            ++i;
        }
        CompRegionByFrom c = new CompRegionByFrom();
        Arrays.sort(this.cRegInfList, c);
        return true;
    }

    public ArrayList searchName(ArrayList nameList) {
        ArrayList<RegionInfo> matchInfo = new ArrayList<RegionInfo>();
        HashMap nameHash = new HashMap();
        int i = 0;
        while (i < nameList.size()) {
            nameHash.put((String)nameList.get(i), null);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.size()) {
            RegionInfo r = this.cRegInfList[i2];
            String name = r.getAttr(0);
            if (nameHash.containsKey(name)) {
                matchInfo.add(r);
            }
            ++i2;
        }
        return matchInfo;
    }

    public void setDataName(String name) {
        this.regDataName = new String(name);
    }

    public String getDataName() {
        return new String(this.regDataName);
    }

    public void clearFilter() {
        int i = 0;
        while (i < this.size()) {
            this.setFilter(i, true);
            ++i;
        }
    }

    public void setFilter(int i, boolean f) {
        RegionInfo r = this.cRegInfList[i];
        r.setFilter(f);
    }

    static {
        TYPE_ATTR_STR = true;
        TYPE_ATTR_VAL = false;
    }

    class CompRegionByFrom
    implements Comparator {
        CompRegionByFrom() {
        }

        public int compare(Object objA, Object objB) {
            RegionInfo a = (RegionInfo)objA;
            RegionInfo b = (RegionInfo)objB;
            return a.getFrom() - b.getFrom();
        }
    }
}

