/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BrowsFileList;
import cgat.MarkEnt;
import cgat.MbgdData;
import cgat.MbgdDataMng;
import cgat.RegionInfo;
import cgat.SearchOrfResFrame;
import cgat.ViewWindow;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Observable;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SearchOrfCommand
extends Observable
implements ActionListener {
    private JFrame frame;
    private MbgdDataMng mbgdDataMng;
    private ViewWindow viewWin;
    private JOptionPane optionPane;
    private JPanel panel;
    private JLabel lab1;
    private JLabel lab2;
    private JScrollPane spOrfname;
    private JTextArea taOrfname;
    private JTextField tfOrfFilename;
    private JButton browsFile;

    public SearchOrfCommand(JFrame f, MbgdDataMng dataMng, ViewWindow vWin) {
        this.frame = f;
        this.mbgdDataMng = dataMng;
        this.viewWin = vWin;
        this.frame.setTitle("Search ORF");
    }

    public int showDialog() {
        this.lab1 = new JLabel("Input ORF name(s)");
        this.taOrfname = new JTextArea(10, 40);
        this.spOrfname = new JScrollPane(this.taOrfname);
        this.spOrfname.setVerticalScrollBarPolicy(22);
        this.lab2 = new JLabel("filename : ");
        this.tfOrfFilename = new JTextField(20);
        this.browsFile = new JButton("Brows");
        this.panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        this.panel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.insets = new Insets(20, 0, 0, 0);
        c.gridwidth = 0;
        c.anchor = 17;
        gridbag.setConstraints(this.lab1, c);
        this.panel.add(this.lab1);
        c.insets = new Insets(0, 0, 20, 0);
        c.gridwidth = 0;
        gridbag.setConstraints(this.spOrfname, c);
        this.panel.add(this.spOrfname);
        System.err.println("##");
        MbgdData mbgdData = MbgdData.Instance();
        if (!mbgdData.isApplet()) {
            c.gridwidth = 0;
            c.insets = new Insets(20, 0, 0, 0);
            gridbag.setConstraints(this.lab2, c);
            this.panel.add(this.lab2);
            c.gridwidth = -1;
            c.insets = new Insets(0, 0, 20, 0);
            gridbag.setConstraints(this.tfOrfFilename, c);
            this.panel.add(this.tfOrfFilename);
            c.gridwidth = 0;
            gridbag.setConstraints(this.browsFile, c);
            this.panel.add(this.browsFile);
            BrowsFileList bowsFileList = new BrowsFileList(this.tfOrfFilename);
            this.browsFile.addActionListener(bowsFileList);
        }
        this.frame.setResizable(false);
        Object[] msg = new Object[]{this.panel};
        Object[] btn = new Object[]{"ALL Clear", "Clear", "Search", "Cancel"};
        int ret = JOptionPane.showOptionDialog(this.frame, msg, "SEARCH", 2, -1, null, btn, btn[2]);
        return ret;
    }

    public ArrayList getOrfNameList() {
        ArrayList<String> orfList = new ArrayList<String>();
        StringTokenizer stLine = new StringTokenizer(this.taOrfname.getText(), "\n");
        while (stLine.hasMoreTokens()) {
            StringTokenizer stField = new StringTokenizer(stLine.nextToken(), " ");
            while (stField.hasMoreTokens()) {
                String orfname = stField.nextToken();
                orfname.trim();
                if (orfname.equals("")) continue;
                orfList.add(orfname);
            }
        }
        return orfList;
    }

    public void actionAllClear() {
        this.mbgdDataMng.clearMarkEnt();
    }

    public void actionClear() {
        ArrayList orfList = this.getOrfNameList();
        int loopMax = orfList.size();
        int i = 0;
        while (i < loopMax) {
            String orfName = (String)orfList.get(i);
            this.mbgdDataMng.delMarkEnt(orfName);
            ++i;
        }
    }

    public void actionSearch() {
        ArrayList orfList = this.getOrfNameList();
        MbgdData mbgdData = MbgdData.Instance();
        if (!mbgdData.isApplet()) {
            File orfFile = new File(this.tfOrfFilename.getText());
            String inOrfName = "";
            if (orfFile.exists()) {
                try {
                    String buf;
                    BufferedReader br = new BufferedReader(new FileReader(orfFile));
                    while ((buf = br.readLine()) != null) {
                        inOrfName = inOrfName + " " + buf;
                    }
                }
                catch (Exception e2) {
                    System.err.println("File read error : " + orfFile.getAbsolutePath());
                }
            }
            StringTokenizer stLine = new StringTokenizer(inOrfName, " ");
            while (stLine.hasMoreTokens()) {
                orfList.add(stLine.nextToken());
            }
        }
        boolean isExist = false;
        String sp1Name = this.mbgdDataMng.getSpecName(true);
        String sp2Name = this.mbgdDataMng.getSpecName(false);
        int i = 0;
        while (i < orfList.size()) {
            String orfName = (String)orfList.get(i);
            orfName = orfName.toUpperCase();
            boolean basespec = true;
            String spName = sp1Name;
            RegionInfo rInfo = this.mbgdDataMng.getGeneInfo(true, orfName);
            if (rInfo == null) {
                basespec = false;
                spName = sp2Name;
                rInfo = this.mbgdDataMng.getGeneInfo(false, orfName);
            }
            if (rInfo != null) {
                int from = rInfo.getFrom();
                int to = rInfo.getTo();
                byte dir = rInfo.getDir();
                this.mbgdDataMng.addMarkEnt(basespec, new MarkEnt(spName, orfName, from, to, dir, 1, new Color(65535)));
            }
            ++i;
        }
        this.dispHitOrfTable();
    }

    public void dispHitOrfTable() {
        JFrame f = new JFrame();
        f.setTitle("ORF name");
        SearchOrfResFrame resFrame = SearchOrfResFrame.Instance(this.viewWin);
        resFrame.clear();
        boolean isExist = false;
        MarkEnt[] entListBase = this.mbgdDataMng.getMarkEntAll(true);
        this.setHitOrfTableEnt(resFrame, entListBase);
        MarkEnt[] entListOppo = this.mbgdDataMng.getMarkEntAll(false);
        this.setHitOrfTableEnt(resFrame, entListOppo);
        if (entListBase.length == 0 && entListOppo.length == 0) {
            int idx = 0;
            Object[] dat = new Object[5];
            dat[idx++] = new String("nodata found");
            dat[idx++] = new String("");
            dat[idx++] = new Integer(0);
            dat[idx++] = new Integer(0);
            dat[idx++] = new String("");
            resFrame.addRow(dat);
        }
        resFrame.setVisible(true);
    }

    public void setHitOrfTableEnt(SearchOrfResFrame resFrame, MarkEnt[] entList) {
        int loopMax = entList.length;
        int i = 0;
        while (i < loopMax) {
            MarkEnt ent = entList[i];
            int idx = 0;
            Object[] dat = new Object[6];
            dat[idx++] = new String(ent.getSpName());
            dat[idx++] = new Integer(ent.getPosFrom());
            dat[idx++] = new Integer(ent.getPosTo());
            dat[idx++] = 0 < ent.getDir() ? new String("DIR") : new String("INV");
            dat[idx++] = new Integer(ent.getColorType());
            dat[idx++] = new String(ent.getName());
            resFrame.addRow(dat);
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        int ret = this.showDialog();
        switch (ret) {
            case 0: {
                this.actionAllClear();
                this.setChanged();
                this.notifyObservers("searchOrf");
                break;
            }
            case 1: {
                this.actionClear();
                this.setChanged();
                this.notifyObservers("searchOrf");
                break;
            }
            case 2: {
                this.actionSearch();
                this.setChanged();
                this.notifyObservers("searchOrf");
                break;
            }
        }
    }
}

