/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseMessageDialog;
import cgat.MbgdDataMng;
import cgat.SegmentFilterDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;

public class SegmentFilterCommand
implements ActionListener,
Observer {
    private Frame frame;
    private MbgdDataMng mbgdDataMng;
    private SegmentFilterDialog dialog;

    public SegmentFilterCommand(Frame f, MbgdDataMng dataMng) {
        this.frame = f;
        this.dialog = SegmentFilterDialog.Instance(f);
        this._init(dataMng);
    }

    private void _init(MbgdDataMng dataMng) {
        this.mbgdDataMng = dataMng;
        this.setup();
    }

    public void setup() {
        this.dialog.clear();
        String[] segName = new String[]{this.mbgdDataMng.getSegmentName(true), this.mbgdDataMng.getSegmentName(false)};
        this.dialog.setSegmentName(segName);
        String[] segItemName = new String[5];
        int i = 0;
        while (i < 5) {
            segItemName[i] = this.mbgdDataMng.getSegAttrName(2, 0, i);
            ++i;
        }
        this.dialog.setSegmentItem(0, segItemName);
        segItemName = new String[5];
        i = 0;
        while (i < 5) {
            segItemName[i] = this.mbgdDataMng.getSegAttrName(12, 1, i);
            ++i;
        }
        this.dialog.setSegmentItem(1, segItemName);
        this.dialog.setGuiParts();
    }

    public void actionPerformed(ActionEvent e) {
        StringTokenizer st;
        String str1;
        double val2;
        double val1;
        int idxCond;
        int idxSegmentItem;
        int idxSegment;
        block16: {
            this.setup();
            this.dialog.setVisible(true);
            idxSegment = this.dialog.getSelectedSegmentIndex();
            int sta = this.dialog.getStatus();
            switch (sta) {
                case -1: {
                    return;
                }
                case 0: {
                    this.mbgdDataMng.clearFilterSegment(idxSegment);
                    this.frame.repaint();
                    return;
                }
            }
            idxSegmentItem = this.dialog.getSelectedSegmentItemIndex();
            idxCond = this.dialog.getSelectedConditionIndex();
            String text = this.dialog.getInputTextValue().trim();
            val1 = 0.0;
            val2 = 0.0;
            str1 = "";
            st = new StringTokenizer(text);
            if (st.countTokens() == 0) {
                return;
            }
            try {
                str1 = st.nextToken();
                val1 = Double.valueOf(str1);
            }
            catch (Exception e1) {
                if (idxCond == 4) break block16;
                String msg = new String("Data format error.\n");
                BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
                msgDialog.message(msg);
                return;
            }
        }
        try {
            if (idxCond == 0 || idxCond == 1) {
                val2 = Double.valueOf(st.nextToken());
            }
        }
        catch (Exception e2) {
            String msg = new String("Data format error.\n");
            BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
            msgDialog.message(msg);
            return;
        }
        switch (idxCond) {
            case 0: 
            case 1: {
                this.mbgdDataMng.filterSegment(idxCond, idxSegment, idxSegmentItem, val1, val2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                this.mbgdDataMng.filterSegment(idxCond, idxSegment, idxSegmentItem, val1);
                break;
            }
            case 4: {
                if (!this.mbgdDataMng.getSegAttrDataType(0, idxSegmentItem)) {
                    this.mbgdDataMng.filterSegment(idxCond, idxSegment, idxSegmentItem, val1);
                    break;
                }
                this.mbgdDataMng.filterSegment(idxCond, idxSegment, idxSegmentItem, str1);
                break;
            }
        }
        this.frame.repaint();
    }

    public void update(Observable o, Object arg) {
        if (o instanceof MbgdDataMng) {
            this.update((MbgdDataMng)o, arg);
        }
    }

    public void update(MbgdDataMng mbgdDataMng, Object arg) {
    }
}

