/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseFilterDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SegmentFilterDialog
extends BaseFilterDialog
implements ActionListener {
    private static SegmentFilterDialog _instance = null;
    private JComboBox cbSegName = null;
    private JComboBox cbSegItem = null;
    private JComboBox cbCond = null;
    private JTextField tfInput = null;
    private String[] segmentName;
    private String[][] segmentItem;

    public static SegmentFilterDialog Instance(Frame f) {
        if (_instance == null) {
            _instance = new SegmentFilterDialog(f, true);
        }
        return _instance;
    }

    public static SegmentFilterDialog Instance() {
        if (_instance == null) {
            System.err.println("Error!! Can not create 'SegmentFilterDialog'");
        }
        return _instance;
    }

    private SegmentFilterDialog(Frame f, boolean sta) {
        super(f, sta);
        this.setVisible(false);
        this.setSize(600, 300);
        this.setResizable(false);
        this.clear();
    }

    public void clear() {
        this.setStatus(-1);
        this.segmentName = null;
        this.segmentItem = null;
    }

    public void setGuiParts() {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.removeAll();
        JPanel pCenter = new JPanel();
        this.cbSegName = new JComboBox<String>(this.segmentName);
        this.cbSegItem = new JComboBox<String>(this.segmentItem[0]);
        this.cbCond = new JComboBox<String>(BaseFilterDialog.CondList);
        this.tfInput = new JTextField(20);
        this.tfInput.setSize(100, 50);
        this.cbSegName.addActionListener(this);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        pCenter.setLayout(layout);
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(10, 10, 10, 10);
        c.gridwidth = 3;
        c.gridheight = 2;
        c.gridx = 0;
        c.gridy = 0;
        layout.setConstraints(this.cbSegName, c);
        pCenter.add(this.cbSegName);
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = -1;
        c.gridy = -1;
        layout.setConstraints(this.cbSegItem, c);
        pCenter.add(this.cbSegItem);
        c.weightx = 1.0;
        c.weighty = 1.0;
        layout.setConstraints(this.cbCond, c);
        pCenter.add(this.cbCond);
        layout.setConstraints(this.tfInput, c);
        pCenter.add(this.tfInput);
        JPanel pSouth = new JPanel();
        JButton btnClear = new JButton("Reset filter");
        JButton btnFilter = new JButton("Filter");
        JButton btnCancel = new JButton("Cancel");
        BaseFilterDialog.CmdClear cmdClear = new BaseFilterDialog.CmdClear(this);
        BaseFilterDialog.CmdFilter cmdFilter = new BaseFilterDialog.CmdFilter(this);
        BaseFilterDialog.CmdCancel cmdCancel = new BaseFilterDialog.CmdCancel(this);
        btnClear.addActionListener(cmdClear);
        btnFilter.addActionListener(cmdFilter);
        btnCancel.addActionListener(cmdCancel);
        pSouth.add(btnClear);
        pSouth.add(btnFilter);
        pSouth.add(btnCancel);
        pane.add((Component)pCenter, "Center");
        pane.add((Component)pSouth, "South");
        this.pack();
    }

    public void setSegmentName(String[] segName) {
        int n = 0;
        while (n < segName.length) {
            if (segName[n] == null) break;
            ++n;
        }
        this.segmentName = new String[n];
        int i = 0;
        while (i < n) {
            this.segmentName[i] = new String(segName[i]);
            ++i;
        }
        this.segmentItem = new String[n][];
    }

    public void setSegmentItem(int segIdx, String[] segItem) {
        int n = 0;
        while (n < segItem.length) {
            if (segItem[n] == null) break;
            ++n;
        }
        this.segmentItem[segIdx] = new String[n];
        int i = 0;
        while (i < n) {
            this.segmentItem[segIdx][i] = new String(segItem[i]);
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        JComboBox srcObj = (JComboBox)e.getSource();
        int idx = srcObj.getSelectedIndex();
        this.cbSegItem.removeAllItems();
        int i = 0;
        while (i < this.segmentItem[idx].length) {
            this.cbSegItem.addItem(this.segmentItem[idx][i]);
            ++i;
        }
    }

    public String getSelectedSegmentName() {
        return new String((String)this.cbSegName.getSelectedItem());
    }

    public int getSelectedSegmentIndex() {
        return this.cbSegName.getSelectedIndex();
    }

    public String getSelectedSegmentItemName() {
        return new String((String)this.cbSegItem.getSelectedItem());
    }

    public int getSelectedSegmentItemIndex() {
        return this.cbSegItem.getSelectedIndex();
    }

    public String getSelectedConditionName() {
        return new String((String)this.cbCond.getSelectedItem());
    }

    public int getSelectedConditionIndex() {
        return this.cbCond.getSelectedIndex();
    }

    public String getInputTextValue() {
        return new String(this.tfInput.getText());
    }
}

