/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.InfoGeneAttr;
import cgat.InfoSegments;
import cgat.MbgdData;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SelectSpecDialog {
    private static SelectSpecDialog _instance = null;
    boolean staSelect;
    JComboBox spec;
    JComboBox attr;
    JComboBox seg1;
    JComboBox seg2;
    ArrayList specFileList;
    InfoGeneAttr infoGeneAttr;
    InfoSegments infoSegments;
    HashMap selectSpecInfo;
    String selectGeneAttr;
    String selectGeneColorType;
    String selectSeg1Info;
    String selectSeg2Info;

    public static SelectSpecDialog Instance() {
        if (_instance == null) {
            _instance = new SelectSpecDialog();
        }
        return _instance;
    }

    private SelectSpecDialog() {
        this.setStaSelect(false, null, null, null, null, null);
        this.specFileList = this.getSpecList();
        String[] specList = new String[this.specFileList.size()];
        int i = 0;
        while (i < this.specFileList.size()) {
            HashMap specInfo = (HashMap)this.specFileList.get(i);
            String locate = ((String)specInfo.get("PATH")).startsWith("http://") ? "(Server)" : "";
            specList[i] = new String(specInfo.get("SPEC") + locate);
            ++i;
        }
        this.spec = new JComboBox<String>(specList);
        String path = (String)((HashMap)this.specFileList.get(0)).get("PATH");
        this.infoGeneAttr = new InfoGeneAttr();
        this.infoGeneAttr.load(path + "/geneAttr");
        String[] attrList = new String[this.infoGeneAttr.size() + 1];
        attrList[0] = new String("Function Category");
        int i2 = 0;
        while (i2 < this.infoGeneAttr.size()) {
            attrList[i2 + 1] = this.infoGeneAttr.getName(i2);
            ++i2;
        }
        this.attr = new JComboBox<String>(attrList);
        this.infoSegments = new InfoSegments();
        this.infoSegments.load(path + "/infoSegs");
        String[] segList = new String[this.infoSegments.size() + 1];
        segList[0] = new String("### no data ###");
        int i3 = 0;
        while (i3 < this.infoSegments.size()) {
            segList[i3 + 1] = this.infoSegments.getName(i3);
            ++i3;
        }
        this.seg1 = new JComboBox<String>(segList);
        if (1 <= this.infoSegments.size()) {
            this.seg1.setSelectedIndex(1);
        } else {
            this.seg1.setSelectedIndex(0);
        }
        this.seg2 = new JComboBox<String>(segList);
        if (2 <= this.infoSegments.size()) {
            this.seg2.setSelectedIndex(2);
        } else {
            this.seg2.setSelectedIndex(0);
        }
    }

    public void showDialog(JFrame frame) {
        Object[] opt = new Object[]{"Please select spec data", this.spec, "Gene Attribute", this.attr, "Seg1", this.seg1, "Seg2", this.seg2};
        int ret = JOptionPane.showConfirmDialog(frame.getContentPane(), opt, "Select spec", 2, -1);
        if (ret == 0) {
            String geneAttr = null;
            String geneColorType = null;
            String seg1Info = null;
            String seg2Info = null;
            int idx = this.attr.getSelectedIndex();
            if (idx != 0) {
                geneAttr = this.infoGeneAttr.getKey(idx - 1);
                geneColorType = this.infoGeneAttr.getType(idx - 1);
            }
            if ((idx = this.seg1.getSelectedIndex()) != 0) {
                seg1Info = this.infoSegments.getDir(idx - 1);
            }
            if ((idx = this.seg2.getSelectedIndex()) != 0) {
                seg2Info = this.infoSegments.getDir(idx - 1);
            }
            this.setStaSelect(true, (HashMap)this.specFileList.get(this.spec.getSelectedIndex()), geneAttr, geneColorType, seg1Info, seg2Info);
        }
    }

    public void setStaSelect(boolean sta, HashMap info, String geneAttr, String geneColorType, String seg1Info, String seg2Info) {
        this.staSelect = sta;
        this.selectSpecInfo = info;
        this.selectGeneAttr = geneAttr;
        this.selectGeneColorType = geneColorType;
        this.selectSeg1Info = seg1Info;
        this.selectSeg2Info = seg2Info;
    }

    public boolean getStaSelect() {
        return this.staSelect;
    }

    protected ArrayList getSpecList() {
        ArrayList geneFileList = new ArrayList();
        this.getSpecListUrl(geneFileList);
        return geneFileList;
    }

    protected void getSpecListUrl(ArrayList geneFileList) {
        int i = 0;
        while (i < 1) {
            String url = MbgdData.Instance().getProps(MbgdData.PROP_DATASERVER, i);
            if (!url.equals("")) {
                this.getGeneFileListUrl(url, geneFileList);
            }
            ++i;
        }
    }

    protected void getGeneFileListUrl(String url, ArrayList fileList) {
        try {
            String buf;
            String geneUrl = new String(url + "/gene");
            String filelist = new String(geneUrl + "/filelist");
            DataInputStream in = new DataInputStream(new URL(filelist).openStream());
            BufferedReader inGene = new BufferedReader(new InputStreamReader(in));
            ArrayList<String> workFileList = new ArrayList<String>();
            String colorTabOrg = new String(geneUrl + "/colorTab");
            while ((buf = inGene.readLine()) != null) {
                workFileList.add(buf);
            }
            int i = 0;
            while (i < workFileList.size()) {
                String file = (String)workFileList.get(i);
                if (file.startsWith("gene.")) {
                    String spec = file.substring("gene.".length());
                    if (file.endsWith(".gz")) {
                        spec = spec.substring(0, spec.length() - ".gz".length());
                    }
                    if (0 > spec.indexOf(".")) {
                        String chromosome = new String(geneUrl + "/chromosome." + spec);
                        if (this.selectFile(new String("chromosome." + spec), workFileList) == null) {
                            // empty if block
                        }
                        String colorTab = new String(geneUrl + "/colorTab." + spec);
                        if (this.selectFile(new String("colorTab." + spec), workFileList) == null) {
                            colorTab = colorTabOrg;
                        }
                        HashMap<String, String> geneInfo = new HashMap<String, String>();
                        geneInfo.put("PATH", url);
                        geneInfo.put("SPEC", spec);
                        geneInfo.put("GENE", new String(geneUrl + "/" + file));
                        geneInfo.put("CHROMOSOME", chromosome);
                        geneInfo.put("COLORTAB", colorTab);
                        fileList.add(geneInfo);
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void getSegFileListUrl(String type2, String url, ArrayList fileList) {
        try {
            String buf;
            String segUrl = new String(url + "/" + type2);
            String filelist = new String(segUrl + "/filelist");
            DataInputStream in = new DataInputStream(new URL(filelist).openStream());
            BufferedReader inSeg = new BufferedReader(new InputStreamReader(in));
            ArrayList<String> workFileList = new ArrayList<String>();
            String colorTabOrg = new String("");
            while ((buf = inSeg.readLine()) != null) {
                workFileList.add(buf);
                if (!buf.equals("colorTab")) continue;
                colorTabOrg = new String(segUrl + "/colorTab");
            }
            int i = 0;
            while (i < workFileList.size()) {
                String file = (String)workFileList.get(i);
                if (file.startsWith("seg.")) {
                    String spec = file.substring("seg.".length());
                    if (file.endsWith(".gz")) {
                        spec = spec.substring(0, spec.length() - ".gz".length());
                    }
                    if (0 > spec.indexOf(".")) {
                        String colorTab = new String(segUrl + "/colorTab." + spec);
                        if (this.selectFile(new String("colorTab." + spec), workFileList) == null) {
                            colorTab = colorTabOrg;
                        }
                        HashMap<String, String> segInfo = new HashMap<String, String>();
                        segInfo.put("SPEC", spec);
                        segInfo.put("SEG", new String(segUrl + "/" + file));
                        segInfo.put("COLORTAB", colorTab);
                        fileList.add(segInfo);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void getGeneFileListDisk(String path, ArrayList fileList) {
        String geneDir = new String(path + System.getProperty("file.separator") + "gene");
        File geneDirFile = new File(geneDir);
        if (!geneDirFile.isDirectory()) {
            return;
        }
        String colorTabOrg = new String(geneDir + System.getProperty("file.separator") + "colorTab");
        File colorTabFile = new File(colorTabOrg);
        if (!colorTabFile.isFile()) {
            colorTabOrg = "";
        }
        String[] geneFileList = geneDirFile.list();
        int i = 0;
        while (i < geneFileList.length) {
            if (geneFileList[i].startsWith("gene.")) {
                String chromosome;
                File chromosomeFile;
                String spec = geneFileList[i].substring("gene.".length());
                if (geneFileList[i].endsWith(".gz")) {
                    spec = spec.substring(0, spec.length() - ".gz".length());
                }
                if (0 > spec.indexOf(".") && (chromosomeFile = new File(chromosome = new String(geneDir + System.getProperty("file.separator") + "chromosome." + spec))).isFile()) {
                    String colorTab = new String(geneDir + System.getProperty("file.separator") + "colorTab." + spec);
                    colorTabFile = new File(colorTab);
                    if (!colorTabFile.isFile()) {
                        colorTab = colorTabOrg;
                    }
                    HashMap<String, String> geneInfo = new HashMap<String, String>();
                    geneInfo.put("PATH", path);
                    geneInfo.put("SPEC", spec);
                    geneInfo.put("GENE", new String(geneDir + System.getProperty("file.separator") + geneFileList[i]));
                    geneInfo.put("CHROMOSOME", chromosome);
                    geneInfo.put("COLORTAB", colorTab);
                    fileList.add(geneInfo);
                }
            }
            ++i;
        }
    }

    protected void getSegFileListDisk(String type2, String path, ArrayList fileList) {
        String segDir = new String(path + System.getProperty("file.separator") + type2);
        File segDirFile = new File(segDir);
        if (!segDirFile.isDirectory()) {
            return;
        }
        String colorTabOrg = new String(segDir + System.getProperty("file.separator") + "colorTab");
        File colorTabFile = new File(colorTabOrg);
        if (!colorTabFile.isFile()) {
            colorTabOrg = "";
        }
        String[] segFileList = segDirFile.list();
        int i = 0;
        while (i < segFileList.length) {
            if (segFileList[i].startsWith("seg.")) {
                String spec = segFileList[i].substring("seg.".length());
                if (segFileList[i].endsWith(".gz")) {
                    spec = spec.substring(0, spec.length() - ".gz".length());
                }
                if (0 > spec.indexOf(".")) {
                    String colorTab = new String(segDir + System.getProperty("file.separator") + "colorTab." + spec);
                    colorTabFile = new File(colorTab);
                    if (!colorTabFile.isFile()) {
                        colorTab = colorTabOrg;
                    }
                    HashMap<String, String> segInfo = new HashMap<String, String>();
                    segInfo.put("SPEC", spec);
                    segInfo.put("SEG", new String(segDir + System.getProperty("file.separator") + segFileList[i]));
                    segInfo.put("COLORTAB", colorTab);
                    fileList.add(segInfo);
                }
            }
            ++i;
        }
    }

    protected String selectFile(String filename, ArrayList fileList) {
        int i = 0;
        while (i < fileList.size()) {
            String file = (String)fileList.get(i);
            if (file.equals(filename)) {
                return file;
            }
            ++i;
        }
        return null;
    }

    protected HashMap selectRegInfo(ArrayList fileList, String spec) {
        HashMap selectInfo = null;
        int i = 0;
        while (i < fileList.size()) {
            HashMap info = (HashMap)fileList.get(i);
            if (spec.equals((String)info.get("SPEC"))) {
                selectInfo = info;
                break;
            }
            ++i;
        }
        if (selectInfo == null) {
            System.err.println("not found : " + spec);
        }
        return selectInfo;
    }

    public HashMap getSelectSpecInfo() {
        return this.selectSpecInfo;
    }

    public String getSelectGeneAttr() {
        return this.selectGeneAttr;
    }

    public String getSelectGeneColorType() {
        return this.selectGeneColorType;
    }

    public String getSelectSeg1Info() {
        return this.selectSeg1Info;
    }

    public String getSelectSeg2Info() {
        return this.selectSeg2Info;
    }

    public String getSelectedSeg1Name() {
        String name = null;
        name = new String((String)this.seg1.getSelectedItem());
        return name;
    }

    public String getSelectedSeg2Name() {
        String name = null;
        name = new String((String)this.seg2.getSelectedItem());
        return name;
    }
}

