/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.InfoGeneAttr;
import cgat.InfoSegments;
import cgat.MbgdData;
import cgat.SelectSegment;
import cgat.SelectSegmentInfo;
import cgat.UrlFile;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SelectSpecPairDialog {
    private static SelectSpecPairDialog _instance = null;
    private boolean staSelect;
    private JFrame frame;
    private JComboBox spec;
    private JComboBox attr;
    private JComboBox seg1;
    private JComboBox seg2;
    private ArrayList alignFileList;
    private InfoGeneAttr infoGeneAttr;
    private InfoSegments infoSegments;
    private HashMap selectSpecInfo;
    private String selectGeneAttr;
    private String selectGeneColorType;
    private String selectSeg1Info;
    private String selectSeg2Info;
    private String selectSeg1Cgi;
    private String selectSeg2Cgi;
    private SelectSegmentInfo selectSegInfo;
    private SelectSegment selectSeg1;
    private SelectSegment selectSeg2;

    public static SelectSpecPairDialog Instance(JFrame f) {
        if (_instance == null) {
            _instance = new SelectSpecPairDialog(f);
        }
        return _instance;
    }

    private SelectSpecPairDialog(JFrame f) {
        this.frame = f;
        this.setStaSelect(false, null, null, null, null, null, null, null);
        this.alignFileList = this.getSpecList();
        String[] specList = new String[this.alignFileList.size()];
        int i = 0;
        while (i < this.alignFileList.size()) {
            HashMap alignInfo = (HashMap)this.alignFileList.get(i);
            String locate = ((String)alignInfo.get("PATH")).startsWith("http://") ? "(Server)" : "";
            specList[i] = new String(alignInfo.get("ALIGN") + locate);
            ++i;
        }
        this.spec = new JComboBox<String>(specList);
        MbgdData mbgdData = MbgdData.Instance();
        String path = mbgdData.getBasePath();
        this.infoGeneAttr = new InfoGeneAttr();
        this.infoGeneAttr.load(path + "cgi-bin/geneAttr.cgi");
        String[] attrList = new String[this.infoGeneAttr.size() + 1];
        attrList[0] = new String("Function Category");
        int i2 = 0;
        while (i2 < this.infoGeneAttr.size()) {
            attrList[i2 + 1] = this.infoGeneAttr.getName(i2);
            ++i2;
        }
        this.attr = new JComboBox<String>(attrList);
        this.selectSegInfo = new SelectSegmentInfo();
        this.selectSeg1 = new SelectSegment(this.frame, this.selectSegInfo);
        this.selectSeg2 = new SelectSegment(this.frame, this.selectSegInfo);
    }

    public void showDialog() {
        Object[] opt = new Object[]{"Please select alignment data", this.spec, "Gene Attribute", this.attr, "Seg1", this.selectSeg1, "Seg2", this.selectSeg2};
        this.setStaSelect(false, null, null, null, null, null, null, null);
        int ret = JOptionPane.showConfirmDialog(this.frame.getContentPane(), opt, "Select species pair", 2, -1);
        if (ret == 0) {
            String geneAttr = null;
            String geneColorType = null;
            String seg1Info = null;
            String seg2Info = null;
            String seg1Cgi = null;
            String seg2Cgi = null;
            int idx = this.attr.getSelectedIndex();
            if (idx != 0) {
                geneAttr = this.infoGeneAttr.getKey(idx - 1);
                geneColorType = this.infoGeneAttr.getType(idx - 1);
            }
            seg1Info = this.selectSeg1.getSelectedSegName();
            seg2Info = this.selectSeg2.getSelectedSegName();
            seg1Cgi = this.selectSeg1.getSelectedSegCgi();
            seg2Cgi = this.selectSeg2.getSelectedSegCgi();
            this.setStaSelect(true, (HashMap)this.alignFileList.get(this.spec.getSelectedIndex()), geneAttr, geneColorType, seg1Info, seg1Cgi, seg2Info, seg2Cgi);
        }
    }

    public void setStaSelect(boolean sta, HashMap info, String geneAttr, String geneColorType, String seg1Info, String seg1Cgi, String seg2Info, String seg2Cgi) {
        this.staSelect = sta;
        this.selectSpecInfo = info;
        this.selectGeneAttr = geneAttr;
        this.selectGeneColorType = geneColorType;
        this.selectSeg1Info = seg1Info;
        this.selectSeg2Info = seg2Info;
        this.selectSeg1Cgi = seg1Cgi;
        this.selectSeg2Cgi = seg2Cgi;
    }

    public boolean getStaSelect() {
        return this.staSelect;
    }

    protected ArrayList getSpecList() {
        ArrayList alignFileList = new ArrayList();
        this.getSpecListUrl(alignFileList);
        return alignFileList;
    }

    protected void makeupSpecList(ArrayList alignFileList, ArrayList geneFileList) {
        int i = 0;
        while (i < alignFileList.size()) {
            HashMap alignInfo = (HashMap)alignFileList.get(i);
            alignInfo.put("SP1GENE", this.selectRegInfo(geneFileList, (String)alignInfo.get("SPEC1")));
            alignInfo.put("SP2GENE", this.selectRegInfo(geneFileList, (String)alignInfo.get("SPEC2")));
            ++i;
        }
    }

    protected void getSpecListUrl(ArrayList alignFileList) {
        MbgdData mbgdData = MbgdData.Instance();
        this.getAlignFileListUrl(mbgdData.getBasePath(), alignFileList);
    }

    protected void getAlignFileListUrl(String url, ArrayList fileList) {
        try {
            String buf;
            String alignUrl = new String(url + "/cgi-bin");
            String filelist = new String(alignUrl + "/filelist.cgi");
            UrlFile inAlign = new UrlFile(filelist);
            ArrayList<String> workFileList = new ArrayList<String>();
            String colorTab = new String("");
            while ((buf = inAlign.readLine()) != null) {
                if (buf.trim().equals("")) continue;
                workFileList.add(buf);
            }
            int i = 0;
            while (i < workFileList.size()) {
                String file = (String)workFileList.get(i);
                if (file.endsWith(".gz")) {
                    file = file.substring(0, file.length() - ".gz".length());
                }
                int sepIdx = file.indexOf("-");
                String spec1 = file.substring(file.indexOf(".") + 1, sepIdx);
                String spec2 = file.substring(sepIdx + 1);
                if (0 > spec2.indexOf(".")) {
                    HashMap<String, String> alignInfo = new HashMap<String, String>();
                    alignInfo.put("SPEC1", spec1);
                    alignInfo.put("SPEC2", spec2);
                    alignInfo.put("PATH", url);
                    alignInfo.put("ALIGN", file);
                    alignInfo.put("FILE", file.substring(0, file.indexOf(".")));
                    alignInfo.put("COLORTAB", colorTab);
                    fileList.add(alignInfo);
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("Exception: getAlignFileListURL");
        }
    }

    protected void getGeneFileListUrl(String url, ArrayList fileList) {
        try {
            String buf;
            String geneUrl = new String(url + "/gene");
            String filelist = new String(geneUrl + "/filelist");
            DataInputStream in = new DataInputStream(new URL(filelist).openStream());
            BufferedReader inGene = new BufferedReader(new InputStreamReader(in));
            ArrayList<String> workFileList = new ArrayList<String>();
            String colorTabOrg = new String("");
            while ((buf = inGene.readLine()) != null) {
                workFileList.add(buf);
                if (!buf.equals("colorTab")) continue;
                colorTabOrg = new String(geneUrl + "/colorTab");
            }
            int i = 0;
            while (i < workFileList.size()) {
                String file = (String)workFileList.get(i);
                if (file.startsWith("gene.")) {
                    String spec = file.substring("gene.".length());
                    if (file.endsWith(".gz")) {
                        spec = spec.substring(0, spec.length() - ".gz".length());
                    }
                    if (0 > spec.indexOf(".")) {
                        String chromosome = new String(geneUrl + "/chromosome." + spec);
                        if (this.selectFile(new String("chromosome." + spec), workFileList) != null) {
                            String colorTab = new String(geneUrl + "/colorTab." + spec);
                            if (this.selectFile(new String("colorTab." + spec), workFileList) == null) {
                                colorTab = colorTabOrg;
                            }
                            HashMap<String, String> geneInfo = new HashMap<String, String>();
                            geneInfo.put("SPEC", spec);
                            geneInfo.put("GENE", new String(geneUrl + "/" + file));
                            geneInfo.put("CHROMOSOME", chromosome);
                            geneInfo.put("COLORTAB", colorTab);
                            fileList.add(geneInfo);
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void getSegFileListUrl(String type2, String url, ArrayList fileList) {
        try {
            String buf;
            String segUrl = new String(url + "/" + type2);
            String filelist = new String(segUrl + "/filelist");
            DataInputStream in = new DataInputStream(new URL(filelist).openStream());
            BufferedReader inSeg = new BufferedReader(new InputStreamReader(in));
            ArrayList<String> workFileList = new ArrayList<String>();
            String colorTabOrg = new String("");
            while ((buf = inSeg.readLine()) != null) {
                workFileList.add(buf);
                if (!buf.equals("colorTab")) continue;
                colorTabOrg = new String(segUrl + "/colorTab");
            }
            int i = 0;
            while (i < workFileList.size()) {
                String file = (String)workFileList.get(i);
                if (file.startsWith("seg.")) {
                    String spec = file.substring("seg.".length());
                    if (file.endsWith(".gz")) {
                        spec = spec.substring(0, spec.length() - ".gz".length());
                    }
                    if (0 > spec.indexOf(".")) {
                        String colorTab = new String(segUrl + "/colorTab." + spec);
                        if (this.selectFile(new String("colorTab." + spec), workFileList) == null) {
                            colorTab = colorTabOrg;
                        }
                        HashMap<String, String> segInfo = new HashMap<String, String>();
                        segInfo.put("SPEC", spec);
                        segInfo.put("SEG", new String(segUrl + "/" + file));
                        segInfo.put("COLORTAB", colorTab);
                        fileList.add(segInfo);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void getAlignFileListDisk(String path, ArrayList fileList) {
        String alignDir = new String(path + System.getProperty("file.separator") + "align");
        File alignDirFile = new File(alignDir);
        if (!alignDirFile.isDirectory()) {
            return;
        }
        String colorTab = new String(alignDir + System.getProperty("file.separator") + "colorTab");
        File colorTabFile = new File(colorTab);
        if (!colorTabFile.isFile()) {
            colorTab = "";
        }
        String[] alignFileList = alignDirFile.list();
        int i = 0;
        while (i < alignFileList.length) {
            int sepIdx;
            String file = new String(alignFileList[i]);
            if (file.endsWith(".gz")) {
                file = file.substring(0, file.length() - ".gz".length());
            }
            if ((sepIdx = file.indexOf("-")) >= 0) {
                String spec1 = file.substring(file.indexOf(".") + 1, sepIdx);
                String spec2 = file.substring(sepIdx + 1);
                if (0 > spec2.indexOf(".")) {
                    HashMap<String, String> alignInfo = new HashMap<String, String>();
                    alignInfo.put("SPEC1", spec1);
                    alignInfo.put("SPEC2", spec2);
                    alignInfo.put("PATH", path);
                    alignInfo.put("ALIGN", file);
                    alignInfo.put("COLORTAB", colorTab);
                    fileList.add(alignInfo);
                }
            }
            ++i;
        }
    }

    protected void getGeneFileListDisk(String path, ArrayList fileList) {
        String geneDir = new String(path + System.getProperty("file.separator") + "gene");
        File geneDirFile = new File(geneDir);
        if (!geneDirFile.isDirectory()) {
            return;
        }
        String colorTabOrg = new String(geneDir + System.getProperty("file.separator") + "colorTab");
        File colorTabFile = new File(colorTabOrg);
        if (!colorTabFile.isFile()) {
            colorTabOrg = "";
        }
        String[] geneFileList = geneDirFile.list();
        int i = 0;
        while (i < geneFileList.length) {
            if (geneFileList[i].startsWith("gene.")) {
                String chromosome;
                File chromosomeFile;
                String spec = geneFileList[i].substring("gene.".length());
                if (geneFileList[i].endsWith(".gz")) {
                    spec = spec.substring(0, spec.length() - ".gz".length());
                }
                if (0 > spec.indexOf(".") && (chromosomeFile = new File(chromosome = new String(geneDir + System.getProperty("file.separator") + "chromosome." + spec))).isFile()) {
                    String colorTab = new String(geneDir + System.getProperty("file.separator") + "colorTab." + spec);
                    colorTabFile = new File(colorTab);
                    if (!colorTabFile.isFile()) {
                        colorTab = colorTabOrg;
                    }
                    HashMap<String, String> geneInfo = new HashMap<String, String>();
                    geneInfo.put("SPEC", spec);
                    geneInfo.put("GENE", new String(geneDir + System.getProperty("file.separator") + geneFileList[i]));
                    geneInfo.put("CHROMOSOME", chromosome);
                    geneInfo.put("COLORTAB", colorTab);
                    fileList.add(geneInfo);
                }
            }
            ++i;
        }
    }

    protected void getSegFileListDisk(String type2, String path, ArrayList fileList) {
        String segDir = new String(path + System.getProperty("file.separator") + type2);
        File segDirFile = new File(segDir);
        if (!segDirFile.isDirectory()) {
            return;
        }
        String colorTabOrg = new String(segDir + System.getProperty("file.separator") + "colorTab");
        File colorTabFile = new File(colorTabOrg);
        if (!colorTabFile.isFile()) {
            colorTabOrg = "";
        }
        String[] segFileList = segDirFile.list();
        int i = 0;
        while (i < segFileList.length) {
            if (segFileList[i].startsWith("seg.")) {
                String spec = segFileList[i].substring("seg.".length());
                if (segFileList[i].endsWith(".gz")) {
                    spec = spec.substring(0, spec.length() - ".gz".length());
                }
                if (0 > spec.indexOf(".")) {
                    String colorTab = new String(segDir + System.getProperty("file.separator") + "colorTab." + spec);
                    colorTabFile = new File(colorTab);
                    if (!colorTabFile.isFile()) {
                        colorTab = colorTabOrg;
                    }
                    HashMap<String, String> segInfo = new HashMap<String, String>();
                    segInfo.put("SPEC", spec);
                    segInfo.put("SEG", new String(segDir + System.getProperty("file.separator") + segFileList[i]));
                    segInfo.put("COLORTAB", colorTab);
                    fileList.add(segInfo);
                }
            }
            ++i;
        }
    }

    protected String selectFile(String filename, ArrayList fileList) {
        int i = 0;
        while (i < fileList.size()) {
            String file = (String)fileList.get(i);
            if (file.equals(filename)) {
                return file;
            }
            ++i;
        }
        return null;
    }

    protected HashMap selectRegInfo(ArrayList fileList, String spec) {
        HashMap selectInfo = null;
        int i = 0;
        while (i < fileList.size()) {
            HashMap info = (HashMap)fileList.get(i);
            if (spec.equals((String)info.get("SPEC"))) {
                selectInfo = info;
                break;
            }
            ++i;
        }
        if (selectInfo == null) {
            System.err.println("not found : " + spec);
        }
        return selectInfo;
    }

    public HashMap getSelectSpecInfo() {
        return this.selectSpecInfo;
    }

    public String getSelectGeneAttr() {
        return this.selectGeneAttr;
    }

    public String getSelectGeneColorType() {
        return this.selectGeneColorType;
    }

    public String getSelectSeg1Info() {
        return this.selectSeg1Info;
    }

    public String getSelectSeg2Info() {
        return this.selectSeg2Info;
    }

    public String getSelectSeg1Cgi() {
        return this.selectSeg1Cgi;
    }

    public String getSelectSeg2Cgi() {
        return this.selectSeg2Cgi;
    }

    public String getSelectedSeg1Name() {
        String name = null;
        name = new String((String)this.seg1.getSelectedItem());
        return name;
    }

    public String getSelectedSeg2Name() {
        String name = null;
        name = new String((String)this.seg2.getSelectedItem());
        return name;
    }

    public String getSelectSeg1Type() {
        String n = this.selectSeg1.getSelectedSegName();
        return new String(n);
    }

    public String getSelectSeg2Type() {
        String n = this.selectSeg2.getSelectedSegName();
        return new String(n);
    }
}

