/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.AlignmentSegment;
import cgat.AlignmentSequence;
import cgat.MbgdDataMng;
import cgat.ViewWindowDotPlot;
import cgat.ViewWindowRegion;
import java.util.Observable;
import java.util.Observer;

public class ViewWindow
extends Observable
implements Observer {
    public static final int DRAWMODE_LEV0 = 20;
    public static final int DRAWMODE_LEV1 = 10;
    public static final int DRAWMODE_LEV2 = 10;
    public static final int DRAWMODE_LEV3 = 4;
    public static final int DRAWMODE_LEV4 = 1;
    public static final int DRAWMODE_LEV5 = 13;
    public static final String CHANGE_REGION = "region";
    public static final String CHANGE_DOTPLOT = "dotPlot";
    public static final String CHANGE_BASESPEC = "baseSpec";
    public static final String CHANGE_DRAWMODE = "drawMode";
    public static final String CHANGE_SRCHORF = "searchOrf";
    private static ViewWindow _instance;
    private MbgdDataMng mbgdDataMng;
    private int dispMode;
    private ViewWindowRegion viewWinRegion;
    private ViewWindowDotPlot viewWinDotPlot;
    private AlignmentSequence alignSequence;
    private AlignmentSegment alignSegment;

    public static ViewWindow Instance(MbgdDataMng dataMng) {
        if (_instance == null) {
            _instance = new ViewWindow(dataMng);
            AlignmentSequence alignSequence = new AlignmentSequence(dataMng, _instance);
            AlignmentSegment alignSegment = new AlignmentSegment(dataMng, _instance);
            _instance.setAlignmentInfo(alignSequence, alignSegment);
        }
        return _instance;
    }

    protected ViewWindow(MbgdDataMng dataMng) {
        this._init(dataMng);
    }

    private void _init(MbgdDataMng dataMng) {
        this.mbgdDataMng = dataMng;
        this.viewWinRegion = ViewWindowRegion.Instance(dataMng, this);
        this.viewWinDotPlot = ViewWindowDotPlot.Instance(dataMng, this);
    }

    public int getDrawMode() {
        return this.viewWinRegion.getDrawMode();
    }

    public void setDrawMode(int sta) {
        this.viewWinRegion.setDrawMode(sta);
        this.setChanged();
        this.notifyObservers(CHANGE_DRAWMODE);
    }

    public void setAlignmentInfo(AlignmentSequence alignSeq, AlignmentSegment alignSeg) {
        this.alignSequence = alignSeq;
        this.alignSegment = alignSeg;
    }

    public int getZoomCount() {
        return this.viewWinRegion.getZoomCount();
    }

    public void setRegCenter(boolean side, int pos) {
        this.viewWinRegion.setRegCenter(side, pos);
    }

    public void setRegCenter(int type2, int pos) {
        boolean side;
        switch (type2) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                side = true;
                break;
            }
            default: {
                side = false;
            }
        }
        this.viewWinRegion.setRegCenter(side, pos);
    }

    public int getRegCenter(boolean side) {
        return this.viewWinRegion.getRegCenter(side);
    }

    public int getRegCenter(int type2) {
        boolean side;
        switch (type2) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                side = true;
                break;
            }
            default: {
                side = false;
            }
        }
        return this.viewWinRegion.getRegCenter(side);
    }

    public void setRegWidth(boolean side, int wid) {
        this.viewWinRegion.setRegWidth(side, wid);
    }

    public int getRegWidth() {
        return this.getRegWidth(true);
    }

    public int getRegWidth(boolean side) {
        return this.viewWinRegion.getRegWidth(side);
    }

    public void setDpCenter(boolean side, int pos) {
        this.viewWinDotPlot.setDpCenter(side, pos);
    }

    public int getDpCenter(boolean side) {
        return this.viewWinDotPlot.getDpCenter(side);
    }

    public void setDpWidth(boolean side, int wid) {
        this.viewWinDotPlot.setDpWidth(side, wid);
    }

    public int getDpWidth(boolean side) {
        return this.viewWinDotPlot.getDpWidth(side);
    }

    public int getRegWidth(int type2) {
        boolean side;
        switch (type2) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                side = true;
                break;
            }
            default: {
                side = false;
            }
        }
        return this.viewWinRegion.getRegWidth(side);
    }

    public void setRegDir(boolean side, boolean sta) {
        this.viewWinRegion.setRegDir(side, sta);
    }

    public void setRegDir(int type2, boolean sta) {
        boolean side;
        switch (type2) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                side = true;
                break;
            }
            default: {
                side = false;
            }
        }
        this.viewWinRegion.setRegDir(side, sta);
    }

    public boolean getRegDir(boolean side) {
        return this.viewWinRegion.getRegDir(side);
    }

    public boolean getRegDir(int type2) {
        boolean side;
        switch (type2) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                side = true;
                break;
            }
            default: {
                side = false;
            }
        }
        return this.viewWinRegion.getRegDir(side);
    }

    public void changeRegDir(int type2) {
        boolean dir = this.getRegDir(type2);
        this.setRegDir(type2, !dir);
        this.makeAlignment();
        this.setChanged();
        this.notifyObservers(CHANGE_REGION);
    }

    public void changeRegDir(boolean type2) {
        boolean dir = this.getRegDir(type2);
        this.setRegDir(type2, !dir);
        this.makeAlignment();
        this.setChanged();
        this.notifyObservers(CHANGE_REGION);
    }

    public void viewPos(String spec, int pos) {
        if (this.mbgdDataMng.getSpecName(true).equals(spec)) {
            this.viewWinRegion.viewGenomePos(pos, true);
        } else {
            this.viewWinRegion.setRegCenter(false, pos);
        }
        this.makeAlignment();
        this.setChanged();
        this.notifyObservers(CHANGE_REGION);
    }

    public void viewPosSide(int side, int pos) {
        if (side == 0) {
            this.viewWinRegion.viewGenomePos(pos, true);
        } else {
            this.viewWinRegion.setRegCenter(false, pos);
        }
        this.makeAlignment();
        this.setChanged();
        this.notifyObservers(CHANGE_REGION);
    }

    public void viewPos(int pos1) {
        this.viewWinRegion.viewGenomePos(pos1, true);
        this.makeAlignment();
        this.setChanged();
        this.notifyObservers(CHANGE_REGION);
    }

    public void viewPos(int pos1, int pos2) {
        this.viewWinRegion.setRegCenter(true, pos1);
        this.viewWinRegion.setRegCenter(false, pos2);
        this.makeAlignment();
        this.setChanged();
        this.notifyObservers(CHANGE_REGION);
    }

    public void viewLeft() {
        boolean retSta = this.viewWinRegion.viewLeft();
        if (!retSta) {
            return;
        }
        this.makeAlignment();
        this.setChanged();
        this.notifyObservers(CHANGE_REGION);
    }

    public void viewRight() {
        boolean retSta = this.viewWinRegion.viewRight();
        if (!retSta) {
            return;
        }
        this.makeAlignment();
        this.setChanged();
        this.notifyObservers(CHANGE_REGION);
    }

    public void zoomUpRegion() {
        boolean retSta = this.viewWinRegion.zoomUp();
        if (!retSta) {
            return;
        }
        this.makeAlignment();
        this.setChanged();
        this.notifyObservers(CHANGE_REGION);
    }

    public void zoomDownRegion() {
        boolean retSta = this.viewWinRegion.zoomDown();
        if (!retSta) {
            return;
        }
        this.makeAlignment();
        this.setChanged();
        this.notifyObservers(CHANGE_REGION);
    }

    public void zoomUpDotPlot() {
        boolean retSta = this.viewWinDotPlot.zoomUp();
        if (!retSta) {
            return;
        }
        this.setChanged();
        this.notifyObservers(CHANGE_DOTPLOT);
    }

    public void zoomDownDotPlot() {
        boolean retSta = this.viewWinDotPlot.zoomDown();
        if (!retSta) {
            return;
        }
        this.setChanged();
        this.notifyObservers(CHANGE_DOTPLOT);
    }

    public void setTargetDotPlotX(boolean sta) {
        this.viewWinDotPlot.setTargetXSta(sta);
    }

    public void setTargetDotPlotY(boolean sta) {
        this.viewWinDotPlot.setTargetYSta(sta);
    }

    public int searchOppositeSpecPos() {
        return 0;
    }

    public AlignmentSequence getAlignSequence() {
        return this.alignSequence;
    }

    public String getAlignSequence(boolean basespec) {
        int side = basespec ? 0 : 1;
        String seq = this.alignSequence.getAlignedSeq(side);
        return new String(seq);
    }

    public String getAlignSequence(int dataType) {
        switch (dataType) {
            case 2: 
            case 4: 
            case 5: {
                return this.getAlignSequence(true);
            }
            case 12: 
            case 14: 
            case 15: {
                return this.getAlignSequence(false);
            }
        }
        return null;
    }

    public AlignmentSegment getAlignSegment() {
        return this.alignSegment;
    }

    public void makeAlignment() {
        int drawMode = this.getDrawMode();
        switch (drawMode) {
            case -1: {
                break;
            }
            case 0: {
                this.makeAlignmentSequenceMode();
                break;
            }
            case 1: {
                this.makeAlignmentSegmentMode();
                break;
            }
        }
    }

    public void makeAlignmentSequenceMode() {
        int zoomCount = this.getZoomCount();
        if (4 < zoomCount) {
            return;
        }
        this.alignSequence.alignment();
    }

    public void makeAlignmentSegmentMode() {
        this.alignSegment.alignment();
    }

    public void exchangeBaseSpec() {
        this.viewWinRegion.exchangeBaseSpec();
        this.viewWinDotPlot.exchangeBaseSpec();
        this.makeAlignment();
        this.setChanged();
        this.notifyObservers();
    }

    public void update(Observable o, Object arg) {
        if (o instanceof MbgdDataMng) {
            this.update((MbgdDataMng)o, arg);
        }
    }

    public void update(MbgdDataMng dataMng, Object arg) {
        if (arg == null) {
            this.setRegCenter(true, 5000);
            this.setRegWidth(true, 10000);
            this.setRegCenter(false, 5000);
            this.setRegWidth(false, 10000);
            int len = dataMng.getGenomeLength(true);
            this.setDpCenter(true, len / 2);
            this.setDpWidth(true, len);
            len = dataMng.getGenomeLength(false);
            this.setDpCenter(false, len / 2);
            this.setDpWidth(false, len);
            this.setChanged();
            this.notifyObservers(CHANGE_DOTPLOT);
        } else if (((String)arg).equals(CHANGE_BASESPEC)) {
            this.exchangeBaseSpec();
        }
    }

    static {
        DRAWMODE_LEV0 = 20;
        DRAWMODE_LEV1 = 10;
        DRAWMODE_LEV2 = 10;
        DRAWMODE_LEV3 = 4;
        DRAWMODE_LEV4 = 1;
        DRAWMODE_LEV5 = 13;
        CHANGE_REGION = CHANGE_REGION;
        CHANGE_DOTPLOT = CHANGE_DOTPLOT;
        CHANGE_BASESPEC = CHANGE_BASESPEC;
        CHANGE_DRAWMODE = CHANGE_DRAWMODE;
        CHANGE_SRCHORF = CHANGE_SRCHORF;
        _instance = null;
    }
}

