/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.MbgdDataMng;
import cgat.ViewWindow;

public class ViewWindowDotPlot {
    public static final int MIN_WIDTH = 50;
    public static final String STR_X = "X";
    public static final String STR_Y = "Y";
    private static ViewWindowDotPlot _instance;
    private MbgdDataMng mbgdDataMng;
    private ViewWindow viewWin;
    private int[] dpCenter;
    private int[] dpWidth;
    private boolean zoomX;
    private boolean zoomY;

    public static ViewWindowDotPlot Instance(MbgdDataMng dataMng, ViewWindow vWin) {
        if (_instance != null) {
            // empty if block
        }
        _instance = new ViewWindowDotPlot(dataMng, vWin);
        return _instance;
    }

    public static ViewWindowDotPlot Instance() {
        if (_instance == null) {
            // empty if block
        }
        return _instance;
    }

    private ViewWindowDotPlot(MbgdDataMng dataMng, ViewWindow vWin) {
        this.mbgdDataMng = dataMng;
        this.viewWin = vWin;
        this.dpCenter = new int[2];
        this.dpWidth = new int[2];
        this.setDpCenter(true, 0);
        this.setDpWidth(true, 0);
        this.setDpCenter(false, 0);
        this.setDpWidth(false, 0);
        this.setTargetXSta(true);
        this.setTargetYSta(true);
    }

    public void setDpCenter(boolean basespec, int pos) {
        int side = basespec ? 0 : 1;
        this.dpCenter[side] = pos;
    }

    public int getDpCenter(boolean basespec) {
        int side = basespec ? 0 : 1;
        return this.dpCenter[side];
    }

    public void setDpWidth(boolean basespec, int wid) {
        int side = basespec ? 0 : 1;
        this.dpWidth[side] = wid;
    }

    public int getDpWidth(boolean basespec) {
        int side = basespec ? 0 : 1;
        return this.dpWidth[side];
    }

    public void setTargetXSta(boolean sta) {
        this.zoomX = sta;
    }

    public boolean getTargetXSta() {
        return this.zoomX;
    }

    public void setTargetYSta(boolean sta) {
        this.zoomY = sta;
    }

    public boolean getTargetYSta() {
        return this.zoomY;
    }

    public boolean zoomUp() {
        int width;
        boolean retSta = false;
        if (this.getTargetXSta()) {
            width = this.getDpWidth(true);
            if ((width /= 2) < 50) {
                width = 50;
            }
            this.setDpWidth(true, width);
            retSta = true;
        } else {
            System.err.println("DBG :: SKIP zoomUpDotPlotX");
        }
        if (this.getTargetYSta()) {
            width = this.getDpWidth(false);
            if ((width /= 2) < 50) {
                width = 50;
            }
            this.setDpWidth(false, width);
            retSta = true;
        } else {
            System.err.println("DBG :: SKIP zoomUpDotPlotY");
        }
        return retSta;
    }

    public boolean zoomDown() {
        boolean retSta = false;
        int maxWidth1 = this.mbgdDataMng.getGenomeLength(true);
        int maxWidth2 = this.mbgdDataMng.getGenomeLength(false);
        int center1 = this.getDpCenter(true);
        int center2 = this.getDpCenter(false);
        int width1 = this.getDpWidth(true);
        int width2 = this.getDpWidth(false);
        if (this.getTargetXSta()) {
            if (maxWidth1 > width1) {
                if (maxWidth1 < (width1 *= 2)) {
                    width1 = maxWidth1;
                }
                if (center1 - width1 / 2 < 0) {
                    this.setDpCenter(true, width1 / 2);
                } else if (maxWidth1 < center1 + width1 / 2) {
                    this.setDpCenter(true, maxWidth1 - width1 / 2);
                }
                this.setDpWidth(true, width1);
                retSta = true;
            }
        } else {
            System.err.println("DBG :: SKIP zoomDownDotPlotX");
        }
        if (this.getTargetYSta()) {
            if (maxWidth2 > width2) {
                if (maxWidth2 < (width2 *= 2)) {
                    width2 = maxWidth2;
                }
                if (center2 - width2 / 2 < 0) {
                    this.setDpCenter(false, width2 / 2);
                } else if (maxWidth2 < center2 + width2 / 2) {
                    this.setDpCenter(false, maxWidth2 - width2 / 2);
                }
                this.setDpWidth(false, width2);
                retSta = true;
            }
        } else {
            System.err.println("DBG :: SKIP zoomDownDotPlotY");
        }
        return retSta;
    }

    public void exchangeBaseSpec() {
        int iWk = this.dpCenter[0];
        this.dpCenter[0] = this.dpCenter[1];
        this.dpCenter[1] = iWk;
        iWk = this.dpWidth[0];
        this.dpWidth[0] = this.dpWidth[1];
        this.dpWidth[1] = iWk;
        boolean bWk = this.zoomX;
        this.zoomX = this.zoomY;
        this.zoomY = bWk;
    }

    static {
        MIN_WIDTH = 50;
        STR_X = STR_X;
        STR_Y = STR_Y;
        _instance = null;
    }
}

