/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.Alignment;
import cgat.AlignmentListFilter;
import cgat.MbgdDataMng;
import cgat.ViewWindow;
import cgat.ZoomLevel;

public class ViewWindowRegion {
    public static final int INIT_REGWIDTH = 10000;
    public static final int MIN_WIDTH = 50;
    public static final String STR_SEQUENCE = "Align at center";
    public static final String STR_SEGMENT = "Align against reference";
    public static final int MODE_SEQUENCE = 0;
    public static final int MODE_SEGMENT = 1;
    public static final int MODE_SEQVIEW = -1;
    private static ViewWindowRegion _instance;
    private MbgdDataMng mbgdDataMng;
    private ViewWindow viewWin;
    private ZoomLevel zoomLevel;
    private int drawMode;
    private Alignment currentAlignment;
    private int[] regCenter;
    private int[] regWidth;
    private boolean[] regDir;

    public static ViewWindowRegion Instance(MbgdDataMng dataMng, ViewWindow vWin) {
        if (_instance != null) {
            // empty if block
        }
        _instance = new ViewWindowRegion(dataMng, vWin);
        return _instance;
    }

    public static ViewWindowRegion Instance() {
        if (_instance == null) {
            // empty if block
        }
        return _instance;
    }

    private ViewWindowRegion(MbgdDataMng dataMng, ViewWindow vWin) {
        this._init(dataMng, vWin);
    }

    private void _init(MbgdDataMng dataMng, ViewWindow vWin) {
        this.mbgdDataMng = dataMng;
        this.viewWin = vWin;
        this.zoomLevel = ZoomLevel.Instance();
        this.regCenter = new int[2];
        this.regWidth = new int[2];
        this.regDir = new boolean[2];
        this.setRegCenter(true, 0);
        this.setRegCenter(false, 0);
        this.setRegWidth(true, 10000);
        this.setRegWidth(false, 10000);
        this.setRegDir(true, true);
        this.setRegDir(false, true);
    }

    public void setDrawMode(int mode) {
        this.drawMode = mode;
    }

    public int getDrawMode() {
        return this.drawMode;
    }

    public int getZoomCount() {
        return this.zoomLevel.getLevel(this.getRegWidth(true));
    }

    public void setRegCenter(boolean basespec, int cent) {
        if (basespec) {
            this.regCenter[0] = cent;
        } else {
            this.regCenter[1] = cent;
        }
    }

    public int getRegCenter(boolean basespec) {
        if (basespec) {
            return this.regCenter[0];
        }
        return this.regCenter[1];
    }

    public void setRegWidth(boolean basespec, int wid) {
        if (basespec) {
            this.regWidth[0] = wid;
        } else {
            this.regWidth[1] = wid;
        }
    }

    public int getRegWidth(boolean basespec) {
        if (basespec) {
            return this.regWidth[0];
        }
        return this.regWidth[1];
    }

    public void setRegDir(boolean basespec, boolean dir) {
        if (basespec) {
            this.regDir[0] = dir;
        } else {
            this.regDir[1] = dir;
        }
    }

    public boolean getRegDir(boolean basespec) {
        if (basespec) {
            return this.regDir[0];
        }
        return this.regDir[1];
    }

    public boolean viewLeft() {
        int pos = this.getRegCenter(true);
        int wid = this.getRegWidth(true);
        if ((pos -= wid / 2) < 0) {
            int lenGenome = this.mbgdDataMng.getGenomeLength(true);
            pos += lenGenome;
        }
        this.viewGenomePos(pos, false);
        return true;
    }

    public boolean viewRight() {
        int pos = this.getRegCenter(true);
        int wid = this.getRegWidth(true);
        int lenGenome = this.mbgdDataMng.getGenomeLength(true);
        if (lenGenome <= (pos += wid / 2)) {
            pos -= lenGenome;
        }
        this.viewGenomePos(pos, true);
        return true;
    }

    public void viewGenomePos(int pos0, boolean lr) {
        Alignment ali1;
        this.setRegCenter(true, pos0);
        this.currentAlignment = ali1 = AlignmentListFilter.searchAlignOppositeSpec(this.mbgdDataMng, this.viewWin, this.currentAlignment);
        int pos1 = AlignmentListFilter.getPosFromAlign(ali1, this.mbgdDataMng, this.viewWin, lr);
        this.setRegCenter(false, pos1);
    }

    public boolean zoomUp() {
        int lev;
        int newWidth;
        int width = this.getRegWidth(true);
        if (width == (newWidth = this.zoomLevel.getRangeByLevel((lev = this.zoomLevel.getLevel(width)) - 1))) {
            return false;
        }
        this.setRegWidth(true, newWidth);
        this.setRegWidth(false, newWidth);
        return true;
    }

    public boolean zoomDown() {
        int width = this.getRegWidth(true);
        int lev = this.zoomLevel.getLevel(width);
        int newWidth = this.zoomLevel.getRangeByLevel(lev + 1);
        int maxWidth = this.mbgdDataMng.getGenomeLength(true);
        if (maxWidth < newWidth) {
            newWidth = maxWidth;
        }
        if (width == newWidth) {
            return false;
        }
        int center = this.getRegCenter(true);
        if (center - newWidth / 2 < 0) {
            this.setRegCenter(true, newWidth / 2);
        } else if (maxWidth < center + newWidth / 2) {
            this.setRegCenter(true, maxWidth - newWidth / 2);
        }
        maxWidth = this.mbgdDataMng.getGenomeLength(false);
        center = this.getRegCenter(false);
        if (center - newWidth / 2 < 0) {
            this.setRegCenter(false, newWidth / 2);
        } else if (maxWidth < center + newWidth / 2) {
            this.setRegCenter(false, maxWidth - newWidth / 2);
        }
        this.setRegWidth(true, newWidth);
        this.setRegWidth(false, newWidth);
        return true;
    }

    public void exchangeBaseSpec() {
        int iWk = this.regCenter[0];
        this.regCenter[0] = this.regCenter[1];
        this.regCenter[1] = iWk;
        iWk = this.regWidth[0];
        this.regWidth[0] = this.regWidth[1];
        this.regWidth[1] = iWk;
        boolean bWk = this.regDir[0];
        this.regDir[0] = this.regDir[1];
        this.regDir[1] = bWk;
    }

    static {
        INIT_REGWIDTH = 10000;
        MIN_WIDTH = 50;
        STR_SEQUENCE = STR_SEQUENCE;
        STR_SEGMENT = STR_SEGMENT;
        MODE_SEQUENCE = 0;
        MODE_SEGMENT = 1;
        MODE_SEQVIEW = -1;
        _instance = null;
    }
}

