/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import java.util.ArrayList;

public class ZoomLevel {
    private static ZoomLevel _instance = null;
    private ArrayList zoomTab;

    public static ZoomLevel Instance() {
        if (_instance == null) {
            _instance = new ZoomLevel();
        }
        return _instance;
    }

    private ZoomLevel() {
        this._initTable();
    }

    private void _initTable() {
        int lev = 0;
        this.zoomTab = new ArrayList();
        this.zoomTab.add(new ZoomRange(lev++, 0, 50));
        this.zoomTab.add(new ZoomRange(lev++, 50, 100));
        this.zoomTab.add(new ZoomRange(lev++, 100, 200));
        this.zoomTab.add(new ZoomRange(lev++, 200, 300));
        this.zoomTab.add(new ZoomRange(lev++, 300, 500));
        this.zoomTab.add(new ZoomRange(lev++, 500, 1000));
        this.zoomTab.add(new ZoomRange(lev++, 1000, 2000));
        this.zoomTab.add(new ZoomRange(lev++, 2000, 3000));
        this.zoomTab.add(new ZoomRange(lev++, 3000, 5000));
        this.zoomTab.add(new ZoomRange(lev++, 5000, 10000));
        this.zoomTab.add(new ZoomRange(lev++, 10000, 20000));
        this.zoomTab.add(new ZoomRange(lev++, 20000, 30000));
        this.zoomTab.add(new ZoomRange(lev++, 30000, 50000));
        this.zoomTab.add(new ZoomRange(lev++, 50000, 100000));
        this.zoomTab.add(new ZoomRange(lev++, 100000, 200000));
        this.zoomTab.add(new ZoomRange(lev++, 200000, 300000));
        this.zoomTab.add(new ZoomRange(lev++, 300000, 500000));
        this.zoomTab.add(new ZoomRange(lev++, 500000, 1000000));
        this.zoomTab.add(new ZoomRange(lev++, 1000000, 2000000));
        this.zoomTab.add(new ZoomRange(lev++, 2000000, 3000000));
        this.zoomTab.add(new ZoomRange(lev++, 3000000, 5000000));
        this.zoomTab.add(new ZoomRange(lev++, 5000000, 10000000));
        this.zoomTab.add(new ZoomRange(lev++, 10000000, 20000000));
        this.zoomTab.add(new ZoomRange(lev++, 20000000, 30000000));
        this.zoomTab.add(new ZoomRange(lev++, 30000000, 50000000));
        this.zoomTab.add(new ZoomRange(lev++, 50000000, 100000000));
        this.zoomTab.add(new ZoomRange(lev++, 100000000, 200000000));
        this.zoomTab.add(new ZoomRange(lev++, 200000000, 300000000));
        this.zoomTab.add(new ZoomRange(lev++, 300000000, 500000000));
        this.zoomTab.add(new ZoomRange(lev++, 500000000, 1000000000));
        this.zoomTab.add(new ZoomRange(lev++, 1000000000, 2000000000));
    }

    public int getLevel(int width) {
        int loopMax = this.zoomTab.size();
        int i = 0;
        while (i < loopMax) {
            ZoomRange range = (ZoomRange)this.zoomTab.get(i);
            if (width <= range.getTo()) {
                return range.getLevel();
            }
            ++i;
        }
        return Integer.MAX_VALUE;
    }

    public int getRangeByLevel(int level) {
        if (this.zoomTab.size() <= level) {
            return Integer.MAX_VALUE;
        }
        if (level <= 0) {
            level = 0;
        }
        ZoomRange range = (ZoomRange)this.zoomTab.get(level);
        return range.getTo();
    }

    public int getRangeByWidth(int width) {
        int loopMax = this.zoomTab.size();
        int i = 0;
        while (i < loopMax) {
            ZoomRange range = (ZoomRange)this.zoomTab.get(i);
            if (width <= range.getTo()) {
                return range.getTo();
            }
            ++i;
        }
        return Integer.MAX_VALUE;
    }

    class ZoomRange {
        private int rangeLevel;
        private int rangeFrom;
        private int rangeTo;

        public ZoomRange(int level, int from, int to) {
            this.rangeLevel = level;
            this.rangeFrom = from;
            this.rangeTo = to;
        }

        public int getLevel() {
            return this.rangeLevel;
        }

        public int getFrom() {
            return this.rangeFrom;
        }

        public int getTo() {
            return this.rangeTo;
        }
    }
}

