/*
 * Decompiled with CFR 0.152.
 */
package cgat.seq;

import cgat.seq.Utils;

public class Alphabet {
    private String charset;
    private int[] toIdx;
    private int[] complementArray;
    private String[] names;
    private int charnum;
    private static final int NOT_FOUND = -1;
    private boolean ignoreCase = true;
    static Alphabet aminoAcids;
    static Alphabet nucleotides;
    static final String AMINO_CHARS = "ARNDCQEGHILKMFPSTWYVBZX*";
    static final String[] AMINO_NAMES;
    static final String NUCLEOTIDE_CHARS = "ATGCSWRYKMBVHDN";
    static final String[] NUCLEOTIDE_OPT;
    static final int NUMCHAR = 128;

    public Alphabet() {
    }

    public Alphabet(char[] charset) {
        this.init(new String(charset), null);
    }

    public Alphabet(String charset) {
        this.init(charset, null);
    }

    public Alphabet(String charset, String[] optionArgs) {
        this.init(charset, optionArgs);
    }

    public static Alphabet getAminoAcids() {
        if (aminoAcids == null) {
            aminoAcids = new Alphabet(AMINO_CHARS);
            aminoAcids.setNames(AMINO_NAMES);
        }
        return aminoAcids;
    }

    public static Alphabet getNucleotides() {
        if (nucleotides == null) {
            nucleotides = new Alphabet(NUCLEOTIDE_CHARS, NUCLEOTIDE_OPT);
        }
        return nucleotides;
    }

    public void init(String _charset, String[] optionArgs) {
        int i;
        this.charset = _charset;
        this.charnum = this.charset.length();
        this.toIdx = new int[128];
        int i2 = 0;
        while (i2 < 128) {
            this.toIdx[i2] = -1;
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.charnum) {
            char c = this.charset.charAt(i3);
            this.toIdx[c] = i3;
            if (this.ignoreCase) {
                if (Character.isUpperCase(c)) {
                    this.toIdx[Character.toLowerCase((char)c)] = i3;
                } else if (Character.isLowerCase(c)) {
                    this.toIdx[Character.toUpperCase((char)c)] = i3;
                }
            }
            ++i3;
        }
        String complementString = null;
        if (optionArgs != null) {
            i = 0;
            while (i < optionArgs.length) {
                String[] str = Utils.split(optionArgs[i], "=", 2);
                if (str[0].equals("complement")) {
                    complementString = str[1];
                }
                ++i;
            }
        }
        if (complementString != null) {
            this.complementArray = new int[128];
            if (this.charnum != this.charset.length()) {
                // empty if block
            }
            i = 0;
            while (i < 128) {
                this.complementArray[i] = -1;
                ++i;
            }
            int i4 = 0;
            while (i4 < this.charnum) {
                this.complementArray[i4] = this.toIdx[complementString.charAt(i4)];
                ++i4;
            }
        }
    }

    public void setNames(String[] names) {
        this.names = names;
    }

    public String getName(char c) {
        return this.names[this.toIdx[c]];
    }

    public String getName(int idx) {
        return this.names[idx];
    }

    public char get(int idx) {
        return this.charset.charAt(idx);
    }

    public int complement(int idx) {
        if (this.complementArray == null) {
            return idx;
        }
        return this.complementArray[idx];
    }

    public char complement(char c) {
        return this.charset.charAt(this.complement(this.toIdx[c]));
    }

    public boolean contains(char c) {
        return this.toIdx[c] != -1;
    }

    public int toIdx(char c) {
        return this.toIdx[c];
    }

    public int charnum() {
        return this.charnum;
    }

    static {
        NOT_FOUND = -1;
        AMINO_CHARS = AMINO_CHARS;
        AMINO_NAMES = new String[]{"Ala", "Arg", "Asn", "Asp", "Cys", "Gln", "Glu", "Gly", "His", "Ile", "Leu", "Lys", "Met", "Phe", "Pro", "Ser", "Thr", "Trp", "Tyr", "Val", "Asx", "Glx", "Xaa", "TER"};
        NUCLEOTIDE_CHARS = NUCLEOTIDE_CHARS;
        NUCLEOTIDE_OPT = new String[]{"complement=TACGSWYRMKVBDHN", "origCharNum=4"};
        NUMCHAR = 128;
    }
}

