/*
 * Decompiled with CFR 0.152.
 */
package cgat.seq;

import cgat.seq.Alphabet;
import cgat.seq.GeneticCode;
import cgat.seq.ProteinSequence;
import cgat.seq.RawSequence;
import cgat.seq.Sequence;

public class DNASequence
extends RawSequence {
    public DNASequence(String name, String seq) {
        super(name, seq);
        this.alpha = Alphabet.getNucleotides();
    }

    public DNASequence(String name, String seq, boolean isCircular) {
        super(name, seq);
        this.alpha = Alphabet.getNucleotides();
        this.setCircular(isCircular);
    }

    public static ProteinSequence translate(Sequence seq) {
        GeneticCode tab = GeneticCode.generate(1);
        return DNASequence.translate(seq, tab);
    }

    public static ProteinSequence translate(Sequence seq, GeneticCode tab) {
        return DNASequence.translate(seq, tab, 1);
    }

    public static ProteinSequence translate(Sequence seq, GeneticCode tab, int start) {
        String ntseq = seq.getSeqString();
        StringBuffer aaseq = new StringBuffer();
        int i = start - 1;
        while (i < ntseq.length()) {
            String codon = ntseq.substring(i, i + 3);
            char aa = tab.getAmino(codon);
            aaseq.append(aa);
            i += 3;
        }
        return new ProteinSequence(seq.getName(), aaseq.toString());
    }
}

