/*
 * Decompiled with CFR 0.152.
 */
package cgat.seq;

import cgat.seq.DNASequence;
import cgat.seq.ProteinSequence;
import cgat.seq.RawSequence;
import cgat.seq.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;

public class FastaFile {
    BufferedReader in;
    String linebuf;
    String titSepChar = " \t\n";
    int seqType = 0;

    public FastaFile() {
        this.in = new BufferedReader(new InputStreamReader(System.in));
    }

    public FastaFile(String filename) throws IOException {
        InputStreamReader reader;
        if (filename.startsWith("http:") || filename.startsWith("file:")) {
            URL url = new URL(filename);
            reader = new InputStreamReader(url.openStream());
        } else {
            reader = new FileReader(filename);
        }
        this.in = new BufferedReader(reader);
    }

    public void setTitSepChar(String sep) {
        this.titSepChar = sep;
    }

    public void asDNA() {
        this.seqType = 1;
    }

    public void asProtein() {
        this.seqType = 2;
    }

    public boolean isDNA() {
        return this.seqType == 1;
    }

    public boolean isProtein() {
        return this.seqType == 2;
    }

    public RawSequence readSeq() throws IOException {
        boolean readflag = false;
        StringBuffer seqbuf = new StringBuffer();
        StringBuffer namebuf = new StringBuffer();
        if (this.linebuf != null && this.linebuf.startsWith(">")) {
            this.extract_name(this.linebuf, namebuf);
        }
        try {
            while ((this.linebuf = this.in.readLine()) != null) {
                if (this.linebuf.startsWith(">")) {
                    if (readflag) {
                        return this.createSeq(namebuf, seqbuf);
                    }
                    this.extract_name(this.linebuf, namebuf);
                    continue;
                }
                this.linebuf.trim();
                readflag = true;
                seqbuf.append(this.linebuf);
            }
            if (readflag) {
                return this.createSeq(namebuf, seqbuf);
            }
            return null;
        }
        catch (IOException e) {
            if (readflag) {
                return this.createSeq(namebuf, seqbuf);
            }
            throw e;
        }
    }

    private RawSequence createSeq(StringBuffer name, StringBuffer seq) {
        if (this.isDNA()) {
            return new DNASequence(name.toString(), seq.toString());
        }
        if (this.isProtein()) {
            return new ProteinSequence(name.toString(), seq.toString());
        }
        return new RawSequence(name.toString(), seq.toString());
    }

    private void extract_name(String linebuf, StringBuffer namebuf) {
        int i = 1;
        while (Character.isWhitespace(linebuf.charAt(i))) {
            ++i;
        }
        String[] str = Utils.split(linebuf.substring(i), this.titSepChar, 1);
        namebuf.append(str[0]);
    }

    public void close() throws IOException {
        this.in.close();
    }

    static interface type {
        public static final int UNKNOWN = 0;
        public static final int DNA = 1;
        public static final int PROTEIN = 2;

        static {
            UNKNOWN = 0;
            DNA = 1;
            PROTEIN = 2;
        }
    }
}

