/*
 * Decompiled with CFR 0.152.
 */
package cgat.seq;

import cgat.seq.ScoreMat;
import cgat.seq.Sequence;
import cgat.seq.Utils;
import java.util.Iterator;
import java.util.LinkedList;

public class SequenceAlignment {
    String[] alignSeq;
    Sequence[] seqSet;
    int seqnum;
    int score;
    int aliLen;
    int lineLen = 60;
    char GAPCHAR = (char)45;
    char MATCH_CHAR = (char)58;
    char POSITIVE_CHAR = (char)46;
    char MISMATCH_CHAR = (char)32;
    int TITWIDTH = 14;
    char add_match = '\u0000';
    char add_consensus = '\u0000';
    ScoreMat sMat;

    public SequenceAlignment(Sequence[] _seqSet, int _seqnum, LinkedList aliPath) {
        this.makeAlignment(_seqSet, _seqnum, aliPath);
    }

    public SequenceAlignment(Sequence[] _seqSet, int _seqnum, LinkedList aliPath, ScoreMat _sMat) {
        this.makeAlignment(_seqSet, _seqnum, aliPath);
        this.setScoreMat(_sMat);
    }

    public void makeAlignment(Sequence[] _seqSet, int _seqnum, LinkedList aliPath) {
        this.seqnum = _seqnum;
        this.seqSet = _seqSet;
        StringBuffer[] alignSeqBuf = new StringBuffer[_seqnum];
        Iterator iter = aliPath.iterator();
        int i = 0;
        while (i < this.seqnum) {
            alignSeqBuf[i] = new StringBuffer();
            ++i;
        }
        int[] prevPosSet = new int[this.seqnum];
        while (iter.hasNext()) {
            int[] posSet = (int[])iter.next();
            int maxdiff = 0;
            int diff = 0;
            int i2 = 0;
            while (i2 < this.seqnum) {
                diff = posSet[i2] - prevPosSet[i2] - 1;
                if (maxdiff < diff) {
                    maxdiff = diff;
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < this.seqnum) {
                diff = posSet[i3] - prevPosSet[i3] - 1;
                int j = 0;
                while (j < maxdiff) {
                    if (j < diff) {
                        alignSeqBuf[i3].append(this.seqSet[i3].charAt(prevPosSet[i3] + j));
                    } else {
                        alignSeqBuf[i3].append(this.GAPCHAR);
                    }
                    ++j;
                }
                if (diff >= 0) {
                    alignSeqBuf[i3].append(this.seqSet[i3].charAt(posSet[i3] - 1));
                } else {
                    alignSeqBuf[i3].append(this.GAPCHAR);
                }
                ++i3;
            }
            prevPosSet = posSet;
        }
        this.alignSeq = new String[_seqnum];
        int i4 = 0;
        while (i4 < this.seqnum) {
            this.alignSeq[i4] = alignSeqBuf[i4].toString();
            ++i4;
        }
        this.aliLen = this.alignSeq[0].length();
        if (this.seqnum == 2) {
            this.add_match = '\u0001';
            this.add_consensus = '\u0000';
        } else {
            this.add_match = '\u0000';
            this.add_consensus = '\u0001';
        }
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        int j = 0;
        while (j < this.aliLen) {
            int i = 0;
            while (i < this.seqnum) {
                int endj = Math.min(j + this.lineLen, this.aliLen);
                strbuf.append(Utils.setStringWidth(this.seqSet[i].getName(), this.TITWIDTH));
                strbuf.append(this.alignSeq[i].substring(j, endj));
                strbuf.append("\n");
                if (this.add_match == '\u0001' && i < this.seqnum - 1) {
                    strbuf.append(Utils.setStringWidth("", this.TITWIDTH));
                    int k = j;
                    while (k < endj) {
                        strbuf.append(this.matchChar(this.alignSeq[i].charAt(k), this.alignSeq[i + 1].charAt(k)));
                        ++k;
                    }
                    strbuf.append("\n");
                }
                ++i;
            }
            strbuf.append("\n");
            j += this.lineLen;
        }
        strbuf.append("Score: " + this.score + "\n");
        return strbuf.toString();
    }

    public void setScoreMat(ScoreMat _sMat) {
        this.sMat = _sMat;
    }

    public void setMatchChars(char match, char positive, char mismatch) {
        this.MATCH_CHAR = match;
        this.POSITIVE_CHAR = positive;
        this.MISMATCH_CHAR = mismatch;
    }

    public void setScore(int _score) {
        this.score = _score;
    }

    public int getScore() {
        return this.score;
    }

    public String getAlignedSeq(int idx) {
        return this.alignSeq[idx];
    }

    private char matchChar(char c1, char c2) {
        if (c1 == c2) {
            return this.MATCH_CHAR;
        }
        if (this.sMat != null && this.sMat.seqScore(c1, c2, 0) > 0) {
            return this.POSITIVE_CHAR;
        }
        return this.MISMATCH_CHAR;
    }
}

