/*
 * Decompiled with CFR 0.152.
 */
package cgat.seq;

import cgat.seq.Alphabet;
import cgat.seq.RawSequence;
import cgat.seq.SeqRegion;
import cgat.seq.Sequence;

public class SubSequence
extends Sequence {
    SeqRegion reg;
    Sequence seq;
    SubSequence rev;
    String subseqName;

    public SubSequence(Sequence _seq, int from, int to) {
        this.seq = _seq;
        this.reg = new SeqRegion(from, to);
    }

    public SubSequence(Sequence _seq, int from, int to, int dir) {
        this.reg = new SeqRegion(from, to);
        this.seq = dir < 0 ? _seq.getReverse() : _seq;
    }

    public SubSequence(Sequence _seq, SeqRegion _reg) {
        this.reg = _reg;
        this.seq = this.reg.isReverse() ? _seq.getReverse() : _seq;
    }

    public void setName(String name) {
        this.subseqName = name;
    }

    public String getName() {
        if (this.subseqName != null) {
            return this.subseqName;
        }
        return this.seq.getName();
    }

    public void setRegion(int from, int to) {
        this.reg.setFrom(from);
        this.reg.setTo(to);
    }

    public String getSeqString() {
        return this.seq.getSubSeqString(this.reg.getFrom(), this.reg.getTo());
    }

    public RawSequence createSubSequence(int from, int to) {
        return this.seq.createSubSequence(this.reg.getFrom() + from - 1, this.reg.getFrom() + to - 1);
    }

    public String getSubSeqString(int _from, int _to) throws IndexOutOfBoundsException {
        if (_from > this.length() || _to > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this.seq.getSubSeqString(this.reg.getFrom() + _from - 1, this.reg.getFrom() + _to - 1);
    }

    public int getSubSeqStringLength(int _from, int _to) throws IndexOutOfBoundsException {
        if (_from > this.length() || _to > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this.seq.getSubSeqStringLength(this.reg.getFrom() + _from - 1, this.reg.getFrom() + _to - 1);
    }

    public String getAltNameSequence() {
        return this.seq.getAltNameSubSequence(this.reg.getFrom(), this.reg.getTo());
    }

    public String getAltNameSubSequence(int from, int to) {
        return this.seq.getAltNameSubSequence(this.reg.getFrom() + from - 1, this.reg.getTo() + to - 1);
    }

    public int length() {
        return this.seq.getSubSeqStringLength(this.reg.getFrom(), this.reg.getTo());
    }

    public Sequence getReverse() {
        if (this.rev == null) {
            this.rev = new SubSequence(this.seq.getReverse(), this.reg.getFrom(), this.reg.getTo());
            this.rev.rev = this;
        }
        return this.rev;
    }

    public Alphabet getAlphabet() {
        return this.seq.getAlphabet();
    }

    public boolean isCircular() {
        return false;
    }
}

