/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.Alignment;
import cgat.AlignmentList;
import java.util.regex.Pattern;

public class AlignmentFilter {
    public static void filterBetween(AlignmentList alignInfo, String nameItem, double val1, double val2) {
        for (int i = 0; i < alignInfo.size(); ++i) {
            Alignment a = alignInfo.getAlignment(i);
            double val = Double.parseDouble(alignInfo.getAttr(nameItem, i));
            if (val1 <= val && val <= val2) continue;
            a.setFilter(false);
        }
    }

    public static void filterExceptBetween(AlignmentList alignInfo, String nameItem, double val1, double val2) {
        for (int i = 0; i < alignInfo.size(); ++i) {
            Alignment a = alignInfo.getAlignment(i);
            double val = Double.parseDouble(alignInfo.getAttr(nameItem, i));
            if (val < val1 || val2 < val) continue;
            a.setFilter(false);
        }
    }

    public static void filterLessThan(AlignmentList alignInfo, String nameItem, double val1) {
        for (int i = 0; i < alignInfo.size(); ++i) {
            Alignment a = alignInfo.getAlignment(i);
            double val = Double.parseDouble(alignInfo.getAttr(nameItem, i));
            if (val < val1) continue;
            a.setFilter(false);
        }
    }

    public static void filterLessEqual(AlignmentList alignInfo, String nameItem, double val1) {
        for (int i = 0; i < alignInfo.size(); ++i) {
            Alignment a = alignInfo.getAlignment(i);
            double val = Double.parseDouble(alignInfo.getAttr(nameItem, i));
            if (val <= val1) continue;
            a.setFilter(false);
        }
    }

    public static void filterEqual(AlignmentList alignInfo, String nameItem, double val1) {
        for (int i = 0; i < alignInfo.size(); ++i) {
            Alignment a = alignInfo.getAlignment(i);
            double val = Double.parseDouble(alignInfo.getAttr(nameItem, i));
            if (val == val1) continue;
            a.setFilter(false);
        }
    }

    public static void filterEqual(AlignmentList alignInfo, String nameItem, String val1) {
        for (int i = 0; i < alignInfo.size(); ++i) {
            Alignment a = alignInfo.getAlignment(i);
            String val = alignInfo.getAttr(nameItem, i);
            if (val.equalsIgnoreCase(val1)) continue;
            a.setFilter(false);
        }
    }

    public static void filterRegex(AlignmentList alignInfo, String nameItem, String pat) {
        pat = ".*" + pat + ".*";
        Pattern p = Pattern.compile(pat, 2);
        for (int i = 0; i < alignInfo.size(); ++i) {
            Alignment a = alignInfo.getAlignment(i);
            String val = alignInfo.getAttr(nameItem, i);
            if (p.matcher(val).matches()) continue;
            a.setFilter(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void filterSelect(AlignmentList alignInfo, String nameItem, String sel) {
        void var3_3;
        String pat;
        if ("Orthologs (BBH)".equals(sel)) {
            pat = "[3]";
        } else if ("Duplicated".equals(sel)) {
            pat = "[12]";
        } else if ("Eliminate Paralogs".equals(sel)) {
            pat = "[123]";
        } else if ("Paralogs".equals(sel)) {
            pat = "[0]";
        } else {
            return;
        }
        AlignmentFilter.filterRegex(alignInfo, nameItem, (String)var3_3);
    }

    public static void filterGreaterEqual(AlignmentList alignInfo, String nameItem, double val1) {
        for (int i = 0; i < alignInfo.size(); ++i) {
            Alignment a = alignInfo.getAlignment(i);
            double val = Double.parseDouble(alignInfo.getAttr(nameItem, i));
            if (val1 <= val) continue;
            a.setFilter(false);
        }
    }

    public static void filterGreaterThan(AlignmentList alignInfo, String nameItem, double val1) {
        for (int i = 0; i < alignInfo.size(); ++i) {
            Alignment a = alignInfo.getAlignment(i);
            double val = Double.parseDouble(alignInfo.getAttr(nameItem, i));
            if (val1 < val) continue;
            a.setFilter(false);
        }
    }
}

