/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.AlignmentFilterDialog;
import cgat.BaseMessageDialog;
import cgat.MbgdDataMng;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;

public class AlignmentFilterCommand
implements ActionListener,
Observer {
    private Frame frame;
    private MbgdDataMng mbgdDataMng;
    private AlignmentFilterDialog dialog;

    public AlignmentFilterCommand(Frame f, MbgdDataMng dataMng) {
        this.frame = f;
        this.dialog = AlignmentFilterDialog.Instance(f);
        this._init(dataMng);
    }

    private void _init(MbgdDataMng dataMng) {
        this.mbgdDataMng = dataMng;
        this.setup();
    }

    public void setup() {
        this.dialog.clear();
        String[] alignAttrName = new String[5];
        for (int i = 0; i < 5; ++i) {
            alignAttrName[i] = this.mbgdDataMng.getAlignAttrName(i);
        }
        this.dialog.setAttrName(alignAttrName);
        this.dialog.setGuiParts();
    }

    public void actionPerformed(ActionEvent e) {
        this.setup();
        this.dialog.setVisible(true);
        int sta = this.dialog.getStatus();
        switch (sta) {
            case -1: {
                return;
            }
            case 1: {
                this.mbgdDataMng.clearFilterAlignment();
                this.frame.repaint();
                return;
            }
            case 2: {
                this.mbgdDataMng.clearFilterAll();
                break;
            }
        }
        int idxAlignItem = this.dialog.getSelectedAlignItemIndex();
        String nameAlignItem = this.dialog.getSelectedAlignItem();
        int idxCond = this.dialog.getSelectedConditionIndex();
        String nameCond = this.dialog.getSelectedCondition();
        int idxSel = this.dialog.getSelectedTypeIndex();
        String nameSel = "";
        String text = this.dialog.getInputTextValue().trim();
        double val1 = 0.0;
        double val2 = 0.0;
        String str1 = "";
        if ("Select".equals(nameCond)) {
            if (0 <= idxSel) {
                nameSel = this.dialog.getSelectedType();
            }
        } else {
            StringTokenizer st;
            block25: {
                text = this.dialog.getInputTextValue().trim();
                val1 = 0.0;
                val2 = 0.0;
                str1 = "";
                st = new StringTokenizer(text, ",");
                if (st.countTokens() == 0) {
                    return;
                }
                try {
                    str1 = st.nextToken();
                    val1 = Double.valueOf(str1);
                }
                catch (Exception e1) {
                    if ("Equal".equals(nameCond) || "Regex".equals(nameCond)) break block25;
                    String msg = "Data Format Error.\n";
                    BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
                    msgDialog.message(msg);
                    return;
                }
            }
            try {
                if ("Between (e.g. 10,20)".equals(nameCond) || "Except Between".equals(nameCond)) {
                    val2 = Double.valueOf(st.nextToken());
                }
            }
            catch (Exception e2) {
                String msg = "Data Format Error.\n";
                BaseMessageDialog msgDialog = BaseMessageDialog.Instance();
                msgDialog.message(msg);
                return;
            }
        }
        if ("Between (e.g. 10,20)".equals(nameCond) || "Except Between".equals(nameCond)) {
            this.mbgdDataMng.filterAlignment(nameCond, nameAlignItem, val1, val2);
        } else if ("Less Than".equals(nameCond) || "Less Equal".equals(nameCond) || "Greater Equal".equals(nameCond) || "Greater Than".equals(nameCond)) {
            this.mbgdDataMng.filterAlignment(nameCond, nameAlignItem, val1);
        } else if ("Select".equals(nameCond)) {
            this.mbgdDataMng.filterAlignment(nameCond, nameAlignItem, nameSel);
        } else if ("Regex".equals(nameCond)) {
            this.mbgdDataMng.filterAlignment(nameCond, nameAlignItem, str1);
        } else if ("Equal".equals(nameCond)) {
            boolean dataType = this.mbgdDataMng.getAlignAttrDataType(nameAlignItem);
            if (dataType) {
                this.mbgdDataMng.filterAlignment(nameCond, nameAlignItem, str1);
            } else {
                this.mbgdDataMng.filterAlignment(nameCond, nameAlignItem, val1);
            }
        }
        this.frame.repaint();
    }

    public void update(Observable o, Object arg) {
        if (o instanceof MbgdDataMng) {
            this.update((MbgdDataMng)o, arg);
        }
    }

    public void update(MbgdDataMng mbgdDataMng, Object arg) {
    }
}

