/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.AlignmentFilterCommand;
import cgat.AlignmentSegment;
import cgat.AlignmentSequence;
import cgat.BaseFrame;
import cgat.BaseMessageDialog;
import cgat.ButtonAcceleration;
import cgat.ChangeAlignmentColorCommand;
import cgat.ChangeCgatColorCommand;
import cgat.DispRawSequencePairCommand;
import cgat.DispSegmentDataTable;
import cgat.DotPlot;
import cgat.DotPlotZoomDownCommand;
import cgat.DotPlotZoomTarget;
import cgat.DotPlotZoomUpCommand;
import cgat.DrawAlignmentSet;
import cgat.DrawScale;
import cgat.DrawingSet;
import cgat.DynamicSearchCommand;
import cgat.ExitCommand;
import cgat.MbgdData;
import cgat.MbgdDataMng;
import cgat.PanelPrintable;
import cgat.PrintPageCommand;
import cgat.PropertiesCommand;
import cgat.RotateButton;
import cgat.SearchOrfCommand;
import cgat.SegmentFilterCommand;
import cgat.SelectAlignmentMode;
import cgat.SelectSpecPairCommand;
import cgat.SelectSpecPairDialog;
import cgat.ViewLeftCommand;
import cgat.ViewRightCommand;
import cgat.ViewWindow;
import cgat.ViewZoomDownCommand;
import cgat.ViewZoomUpCommand;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class AlignmentViewerFrame
extends BaseFrame
implements Observer {
    static int WIDTH_SCALE = DotPlot.WIDTH;
    static int HEIGHT_SCALE = 80;
    protected ViewWindow viewWin;
    protected DrawingSet drawingSet;
    protected SelectSpecPairCommand selectSpecListener;
    protected ExitCommand exitListener;
    protected PrintPageCommand printAlignmentArea;
    protected PrintPageCommand printDotPlotArea;
    protected PropertiesCommand propertiesListener;
    protected DispSegmentDataTable dispSegDataTab;
    protected DispRawSequencePairCommand dispRawSeqListener;
    protected SearchOrfCommand searchOrf;
    protected AlignmentFilterCommand filterAlignment;
    protected SegmentFilterCommand filterSegment;
    protected DynamicSearchCommand dynSearch;
    protected JPanel panelBase;
    protected JPanel panelRegion;
    protected PanelPrintable panelDotPlot;
    protected DotPlot dotPlot;
    protected DrawScale xscale;
    protected DrawScale yscale;

    public AlignmentViewerFrame(String sp1, String sp2, String prog) {
        super(200, 100);
        MbgdDataMng dataMng = MbgdDataMng.Instance();
        this.viewWin = ViewWindow.Instance(dataMng);
        this.viewWin.setDrawMode(0);
        this.panelBase = new JPanel();
        this.pane.add(this.panelBase);
        this.createDrawingArea(dataMng, this.viewWin);
        this.createMenu(dataMng, this.viewWin, sp1, sp2, prog);
        this.createToolbar(dataMng, this.viewWin);
        AlignmentSequence alignSequence = new AlignmentSequence(dataMng, this.viewWin);
        AlignmentSegment alignSegment = new AlignmentSegment(dataMng, this.viewWin);
        this.viewWin.setAlignmentInfo(alignSequence, alignSegment);
        this.selectSpecListener.addObserver(this.drawingSet);
        this.selectSpecListener.addObserver(this);
        dataMng.addObserver(this);
        dataMng.addObserver(this.viewWin);
        dataMng.addObserver(this.drawingSet);
        this.viewWin.addObserver(this.drawingSet);
        this.viewWin.addObserver(this.dotPlot);
        this.viewWin.addObserver(this.xscale);
        this.viewWin.addObserver(this.yscale);
        alignSegment.addObserver(this.drawingSet);
        this.searchOrf.addObserver(this.xscale);
        this.searchOrf.addObserver(this.yscale);
        this.setSize(1000, 10);
        int segNum = dataMng.getSegNum();
        this.setFrameSize(segNum);
    }

    public void createMenu(MbgdDataMng dataMng, ViewWindow viewWin, String sp1, String sp2, String prog) {
        this.selectSpecListener = new SelectSpecPairCommand(this, dataMng);
        SelectSpecPairDialog selSpDiglog = SelectSpecPairDialog.Instance(this);
        selSpDiglog.setDefault(sp1, sp2, prog);
        selSpDiglog._update();
        this.exitListener = new ExitCommand();
        this.printAlignmentArea = new PrintPageCommand(this.drawingSet);
        this.printDotPlotArea = new PrintPageCommand(this.panelDotPlot);
        this.propertiesListener = new PropertiesCommand(this, dataMng);
        this.dispSegDataTab = new DispSegmentDataTable(this, dataMng, viewWin);
        this.dispRawSeqListener = new DispRawSequencePairCommand(dataMng, viewWin);
        this.searchOrf = new SearchOrfCommand(this, dataMng, viewWin);
        this.filterAlignment = new AlignmentFilterCommand(this, dataMng);
        this.filterSegment = new SegmentFilterCommand(this, dataMng);
        this.dynSearch = new DynamicSearchCommand(this, dataMng, viewWin);
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JMenu menu = new JMenu("File");
        this.menuBar.add(menu);
        JMenuItem item = new JMenuItem("Load");
        item.addActionListener(this.selectSpecListener);
        menu.add(item);
        item = new JMenuItem("Print");
        item.addActionListener(this.printAlignmentArea);
        menu.add(item);
        item = new JMenuItem("Properties");
        item.addActionListener(this.propertiesListener);
        menu.add(item);
        if (!MbgdData.Instance().isApplet()) {
            item = new JMenuItem("Exit");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    AlignmentViewerFrame.this.exitMenuItemActionPerformed(evt);
                }
            });
        }
        menu.add(item);
        menu = new JMenu("Search");
        this.menuBar.add(menu);
        item = new JMenuItem("Mark Genes");
        item.addActionListener(this.searchOrf);
        menu.add(item);
        item = new JMenuItem("Filter Alignment");
        item.addActionListener(this.filterAlignment);
        menu.add(item);
        item = new JMenuItem("Filter Gene/Segment");
        item.addActionListener(this.filterSegment);
        menu.add(item);
        item = new JMenuItem("Dynamic Search");
        item.addActionListener(this.dynSearch);
        menu.add(item);
        menu = new JMenu("View");
        this.menuBar.add(menu);
        item = new JMenuItem("Gene/Segment Data Table");
        item.addActionListener(this.dispSegDataTab);
        menu.add(item);
        item = new JMenuItem("Sequence Window");
        item.addActionListener(this.dispRawSeqListener);
        menu.add(item);
        item = new JMenuItem("Exchange Reference Genome");
        item.addActionListener(dataMng);
        menu.add(item);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    public void setVisibleMenuBar(boolean sta) {
        JMenuBar mb = this.getJMenuBar();
        if (mb != null) {
            mb.setVisible(sta);
        }
    }

    public void createToolbar(MbgdDataMng dataMng, ViewWindow viewWin) {
        BaseMessageDialog msgDialog;
        String msg;
        JToggleButton tb;
        JButton b;
        String tooltip;
        String name;
        Insets is0 = new Insets(0, 0, 0, 0);
        ViewLeftCommand viewLeft = new ViewLeftCommand(viewWin);
        ViewRightCommand viewRight = new ViewRightCommand(viewWin);
        ViewZoomUpCommand viewZoomUp = new ViewZoomUpCommand(viewWin);
        ViewZoomDownCommand viewZoomDown = new ViewZoomDownCommand(viewWin);
        DotPlotZoomUpCommand dotPlotZoomUp = new DotPlotZoomUpCommand(viewWin);
        DotPlotZoomDownCommand dotPlotZoomDown = new DotPlotZoomDownCommand(viewWin);
        ButtonAcceleration viewLeftBtnAct = new ButtonAcceleration(1000, viewLeft);
        ButtonAcceleration viewRightBtnAct = new ButtonAcceleration(1000, viewRight);
        this.toolBar = new JToolBar();
        this.pane.add((Component)this.toolBar, "North");
        String f = "";
        String basePath = dataMng.getBasePath();
        String docBase = dataMng.getDocBase();
        try {
            name = "image/ArrowLeft.jpeg";
            tooltip = dataMng.getProperty("cgat.tooltip.left");
            JButton b2 = this.iconButton(name, is0);
            b2.addMouseListener(viewLeftBtnAct);
            this.toolBar.add(b2);
            b2.setToolTipText(tooltip);
            name = "image/ArrowRight.jpeg";
            tooltip = dataMng.getProperty("cgat.tooltip.right");
            b2 = this.iconButton(name, is0);
            b2.addMouseListener(viewRightBtnAct);
            this.toolBar.add(b2);
            b2.setToolTipText(tooltip);
            name = "image/RegionZoomUp.jpeg";
            tooltip = dataMng.getProperty("cgat.tooltip.region.up");
            b2 = this.iconButton(name, is0);
            b2.addActionListener(viewZoomUp);
            this.toolBar.add(b2);
            b2.setToolTipText(tooltip);
            name = "image/RegionZoomDown.jpeg";
            tooltip = dataMng.getProperty("cgat.tooltip.region.down");
            b2 = this.iconButton(name, is0);
            b2.addActionListener(viewZoomDown);
            this.toolBar.add(b2);
            b2.setToolTipText(tooltip);
        }
        catch (Exception e) {
            String msg2 = "Icon File Not Found.\nFile : " + f + "\n";
            BaseMessageDialog msgDialog2 = BaseMessageDialog.Instance(this);
            msgDialog2.message(msg2);
        }
        JPanel pCol = new JPanel(new GridLayout(2, 1));
        pCol.setPreferredSize(null);
        JLabel lCol = new JLabel("Alignment Color");
        lCol.setPreferredSize(null);
        lCol.setFont(new Font("Serif", 0, 12));
        pCol.add(lCol);
        pCol.setMaximumSize(new Dimension(120, 40));
        RotateButton btnColor = new RotateButton();
        btnColor.addLabel("Best Hit");
        btnColor.addLabel("Identity");
        tooltip = dataMng.getProperty("cgat.tooltip.color");
        ChangeAlignmentColorCommand alBtnColor = new ChangeAlignmentColorCommand(dataMng, btnColor);
        btnColor.addActionListener(alBtnColor);
        btnColor.setToolTipText(tooltip);
        pCol.add(btnColor);
        this.toolBar.add(pCol);
        JPanel pAlign = new JPanel(new GridLayout(2, 1));
        pAlign.setPreferredSize(null);
        JLabel lAlign = new JLabel("Alignment Mode");
        lAlign.setPreferredSize(null);
        lAlign.setFont(new Font("Serif", 0, 12));
        pAlign.add(lAlign);
        pAlign.setMaximumSize(new Dimension(120, 40));
        RotateButton btnAlign = new RotateButton();
        btnAlign.addLabel("Regionwise");
        btnAlign.addLabel("Ref-Target");
        tooltip = dataMng.getProperty("cgat.tooltip.alignment");
        btnAlign.addActionListener(new SelectAlignmentMode(viewWin, this.drawingSet, btnAlign));
        btnAlign.setToolTipText(tooltip);
        pAlign.add(btnAlign);
        this.toolBar.add(pAlign);
        try {
            name = "image/Exchange24.gif";
            tooltip = dataMng.getProperty("cgat.tooltip.exchange");
            b = this.iconButton(name, null);
            b.addActionListener(dataMng);
            this.toolBar.add(b);
            b.setToolTipText(tooltip);
            this.toolBar.add(new JToolBar.Separator());
            tooltip = dataMng.getProperty("cgat.tooltip.dotplot");
            tb = new JToggleButton("DotPlot", true);
            tb.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    AlignmentViewerFrame.this.panelDotPlot.setVisible(e.getStateChange() == 1);
                }
            });
            tb.setToolTipText(tooltip);
            this.toolBar.add(tb);
            name = "image/DotPlotZoomUp.jpeg";
            tooltip = dataMng.getProperty("cgat.tooltip.dotplot.up");
            b = this.iconButton(name, is0);
            b.addActionListener(dotPlotZoomUp);
            this.toolBar.add(b);
            b.setToolTipText(tooltip);
            name = "image/DotPlotZoomDown.jpeg";
            tooltip = dataMng.getProperty("cgat.tooltip.dotplot.down");
            b = this.iconButton(name, is0);
            b.addActionListener(dotPlotZoomDown);
            this.toolBar.add(b);
            b.setToolTipText(tooltip);
        }
        catch (Exception e) {
            msg = "Icon File Not Found.\nFile : " + f + "\n";
            msgDialog = BaseMessageDialog.Instance();
            msgDialog.message(msg);
        }
        name = "image/DotPlotX24.gif";
        tooltip = dataMng.getProperty("cgat.tooltip.dotplot.x");
        URL u = this.getClass().getClassLoader().getResource(name);
        tb = new JToggleButton(new ImageIcon(u), true);
        tb.addActionListener(new DotPlotZoomTarget(viewWin, true));
        tb.setToolTipText(tooltip);
        this.toolBar.add(tb);
        name = "image/DotPlotY24.gif";
        tooltip = dataMng.getProperty("cgat.tooltip.dotplot.y");
        u = this.getClass().getClassLoader().getResource(name);
        tb = new JToggleButton(new ImageIcon(u), true);
        tb.addActionListener(new DotPlotZoomTarget(viewWin, false));
        tb.setToolTipText(tooltip);
        this.toolBar.add(tb);
        try {
            b = null;
            tooltip = dataMng.getProperty("cgat.tooltip.color.bg");
            RotateButton btnBw = new RotateButton();
            name = "image/DotPlotBw24.gif";
            URL u1 = this.getClass().getClassLoader().getResource(name);
            btnBw.addIcon(new ImageIcon(u1));
            name = "image/DotPlotWb24.gif";
            URL u2 = this.getClass().getClassLoader().getResource(name);
            btnBw.addIcon(new ImageIcon(u2));
            btnBw.addActionListener(new ChangeCgatColorCommand(dataMng, btnBw));
            btnBw.setToolTipText(tooltip);
            this.toolBar.add(btnBw);
            name = "image/RegionTable24.gif";
            tooltip = dataMng.getProperty("cgat.tooltip.genetab");
            b = this.iconButton(name, null);
            b.addActionListener(this.dispSegDataTab);
            b.setToolTipText(tooltip);
            this.toolBar.add(b);
        }
        catch (Exception e) {
            msg = "Icon File Not Found.\nFile : " + f + "\n";
            msgDialog = BaseMessageDialog.Instance();
            msgDialog.message(msg);
        }
    }

    private JButton iconButton(String name, Insets is) {
        URL u = this.getClass().getClassLoader().getResource(name);
        ImageIcon i = new ImageIcon(u);
        JButton b = new JButton(i);
        if (is != null) {
            b.setMargin(is);
        }
        b.setRolloverEnabled(true);
        return b;
    }

    public void createDrawingArea(MbgdDataMng dataMng, ViewWindow viewWin) {
        GridBagLayout gridbag = new GridBagLayout();
        this.panelBase.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.ipadx = 800;
        c.ipady = DrawAlignmentSet.HEIGHT;
        c.gridwidth = 1;
        c.gridheight = 1;
        JPanel panelAlignArea = this.createRegionArea(dataMng, viewWin);
        gridbag.setConstraints(panelAlignArea, c);
        this.panelBase.add(panelAlignArea);
        c = new GridBagConstraints();
        c.weightx = 0.0;
        c.gridx = 1;
        c.gridy = 0;
        c.ipadx = DotPlot.WIDTH + HEIGHT_SCALE + 10;
        c.ipady = DotPlot.HEIGHT + HEIGHT_SCALE;
        c.gridwidth = 1;
        c.gridheight = 1;
        JPanel panelDotPlotArea = this.createDotPlotArea(dataMng, viewWin);
        gridbag.setConstraints(panelDotPlotArea, c);
        this.panelBase.add(panelDotPlotArea);
    }

    public JPanel createRegionArea(MbgdDataMng dataMng, ViewWindow viewWin) {
        this.drawingSet = new DrawingSet(dataMng, viewWin);
        this.panelRegion = this.drawingSet.getDrawingPanel();
        this.drawingSet.setDrawings(false);
        return this.panelRegion;
    }

    public JPanel createDotPlotArea(MbgdDataMng dataMng, ViewWindow viewWin) {
        this.panelDotPlot = new PanelPrintable();
        this.panelDotPlot.setLayout(null);
        this.dotPlot = new DotPlot(dataMng, viewWin);
        this.xscale = new DrawScale(dataMng, "");
        this.xscale.setScaleType(true);
        this.xscale.setScaleSize(WIDTH_SCALE, HEIGHT_SCALE);
        this.yscale = new DrawScale(dataMng, "");
        this.yscale.setScaleType(false);
        this.yscale.setScaleSize(HEIGHT_SCALE, WIDTH_SCALE);
        this.panelDotPlot.add(this.dotPlot);
        this.dotPlot.setLocation(HEIGHT_SCALE, 0);
        this.panelDotPlot.add((Component)this.xscale, "West");
        this.xscale.setLocation(HEIGHT_SCALE, WIDTH_SCALE);
        this.panelDotPlot.add((Component)this.yscale, "South");
        this.yscale.setLocation(0, 0);
        this.panelDotPlot.validate();
        return this.panelDotPlot;
    }

    public void update(Observable o, Object arg) {
        int segNum = MbgdDataMng.Instance().getSegNum();
        this.setFrameSize(segNum);
    }

    public void setFrameSize(int segN) {
        MbgdDataMng mbgdMng = MbgdDataMng.Instance();
        int height = 0;
        int hAlign = mbgdMng.getPropertyInt("cgat.panel.alignment.alignment.height");
        int hGene = mbgdMng.getPropertyInt("cgat.panel.alignment.gene.height");
        int hSeg = mbgdMng.getPropertyInt("cgat.panel.alignment.segment.height");
        height += hAlign + hGene * 2 + (hSeg + 5) * segN * 2;
        this.drawingSet.setWindowHeight(hAlign, hGene, hSeg);
        if ((height += 270) < 600) {
            height = 600;
        }
        int maxSegNum = mbgdMng.getMaxSegNum();
        boolean[] staSeg = new boolean[maxSegNum];
        for (int i = 0; i < maxSegNum; ++i) {
            staSeg[i] = false;
            if (i >= segN) continue;
            staSeg[i] = true;
        }
        this.drawingSet.setDrawings(staSeg);
        this.setSize(this.getWidth(), height);
        this.validate();
    }
}

