/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.Alignment;
import cgat.AlignmentSegment;
import cgat.AlignmentSequence;
import cgat.BaseDraw;
import cgat.Dbg;
import cgat.MbgdDataMng;
import cgat.PrintTextWindow;
import cgat.SegmentPos;
import cgat.ViewWindow;
import cgat.seq.DNASequence;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;

public class DrawAlignment
extends BaseDraw
implements MouseListener {
    final char CHAR_SAMEBASE = (char)124;
    protected double PadHeightAlignmentRate = 0.25;
    protected MbgdDataMng mbgdDataMng;
    protected ViewWindow viewWin;
    protected PrintTextWindow alignDataWin;
    protected Color colMat = Color.black;
    protected Color colMis = Color.red;
    protected Color colGap = Color.green;

    public DrawAlignment(MbgdDataMng dataMng, ViewWindow vWin) {
        this._init(dataMng, vWin, HEIGHT, WIDTH);
    }

    public DrawAlignment(MbgdDataMng dataMng, ViewWindow vWin, int w, int h) {
        this._init(dataMng, vWin, w, h);
    }

    private void _init(MbgdDataMng dataMng, ViewWindow vWin, int w, int h) {
        this.mbgdDataMng = dataMng;
        this.viewWin = vWin;
        this.setWindowWidth(w);
        this.setWindowHeight(h);
        Dimension d = new Dimension(w, h);
        this.setSize(d);
        this.setMinimumSize(d);
        this.setPreferredSize(d);
        try {
            this.addMouseListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        this.winWidth = this.getWidth();
        this.winHeight = this.getHeight();
        this.updBgColor();
        super.paint(g);
        this.drawAlignment(g);
        this.drawFrame(g);
    }

    public void drawFrame(Graphics g) {
        g.setColor(this.getFgColor());
        g.drawRect(0, 0, this.winWidth - 1, this.winHeight - 1);
    }

    public void drawAlignment(boolean autoAdjust) {
        Graphics g = this.getGraphics();
        if (g != null) {
            super.paint(g);
            this.drawFrame(g);
            this.drawAlignment(g);
        } else {
            Dbg.println(1, "getGraphics() returns null");
        }
    }

    public void drawAlignment(Graphics g) {
        if (this.mbgdDataMng.getAlignmentSize() == 0) {
            return;
        }
        int mode = this.viewWin.getDrawMode();
        if (mode == 0) {
            this.drawAlignmentSequence(g);
        } else if (mode == 1) {
            this.drawAlignmentSegment(g);
        }
    }

    public void drawAlignmentSequence(Graphics g) {
        float ratio = this.seqLenPerPixel(this.viewWin);
        int zoomCount = this.viewWin.getZoomCount();
        if (ratio > 1.0f) {
            this.drawAlignmentSequenceZoomLev0(g);
        } else if ((double)ratio > 0.25) {
            this.drawAlignmentSequenceZoomLev1(g);
        } else {
            this.drawAlignmentSequenceZoomLev2(g);
        }
    }

    public void drawAlignmentSequenceZoomLev2(Graphics g) {
        this.drawAlignmentSequenceZoomLev1(g);
    }

    public void drawAlignmentSequenceZoomLev1(Graphics g) {
        int winWidth = this.getWindowWidth();
        int winHeight = this.getWindowHeight();
        int[] xArrowDir = new int[]{0, -5, -5};
        int[] yArrowDir = new int[]{0, -5, 5};
        int[] xArrowInv = new int[]{0, 5, 5};
        int[] yArrowInv = new int[]{0, -5, 5};
        int virtualWinWidthSbj = 1;
        int virtualWinWidthQry = 1;
        virtualWinWidthSbj = this.viewWin.getAlignSequence(true).length();
        virtualWinWidthQry = this.viewWin.getAlignSequence(false).length();
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regStart1 = this.viewWin.getRegCenter(true) - regWidth1 / 2;
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        boolean regDir1 = this.viewWin.getRegDir(true);
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regStart2 = this.viewWin.getRegCenter(false) - regWidth2 / 2;
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        boolean regDir2 = this.viewWin.getRegDir(false);
        if (regStart1 <= 0) {
            regStart1 += regMax1;
        }
        if (regStart2 <= 0) {
            regStart2 += regMax2;
        }
        Alignment[] alignList = this.mbgdDataMng.selectAlignList(regStart1, regWidth1, regMax1, regStart2, regWidth2, regMax2);
        AlignmentSequence alignSeq = this.viewWin.getAlignSequence();
        g.setColor(Color.black);
        String[] alignSeqPair = this.drawSequence(g);
        if (alignSeqPair == null) {
            return;
        }
        int[] xArrow1 = new int[3];
        int[] yArrow1 = new int[3];
        int[] xArrow2 = new int[3];
        int[] yArrow2 = new int[3];
        virtualWinWidthSbj = regWidth1;
        virtualWinWidthQry = regWidth2;
        int loopMax = alignList.length;
        for (int i = 0; i < loopMax; ++i) {
            int j;
            Alignment align = alignList[i];
            if (!align.getFilter()) continue;
            int from1 = align.getFrom1();
            int to1 = align.getTo1();
            int from2 = align.getFrom2();
            int to2 = align.getTo2();
            byte dir = align.getDir();
            String type2 = align.getType();
            if (regMax1 < regStart1 + regWidth1 && to1 < regStart1) {
                from1 += regMax1;
                to1 += regMax1;
            }
            if (regMax2 < regStart2 + regWidth2 && to2 < regStart2) {
                from2 += regMax2;
                to2 += regMax2;
            }
            from1 = alignSeq.getGappedRegPosOfs(0, from1);
            to1 = alignSeq.getGappedRegPosOfs(0, to1) + 1;
            int x1 = (int)((float)from1 / (float)regWidth1 * (float)winWidth);
            int y1 = (int)((double)winHeight * this.PadHeightAlignmentRate);
            int w1 = (int)((float)(to1 - from1) / (float)regWidth1 * (float)winWidth);
            if (w1 < 0) {
                x1 += w1;
                w1 = -w1;
            }
            if (regDir1) {
                j = 0;
                xArrow1[j] = x1 + w1 + xArrowDir[j];
                yArrow1[j] = y1 + yArrowDir[j];
                xArrow1[++j] = x1 + w1 + xArrowDir[j];
                yArrow1[j] = y1 + yArrowDir[j];
                xArrow1[++j] = x1 + w1 + xArrowDir[j];
                yArrow1[j] = y1 + yArrowDir[j];
                ++j;
            } else {
                j = 0;
                xArrow1[j] = x1 + xArrowInv[j];
                yArrow1[j] = y1 + yArrowInv[j];
                xArrow1[++j] = x1 + xArrowInv[j];
                yArrow1[j] = y1 + yArrowInv[j];
                xArrow1[++j] = x1 + xArrowInv[j];
                yArrow1[j] = y1 + yArrowInv[j];
                ++j;
            }
            if (regDir2) {
                from2 = alignSeq.getGappedRegPosOfs(1, from2);
                to2 = alignSeq.getGappedRegPosOfs(1, to2) + 1;
            } else {
                int oldFrom2 = from2 = alignSeq.getGappedRegPosOfs(1, from2 - 1) + 1;
                int oldTo2 = to2 = alignSeq.getGappedRegPosOfs(1, to2 - 1);
            }
            if (to2 < from2) {
                int wk = from2;
                from2 = to2;
                to2 = wk;
            }
            int x2 = (int)((float)from2 / (float)regWidth2 * (float)winWidth);
            int y2 = (int)((double)winHeight * (1.0 - this.PadHeightAlignmentRate));
            int w2 = (int)((float)(to2 - from2) / (float)regWidth2 * (float)winWidth);
            if (w2 < 0) {
                x2 += w2;
                w2 = -w2;
            }
            j = 0;
            if (dir == 1) {
                if (regDir2) {
                    xArrow2[j] = x2 + w2 + xArrowDir[j];
                    yArrow2[j] = y2 + yArrowDir[j];
                    xArrow2[++j] = x2 + w2 + xArrowDir[j];
                    yArrow2[j] = y2 + yArrowDir[j];
                    xArrow2[++j] = x2 + w2 + xArrowDir[j];
                    yArrow2[j] = y2 + yArrowDir[j];
                    ++j;
                } else {
                    xArrow2[j] = x2 + xArrowInv[j];
                    yArrow2[j] = y2 + yArrowInv[j];
                    xArrow2[++j] = x2 + xArrowInv[j];
                    yArrow2[j] = y2 + yArrowInv[j];
                    xArrow2[++j] = x2 + xArrowInv[j];
                    yArrow2[j] = y2 + yArrowInv[j];
                    ++j;
                }
            } else if (regDir2) {
                xArrow2[j] = x2 + xArrowInv[j];
                yArrow2[j] = y2 + yArrowInv[j];
                xArrow2[++j] = x2 + xArrowInv[j];
                yArrow2[j] = y2 + yArrowInv[j];
                xArrow2[++j] = x2 + xArrowInv[j];
                yArrow2[j] = y2 + yArrowInv[j];
                ++j;
            } else {
                xArrow2[j] = x2 + w2 + xArrowDir[j];
                yArrow2[j] = y2 + yArrowDir[j];
                xArrow2[++j] = x2 + w2 + xArrowDir[j];
                yArrow2[j] = y2 + yArrowDir[j];
                xArrow2[++j] = x2 + w2 + xArrowDir[j];
                yArrow2[j] = y2 + yArrowDir[j];
                ++j;
            }
            Color color = this.mbgdDataMng.getAlignColor(1, type2, "int", align);
            g.setColor(color);
            g.drawLine(x1, y1, x1 + w1, y1);
            g.drawLine(x2, y2, x2 + w2, y2);
            int zoomCount = this.viewWin.getZoomCount();
            if (dir == 1) {
                if (regDir1 == regDir2) {
                    g.drawLine(x1, y1, x2, y2);
                    g.drawLine(x1 + w1, y1, x2 + w2, y2);
                    continue;
                }
                g.drawLine(x1, y1, x2 + w2, y2);
                g.drawLine(x1 + w1, y1, x2, y2);
                continue;
            }
            if (regDir1 == regDir2) {
                g.drawLine(x1, y1, x2 + w2, y2);
                g.drawLine(x1 + w1, y1, x2, y2);
                continue;
            }
            g.drawLine(x1, y1, x2, y2);
            g.drawLine(x1 + w1, y1, x2 + w2, y2);
        }
    }

    protected Alignment getNextAlignL(Alignment[] alignList, int i, int loopMax) {
        Alignment align = alignList[i];
        Alignment a = null;
        --i;
        while (0 <= i) {
            if (alignList[i].getFilter() && align.getType().equals(alignList[i].getType())) {
                a = alignList[i];
                break;
            }
            --i;
        }
        return a;
    }

    protected Alignment getNextAlignR(Alignment[] alignList, int i, int loopMax) {
        Alignment align = alignList[i];
        Alignment a = null;
        ++i;
        while (i < loopMax) {
            if (alignList[i].getFilter() && align.getType().equals(alignList[i].getType())) {
                a = alignList[i];
                break;
            }
            ++i;
        }
        return a;
    }

    public void drawAlignmentSequenceZoomLev0(Graphics g) {
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regStart1 = this.viewWin.getRegCenter(true) - regWidth1 / 2;
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        boolean regDir1 = this.viewWin.getRegDir(true);
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regStart2 = this.viewWin.getRegCenter(false) - regWidth2 / 2;
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        boolean regDir2 = this.viewWin.getRegDir(false);
        int winWidth = this.getWindowWidth();
        int winHeight = this.getWindowHeight();
        if (regStart1 < 0) {
            regStart1 += regMax1;
        }
        if (regStart2 < 0) {
            regStart2 += regMax2;
        }
        int[] xArrowDir = new int[]{0, -5, -5};
        int[] yArrowDir = new int[]{0, -5, 5};
        int[] xArrowInv = new int[]{0, 5, 5};
        int[] yArrowInv = new int[]{0, -5, 5};
        Alignment[] alignList = this.mbgdDataMng.selectAlignList(regStart1, regWidth1, regMax1, regStart2, regWidth2, regMax2);
        g.setColor(Color.black);
        String[] alignSeqPair = this.drawSequence(g);
        if (alignSeqPair == null) {
            return;
        }
        int[] xArrow1 = new int[3];
        int[] yArrow1 = new int[3];
        int[] xArrow2 = new int[3];
        int[] yArrow2 = new int[3];
        int loopMax = alignList.length;
        Dbg.println(3, "n alignment :: " + loopMax);
        for (int i = 0; i < loopMax; ++i) {
            Alignment align = alignList[i];
            if (!align.getFilter()) continue;
            int from1 = align.getFrom1();
            int to1 = align.getTo1() + 1;
            int from2 = align.getFrom2();
            int to2 = align.getTo2() + 1;
            byte dir = align.getDir();
            String type2 = align.getType();
            int x1 = this.getWinPosX(from1, regStart1, regWidth1, regMax1, winWidth);
            int y1 = (int)((double)winHeight * this.PadHeightAlignmentRate);
            int w1 = (int)((float)(to1 - from1) / (float)regWidth1 * (float)winWidth);
            int j = 0;
            xArrow1[j] = x1 + w1 + xArrowDir[j];
            yArrow1[j] = y1 + yArrowDir[j];
            xArrow1[++j] = x1 + w1 + xArrowDir[j];
            yArrow1[j] = y1 + yArrowDir[j];
            xArrow1[++j] = x1 + w1 + xArrowDir[j];
            yArrow1[j] = y1 + yArrowDir[j];
            ++j;
            int x2 = this.getWinPosX(from2, regStart2, regWidth2, regMax2, winWidth);
            int y2 = (int)((double)winHeight * (1.0 - this.PadHeightAlignmentRate));
            int w2 = (int)((float)(to2 - from2) / (float)regWidth2 * (float)winWidth);
            if (dir == 1) {
                j = 0;
                xArrow2[j] = x2 + w2 + xArrowDir[j];
                yArrow2[j] = y2 + yArrowDir[j];
                xArrow2[++j] = x2 + w2 + xArrowDir[j];
                yArrow2[j] = y2 + yArrowDir[j];
                xArrow2[++j] = x2 + w2 + xArrowDir[j];
                yArrow2[j] = y2 + yArrowDir[j];
                ++j;
            } else {
                j = 0;
                xArrow2[j] = x2 + xArrowInv[j];
                yArrow2[j] = y2 + yArrowInv[j];
                xArrow2[++j] = x2 + xArrowInv[j];
                yArrow2[j] = y2 + yArrowInv[j];
                xArrow2[++j] = x2 + xArrowInv[j];
                yArrow2[j] = y2 + yArrowInv[j];
                ++j;
            }
            if (!regDir1) {
                x1 = this.revDispPos(x1, w1, winWidth);
                j = 0;
                xArrow1[j] = this.revDispPos(xArrow1[j], 0, winWidth);
                xArrow1[++j] = this.revDispPos(xArrow1[j], 0, winWidth);
                xArrow1[++j] = this.revDispPos(xArrow1[j], 0, winWidth);
                ++j;
            }
            if (!regDir2) {
                x2 = this.revDispPos(x2, w2, winWidth);
                j = 0;
                xArrow2[j] = this.revDispPos(xArrow2[j], 0, winWidth);
                xArrow2[++j] = this.revDispPos(xArrow2[j], 0, winWidth);
                xArrow2[++j] = this.revDispPos(xArrow2[j], 0, winWidth);
                ++j;
            }
            Color color = this.mbgdDataMng.getAlignColor(1, type2, "int", align);
            g.setColor(color);
            g.drawLine(x1, y1, x1 + w1, y1);
            g.drawLine(x2, y2, x2 + w2, y2);
            int zoomCount = this.viewWin.getZoomCount();
            if (dir == 1) {
                if (regDir1 == regDir2) {
                    g.drawLine(x1, y1, x2, y2);
                    g.drawLine(x1 + w1, y1, x2 + w2, y2);
                    continue;
                }
                g.drawLine(x1, y1, x2 + w2, y2);
                g.drawLine(x1 + w1, y1, x2, y2);
                continue;
            }
            if (regDir1 == regDir2) {
                g.drawLine(x1, y1, x2 + w2, y2);
                g.drawLine(x1 + w1, y1, x2, y2);
                continue;
            }
            g.drawLine(x1, y1, x2, y2);
            g.drawLine(x1 + w1, y1, x2 + w2, y2);
        }
    }

    public boolean isDrawAlignmentSequenceArrowHead(Alignment cAlign, Alignment rAlign, Alignment lAlign, boolean headSp1) {
        boolean drawArrowhead1 = true;
        boolean drawArrowhead2 = true;
        int minAlignGap = this.mbgdDataMng.getMinAlignGaps();
        if (cAlign.getDir() == 1) {
            if (rAlign != null && rAlign.getDir() == 1 && cAlign.getTo1() < rAlign.getFrom1() && cAlign.getTo2() < rAlign.getFrom2()) {
                int d = rAlign.getFrom1() - cAlign.getTo1();
                if (d <= minAlignGap) {
                    drawArrowhead1 = false;
                }
                if ((d = rAlign.getFrom2() - cAlign.getTo2()) <= minAlignGap) {
                    drawArrowhead2 = false;
                }
            }
        } else {
            int d;
            if (rAlign != null && rAlign.getDir() != 1 && cAlign.getTo1() < rAlign.getFrom1() && rAlign.getTo2() < cAlign.getFrom2()) {
                d = rAlign.getFrom1() - cAlign.getTo1();
                if (d <= minAlignGap) {
                    drawArrowhead1 = false;
                }
                if ((d = cAlign.getFrom2() - rAlign.getTo2()) <= minAlignGap) {
                    drawArrowhead2 = false;
                }
            }
            if (lAlign != null && lAlign.getDir() != 1 && lAlign.getTo1() < cAlign.getFrom1() && lAlign.getTo2() < cAlign.getFrom2() && (d = cAlign.getFrom2() - lAlign.getTo2()) <= minAlignGap) {
                drawArrowhead2 = false;
            }
        }
        if (headSp1) {
            return drawArrowhead1;
        }
        return drawArrowhead2;
    }

    public void drawAlignmentSegment(Graphics g) {
        AlignmentSegment alignSeg = this.viewWin.getAlignSegment();
        if (alignSeg == null) {
            this.drawAlignmentSequence(g);
            return;
        }
        boolean regDir1 = this.viewWin.getRegDir(true);
        this.updateRawElmColor();
        ArrayList segPosList = alignSeg.getAlignSegment();
        double[] regFrom = new double[2];
        double[] regTo = new double[2];
        double regCenter = this.viewWin.getRegCenter(1);
        double regWidth = this.viewWin.getRegWidth(1);
        double regStart = regCenter - regWidth / 2.0;
        double dx = (double)this.winWidth / regWidth;
        int zoomCount = this.viewWin.getZoomCount();
        for (int i = 0; i < segPosList.size(); ++i) {
            SegmentPos segPos = (SegmentPos)segPosList.get(i);
            int x1 = (int)(segPos.getScreenFrom() * (double)this.winWidth);
            int x2 = (int)(segPos.getScreenTo() * (double)this.winWidth);
            int y1 = (int)((double)this.winHeight * this.PadHeightAlignmentRate);
            int y2 = (int)((double)this.winHeight * (1.0 - this.PadHeightAlignmentRate));
            Alignment align = segPos.getAlignment();
            String type2 = align.getType();
            Color color = this.mbgdDataMng.getAlignColor(1, type2, "int", align);
            g.setColor(color);
            if (regDir1) {
                g.drawLine(x1, y1, x2, y1);
                g.drawLine(x1, y2, x2, y2);
                g.setColor(Color.orange);
                g.drawLine(x1, 0, x1, this.winHeight);
                g.drawLine(x2, 0, x2, this.winHeight);
            } else {
                g.drawLine(this.winWidth - x1, y1, this.winWidth - x2, y1);
                g.drawLine(this.winWidth - x1, y2, this.winWidth - x2, y2);
                g.setColor(Color.orange);
                g.drawLine(this.winWidth - x1, 0, this.winWidth - x1, this.winHeight);
                g.drawLine(this.winWidth - x2, 0, this.winWidth - x2, this.winHeight);
            }
            String seq1 = segPos.getAlignSeq1();
            String seq2 = segPos.getAlignSeq2();
            if (!regDir1) {
                DNASequence seq = new DNASequence("rev", seq1);
                seq1 = seq.getReverse().getSeqString().toUpperCase();
                seq = new DNASequence("rev", seq2);
                seq2 = seq.getReverse().getSeqString().toUpperCase();
                StringBuffer sb = new StringBuffer(seq1);
                seq1 = sb.reverse().toString();
                sb = new StringBuffer(seq2);
                seq2 = sb.reverse().toString();
            }
            if (x1 < 0) {
                x1 = 0;
            }
            for (int idx = 0; idx < seq1.length(); ++idx) {
                int yy;
                char c1 = seq1.charAt(idx);
                char c2 = seq2.charAt(idx);
                if (c1 == '-' || c2 == '-') {
                    g.setColor(this.colGap);
                } else if (c1 == c2) {
                    g.setColor(this.colMat);
                } else {
                    g.setColor(this.colMis);
                }
                float ratio = this.seqLenPerPixel(this.viewWin);
                if (ratio > 1.0f) continue;
                if ((double)ratio > 0.25) {
                    c2 = '|';
                    c1 = '|';
                }
                int xx = x1 + (int)((double)idx * dx);
                if (regDir1) {
                    yy = this.fh;
                    this.drawChar(g, xx, yy, (int)dx, c1);
                    yy = this.getWindowHeight() - 4;
                    this.drawChar(g, xx, yy, (int)dx, c2);
                    continue;
                }
                yy = this.fh;
                this.drawChar(g, this.winWidth - xx - (int)dx, yy, (int)dx, c1);
                yy = this.getWindowHeight() - 4;
                this.drawChar(g, this.winWidth - xx - (int)dx, yy, (int)dx, c2);
            }
        }
    }

    public String[] drawRawSequence(Graphics g, int level) {
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regStart1 = this.viewWin.getRegCenter(true) - regWidth1 / 2;
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regStart2 = this.viewWin.getRegCenter(false) - regWidth2 / 2;
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        if (regStart1 <= 0) {
            regStart1 += regMax1;
        }
        if (regStart2 <= 0) {
            regStart2 += regMax2;
        }
        this.updateRawElmColor();
        g.setColor(Color.black);
        String seq1 = this.viewWin.getAlignSequence(true);
        String seq2 = this.viewWin.getAlignSequence(false);
        float dx = (float)this.winWidth / (float)regWidth1;
        for (int i = 0; i < regWidth1; ++i) {
            char c1 = Character.toUpperCase(seq1.charAt(i));
            char c2 = Character.toUpperCase(seq2.charAt(i));
            if (c1 == '-' || c2 == '-') {
                g.setColor(this.colGap);
            } else if (c1 == c2) {
                g.setColor(this.colMat);
            } else {
                g.setColor(this.colMis);
            }
            boolean dd = false;
            int xx = (int)((float)i * dx);
            int yy = this.fh;
            if (level == 1) {
                c1 = c1 == '-' ? (char)'.' : '|';
                c2 = c2 == '-' ? (char)'.' : '|';
            }
            this.drawChar(g, xx, this.fh, (int)dx, c1);
            this.drawChar(g, xx, this.getWindowHeight() - 4, (int)dx, c2);
        }
        String[] alignSeqPair = new String[]{seq1, seq2};
        return alignSeqPair;
    }

    public String[] drawNoSequence(Graphics g) {
        String[] alignSeqPair = new String[]{"", ""};
        return alignSeqPair;
    }

    public String[] drawSequence(Graphics g) {
        int zoomCount = this.viewWin.getZoomCount();
        float ratio = this.seqLenPerPixel(this.viewWin);
        if ((double)ratio > 1.0) {
            return this.drawNoSequence(g);
        }
        if ((double)ratio > 0.25) {
            return this.drawRawSequence(g, 1);
        }
        return this.drawRawSequence(g, 2);
    }

    public void drawSegmentElmZoomLev2(Graphics g, SegmentPos[] segSeqPos) {
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regStart1 = this.viewWin.getRegCenter(true) - regWidth1 / 2;
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regStart2 = this.viewWin.getRegCenter(false) - regWidth2 / 2;
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        if (regStart1 <= 0) {
            regStart1 += regMax1;
        }
        if (regStart2 <= 0) {
            regStart2 += regMax2;
        }
        float dx = (float)this.winWidth / (float)regWidth1;
    }

    public void drawSegmentElmZoomLev1(Graphics g, SegmentPos[] segSeqPos) {
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regStart1 = this.viewWin.getRegCenter(true) - regWidth1 / 2;
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regStart2 = this.viewWin.getRegCenter(false) - regWidth2 / 2;
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        if (regStart1 <= 0) {
            regStart1 += regMax1;
        }
        if (regStart2 <= 0) {
            regStart2 += regMax2;
        }
        float dx = (float)this.winWidth / (float)regWidth1;
    }

    public void drawSegmentElmZoomLev0(Graphics g, SegmentPos[] segSeqPos) {
    }

    public void drawElmSeq(Graphics g, String seq1, String seq2, double dx, int y1, int y2, boolean flagSkipSame) {
        this.updateRawElmColor();
        int loopMax = seq1.length();
        for (int i = 0; i < loopMax; ++i) {
            Color c;
            char c2;
            char c1 = seq1.charAt(i);
            try {
                c2 = seq2.charAt(i);
            }
            catch (IndexOutOfBoundsException e) {
                c2 = '-';
            }
            if (c1 == '-' || c2 == '-') {
                c = this.colGap;
            } else if (c1 == c2) {
                if (flagSkipSame) continue;
                c = this.colMat;
            } else {
                c = this.colMis;
            }
            if (flagSkipSame) continue;
            g.setColor(c);
            this.drawChar(g, (int)((double)i * dx), y1, (int)dx, c1);
            this.drawChar(g, (int)((double)i * dx), y2, (int)dx, c2);
        }
    }

    public void drawElmSeq(Graphics g, String seq1, String seq2, double dx, int y1, int y2) {
        this.drawElmSeq(g, seq1, seq2, dx, y1, y2, false);
    }

    public void drawElmDif(Graphics g, String seq1, String seq2, double dx, int y1, int y2) {
        this.drawElmSeq(g, seq1, seq2, dx, y1, y2, true);
    }

    public void drawSegmentElmZoom(Graphics g) {
        AlignmentSegment alignSeg = this.viewWin.getAlignSegment();
        if (alignSeg == null) {
            this.drawAlignmentSequence(g);
            return;
        }
    }

    public int searchCenterAlignData(ArrayList dispAlignList) {
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regStart1 = this.viewWin.getRegCenter(true) - regWidth1 / 2;
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regStart2 = this.viewWin.getRegCenter(false) - regWidth2 / 2;
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        int idxCenter = -1;
        if (regStart1 <= 0) {
            regStart1 += regMax1;
        }
        if (regStart2 <= 0) {
            regStart2 += regMax2;
        }
        int centerPos = regStart1 + regWidth1 / 2;
        int minDist = 9999999;
        int dist = 0;
        int loopMax = dispAlignList.size();
        for (int i = 0; i < loopMax; ++i) {
            int idx = (Integer)dispAlignList.get(i);
            Alignment align = this.mbgdDataMng.getAlignment(true, idx);
            String type2 = align.getType();
            if (!type2.equals("3")) continue;
            int from1 = align.getFrom1();
            int to1 = align.getTo1();
            dist = to1 < centerPos ? Math.abs(centerPos - ((from1 + to1) / 2 + regMax1)) : Math.abs(centerPos - (from1 + to1) / 2);
            if (dist >= minDist) continue;
            minDist = dist;
            idxCenter = idx;
        }
        return idxCenter;
    }

    public void mouseClicked(MouseEvent e) {
        this.displayClickedAlignment(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void displayClickedAlignment(MouseEvent e) {
        int sp2Reg;
        int y;
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regStart1 = this.viewWin.getRegCenter(true) - regWidth1 / 2;
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regStart2 = this.viewWin.getRegCenter(false) - regWidth2 / 2;
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        if (regStart1 <= 0) {
            regStart1 += regMax1;
        }
        if (regStart2 <= 0) {
            regStart2 += regMax2;
        }
        int winWidth = this.getWindowWidth();
        int winHeight = this.getWindowHeight();
        int x = e.getX();
        int minDistPairIdx = this.getClickedAlignment(x, y = e.getY());
        if (minDistPairIdx < 0) {
            Dbg.println(1, "DBG :: not found clicked align");
            return;
        }
        Alignment align = this.mbgdDataMng.getAlignment(true, minDistPairIdx);
        int from1 = align.getFrom1();
        int to1 = align.getTo1();
        int from2 = align.getFrom2();
        int to2 = align.getTo2();
        byte dir = align.getDir();
        int sp1Reg = (from1 + to1) / 2;
        if (sp1Reg <= 0) {
            sp1Reg += regMax1;
        }
        if ((sp2Reg = (from2 + to2) / 2) <= 0) {
            sp2Reg += regMax2;
        }
        this.viewWin.setRegDir(true, true);
        if (dir == 1) {
            this.viewWin.setRegDir(false, true);
        } else {
            this.viewWin.setRegDir(false, false);
        }
        this.viewWin.viewPos(sp1Reg, sp2Reg);
    }

    protected int getClickedAlignment(int x, int y) {
        double dist;
        int toX;
        int fromX;
        int to2;
        int from2;
        int to1;
        int from1;
        Alignment align;
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regStart1 = this.viewWin.getRegCenter(true) - regWidth1 / 2;
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        boolean regDir1 = this.viewWin.getRegDir(true);
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regStart2 = this.viewWin.getRegCenter(false) - regWidth2 / 2;
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        boolean regDir2 = this.viewWin.getRegDir(false);
        int dispStart = -1;
        int dispEnd = -2;
        if (regStart1 <= 0) {
            regStart1 += regMax1;
        }
        if (regStart2 <= 0) {
            regStart2 += regMax2;
        }
        double minDist = Double.MAX_VALUE;
        int minDistPairIdx = -1;
        int loopMax = this.mbgdDataMng.getAlignmentSize();
        for (int i = 0; i < loopMax; ++i) {
            int X;
            int to;
            int from;
            align = this.mbgdDataMng.getAlignment(true, i);
            if (!align.getFilter()) continue;
            from1 = align.getFrom1();
            to1 = align.getTo1();
            from2 = align.getFrom2();
            to2 = align.getTo2();
            if (regStart1 + regWidth1 >= regMax1 ? (regStart1 + regWidth1) % regMax1 < from1 && to1 < regStart1 : to1 < regStart1 || regStart1 + regWidth1 < from1) continue;
            if (regStart2 + regWidth2 >= regMax2 ? (regStart2 + regWidth2) % regMax2 < from2 && to2 < regStart2 : to2 < regStart2 || regStart2 + regWidth2 < from2) continue;
            if (dispStart < 0) {
                dispStart = i;
            }
            dispEnd = i;
            if (from1 < to1) {
                from = from1;
                to = to1;
            } else {
                from = to1;
                to = from1;
            }
            fromX = this.getWinPosX(from, regStart1, regWidth1, regMax1, this.winWidth);
            toX = this.getWinPosX(to, regStart1, regWidth1, regMax1, this.winWidth);
            int Y = this.winHeight / 3;
            if (regDir1) {
                if (x < fromX) {
                    X = fromX;
                    dist = this.getPointDistance(X, Y, x, y);
                } else if (toX < x) {
                    X = toX;
                    dist = this.getPointDistance(X, Y, x, y);
                } else {
                    dist = this.getLineDistance(fromX, Y, toX, Y, x, y);
                }
            } else if (x < toX) {
                X = this.winWidth - toX;
                dist = this.getPointDistance(X, Y, x, y);
            } else if (fromX < x) {
                X = this.winWidth - fromX;
                dist = this.getPointDistance(X, Y, x, y);
            } else {
                dist = this.getLineDistance(this.winWidth - fromX, Y, this.winWidth - toX, Y, x, y);
            }
            if (dist <= minDist) {
                minDist = dist;
                minDistPairIdx = i;
            }
            if (from2 < to2) {
                from = from2;
                to = to2;
            } else {
                from = to2;
                to = from2;
            }
            fromX = this.getWinPosX(from, regStart2, regWidth2, regMax2, this.winWidth);
            toX = this.getWinPosX(to, regStart2, regWidth2, regMax2, this.winWidth);
            Y = this.winHeight * 2 / 3;
            if (regDir2) {
                if (x < fromX) {
                    X = fromX;
                    dist = this.getPointDistance(X, Y, x, y);
                } else if (toX < x) {
                    X = toX;
                    dist = this.getPointDistance(X, Y, x, y);
                } else {
                    dist = this.getLineDistance(fromX, Y, toX, Y, x, y);
                }
            } else if (x < toX) {
                X = this.winWidth - toX;
                dist = this.getPointDistance(X, Y, x, y);
            } else if (fromX < x) {
                X = this.winWidth - fromX;
                dist = this.getPointDistance(X, Y, x, y);
            } else {
                dist = this.getLineDistance(this.winWidth - fromX, Y, this.winWidth - toX, Y, x, y);
            }
            if (!(dist <= minDist)) continue;
            minDist = dist;
            minDistPairIdx = i;
        }
        int y1 = (int)((double)this.winHeight * this.PadHeightAlignmentRate);
        int y2 = (int)((double)this.winHeight * (1.0 - this.PadHeightAlignmentRate));
        for (int i = dispStart; i <= dispEnd; ++i) {
            align = this.mbgdDataMng.getAlignment(true, i);
            from1 = align.getFrom1();
            to1 = align.getTo1();
            from2 = align.getFrom2();
            to2 = align.getTo2();
            if (to1 < regStart1 || regStart1 + regWidth1 < from1 || to2 < regStart2 || regStart2 + regWidth2 < from2) continue;
            fromX = this.getWinPosX(from1, regStart1, regWidth1, regMax1, this.winWidth);
            toX = this.getWinPosX(to1, regStart1, regWidth1, regMax1, this.winWidth);
            int x1 = (fromX + toX) / 2;
            fromX = this.getWinPosX(from2, regStart2, regWidth2, regMax2, this.winWidth);
            toX = this.getWinPosX(to2, regStart2, regWidth2, regMax2, this.winWidth);
            int x2 = (fromX + toX) / 2;
            dist = regDir1 ? (regDir2 ? this.getLineDistance(x1, y1, x2, y2, x, y) : this.getLineDistance(x1, y1, this.winWidth - x2, y2, x, y)) : (regDir2 ? this.getLineDistance(this.winWidth - x1, y1, x2, y2, x, y) : this.getLineDistance(this.winWidth - x1, y1, this.winWidth - x2, y2, x, y));
            if (!(dist <= minDist)) continue;
            minDist = dist;
            minDistPairIdx = i;
        }
        return minDistPairIdx;
    }

    protected double getPointDistance(int x0, int y0, int x, int y) {
        return this.getPointDistance((double)x0, (double)y0, x, y);
    }

    protected double getPointDistance(double x0, double y0, int x, int y) {
        double distX = x0 - (double)x;
        double distY = y0 - (double)y;
        double dist = Math.sqrt(distX * distX + distY * distY);
        return dist;
    }

    protected double getLineDistance(int x1, int y1, int x2, int y2, int x, int y) {
        if ((double)Math.abs(x2 - x1) < 2.0) {
            double dist = Math.abs(x - (x1 + x2) / 2);
            return dist;
        }
        if ((double)Math.abs(y2 - y1) < 2.0) {
            double dist = Math.abs(y - (y2 + y1) / 2);
            return dist;
        }
        double a = ((double)y2 - (double)y1) / ((double)x2 - (double)x1);
        double b = (double)y1 - a * (double)x1;
        double c = (double)y + (double)x / a;
        double x0 = (c - b) / (a + 1.0 / a);
        double y0 = a * x0 + b;
        double dist = this.getPointDistance(x0, y0, x, y);
        return dist;
    }

    protected int revDispPos(int oldPos, int width, int winWidth) {
        int newPos = winWidth - oldPos - width;
        return newPos;
    }

    public void updBgColor() {
        String colBg;
        String colFg;
        if (this.mbgdDataMng.getUseColor() == 0) {
            colFg = this.mbgdDataMng.getProperty("cgat.color.bg.dark");
            colBg = this.mbgdDataMng.getProperty("cgat.color.bg.light");
        } else {
            colFg = this.mbgdDataMng.getProperty("cgat.color.bg.light");
            colBg = this.mbgdDataMng.getProperty("cgat.color.bg.dark");
        }
        if (colFg == null) {
            colFg = "ffffff";
        }
        if (colBg == null) {
            colBg = "0";
        }
        int rgbFg = Integer.parseInt(colFg, 16);
        int rgbBg = Integer.parseInt(colBg, 16);
        this.setFgColor(new Color(rgbFg));
        this.setBgColor(new Color(rgbBg));
    }

    public void updateRawElmColor() {
        String keyGap;
        String keyMis;
        String keyMat;
        if (this.mbgdDataMng.getUseColor() == 0) {
            keyMat = "cgat.alignment.sequence.color.match.light";
            keyMis = "cgat.alignment.sequence.color.mismatch.light";
            keyGap = "cgat.alignment.sequence.color.gap.light";
        } else {
            keyMat = "cgat.alignment.sequence.color.match.dark";
            keyMis = "cgat.alignment.sequence.color.mismatch.dark";
            keyGap = "cgat.alignment.sequence.color.gap.dark";
        }
        int rgbMat = this.mbgdDataMng.getPropertyInt(keyMat, 16);
        int rgbMis = this.mbgdDataMng.getPropertyInt(keyMis, 16);
        int rgbGap = this.mbgdDataMng.getPropertyInt(keyGap, 16);
        this.colMat = new Color(rgbMat);
        this.colMis = new Color(rgbMis);
        this.colGap = new Color(rgbGap);
    }

    public int getWinPosX(int x0, int regSta, int regWid, int regMax, int winWid) {
        int x = regMax < regSta + regWid && x0 % regMax < regSta ? (int)((float)(regMax - regSta + x0) / (float)regWid * (float)winWid) : (int)((float)(x0 - regSta) / (float)regWid * (float)winWid);
        return x;
    }
}

