/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.Alignment;
import cgat.Dbg;
import cgat.DispAlignmentSequenceCommand;
import cgat.DispReAlignmentSequenceCommand;
import cgat.DrawAlignment;
import cgat.ExecReAlignmentSequenceCommand;
import cgat.MbgdDataMng;
import cgat.MessageWindow;
import cgat.ViewWindow;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class DrawAlignmentCgat
extends DrawAlignment {
    protected JPopupMenu popup;

    public DrawAlignmentCgat(MbgdDataMng dataMng, ViewWindow vWin) {
        super(dataMng, vWin);
    }

    public DrawAlignmentCgat(MbgdDataMng dataMng, ViewWindow vWin, int w, int h) {
        super(dataMng, vWin, w, h);
    }

    public void mouseClicked(MouseEvent e) {
        int mod = e.getModifiers();
        if ((mod & 0x10) != 0) {
            this.displayClickedAlignment(e);
        }
        if ((mod & 8) != 0) {
            // empty if block
        }
        if ((mod & 4) != 0) {
            this.popUpMenu(e);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void displayClickedAlignment(MouseEvent e) {
        int sp2Reg;
        int y;
        int regWidth1 = this.viewWin.getRegWidth(true);
        int regStart1 = this.viewWin.getRegCenter(true) - regWidth1 / 2;
        int regMax1 = this.mbgdDataMng.getGenomeLength(true);
        int regWidth2 = this.viewWin.getRegWidth(false);
        int regStart2 = this.viewWin.getRegCenter(false) - regWidth2 / 2;
        int regMax2 = this.mbgdDataMng.getGenomeLength(false);
        if (regStart1 <= 0) {
            regStart1 += regMax1;
        }
        if (regStart2 <= 0) {
            regStart2 += regMax2;
        }
        int winWidth = this.getWindowWidth();
        int winHeight = this.getWindowHeight();
        int x = e.getX();
        int minDistPairIdx = this.getClickedAlignment(x, y = e.getY());
        if (minDistPairIdx < 0) {
            Dbg.println(1, "DBG :: not found clicked align");
            return;
        }
        Dbg.println(1, "DBG :: Clicked Alignment index :: " + minDistPairIdx);
        Alignment align = this.mbgdDataMng.getAlignment(true, minDistPairIdx);
        int from1 = align.getFrom1();
        int to1 = align.getTo1();
        int from2 = align.getFrom2();
        int to2 = align.getTo2();
        byte dir = align.getDir();
        int sp1Reg = (from1 + to1) / 2;
        if (sp1Reg <= 0) {
            sp1Reg += regMax1;
        }
        if ((sp2Reg = (from2 + to2) / 2) <= 0) {
            sp2Reg += regMax2;
        }
        this.viewWin.setRegDir(true, true);
        if (dir == 1) {
            this.viewWin.setRegDir(false, true);
        } else {
            this.viewWin.setRegDir(false, false);
        }
        this.viewWin.viewPos(sp1Reg, sp2Reg, align);
    }

    public void popUpMenu(MouseEvent e) {
        int y;
        int x;
        int minDistPairIdx;
        JMenuItem jMenuItem;
        int maxReAlignLength;
        boolean isPopupMenu = false;
        this.popup = new JPopupMenu();
        float ratio = this.seqLenPerPixel(this.viewWin);
        int regWidth1 = this.viewWin.getRegWidth(true);
        if (regWidth1 <= (maxReAlignLength = Integer.parseInt(this.mbgdDataMng.getProperty("cgat.alignment.max.realignment")))) {
            ActionListener cmd3;
            jMenuItem = new JMenuItem("View Re-Alignment");
            if (ratio <= 1.0f) {
                cmd3 = new DispReAlignmentSequenceCommand(this.mbgdDataMng, this.viewWin);
                jMenuItem.addActionListener(cmd3);
            } else {
                cmd3 = new ExecReAlignmentSequenceCommand(this.mbgdDataMng, this.viewWin);
                jMenuItem.addActionListener(cmd3);
            }
            this.popup.add(jMenuItem);
            isPopupMenu = true;
        }
        if (0 <= (minDistPairIdx = this.getClickedAlignment(x = e.getX(), y = e.getY()))) {
            isPopupMenu = true;
            Alignment align = this.mbgdDataMng.getAlignment(true, minDistPairIdx);
            String sp1Name = this.mbgdDataMng.getSpecName(true);
            String sp2Name = this.mbgdDataMng.getSpecName(false);
            int from1 = align.getFrom1();
            int to1 = align.getTo1();
            int from2 = align.getFrom2();
            int to2 = align.getTo2();
            byte dir = align.getDir();
            jMenuItem = new JMenuItem("View Alignment");
            DispAlignmentSequenceCommand cmd1 = new DispAlignmentSequenceCommand(this.mbgdDataMng);
            cmd1.setRegion1(sp1Name, from1, to1);
            cmd1.setRegion2(sp2Name, from2, to2);
            cmd1.setDirection(dir);
            jMenuItem.addActionListener(cmd1);
            this.popup.add(jMenuItem);
            jMenuItem = new JMenuItem("Ident = " + align.getIdent());
            this.popup.add(jMenuItem);
            jMenuItem = new JMenuItem("Color Legend");
            MessageWindow cmd4 = new MessageWindow();
            if (this.mbgdDataMng.getAlignColorMode() == 0) {
                String url = this.mbgdDataMng.getBasePath() + "cgi-bin/helpColorTab.cgi?type=align";
                cmd4.setContents(url);
            } else {
                String html = this.mbgdDataMng.getColorLegend();
                cmd4.setContents("text/html", html);
            }
            jMenuItem.addActionListener(cmd4);
            this.popup.add(jMenuItem);
        }
        if (isPopupMenu) {
            this.popup.setVisible(true);
            this.popup.show(e.getComponent(), x, y);
        }
    }
}

