/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.AlignmentSegment;
import cgat.BaseLabel;
import cgat.DrawAlignmentSet;
import cgat.DrawRegion;
import cgat.DrawRegionSet;
import cgat.MbgdDataMng;
import cgat.SelectSpecPairCommand;
import cgat.ViewWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DrawingSet
extends JPanel
implements Observer,
Printable {
    protected MbgdDataMng mbgdDataMng;
    protected ViewWindow viewWin;
    static int drawingMode = 0;
    public JPanel basePanel;
    protected JPanel sp1NamePos;
    protected JLabel sp1DpsRegFrom;
    protected JLabel sp1DpsRegTo;
    protected BaseLabel spec1Name;
    protected DrawRegionSet[] sp1SegArea;
    protected DrawRegionSet sp1GeneArea;
    protected DrawAlignmentSet alignmentArea;
    protected DrawRegionSet sp2GeneArea;
    protected DrawRegionSet[] sp2SegArea;
    protected BaseLabel spec2Name;
    protected JPanel sp2NamePos;
    protected JLabel sp2DpsRegFrom;
    protected JLabel sp2DpsRegTo;

    public DrawingSet(MbgdDataMng dataMng, ViewWindow vWin) {
        int hAlign = dataMng.getPropertyInt("cgat.panel.alignment.alignment.height");
        int hGene = dataMng.getPropertyInt("cgat.panel.alignment.gene.height");
        int hSeg = dataMng.getPropertyInt("cgat.panel.alignment.segment.height");
        int w = DrawRegion.WIDTH;
        this._init(dataMng, vWin, w, hAlign, hGene, hSeg);
    }

    public DrawingSet(MbgdDataMng dataMng, ViewWindow vWin, int w, int hAlign, int hGene, int hSeg) {
        this._init(dataMng, vWin, w, hAlign, hGene, hSeg);
    }

    public void _init(MbgdDataMng dataMng, ViewWindow vWin, int w, int hAlign, int hGene, int hSeg) {
        this.mbgdDataMng = dataMng;
        this.viewWin = vWin;
        int maxSegNum = 5;
        this.basePanel = new JPanel();
        this.alignmentArea = new DrawAlignmentSet(dataMng, vWin, w, hAlign);
        this.sp1NamePos = new JPanel(new GridLayout(2, 1));
        this.spec1Name = new BaseLabel("=== sequence-1 ===");
        this.sp1NamePos.add(this.spec1Name);
        GridBagLayout gridbag = new GridBagLayout();
        JPanel panelSp1 = new JPanel(gridbag);
        this.sp1NamePos.add(panelSp1);
        this.sp1DpsRegFrom = new JLabel("seq1 from");
        this.sp1DpsRegTo = new JLabel("seq1 to");
        this.sp1DpsRegTo.setHorizontalAlignment(4);
        GridBagConstraints gbcf = new GridBagConstraints();
        gbcf.gridx = 1;
        gbcf.gridy = 1;
        gbcf.anchor = 17;
        gbcf.insets = new Insets(0, 100, 0, 0);
        panelSp1.add((Component)this.sp1DpsRegFrom, gbcf);
        GridBagConstraints gbct = new GridBagConstraints();
        gbct.gridx = 2;
        gbct.gridy = 1;
        gbct.weightx = 1.0;
        gbct.anchor = 13;
        panelSp1.add((Component)this.sp1DpsRegTo, gbct);
        this.spec1Name.setVerticalAlignment(3);
        this.sp1DpsRegFrom.setVerticalAlignment(3);
        this.sp1DpsRegTo.setVerticalAlignment(3);
        this.sp1GeneArea = new DrawRegionSet(2, dataMng, vWin, w, hGene);
        this.sp1GeneArea.setId("sp1GeneArea");
        this.sp1SegArea = new DrawRegionSet[maxSegNum];
        for (int i = 0; i < maxSegNum; ++i) {
            this.sp1SegArea[i] = new DrawRegionSet(4 + i, dataMng, vWin, w, hSeg);
            this.sp1SegArea[i].setId("sp1SegArea" + String.valueOf(i + 1));
            this.sp1SegArea[i].setDataLabel("Segment" + String.valueOf(i + 1));
            this.sp1SegArea[i].setTextVisible(false);
        }
        this.sp2NamePos = new JPanel(new GridLayout(2, 1));
        JPanel panelSp2 = new JPanel(new GridBagLayout());
        this.sp2NamePos.add(panelSp2);
        this.sp2DpsRegFrom = new JLabel("seq2 from");
        this.sp2DpsRegTo = new JLabel("seq2 to");
        this.sp2DpsRegTo.setHorizontalAlignment(4);
        panelSp2.add((Component)this.sp2DpsRegFrom, gbcf);
        panelSp2.add((Component)this.sp2DpsRegTo, gbct);
        this.spec2Name = new BaseLabel("=== sequence-2 ===");
        this.sp2NamePos.add(this.spec2Name);
        this.sp2GeneArea = new DrawRegionSet(12, dataMng, vWin, w, hGene);
        this.sp2GeneArea.setId("sp2GeneArea");
        this.sp2SegArea = new DrawRegionSet[maxSegNum];
        for (int i = 0; i < maxSegNum; ++i) {
            this.sp2SegArea[i] = new DrawRegionSet(14 + i, dataMng, vWin, w, hSeg);
            this.sp2SegArea[i].setId("sp2SegArea" + String.valueOf(i + 1));
            this.sp2SegArea[i].setDataLabel("Segment" + String.valueOf(i + 1));
            this.sp2SegArea[i].setTextVisible(false);
        }
    }

    public int getElementSize() {
        return 5 + this.mbgdDataMng.getMaxSegNum();
    }

    public DrawAlignmentSet getAlignmentArea() {
        return this.alignmentArea;
    }

    public JPanel getSp1NamePosArea() {
        return this.sp1NamePos;
    }

    public JLabel getSp1NameArea() {
        return this.spec1Name;
    }

    public JPanel getSp2NamePosArea() {
        return this.sp2NamePos;
    }

    public JLabel getSp2NameArea() {
        return this.spec2Name;
    }

    public DrawRegionSet getSp1GeneArea() {
        return this.sp1GeneArea;
    }

    public DrawRegionSet getSp2GeneArea() {
        return this.sp2GeneArea;
    }

    public DrawRegionSet getSp1SegArea(int idx) {
        return this.sp1SegArea[idx];
    }

    public DrawRegionSet getSp2SegArea(int idx) {
        return this.sp2SegArea[idx];
    }

    public void exchangeDispSpec() {
        this.viewWin.exchangeBaseSpec();
    }

    public JPanel getDrawingPanel() {
        return this.basePanel;
    }

    public void setDrawings(boolean[] isDispSegs) {
        int i;
        int maxSegNum = this.mbgdDataMng.getMaxSegNum();
        int numItem = 5;
        for (int i2 = 0; i2 < maxSegNum; ++i2) {
            if (!isDispSegs[i2]) continue;
            numItem += 2;
        }
        GridBagLayout gridbag = new GridBagLayout();
        this.basePanel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        this.basePanel.removeAll();
        int rown = 0;
        c.gridx = 0;
        c.gridy = rown++;
        c.gridheight = 1;
        c.gridwidth = 0;
        this.basePanel.add((Component)this.sp1NamePos, c);
        for (i = maxSegNum - 1; 0 <= i; --i) {
            if (!isDispSegs[i]) continue;
            this.addRegion(rown++, this.sp1SegArea[i], c);
        }
        this.addRegion(rown++, this.sp1GeneArea, c);
        this.addAlignment(rown++, this.alignmentArea, c);
        this.addRegion(rown++, this.sp2GeneArea, c);
        for (i = 0; i < maxSegNum; ++i) {
            if (!isDispSegs[i]) continue;
            this.addRegion(rown++, this.sp2SegArea[i], c);
        }
        c.gridx = 0;
        c.gridy = rown++;
        c.gridheight = 1;
        c.gridwidth = 0;
        this.basePanel.add((Component)this.sp2NamePos, c);
        this.basePanel.validate();
    }

    public void setDrawings(boolean isDispSeg) {
        int maxSegNum = this.mbgdDataMng.getMaxSegNum();
        boolean[] isDispSegList = new boolean[maxSegNum];
        for (int i = 0; i < maxSegNum; ++i) {
            isDispSegList[i] = isDispSeg;
        }
        this.setDrawings(isDispSegList);
    }

    protected void addRegion(int rown, DrawRegionSet s, GridBagConstraints c) {
        c.insets = new Insets(4, 4, 4, 4);
        c.gridy = rown;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.basePanel.add((Component)s.header, c);
        c.gridy = rown;
        c.weightx = 1.0;
        c.gridx = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        this.basePanel.add((Component)s.drawRegion, c);
    }

    protected void addAlignment(int rown, DrawAlignmentSet s, GridBagConstraints c) {
        c.insets = new Insets(4, 4, 4, 4);
        c.gridx = 0;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.basePanel.add((Component)s.header, c);
        c.gridy = rown;
        c.weightx = 1.0;
        c.gridx = -1;
        c.gridheight = 1;
        c.gridwidth = -1;
        this.basePanel.add((Component)s.drawAlignment, c);
    }

    public void setWindowHeight(int hAlign, int hGene, int hSeg) {
        this.alignmentArea.setWindowHeight(hAlign);
        this.sp1GeneArea.setWindowHeight(hGene);
        this.sp2GeneArea.setWindowHeight(hGene);
        int maxSegNum = this.mbgdDataMng.getMaxSegNum();
        for (int i = maxSegNum - 1; 0 <= i; --i) {
            this.sp1SegArea[i].setWindowHeight(hSeg);
            this.sp2SegArea[i].setWindowHeight(hSeg);
        }
    }

    public void update(Observable o, Object arg) {
        if (o instanceof ViewWindow) {
            this.update((ViewWindow)o, arg);
        } else if (o instanceof MbgdDataMng) {
            this.update((MbgdDataMng)o, arg);
        } else if (o instanceof AlignmentSegment) {
            this.update((AlignmentSegment)o, arg);
        } else if (o instanceof SelectSpecPairCommand) {
            this.update((SelectSpecPairCommand)o, arg);
        }
    }

    public void update(ViewWindow vWin, Object arg) {
        int i;
        int drawMode = vWin.getDrawMode();
        if (drawMode == 0) {
            this.alignmentArea.setDirButtonEnabled(true);
        } else if (drawMode == 1) {
            this.alignmentArea.setDirButtonEnabled(false);
        }
        String sp1Name = this.mbgdDataMng.getSpecFullName(true);
        String sp2Name = this.mbgdDataMng.getSpecFullName(false);
        this.spec1Name.setText(sp1Name);
        this.spec2Name.setText(sp2Name);
        int maxSegNum = this.mbgdDataMng.getMaxSegNum();
        for (int i2 = 0; i2 < maxSegNum; ++i2) {
            String segName = this.mbgdDataMng.getSegmentName(i2);
            segName = segName.replaceAll("\\(Server\\)", "");
            this.sp1SegArea[i2].setDataLabel(segName);
            this.sp2SegArea[i2].setDataLabel(segName);
        }
        int zoomCount = vWin.getZoomCount();
        int center1 = vWin.getRegCenter(true);
        int width1 = vWin.getRegWidth(true);
        int start1 = center1 - width1 / 2;
        int max1 = this.mbgdDataMng.getGenomeLength(true);
        boolean dir1 = vWin.getRegDir(true);
        int from1 = center1 - width1 / 2;
        int to1 = center1 + width1 / 2;
        if (from1 < 0) {
            from1 += max1;
        }
        int center2 = vWin.getRegCenter(false);
        int width2 = vWin.getRegWidth(false);
        int start2 = center2 - width1 / 2;
        int max2 = this.mbgdDataMng.getGenomeLength(false);
        boolean dir2 = vWin.getRegDir(false);
        int from2 = center2 - width2 / 2;
        int to2 = center2 + width2 / 2;
        if (from2 < 0) {
            from2 += max2;
        }
        this.alignmentArea.setRegDir();
        this.sp1GeneArea.setRegText(center1);
        this.sp2GeneArea.setRegText(center2);
        if (dir1) {
            this.sp1DpsRegFrom.setText(String.valueOf(from1 + 1));
            this.sp1DpsRegTo.setText(String.valueOf(to1));
        } else {
            this.sp1DpsRegFrom.setText(String.valueOf(to1));
            this.sp1DpsRegTo.setText(String.valueOf(from1 + 1));
        }
        if (this.viewWin.getDrawMode() != 1) {
            if (dir2) {
                this.sp2DpsRegFrom.setText(String.valueOf(from2 + 1));
                this.sp2DpsRegTo.setText(String.valueOf(to2));
            } else {
                this.sp2DpsRegFrom.setText(String.valueOf(to2));
                this.sp2DpsRegTo.setText(String.valueOf(from2 + 1));
            }
        } else {
            this.sp2DpsRegFrom.setText("");
            this.sp2DpsRegTo.setText("");
        }
        this.spec1Name.repaint();
        this.spec2Name.repaint();
        if (this.viewWin.getDrawMode() == 1) {
            this.viewWin.makeAlignmentSegmentMode();
        }
        for (i = 0; i < maxSegNum; ++i) {
            this.sp1SegArea[i].repaint();
        }
        this.sp1GeneArea.repaint();
        this.alignmentArea.header.repaint();
        this.alignmentArea.drawAlignment.repaint();
        this.sp2GeneArea.repaint();
        for (i = 0; i < maxSegNum; ++i) {
            this.sp2SegArea[i].repaint();
        }
    }

    public void update(MbgdDataMng dataMng, Object arg) {
        int i;
        int maxSegNum = this.mbgdDataMng.getMaxSegNum();
        for (i = 0; i < maxSegNum; ++i) {
            String segName = dataMng.getSegmentName(i);
            this.sp1SegArea[i].setDataLabel(segName);
            this.sp2SegArea[i].setDataLabel(segName);
        }
        this.alignmentArea.setFilter(this.mbgdDataMng.isFilterAlignment());
        this.sp1GeneArea.setFilter(this.mbgdDataMng.isFilterGene());
        this.sp2GeneArea.setFilter(this.mbgdDataMng.isFilterGene());
        for (i = 0; i < maxSegNum; ++i) {
            this.sp1SegArea[i].setFilter(this.mbgdDataMng.isFilterSegment(i));
            this.sp2SegArea[i].setFilter(this.mbgdDataMng.isFilterSegment(i));
        }
    }

    public void update(AlignmentSegment alignSegment, Object arg) {
    }

    public void update(SelectSpecPairCommand selSpPairCmd, Object arg) {
        int maxSegNum = this.mbgdDataMng.getMaxSegNum();
        boolean[] isDispSegs = new boolean[maxSegNum];
        for (int i = 0; i < maxSegNum; ++i) {
            isDispSegs[i] = selSpPairCmd.isDispSegs(i);
        }
        this.setDrawings(isDispSegs);
    }

    public int print(Graphics g, PageFormat fmt, int pageIdx) {
        if (pageIdx > 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(fmt.getImageableX(), fmt.getImageableY());
        double pageWidth = fmt.getImageableWidth();
        double pageHeight = fmt.getImageableHeight();
        Dimension size = this.basePanel.getSize();
        double scale = 1.0;
        if ((double)size.width > pageWidth) {
            scale = pageWidth / (double)size.width;
        }
        if (pageHeight / (double)size.height < scale) {
            scale = pageHeight / (double)size.height;
        }
        g2.scale(scale, scale);
        g2.translate(((pageWidth /= scale) - (double)size.width) / 2.0, ((pageHeight /= scale) - (double)size.height) / 2.0);
        this.basePanel.printAll(g2);
        return 0;
    }
}

