/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.AlignmentViewerFrame;
import cgat.Dbg;
import cgat.DynamicSearchBaseDialog;
import cgat.MbgdDataMng;
import cgat.SearchOrfList;
import cgat.UrlFile;
import cgat.ViewWindow;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class DynamicSearchCommand
implements ActionListener {
    private Frame frame;
    private MbgdDataMng dataMng;
    private ViewWindow viewWin;

    public DynamicSearchCommand(Frame f, MbgdDataMng dmng, ViewWindow vWin) {
        this.frame = f;
        this.dataMng = dmng;
        this.viewWin = vWin;
    }

    public void actionPerformed(ActionEvent e) {
        String url = this.dataMng.getBasePath();
        DynamicSearchBaseDialog baseWin = new DynamicSearchBaseDialog(this.frame, url, "/dynSearch/getGuiInfo.cgi?type=top");
        baseWin.setSize(400, 300);
        baseWin.setVisible(true);
        String dynSrchType = baseWin.getSearchType();
        String cgiPath = baseWin.getCgiPath();
        if (cgiPath == null) {
            return;
        }
        DynamicSearchBaseDialog win = new DynamicSearchBaseDialog(this.frame, url, cgiPath);
        win.setSize(400, 300);
        win.setVisible(true);
        cgiPath = win.getCgiPath();
        if (cgiPath == null) {
            return;
        }
        SearchOrfList srchResWin = new SearchOrfList("Search results");
        int maxSegNum = this.dataMng.getMaxSegNum();
        int segNum = this.dataMng.getSegNum();
        int segIdx = segNum - 1;
        if (segNum == 0) {
            segIdx = 0;
            this.dataMng.setSegNum(++segNum);
            this.dataMng.setSegmentName(segIdx, dynSrchType);
        } else if (segNum < maxSegNum) {
            segIdx = segNum++;
            this.dataMng.setSegNum(segNum);
            this.dataMng.setSegmentName(segIdx, dynSrchType);
        } else if (segNum == maxSegNum) {
            segIdx = maxSegNum - 1;
            this.dataMng.setSegmentName(segIdx, dynSrchType);
        }
        String sp1 = this.dataMng.getSpecName(true);
        this.dataMng.loadSegment0(0, segIdx, null, cgiPath, url + cgiPath);
        Dbg.println(1, "DynamicSearch :: " + url + cgiPath + " :: " + sp1);
        String sp2 = this.dataMng.getSpecName(false);
        this.dataMng.loadSegment0(1, segIdx, null, cgiPath, url + cgiPath);
        Dbg.println(1, "DynamicSearch :: " + url + cgiPath + " :: " + sp2);
        ((AlignmentViewerFrame)this.frame).setFrameSize(segNum);
        this.viewWin.setDrawMode(this.viewWin.getDrawMode());
    }

    public ArrayList execDynSearch(String u) {
        ArrayList<Object[]> ar = new ArrayList<Object[]>();
        try {
            String buf;
            UrlFile uFile = new UrlFile(u);
            String[] title = null;
            while ((buf = uFile.readLine()) != null) {
                int i;
                int n;
                StringTokenizer st;
                if ((buf = buf.trim()).equals("")) continue;
                if (buf.startsWith("#")) {
                    if (title != null) continue;
                    st = new StringTokenizer(buf.substring(1), "\t");
                    n = st.countTokens();
                    title = new String[n];
                    for (i = 0; i < n; ++i) {
                        title[i] = st.nextToken();
                    }
                    ar.add(0, title);
                    continue;
                }
                st = new StringTokenizer(buf, "\t");
                n = st.countTokens();
                Object[] dat = new Object[n];
                for (i = 0; i < 1; ++i) {
                    dat[i] = st.nextToken();
                }
                while (i < 3) {
                    dat[i] = new Integer(st.nextToken());
                    ++i;
                }
                while (i < 4) {
                    dat[i] = st.nextToken();
                    ++i;
                }
                while (i < 5) {
                    String wk = st.nextToken();
                    int c = 0;
                    if (wk.startsWith("#")) {
                        c = Integer.parseInt(wk.substring(1), 16);
                    }
                    dat[i] = new Color(c);
                    ++i;
                }
                while (i < n) {
                    dat[i] = st.nextToken();
                    ++i;
                }
                ar.add(dat);
            }
        }
        catch (Exception e) {
            Dbg.println(1, "ERROR :: " + e);
        }
        return ar;
    }
}

