/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.seq.DNASequence;
import cgat.seq.FastaFile;
import cgat.seq.SubSequence;
import java.io.IOException;

public class GenomeSequence {
    private String dataFilename;
    private boolean flagDataLoad = false;
    DNASequence _seq;

    public GenomeSequence(String name, String seq) {
        this._seq = new DNASequence(name, seq, true);
        this.setDataFilename("");
    }

    public void setDataFilename(String nam) {
        this.dataFilename = nam;
    }

    public void setFlagDataLoad(boolean f) {
        this.flagDataLoad = f;
    }

    public boolean getFlagDataLoad() {
        return this.flagDataLoad;
    }

    public boolean load(String filename) {
        String fname = "";
        if (this.dataFilename.equals(filename)) {
            this.setFlagDataLoad(false);
            return true;
        }
        this.setDataFilename(filename);
        FastaFile ff = null;
        try {
            ff = new FastaFile(filename);
            ff.asDNA();
            ff.setTitSepChar("\t\n");
            this._seq.setSequence(ff.readSeq());
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public int getLength() {
        return this._seq.length();
    }

    public String getName() {
        return this._seq.getName();
    }

    public String getSequence() {
        return this._seq.getSeqString();
    }

    public String getSequence(int from, int to) {
        SubSequence sub = new SubSequence(this._seq, from + 1, to + 1);
        return sub.getSeqString();
    }

    public static String getReverseComplement(String oldSeq) {
        DNASequence seq = new DNASequence("rev", oldSeq);
        String retseq = seq.getReverse().getSeqString();
        return retseq.toLowerCase();
    }
}

