/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.AlignSeq;
import cgat.Alignment;
import cgat.AlignmentFilter;
import cgat.AlignmentList;
import cgat.AlignmentListFilter;
import cgat.BaseFile;
import cgat.ColorAssign;
import cgat.ColorTab;
import cgat.DataLoader;
import cgat.Dbg;
import cgat.GeneAttr;
import cgat.GenomeSequence;
import cgat.MarkEnt;
import cgat.MarkEntList;
import cgat.MbgdData;
import cgat.RGB;
import cgat.RegionInfo;
import cgat.RegionInfoList;
import cgat.SegmentFilter;
import cgat.UrlFile;
import cgat.ViewWindow;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import javax.swing.JFrame;

public class MbgdDataMng
extends Observable
implements ActionListener,
Observer {
    protected String CgatHome = "";
    protected Properties cgatProperties = new Properties();
    protected int use_color = 1;
    public static final int MAX_SEGS = 5;
    public static int NUM_SEGS = 3;
    public static final int SIDE0 = 0;
    public static final int SIDE1 = 1;
    public static final boolean BASE_SPEC = true;
    public static final int BASE_ALIGN = 1;
    public static final int BASE_GENE = 2;
    public static final int BASE_GENEATTR = 3;
    public static final int BASE_SEG1 = 4;
    public static final int BASE_SEG2 = 5;
    public static final int BASE_SEG3 = 6;
    public static final int BASE_SEG4 = 7;
    public static final int BASE_SEG5 = 8;
    public static final boolean OPPO_SPEC = false;
    public static final int OPPO_ALIGN = 11;
    public static final int OPPO_GENE = 12;
    public static final int OPPO_GENEATTR = 13;
    public static final int OPPO_SEG1 = 14;
    public static final int OPPO_SEG2 = 15;
    public static final int OPPO_SEG3 = 16;
    public static final int OPPO_SEG4 = 17;
    public static final int OPPO_SEG5 = 18;
    public static final String OPT_DEBUG = "cgat.debug";
    public static final String OPT_DIR_HOME = "cgat.dir.home";
    public static final String OPT_URL_HOME = "cgat.url.home";
    public static final int MAX_URL_HOME = 10;
    public static final String OPT_URL_PROXY = "cgat.url.proxy";
    public static final String OPT_CMD_BROWSER_WIN = "cgat.cmd.browser.win";
    public static final String OPT_CMD_BROWSER_MAC = "cgat.cmd.browser.mac";
    public static final String OPT_CMD_BROWSER_UNIX = "cgat.cmd.browser.unix";
    public static final String OPT_BG_DARK = "cgat.color.bg.dark";
    public static final String OPT_BG_LIGHT = "cgat.color.bg.light";
    public static final String OPT_DP_FRAME_DARK = "cgat.color.dotplot.frame.dark";
    public static final String OPT_DP_FRAME_LIGHT = "cgat.color.dotplot.frame.light";
    public static final String OPT_AL_SEQ_MAT_DARK = "cgat.alignment.sequence.color.match.dark";
    public static final String OPT_AL_SEQ_MIS_DARK = "cgat.alignment.sequence.color.mismatch.dark";
    public static final String OPT_AL_SEQ_GAP_DARK = "cgat.alignment.sequence.color.gap.dark";
    public static final String OPT_AL_SEQ_MAT_LIGHT = "cgat.alignment.sequence.color.match.light";
    public static final String OPT_AL_SEQ_MIS_LIGHT = "cgat.alignment.sequence.color.mismatch.light";
    public static final String OPT_AL_SEQ_GAP_LIGHT = "cgat.alignment.sequence.color.gap.light";
    public static final String OPT_AL_ID_H_DARK = "cgat.alignment.identity.color.high.dark";
    public static final String OPT_AL_ID_M_DARK = "cgat.alignment.identity.color.middle.dark";
    public static final String OPT_AL_ID_L_DARK = "cgat.alignment.identity.color.low.dark";
    public static final String OPT_AL_ID_H_LIGHT = "cgat.alignment.identity.color.high.light";
    public static final String OPT_AL_ID_M_LIGHT = "cgat.alignment.identity.color.middle.light";
    public static final String OPT_AL_ID_L_LIGHT = "cgat.alignment.identity.color.low.light";
    public static final String OPT_AL_ID_H_PERCENT = "cgat.alignment.identity.high.percent";
    public static final String OPT_AL_ID_M_PERCENT = "cgat.alignment.identity.middle.percent";
    public static final String OPT_AL_ID_L_PERCENT = "cgat.alignment.identity.low.percent";
    public static final String OPT_GENE_ATTR_H_DARK = "cgat.gene.attr.color.high.dark";
    public static final String OPT_GENE_ATTR_L_DARK = "cgat.gene.attr.color.low.dark";
    public static final String OPT_GENE_ATTR_H_LIGHT = "cgat.gene.attr.color.high.light";
    public static final String OPT_GENE_ATTR_L_LIGHT = "cgat.gene.attr.color.low.light";
    public static final String OPT_TT_LEFT = "cgat.tooltip.left";
    public static final String OPT_TT_RIGHT = "cgat.tooltip.right";
    public static final String OPT_TT_REG_UP = "cgat.tooltip.region.up";
    public static final String OPT_TT_REG_DOWN = "cgat.tooltip.region.down";
    public static final String OPT_TT_DOTPLOT = "cgat.tooltip.dotplot";
    public static final String OPT_TT_DP_UP = "cgat.tooltip.dotplot.up";
    public static final String OPT_TT_DP_DOWN = "cgat.tooltip.dotplot.down";
    public static final String OPT_TT_DP_X = "cgat.tooltip.dotplot.x";
    public static final String OPT_TT_DP_Y = "cgat.tooltip.dotplot.y";
    public static final String OPT_TT_COLOR = "cgat.tooltip.color";
    public static final String OPT_TT_COLOR_BG = "cgat.tooltip.color.bg";
    public static final String OPT_TT_GENE_TAB = "cgat.tooltip.genetab";
    public static final String OPT_TT_ALIGN = "cgat.tooltip.alignment";
    public static final String OPT_TT_EXCHANGE = "cgat.tooltip.exchange";
    public static final String OPT_MAX_SEGMENTS = "cgat.max.segments";
    public static final String OPT_PANEL_ALIGN_H = "cgat.panel.alignment.alignment.height";
    public static final String OPT_PANEL_GENE_H = "cgat.panel.alignment.gene.height";
    public static final String OPT_PANEL_SEGMENT_H = "cgat.panel.alignment.segment.height";
    public static final String OPT_DP_MATCH = "cgat.dp.match";
    public static final String OPT_DP_MISMATCH = "cgat.dp.mismatch";
    public static final String OPT_DP_OPENGAP = "cgat.dp.opengap";
    public static final String OPT_DP_EXTGAP = "cgat.dp.extgap";
    public static final String OPT_DP_EDGEGAP = "cgat.dp.edgegap";
    public static final String OPT_AL_MAX_REALIGN = "cgat.alignment.max.realignment";
    public static final String OPT_PANEL_GENESET_YOFS = "cgat.panel.alignment.geneset.yofs";
    public static final String OPT_MBGD_URL_GENE = "mbgd.url.gene";
    private static MbgdDataMng _instance = null;
    protected String docBase = "";
    protected String codeBase = "";
    protected String basePath = "";
    protected String proxy = "";
    private int selectedSpec = 0;
    private int oppositeSpec = 1;
    private boolean alignViewerMode;
    protected int minAlignGap = 30;
    protected int alignColorMode = 0;
    protected boolean staSameSpecPair = false;
    private int loadStatus = 0;
    private String spFileName = null;
    private RGB rgb;
    private String loadedSp1 = "";
    private String loadedSp2 = "";
    private String[] specName;
    private int[] specChr;
    private GenomeSequence[] infoGenome;
    private AlignmentList infoAlign;
    private ColorTab infoAlignColor;
    private RegionInfoList[] infoGene;
    private ColorTab[] infoGeneColor;
    private GeneAttr[] infoGeneAttr;
    private ColorTab[] infoGeneAttrColor;
    private int maxSegNum;
    private int segNum;
    private RegionInfoList[][] infoSegs;
    private ColorTab[][] infoSegsColor;
    private String[] infoSegsName;
    private MarkEntList[] infoSearchOrf;
    private String infoGeneUrl;
    private String[] infoSegsUrl;
    protected boolean isFilterAlignment;
    protected boolean isFilterGene;
    protected boolean[] isFilterSegment;
    protected String CGI_getAlign;
    protected String CGI_getColorTab;
    protected String CGI_getSequence;
    protected String CGI_getRegInfoUrl;
    protected String CGI_getGene;
    protected String CGI_getGeneAttr;
    protected String CGI_getSegment;

    public static MbgdDataMng Instance() {
        if (_instance == null) {
            _instance = new MbgdDataMng();
        }
        return _instance;
    }

    private MbgdDataMng() {
        this._init();
    }

    private void _init() {
        int j;
        String dirCgat = "";
        try {
            dirCgat = System.getProperty("CGAT_HOME");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (dirCgat == null || dirCgat.trim().equals("")) {
            dirCgat = this.getProperty(OPT_DIR_HOME);
        }
        if (dirCgat != null) {
            this.setCgatHome(dirCgat);
        }
        this.loadProperties();
        int n = 5;
        this.rgb = null;
        this.specName = new String[2];
        this.specChr = new int[2];
        this.infoGenome = new GenomeSequence[2];
        this.infoGene = new RegionInfoList[2];
        this.infoGeneColor = new ColorTab[2];
        this.infoGeneAttr = new GeneAttr[2];
        this.infoGeneAttrColor = new ColorTab[2];
        this.infoSegsName = new String[n];
        this.infoSegs = new RegionInfoList[2][n];
        this.infoSegsColor = new ColorTab[2][n];
        this.infoSearchOrf = new MarkEntList[2];
        this.rgb = null;
        this.infoAlign = null;
        this.infoAlignColor = null;
        for (int i = 0; i < 2; ++i) {
            this.specName[i] = null;
            this.specChr[i] = 1;
            this.infoGenome[i] = null;
            this.infoGene[i] = null;
            this.infoGeneColor[i] = null;
            this.infoGeneAttr[i] = null;
            this.infoGeneAttrColor[i] = null;
            this.infoSearchOrf[i] = null;
            for (j = 0; j < n; ++j) {
                this.infoSegsName[j] = null;
                this.infoSegs[i][j] = null;
                this.infoSegsColor[i][j] = null;
            }
        }
        for (j = 0; j < n; ++j) {
            this.infoSegsName[j] = null;
        }
        this.infoSegsUrl = new String[n];
        this.isFilterAlignment = false;
        this.isFilterGene = false;
        this.isFilterSegment = new boolean[n];
        for (j = 0; j < n; ++j) {
            this.isFilterSegment[j] = false;
        }
        this.setDefaultCgiPrograms();
    }

    public boolean isReady() {
        return this.isReady(10);
    }

    public boolean isReady(int sta) {
        return this.loadStatus >= sta;
    }

    public void setReady(int sta) {
        this.loadStatus = sta;
        Dbg.println(1, "LoadStatus: " + sta);
    }

    private void setSpecName(int side, String n) {
        this.specName[side] = n == null ? null : n;
    }

    public String getSpecName(boolean basespec) {
        if (!this.isReady(1)) {
            return "";
        }
        String spname = basespec ? this.specName[this.selectedSpec] : this.specName[this.oppositeSpec];
        if (spname == null) {
            return "";
        }
        return spname;
    }

    public String getSpecNameInit(int side) {
        String spname;
        if (!this.isReady(1)) {
            return "";
        }
        try {
            spname = this.specName[side];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return "";
        }
        return spname;
    }

    public String getSpecFullName(boolean basespec) {
        if (!this.isReady()) {
            return "";
        }
        String spname = basespec ? this.infoGenome[this.selectedSpec].getName() : this.infoGenome[this.oppositeSpec].getName();
        if (spname == null) {
            return "";
        }
        return spname;
    }

    public String getSpecName(int type2) {
        if (!this.isReady()) {
            return "";
        }
        switch (type2) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return this.getSpecName(true);
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return this.getSpecName(false);
            }
        }
        return "";
    }

    public void setSpecChr(int side, int chr) {
        this.specChr[side] = chr;
    }

    public int getSpecChr(boolean basespec) {
        if (!this.isReady(1)) {
            return 1;
        }
        int chr = basespec ? this.specChr[this.selectedSpec] : this.specChr[this.oppositeSpec];
        return chr;
    }

    public String getAlignAttrName(int idx) {
        if (!this.isReady()) {
            return "";
        }
        return this.infoAlign.getAlignAttrName(idx);
    }

    protected void setMaxSegNum(int n) {
        this.maxSegNum = n;
    }

    protected int getMaxSegNum() {
        return this.maxSegNum;
    }

    protected synchronized void setSegNum(int n) {
        this.segNum = n;
    }

    protected synchronized int getSegNum() {
        return this.segNum;
    }

    public void setSegmentName(int idx, String name) {
        this.infoSegsName[idx] = name;
    }

    public String getSegmentName(int idx) {
        if (this.infoSegsName == null) {
            return "";
        }
        try {
            if (this.infoSegsName[idx] == null) {
                return "";
            }
            return this.infoSegsName[idx];
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setSpFileName(String name) {
        this.spFileName = name;
    }

    public String getSpFileName() {
        return this.spFileName;
    }

    private void exchangeBaseSpec() {
        int wk = this.selectedSpec;
        this.selectedSpec = this.oppositeSpec;
        this.oppositeSpec = wk;
        this.setChanged();
        this.notifyObservers("baseSpec");
    }

    public void load(JFrame f, String sp1, String sp2, String url, String falign, String geneAttrDir, String geneAttrColorType, String[] segType, String[] segCgi) {
        this.staSameSpecPair = false;
        if (sp1.equals(this.loadedSp1) && sp2.equals(this.loadedSp2)) {
            this.staSameSpecPair = true;
        }
        this.loadedSp1 = sp1;
        this.loadedSp2 = sp2;
        this.setSpFileName(falign);
        DataLoader dataLoader = new DataLoader(f, this);
        dataLoader.setInfo(sp1, sp2, url, falign, geneAttrDir, geneAttrColorType, segType, segCgi);
        dataLoader.addObserver(this);
        Thread thread = new Thread(dataLoader);
        thread.start();
    }

    public void makeObj() {
    }

    public void execLoad(String sp1, String sp2, String path, String falign, String geneAttrDir, String geneAttrColorType, String[] segType, String[] segCgi) {
        String fileAlignColor;
        String fileAlign;
        String fileRgb;
        int sp1chr = this.getSpecChr(true);
        int sp2chr = this.getSpecChr(false);
        String fileGenome1 = null;
        String fileGenome2 = null;
        Object fileChromosome = null;
        String fileGene1 = null;
        String fileGene2 = null;
        String fileGeneColor1 = null;
        String fileGeneColor2 = null;
        String fileGeneAttr1 = null;
        String fileGeneAttr2 = null;
        String fileGeneAttrColor1 = null;
        String fileGeneAttrColor2 = null;
        String fileGeneUrl = null;
        String[] fileSegUrl = new String[segCgi.length];
        String url = path;
        String sep = System.getProperty("file.separator");
        String dirCgat = this.getCgatHome();
        String dirDb = dirCgat + sep + "database";
        String dirEtc = dirCgat + sep + "etc";
        if (path.startsWith("http")) {
            fileRgb = url + "rgb.txt";
            fileAlign = url + this.CGI_getAlign + "type=" + falign + "&" + "spec=" + sp1 + "&spec=" + sp2 + "&" + "sp1chr=" + sp1chr + "&" + "sp2chr=" + sp2chr;
            fileAlignColor = url + this.CGI_getColorTab + "type=align";
            fileGenome1 = url + this.CGI_getSequence + "reg=" + sp1 + "&" + "chr=" + sp1chr;
            fileGenome2 = url + this.CGI_getSequence + "reg=" + sp2 + "&" + "chr=" + sp2chr;
            fileGeneUrl = url + this.CGI_getRegInfoUrl + "type=gene";
            fileGene1 = url + this.CGI_getGene + "spec=" + sp1 + "&" + "chr=" + sp1chr;
            fileGeneColor1 = url + this.CGI_getColorTab + "type=gene&" + "spec=" + sp1;
            fileGene2 = url + this.CGI_getGene + "spec=" + sp2 + "&" + "chr=" + sp2chr;
            fileGeneColor2 = url + this.CGI_getColorTab + "type=gene&" + "spec=" + sp2;
        } else {
            fileRgb = dirEtc + sep + "rgb.txt";
            fileAlign = dirDb + sep + "align" + sep + falign + "." + sp1 + "-" + sp2;
            fileAlignColor = dirEtc + sep + "colorTab" + sep + "colorTab.align";
            fileGenome1 = dirDb + sep + "genomes" + sep + sp1;
            fileGenome2 = dirDb + sep + "genomes" + sep + sp2;
            fileGeneUrl = "";
            fileGene1 = dirDb + sep + "genes" + sep + "tab" + sep + sp1;
            fileGeneColor1 = dirEtc + sep + "colorTab" + sep + "colorTab.gene";
            fileGene2 = dirDb + sep + "genes" + sep + "tab" + sep + sp2;
            fileGeneColor2 = dirEtc + sep + "colorTab" + sep + "colorTab.gene";
        }
        if (geneAttrDir != null) {
            if (geneAttrDir.endsWith("(Server)")) {
                String ga = geneAttrDir.replaceAll("\\(Server\\)", "");
                fileGeneAttr1 = url + this.CGI_getGeneAttr + "type=" + ga + "&" + "spec=" + sp1;
                fileGeneAttrColor1 = url + this.CGI_getColorTab + "typ=" + ga + "&" + "spec=" + sp1;
                fileGeneAttr2 = url + this.CGI_getGeneAttr + "type=" + ga + "&" + "spec=" + sp2;
                fileGeneAttrColor2 = url + this.CGI_getColorTab + "typ=" + ga + "&" + "spec=" + sp2;
            } else {
                fileGeneAttr1 = dirDb + sep + "geneattr" + sep + geneAttrDir + sep + "attr." + sp1;
                fileGeneAttrColor1 = "no_gene_attr";
                fileGeneAttr2 = dirDb + sep + "geneattr" + sep + geneAttrDir + sep + "attr." + sp2;
                fileGeneAttrColor2 = "no_gene_attr";
            }
        }
        for (int segNo = 0; segNo < segCgi.length; ++segNo) {
            segCgi[segNo] = null;
            if (segType[segNo] == null || segType[segNo].equalsIgnoreCase("No Data")) continue;
            String st = segType[segNo].replaceAll("\\(Server\\)", "");
            segCgi[segNo] = segType[segNo].endsWith("(Server)") ? url + this.CGI_getSegment + "type=" + st : dirDb + sep + "segment" + sep + st + sep + "seg." + sp2;
        }
        this.alignViewerMode = true;
        if (sp2 == null) {
            this.alignViewerMode = false;
        }
        this.setReady(0);
        if (this.rgb == null) {
            this.rgb = new RGB();
            try {
                URL u = this.getClass().getClassLoader().getResource("image/rgb.txt");
                BaseFile bf = new BaseFile(new BufferedReader(new InputStreamReader(u.openStream())));
                this.rgb.parse("rgb.txt", bf);
            }
            catch (IOException ioe) {
                this.rgb.load(fileRgb);
            }
        }
        this.setSpecName(0, sp1);
        this.setSpecName(1, sp2);
        this.setReady(1);
        if (this.infoAlign == null) {
            this.infoAlign = new AlignmentList();
            this.infoAlignColor = new ColorTab(this.rgb);
        }
        if (this.alignViewerMode) {
            String fileAlignSeq = falign;
            this.infoAlign.load(sp1, sp2, fileAlign, fileAlignSeq);
            this.infoAlignColor.load(fileAlignColor);
        }
        this.setReady(2);
        if (this.infoGenome[0] == null) {
            this.infoGenome[0] = new GenomeSequence("", "");
        }
        this.infoGenome[0].load(fileGenome1);
        if (this.infoGenome[1] == null) {
            this.infoGenome[1] = new GenomeSequence("", "");
        }
        if (this.alignViewerMode) {
            this.infoGenome[1].load(fileGenome2);
        }
        this.setReady(3);
        try {
            this.infoGeneUrl = new UrlFile(fileGeneUrl).readLine().trim();
        }
        catch (Exception e) {
            this.infoGeneUrl = this.getProperty(OPT_MBGD_URL_GENE);
        }
        if (this.infoGene[0] == null) {
            this.infoGene[0] = new RegionInfoList();
            this.infoGeneColor[0] = new ColorTab(this.rgb);
            this.infoSearchOrf[0] = new MarkEntList();
        }
        this.infoGene[0].load(fileGene1);
        this.infoGene[0].setDataName("gene");
        boolean bSta = this.infoGeneColor[0].load(fileGeneColor1);
        if (this.infoGene[1] == null) {
            this.infoGene[1] = new RegionInfoList();
            this.infoGeneColor[1] = new ColorTab(this.rgb);
            this.infoSearchOrf[1] = new MarkEntList();
        }
        if (this.alignViewerMode) {
            this.infoGene[1].load(fileGene2);
            this.infoGene[1].setDataName("gene");
            bSta = this.infoGeneColor[1].load(fileGeneColor2);
        }
        this.setReady(4);
        if (this.infoGeneAttr[0] == null) {
            this.infoGeneAttr[0] = new GeneAttr();
            this.infoGeneAttrColor[0] = new ColorTab(this.rgb);
        }
        if (this.infoGeneAttr[1] == null) {
            this.infoGeneAttr[1] = new GeneAttr();
            this.infoGeneAttrColor[1] = new ColorTab(this.rgb);
        }
        if (geneAttrDir != null) {
            this.infoGeneAttr[0].load(fileGeneAttr1);
            this.infoGene[0].setDataName(geneAttrDir);
            this.infoGeneAttr[0].setColorType(geneAttrColorType);
            bSta = this.infoGeneAttrColor[0].load(fileGeneAttrColor1);
            if (!bSta) {
                this.infoGeneAttrColor[0].setDefaultColorTab(this.infoGeneAttr[0].getMinValue(), this.infoGeneAttr[0].getMaxValue());
                this.infoGene[0].setDataName("float");
            }
            if (this.alignViewerMode) {
                this.infoGeneAttr[1].load(fileGeneAttr2);
                this.infoGene[1].setDataName(geneAttrDir);
                this.infoGeneAttr[1].setColorType(geneAttrColorType);
                bSta = this.infoGeneAttrColor[1].load(fileGeneAttrColor2);
                if (!bSta) {
                    this.infoGeneAttrColor[1].setDefaultColorTab(this.infoGeneAttr[1].getMinValue(), this.infoGeneAttr[1].getMaxValue());
                    this.infoGene[0].setDataName("float");
                }
            }
        } else {
            this.infoGeneAttr[0].clear();
            this.infoGeneAttr[1].clear();
        }
        this.setReady(5);
        this.loadSegment(path, segType, segCgi);
        this.setReady(6);
        this.setReady(10);
    }

    public void loadSegment(String path, String[] segType, String[] segCgi) {
        String sep = System.getProperty("file.separator");
        String dirCgat = this.getCgatHome();
        String dirDb = dirCgat + sep + "database";
        int loopMax = segCgi.length;
        Dbg.println(1, "Loop>>" + loopMax);
        for (int segNo = 0; segNo < loopMax; ++segNo) {
            String fileSeg;
            Dbg.println(1, ">" + segCgi[segNo]);
            if (segType[segNo] == null || segType[segNo].equals("No Data")) continue;
            String st = segType[segNo].replaceAll("\\(Server\\)", "");
            if (segType[segNo].endsWith("(Server)")) {
                fileSeg = path + "/cgi-bin/getRegInfoUrl.cgi?type=" + st;
            } else {
                fileSeg = path + sep + "database" + sep + "segment" + sep + st;
                segCgi[segNo] = null;
            }
            Dbg.println(3, fileSeg + " " + segNo);
            try {
                this.infoSegsUrl[segNo] = new UrlFile(fileSeg).readLine().trim();
            }
            catch (Exception e) {
                this.infoSegsUrl[segNo] = "";
            }
            Dbg.println(3, this.infoSegsUrl[segNo] + " " + segNo);
            this.loadSegment0(0, segNo, path, st, segCgi[segNo]);
            if (!this.alignViewerMode) continue;
            this.loadSegment0(1, segNo, path, st, segCgi[segNo]);
        }
    }

    public void loadSegment0(int seqNum, int segNo, String path, String segType, String segCgi) {
        String sp = this.getSpecName(this.isBaseSpec(seqNum));
        String fileSegment = null;
        String fileSegmentColor = null;
        String sep = System.getProperty("file.separator");
        String dirCgat = this.getCgatHome();
        String dirDb = dirCgat + sep + "database";
        String dirEtc = dirCgat + sep + "etc";
        if (this.infoSegs[seqNum][segNo] == null) {
            this.infoSegs[seqNum][segNo] = new RegionInfoList();
            this.infoSegsColor[seqNum][segNo] = new ColorTab(this.rgb);
        }
        if (segType == null || segType.equals("")) {
            return;
        }
        if (segCgi != null) {
            fileSegment = segCgi;
            if (fileSegment.endsWith(".cgi")) {
                fileSegment = fileSegment + "?";
            }
            fileSegment = fileSegment + "&spec=" + sp;
            fileSegmentColor = path + "/cgi-bin/getColorTab.cgi?" + "type=" + segType + "&" + "spec=" + sp;
        } else {
            fileSegment = dirDb + sep + "segment" + sep + segType + sep + "seg." + sp;
            fileSegmentColor = dirEtc + sep + "colorTab." + segType;
        }
        Dbg.println(3, "fileSegment :: " + fileSegment);
        this.infoSegs[seqNum][segNo].load(fileSegment);
        this.infoSegs[seqNum][segNo].setDataName(segType);
        boolean bSta = this.infoSegsColor[seqNum][segNo].load(fileSegmentColor);
        if (!bSta) {
            this.infoSegsColor[seqNum][segNo].load(fileSegmentColor);
        }
        ColorAssign colAssignSeg = new ColorAssign();
        int loopMax = this.infoSegs[seqNum][segNo].size();
        for (int idx = 0; idx < loopMax; ++idx) {
            RegionInfo r = this.infoSegs[seqNum][segNo].getRegionInfo(idx);
            colAssignSeg.countColorType(r.getColor());
        }
        colAssignSeg.assignColor();
        this.infoSegsColor[seqNum][segNo].setColorAssign(colAssignSeg);
    }

    public void loadAlignmentSeq(int f1, int t1, int f2, int t2) {
        String name1 = this.getSpecName(true);
        String name2 = this.getSpecName(false);
        this.loadAlignmentSeq(name1, f1, t1, name2, f2, t2);
    }

    public void loadAlignmentSeq(String name1, int f1, int t1, String name2, int f2, int t2) {
        this.infoAlign.loadAlignSeq(name1, f1, t1, name2, f2, t2);
    }

    public String getAlignmentSeq(int f1, int t1, int f2, int t2, boolean side) {
        String name1 = this.getSpecName(true);
        String name2 = this.getSpecName(false);
        String seq = this.getAlignmentSeq(name1, f1, t1, name2, f2, t2, side);
        return seq;
    }

    public AlignSeq getAlignSeq(String name1, int f1, int t1, String name2, int f2, int t2) {
        AlignSeq as = this.infoAlign.getAlignSeq(name1, f1, t1, name2, f2, t2);
        return as;
    }

    public String getAlignmentSeq(String name1, int f1, int t1, String name2, int f2, int t2, boolean side) {
        MbgdData mbgdData = MbgdData.Instance();
        String server = mbgdData.getServerUrl();
        AlignSeq as = this.infoAlign.getAlignSeq(name1, f1, t1, name2, f2, t2);
        String seq = side ? as.getSeq1() : as.getSeq2();
        return seq;
    }

    public String getGenomeSequence(boolean basespec, int from, int to) {
        if (!this.isReady(3)) {
            return "";
        }
        String subSeq = basespec ? this.infoGenome[this.selectedSpec].getSequence(from, to) : this.infoGenome[this.oppositeSpec].getSequence(from, to);
        return subSeq;
    }

    public int getGenomeLength(boolean basespec) {
        if (!this.isReady(3)) {
            return 0;
        }
        if (basespec) {
            return this.infoGenome[this.selectedSpec].getLength();
        }
        return this.infoGenome[this.oppositeSpec].getLength();
    }

    public int getGenomeLength(int type2) {
        boolean side;
        if (!this.isReady(3)) {
            return 0;
        }
        switch (type2) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                side = true;
                break;
            }
            default: {
                side = false;
            }
        }
        return this.getGenomeLength(side);
    }

    public Alignment getAlignment(boolean basespec, String key) {
        if (!this.isReady(2)) {
            return null;
        }
        Alignment info = new Alignment(this.infoAlign.getAlignment(key));
        if (this.selectedSpec != 0) {
            info.exchangeSpec();
        }
        return info;
    }

    public Alignment getAlignment(boolean basespec, int index) {
        Alignment info;
        if (!this.isReady(2)) {
            return null;
        }
        if (basespec) {
            if (this.selectedSpec == 0) {
                info = new Alignment(this.infoAlign.getAlignment1(index));
            } else {
                info = new Alignment(this.infoAlign.getAlignment2(index));
                info.exchangeSpec();
            }
        } else if (this.selectedSpec != 0) {
            info = new Alignment(this.infoAlign.getAlignment1(index));
        } else {
            info = new Alignment(this.infoAlign.getAlignment2(index));
            info.exchangeSpec();
        }
        return info;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList getAlignment(int dataType, ViewWindow viewWin, int from, int to) {
        ArrayList alignList;
        void var6_5;
        switch (dataType) {
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                boolean basespec = true;
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                boolean basespec = false;
                break;
            }
            default: {
                return new ArrayList();
            }
        }
        if (from < to) {
            alignList = AlignmentListFilter.search(this, viewWin, (boolean)var6_5, from, to);
        } else {
            int genomeLength = this.getGenomeLength((boolean)var6_5);
            ArrayList wk = AlignmentListFilter.search(this, viewWin, (boolean)var6_5, from, genomeLength);
            alignList = AlignmentListFilter.search(this, viewWin, (boolean)var6_5, 0, to);
            alignList.addAll(wk);
        }
        return alignList;
    }

    public int getAlignmentSize() {
        if (!this.isReady(2)) {
            return 0;
        }
        return this.infoAlign.size();
    }

    public boolean getAlignAttrDataType(String nameItem) {
        if (!this.isReady(2)) {
            return false;
        }
        boolean dataType = this.infoAlign.getAttrDataType(nameItem);
        return dataType;
    }

    public RegionInfo getGeneInfo(boolean basespec, int index) {
        if (!this.isReady(4)) {
            return null;
        }
        RegionInfo info = basespec ? new RegionInfo(this.infoGene[this.selectedSpec].getRegionInfo(index)) : new RegionInfo(this.infoGene[this.oppositeSpec].getRegionInfo(index));
        return info;
    }

    public RegionInfo getGeneInfo(boolean basespec, String orfName) {
        if (!this.isReady(4)) {
            return null;
        }
        RegionInfo info = basespec ? this.infoGene[this.selectedSpec].getRegionInfo(orfName) : this.infoGene[this.oppositeSpec].getRegionInfo(orfName);
        if (info == null) {
            return null;
        }
        return new RegionInfo(info);
    }

    public RegionInfo getSegmentInfo(boolean basespec, int segNo, int index) {
        if (!this.isReady(6)) {
            return null;
        }
        RegionInfo info = basespec ? new RegionInfo(this.infoSegs[this.selectedSpec][segNo].getRegionInfo(index)) : new RegionInfo(this.infoSegs[this.oppositeSpec][segNo].getRegionInfo(index));
        return info;
    }

    public RegionInfo getSegmentInfo(int type2, int index) {
        if (!this.isReady(6)) {
            return null;
        }
        switch (type2) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return this.getSegmentInfo(true, type2 - 4, index);
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return this.getSegmentInfo(false, type2 - 14, index);
            }
        }
        return null;
    }

    public int getRegionMaxLane(int type2) {
        if (!this.isReady(6)) {
            return 1;
        }
        int maxLane = 1;
        switch (type2) {
            case 2: {
                maxLane = this.infoGene[this.selectedSpec].getMaxLane();
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                maxLane = this.infoSegs[this.selectedSpec][type2 - 4].getMaxLane();
                break;
            }
            case 12: {
                maxLane = this.infoGene[this.oppositeSpec].getMaxLane();
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                maxLane = this.infoSegs[this.oppositeSpec][type2 - 14].getMaxLane();
            }
        }
        if (maxLane <= 0) {
            maxLane = 1;
        }
        return maxLane;
    }

    public RegionInfoList getRegionInfoList(int type2) {
        if (!this.isReady(6)) {
            return null;
        }
        switch (type2) {
            case 2: {
                return this.infoGene[this.selectedSpec];
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return this.infoSegs[this.selectedSpec][type2 - 4];
            }
            case 12: {
                return this.infoGene[this.oppositeSpec];
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return this.infoSegs[this.oppositeSpec][type2 - 14];
            }
        }
        return null;
    }

    public RegionInfo getRegionInfo(int type2, int index) {
        if (!this.isReady(6)) {
            return null;
        }
        switch (type2) {
            case 2: {
                return this.getGeneInfo(true, index);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return this.getSegmentInfo(true, type2 - 4, index);
            }
            case 12: {
                return this.getGeneInfo(false, index);
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return this.getSegmentInfo(false, type2 - 14, index);
            }
        }
        return null;
    }

    public String getSegAttrName(int type2, int idxSeg, int idxItem) {
        String name = "unknown";
        if (!this.isReady(6)) {
            return null;
        }
        switch (type2) {
            case 2: {
                return this.infoGene[this.selectedSpec].getAttrName(idxItem);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                try {
                    return this.infoSegs[this.selectedSpec][idxSeg].getAttrName(idxItem);
                }
                catch (Exception e) {
                    return null;
                }
            }
            case 12: {
                return this.infoGene[this.selectedSpec].getAttrName(idxItem);
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                try {
                    return this.infoSegs[this.oppositeSpec][idxSeg].getAttrName(idxItem);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return name;
    }

    public boolean getGeneAttrDataType(int idxItem) {
        if (!this.isReady(6)) {
            return false;
        }
        boolean dataType = this.infoGene[this.selectedSpec].getAttrDataType(idxItem);
        return dataType;
    }

    public boolean getSegAttrDataType(int idxSeg, int idxItem) {
        if (!this.isReady(6)) {
            return false;
        }
        boolean dataType = this.infoSegs[this.selectedSpec][idxSeg].getAttrDataType(idxItem);
        return dataType;
    }

    public void clearFilterAlignment() {
        if (!this.isReady(6)) {
            return;
        }
        this.isFilterAlignment = false;
        this.infoAlign.clearFilter();
        this.setChanged();
        this.notifyObservers();
    }

    public void filterAlignment(String condName, String nameAlignItem, String str1) {
        if (!this.isReady(6)) {
            return;
        }
        this.isFilterAlignment = true;
        if ("Equal".equals(condName)) {
            AlignmentFilter.filterEqual(this.infoAlign, nameAlignItem, str1);
        } else if ("Regex".equals(condName)) {
            AlignmentFilter.filterRegex(this.infoAlign, nameAlignItem, str1);
        } else if ("Select".equals(condName)) {
            AlignmentFilter.filterSelect(this.infoAlign, nameAlignItem, str1);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void filterAlignment(String condName, String nameAlignItem, double val1) {
        if (!this.isReady(6)) {
            return;
        }
        this.isFilterAlignment = true;
        if ("Less Than".equals(condName)) {
            AlignmentFilter.filterLessThan(this.infoAlign, nameAlignItem, val1);
        } else if ("Less Equal".equals(condName)) {
            AlignmentFilter.filterLessEqual(this.infoAlign, nameAlignItem, val1);
        } else if ("Equal".equals(condName)) {
            AlignmentFilter.filterEqual(this.infoAlign, nameAlignItem, val1);
        } else if ("Greater Equal".equals(condName)) {
            AlignmentFilter.filterGreaterEqual(this.infoAlign, nameAlignItem, val1);
        } else if ("Greater Than".equals(condName)) {
            AlignmentFilter.filterGreaterThan(this.infoAlign, nameAlignItem, val1);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void filterAlignment(String condName, String nameAlignItem, double val1, double val2) {
        if (!this.isReady(6)) {
            return;
        }
        this.isFilterAlignment = true;
        if ("Between (e.g. 10,20)".equals(condName)) {
            AlignmentFilter.filterBetween(this.infoAlign, nameAlignItem, val1, val2);
        } else if ("Except Between".equals(condName)) {
            AlignmentFilter.filterExceptBetween(this.infoAlign, nameAlignItem, val1, val2);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void clearFilterGeneSegment(int idxSeg) {
        if (!this.isReady(6)) {
            return;
        }
        if (idxSeg == 0) {
            this.isFilterGene = false;
            for (int i = 0; i < 2; ++i) {
                this.infoGene[i].clearFilter();
            }
        } else {
            this.isFilterSegment[idxSeg - 1] = false;
            for (int i = 0; i < 2; ++i) {
                this.infoSegs[i][idxSeg - 1].clearFilter();
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void clearFilterAll() {
        this.clearFilterAlignment();
        this.clearFilterGeneSegment(0);
        int segNum = this.getSegNum();
        for (int i = 0; i < segNum; ++i) {
            this.clearFilterGeneSegment(i + 1);
        }
    }

    public void filterGeneSegment(String condName, int idxSeg, int idxSegItem, String str1) {
        if (!this.isReady(6)) {
            return;
        }
        if ("Equal".equals(condName)) {
            if (idxSeg == 0) {
                this.isFilterGene = true;
                for (int i = 0; i < 2; ++i) {
                    SegmentFilter.filterEqual(this.infoGene[i], idxSegItem, str1);
                }
            } else {
                this.isFilterSegment[idxSeg - 1] = true;
                for (int i = 0; i < 2; ++i) {
                    SegmentFilter.filterEqual(this.infoSegs[i][idxSeg - 1], idxSegItem, str1);
                }
            }
        } else if ("Regex".equals(condName)) {
            if (idxSeg == 0) {
                this.isFilterGene = true;
                for (int i = 0; i < 2; ++i) {
                    SegmentFilter.filterRegex(this.infoGene[i], idxSegItem, str1);
                }
            } else {
                this.isFilterSegment[idxSeg - 1] = true;
                for (int i = 0; i < 2; ++i) {
                    SegmentFilter.filterRegex(this.infoSegs[i][idxSeg - 1], idxSegItem, str1);
                }
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void filterGeneSegment(String condName, int idxSeg, int idxSegItem, double val1) {
        if (!this.isReady(6)) {
            return;
        }
        if ("Less Than".equals(condName)) {
            if (idxSeg == 0) {
                this.isFilterGene = true;
                for (int i = 0; i < 2; ++i) {
                    SegmentFilter.filterLessThan(this.infoGene[i], idxSegItem, val1);
                }
            } else {
                this.isFilterSegment[idxSeg - 1] = true;
                for (int i = 0; i < 2; ++i) {
                    SegmentFilter.filterLessThan(this.infoSegs[i][idxSeg - 1], idxSegItem, val1);
                }
            }
        } else if ("Less Equal".equals(condName)) {
            if (idxSeg == 0) {
                this.isFilterGene = true;
                for (int i = 0; i < 2; ++i) {
                    SegmentFilter.filterLessEqual(this.infoGene[i], idxSegItem, val1);
                }
            } else {
                this.isFilterSegment[idxSeg - 1] = true;
                for (int i = 0; i < 2; ++i) {
                    SegmentFilter.filterLessEqual(this.infoSegs[i][idxSeg - 1], idxSegItem, val1);
                }
            }
        } else if ("Equal".equals(condName)) {
            if (idxSeg == 0) {
                this.isFilterGene = true;
                for (int i = 0; i < 2; ++i) {
                    SegmentFilter.filterEqual(this.infoGene[i], idxSegItem, val1);
                }
            } else {
                this.isFilterSegment[idxSeg - 1] = true;
                for (int i = 0; i < 2; ++i) {
                    SegmentFilter.filterEqual(this.infoSegs[i][idxSeg - 1], idxSegItem, val1);
                }
            }
        } else if ("Greater Equal".equals(condName)) {
            if (idxSeg == 0) {
                this.isFilterGene = true;
                for (int i = 0; i < 2; ++i) {
                    SegmentFilter.filterGreaterEqual(this.infoGene[i], idxSegItem, val1);
                }
            } else {
                this.isFilterSegment[idxSeg - 1] = true;
                for (int i = 0; i < 2; ++i) {
                    SegmentFilter.filterGreaterEqual(this.infoSegs[i][idxSeg - 1], idxSegItem, val1);
                }
            }
        } else if ("Greater Than".equals(condName)) {
            if (idxSeg == 0) {
                this.isFilterGene = true;
                for (int i = 0; i < 2; ++i) {
                    SegmentFilter.filterGreaterThan(this.infoGene[i], idxSegItem, val1);
                }
            } else {
                this.isFilterSegment[idxSeg - 1] = true;
                for (int i = 0; i < 2; ++i) {
                    SegmentFilter.filterGreaterThan(this.infoSegs[i][idxSeg - 1], idxSegItem, val1);
                }
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void filterGeneSegment(String condName, int idxSeg, int idxSegItem, double val1, double val2) {
        if (!this.isReady(6)) {
            return;
        }
        if ("Between (e.g. 10,20)".equals(condName)) {
            if (idxSeg == 0) {
                this.isFilterGene = true;
                for (int i = 0; i < 2; ++i) {
                    SegmentFilter.filterBetween(this.infoGene[i], idxSegItem, val1, val2);
                }
            } else {
                this.isFilterSegment[idxSeg - 1] = true;
                for (int i = 0; i < 2; ++i) {
                    SegmentFilter.filterBetween(this.infoSegs[i][idxSeg - 1], idxSegItem, val1, val2);
                }
            }
        } else if ("Except Between".equals(condName)) {
            if (idxSeg == 0) {
                this.isFilterGene = true;
                for (int i = 0; i < 2; ++i) {
                    SegmentFilter.filterExceptBetween(this.infoGene[i], idxSegItem, val1, val2);
                }
            } else {
                this.isFilterSegment[idxSeg - 1] = true;
                for (int i = 0; i < 2; ++i) {
                    SegmentFilter.filterExceptBetween(this.infoSegs[i][idxSeg - 1], idxSegItem, val1, val2);
                }
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    public int getGeneAttrSize(int type2) {
        if (!this.isReady(5)) {
            return 0;
        }
        switch (type2) {
            case 2: {
                return this.infoGeneAttr[this.selectedSpec].size();
            }
            case 12: {
                return this.infoGeneAttr[this.oppositeSpec].size();
            }
        }
        return 0;
    }

    public float getGeneAttrMin(int type2) {
        if (!this.isReady(5)) {
            return 0.0f;
        }
        switch (type2) {
            case 2: {
                return this.infoGeneAttr[this.selectedSpec].getMinValue();
            }
            case 12: {
                return this.infoGeneAttr[this.oppositeSpec].getMinValue();
            }
        }
        return 0.0f;
    }

    public float getGeneAttrMax(int type2) {
        if (!this.isReady(5)) {
            return 0.0f;
        }
        switch (type2) {
            case 2: {
                return this.infoGeneAttr[this.selectedSpec].getMaxValue();
            }
            case 12: {
                return this.infoGeneAttr[this.oppositeSpec].getMaxValue();
            }
        }
        return 0.0f;
    }

    public int getRegionSize(int type2) {
        if (!this.isReady(6)) {
            return 0;
        }
        switch (type2) {
            case 2: {
                return this.infoGene[this.selectedSpec].size();
            }
            case 3: {
                return this.infoGeneAttr[this.selectedSpec].size();
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return this.infoSegs[this.selectedSpec][type2 - 4].size();
            }
            case 12: {
                return this.infoGene[this.oppositeSpec].size();
            }
            case 13: {
                return this.infoGeneAttr[this.oppositeSpec].size();
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return this.infoSegs[this.oppositeSpec][type2 - 14].size();
            }
        }
        return 0;
    }

    public String getGeneAttrName(int type2, int idx) {
        String name = "unknown";
        if (!this.isReady(5)) {
            return null;
        }
        switch (type2) {
            case 2: {
                return this.infoGene[this.selectedSpec].getAttrName(idx);
            }
            case 12: {
                return this.infoGene[this.oppositeSpec].getAttrName(idx);
            }
        }
        return name;
    }

    public ColorTab getAlignColor() {
        if (!this.isReady(2)) {
            return null;
        }
        return this.infoAlignColor;
    }

    public String getColorType(int type2) {
        if (!this.isReady(6)) {
            return "";
        }
        switch (type2) {
            case 2: {
                if (this.infoGeneAttr[this.selectedSpec].size() != 0) {
                    return this.infoGeneAttr[this.selectedSpec].getColorType();
                }
                return this.infoGene[this.selectedSpec].getColorType();
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return this.infoSegs[this.selectedSpec][type2 - 4].getColorType();
            }
            case 12: {
                if (this.infoGeneAttr[this.oppositeSpec].size() != 0) {
                    return this.infoGeneAttr[this.oppositeSpec].getColorType();
                }
                return this.infoGene[this.oppositeSpec].getColorType();
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return this.infoSegs[this.oppositeSpec][type2 - 14].getColorType();
            }
        }
        return null;
    }

    public String getGeneAttr(int type2, String key) {
        if (!this.isReady(5)) {
            return null;
        }
        switch (type2) {
            case 2: {
                return this.infoGeneAttr[this.selectedSpec].get(key);
            }
            case 12: {
                return this.infoGeneAttr[this.oppositeSpec].get(key);
            }
        }
        return null;
    }

    public Color getGeneAttrColor(int type2, String key, String colType) {
        Color c = Color.white;
        if (!this.isReady(5)) {
            return c;
        }
        String colId = this.getGeneAttr(type2, key);
        switch (type2) {
            case 2: {
                this.infoGeneAttrColor[this.selectedSpec].setUseColor(this.use_color);
                c = this.infoGeneAttrColor[this.selectedSpec].getColor(colId, colType);
                break;
            }
            case 12: {
                this.infoGeneAttrColor[this.oppositeSpec].setUseColor(this.use_color);
                c = this.infoGeneAttrColor[this.oppositeSpec].getColor(colId, colType);
            }
        }
        return c;
    }

    public Color getGeneAttrColor(int type2, float val) {
        Color c = Color.white;
        if (!this.isReady(5)) {
            return c;
        }
        switch (type2) {
            case 2: {
                this.infoGeneAttrColor[this.selectedSpec].setUseColor(this.use_color);
                c = this.infoGeneAttrColor[this.selectedSpec].getColorFloat(val);
                break;
            }
            case 12: {
                this.infoGeneAttrColor[this.oppositeSpec].setUseColor(this.use_color);
                c = this.infoGeneAttrColor[this.oppositeSpec].getColorFloat(val);
            }
        }
        return c;
    }

    public Color getAlignColor(int type2, String colId, String colType, Alignment align) {
        Color c = Color.white;
        if (!this.isReady(6)) {
            return c;
        }
        if (this.getAlignColorMode() == 0) {
            this.infoAlignColor.setUseColor(this.use_color);
            c = this.infoAlignColor.getColor(colId, colType);
        } else {
            int b;
            int g;
            int r;
            int h;
            int m;
            int l;
            if (this.use_color == 1) {
                l = this.getPropertyInt(OPT_AL_ID_L_DARK, 16);
                m = this.getPropertyInt(OPT_AL_ID_M_DARK, 16);
                h = this.getPropertyInt(OPT_AL_ID_H_DARK, 16);
            } else {
                l = this.getPropertyInt(OPT_AL_ID_L_LIGHT, 16);
                m = this.getPropertyInt(OPT_AL_ID_M_LIGHT, 16);
                h = this.getPropertyInt(OPT_AL_ID_H_LIGHT, 16);
            }
            Color lCol = new Color(l);
            double lr = lCol.getRed();
            double lg = lCol.getGreen();
            double lb = lCol.getBlue();
            Color mCol = new Color(m);
            double mr = mCol.getRed();
            double mg = mCol.getGreen();
            double mb = mCol.getBlue();
            Color hCol = new Color(h);
            double hr = hCol.getRed();
            double hg = hCol.getGreen();
            double hb = hCol.getBlue();
            double lIdent = Double.parseDouble(this.cgatProperties.getProperty(OPT_AL_ID_L_PERCENT));
            double mIdent = Double.parseDouble(this.cgatProperties.getProperty(OPT_AL_ID_M_PERCENT));
            double hIdent = Double.parseDouble(this.cgatProperties.getProperty(OPT_AL_ID_H_PERCENT));
            double ident = align.getIdent();
            if (ident < lIdent) {
                return lCol;
            }
            if (hIdent < ident) {
                return hCol;
            }
            if (ident < mIdent) {
                double ratio = (ident - lIdent) / (mIdent - lIdent);
                r = (int)(lr + (mr - lr) * ratio);
                g = (int)(lg + (mg - lg) * ratio);
                b = (int)(lb + (mb - lb) * ratio);
            } else {
                double ratio = (ident - mIdent) / (hIdent - mIdent);
                r = (int)(mr + (hr - mr) * ratio);
                g = (int)(mg + (hg - mg) * ratio);
                b = (int)(mb + (hb - mb) * ratio);
            }
            if (r < 0) {
                r = 0;
            }
            if (255 < r) {
                r = 255;
            }
            if (g < 0) {
                g = 0;
            }
            if (255 < g) {
                g = 255;
            }
            if (b < 0) {
                b = 0;
            }
            if (255 < b) {
                b = 255;
            }
            c = new Color(r, g, b);
        }
        return c;
    }

    public String getColorLegend() {
        if (!this.isReady(6)) {
            return "";
        }
        String dl = this.getProperty(OPT_AL_ID_L_DARK);
        String dm = this.getProperty(OPT_AL_ID_M_DARK);
        String dh = this.getProperty(OPT_AL_ID_H_DARK);
        String ll = this.getProperty(OPT_AL_ID_L_LIGHT);
        String lm = this.getProperty(OPT_AL_ID_M_LIGHT);
        String lh = this.getProperty(OPT_AL_ID_H_LIGHT);
        String lIdent = this.cgatProperties.getProperty(OPT_AL_ID_L_PERCENT);
        String mIdent = this.cgatProperties.getProperty(OPT_AL_ID_M_PERCENT);
        String hIdent = this.cgatProperties.getProperty(OPT_AL_ID_H_PERCENT);
        StringBuffer htmlLegend = new StringBuffer("");
        htmlLegend.append("<html>");
        htmlLegend.append("<head>");
        htmlLegend.append("</head>");
        htmlLegend.append("<body>");
        htmlLegend.append("<table border>");
        htmlLegend.append("<tr><th nowrap>Ident[%]</th>");
        htmlLegend.append("<th bgcolor=\"black\"><font color=\"white\">Background</font></th>");
        htmlLegend.append("<th bgcolor=\"white\"><font color=\"black\">Background</font></th>");
        htmlLegend.append("</tr>");
        String ident = lIdent;
        String d = dl;
        String l = ll;
        htmlLegend.append("<tr><td align=\"right\">" + ident + "</td>");
        htmlLegend.append("<td bgcolor=\"#" + d + "\"></td>");
        htmlLegend.append("<td bgcolor=\"#" + l + "\"></td>");
        htmlLegend.append("</tr>");
        ident = mIdent;
        d = dm;
        l = lm;
        htmlLegend.append("<tr><td align=\"right\">" + ident + "</td>");
        htmlLegend.append("<td bgcolor=\"#" + d + "\"></td>");
        htmlLegend.append("<td bgcolor=\"#" + l + "\"></td>");
        htmlLegend.append("</tr>");
        ident = hIdent;
        d = dh;
        l = lh;
        htmlLegend.append("<tr><td align=\"right\">" + ident + "</td>");
        htmlLegend.append("<td bgcolor=\"#" + d + "\"></td>");
        htmlLegend.append("<td bgcolor=\"#" + l + "\"></td>");
        htmlLegend.append("</tr>");
        htmlLegend.append("</table>");
        htmlLegend.append("</body>");
        htmlLegend.append("</html>");
        return htmlLegend.toString();
    }

    public Color getColor(int type2, String colId, String colType) {
        Color c = Color.white;
        if (!this.isReady(6)) {
            return c;
        }
        switch (type2) {
            case 1: {
                this.infoAlignColor.setUseColor(this.use_color);
                c = this.infoAlignColor.getColor(colId, colType);
                break;
            }
            case 2: {
                if (this.infoGeneAttr[this.selectedSpec].size() != 0) {
                    this.infoGeneAttrColor[this.selectedSpec].setUseColor(this.use_color);
                    c = this.infoGeneAttrColor[this.selectedSpec].getColorFloat(colId);
                    break;
                }
                this.infoGeneColor[this.selectedSpec].setUseColor(this.use_color);
                c = this.infoGeneColor[this.selectedSpec].getColor(colId, colType);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.infoSegsColor[this.selectedSpec][type2 - 4].setUseColor(this.use_color);
                c = this.infoSegsColor[this.selectedSpec][type2 - 4].getColor(colId, colType);
                break;
            }
            case 12: {
                if (this.infoGeneAttr[this.selectedSpec].size() != 0) {
                    this.infoGeneAttrColor[this.oppositeSpec].setUseColor(this.use_color);
                    c = this.infoGeneAttrColor[this.oppositeSpec].getColorFloat(colId);
                    break;
                }
                this.infoGeneColor[this.oppositeSpec].setUseColor(this.use_color);
                c = this.infoGeneColor[this.oppositeSpec].getColor(colId, colType);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                this.infoSegsColor[this.oppositeSpec][type2 - 14].setUseColor(this.use_color);
                c = this.infoSegsColor[this.oppositeSpec][type2 - 14].getColor(colId, colType);
            }
        }
        return c;
    }

    public int getPattern(int type2, String patId, String patType) {
        if (!this.isReady(6)) {
            return 0;
        }
        return 0;
    }

    public String getType(int type2) {
        if (!this.isReady()) {
            return null;
        }
        switch (type2) {
            case 1: {
                return "align";
            }
            case 2: 
            case 12: {
                return this.infoGene[0].getDataName();
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return this.infoSegs[0][type2 % 10 - 4].getDataName();
            }
        }
        return null;
    }

    public Alignment[] selectAlignList(int regStart1, int regWidth1, int regMax1, int regStart, int regWidth, int regMax) {
        boolean baseSpec = this.selectedSpec == 0;
        Alignment[] alignList = this.infoAlign.selectAlignList(baseSpec, regStart1, regWidth1, regMax1, regStart, regWidth, regMax);
        if (this.selectedSpec != 0) {
            int loopMax = alignList.length;
            for (int i = 0; i < loopMax; ++i) {
                alignList[i].exchangeSpec();
            }
        }
        return alignList;
    }

    public Alignment[] selectAlignList(int regStart1, int regWidth1, int regMax1) {
        boolean baseSpec = this.selectedSpec == 0;
        Alignment[] alignList = this.infoAlign.selectAlignList(baseSpec, regStart1, regWidth1, regMax1);
        if (this.selectedSpec != 0) {
            int loopMax = alignList.length;
            for (int i = 0; i < loopMax; ++i) {
                alignList[i].exchangeSpec();
            }
        }
        return alignList;
    }

    public boolean isBaseSpec(int specNo) {
        return specNo == this.selectedSpec;
    }

    public void clearMarkEnt() {
        for (int i = 0; i < 2; ++i) {
            if (this.infoSearchOrf[i] == null) continue;
            this.infoSearchOrf[i].clearMark();
        }
    }

    public void delMarkEnt(String n) {
        for (int i = 0; i < 2; ++i) {
            if (this.infoSearchOrf[i] == null) continue;
            this.infoSearchOrf[i].delMark(n);
        }
    }

    public void addMarkEnt(boolean basespec, MarkEnt ent) {
        if (basespec) {
            this.addMarkEnt(this.selectedSpec, ent);
        } else {
            this.addMarkEnt(this.oppositeSpec, ent);
        }
    }

    public void addMarkEnt(int side, MarkEnt ent) {
        this.infoSearchOrf[side].addMark(ent);
    }

    public MarkEnt getMarkEnt(int side, String orfName) {
        return this.infoSearchOrf[side].getMark(orfName);
    }

    public MarkEnt[] getMarkEntAll(boolean basespec) {
        if (!this.isReady()) {
            return new MarkEnt[0];
        }
        if (basespec) {
            return this.infoSearchOrf[this.selectedSpec].getMarkAll();
        }
        return this.infoSearchOrf[this.oppositeSpec].getMarkAll();
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isReady()) {
            return;
        }
        this.exchangeBaseSpec();
    }

    public String getRegInfoUrl(int dataType) {
        switch (dataType) {
            case 2: 
            case 12: {
                return this.infoGeneUrl;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return this.infoSegsUrl[dataType % 10 - 4];
            }
        }
        return "";
    }

    public void update(Observable o, Object arg) {
        if (o instanceof DataLoader) {
            this.update((DataLoader)o, arg);
        }
    }

    public void update(DataLoader dataLoader, Object arg) {
        for (int i = 0; i < 2; ++i) {
            this.infoSearchOrf[i] = new MarkEntList();
        }
        this.setChanged();
        if (this.staSameSpecPair) {
            this.notifyObservers("segment");
        } else {
            this.notifyObservers();
        }
    }

    public void setMinAlignGaps(int d) {
        this.minAlignGap = d;
    }

    public int getMinAlignGaps() {
        return this.minAlignGap;
    }

    public void setAlignColorMode(int mode) {
        this.alignColorMode = mode;
        this.setChanged();
        this.notifyObservers("color");
    }

    public int getAlignColorMode() {
        return this.alignColorMode;
    }

    public void setUseColor(int uc) {
        this.use_color = uc;
        this.setChanged();
        this.notifyObservers("color");
    }

    public int getUseColor() {
        return this.use_color;
    }

    public void updateProperties() {
        String wk;
        int dbgLevel = this.getPropertyInt(OPT_DEBUG);
        Dbg.setDbgLevel(dbgLevel);
        String cgatHome = "";
        try {
            wk = System.getProperty("CGAT_HOME");
            if (wk != null) {
                cgatHome = wk;
            }
        }
        catch (Exception eSysProp) {
            // empty catch block
        }
        if (cgatHome.equals("") && (wk = this.getProperty(OPT_DIR_HOME)) != null) {
            cgatHome = wk;
        }
        this.setCgatHome(cgatHome);
        this.setProxy(this.getProperty(OPT_URL_PROXY));
        NUM_SEGS = this.getPropertyInt(OPT_MAX_SEGMENTS);
        if (NUM_SEGS < 1) {
            NUM_SEGS = 1;
        }
        if (5 < NUM_SEGS) {
            NUM_SEGS = 5;
        }
        this.setMaxSegNum(NUM_SEGS);
        if (this.infoGeneAttrColor != null) {
            if (this.infoGeneAttrColor[0] != null) {
                this.infoGeneAttrColor[0].updateDefaultColor();
            }
            if (this.infoGeneAttrColor[1] != null) {
                this.infoGeneAttrColor[1].updateDefaultColor();
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void loadProperties() {
        String fileProperty;
        InputStream is;
        String sep = System.getProperty("file.separator");
        try {
            is = this.getClass().getClassLoader().getResourceAsStream("cgat.properties");
            this.cgatProperties.load(is);
            Dbg.println(1, "Success :: loadProperties()");
        }
        catch (Exception eDefault) {
            Dbg.println(1, "Error :: loadProperties()");
        }
        try {
            String dirHome = System.getProperty("user.home");
            fileProperty = dirHome + sep + ".cgat" + sep + "cgat.properties";
            FileInputStream is2 = new FileInputStream(fileProperty);
            this.cgatProperties.load(is2);
            Dbg.println(1, "Success :: loadProperties() :: " + fileProperty);
        }
        catch (Exception eUserHome) {
            // empty catch block
        }
        try {
            String dirCgatHome = ".";
            fileProperty = dirCgatHome + sep + "cgat.properties";
            is = new FileInputStream(fileProperty);
            this.cgatProperties.load(is);
            Dbg.println(1, "Success :: loadProperties() :: " + fileProperty);
        }
        catch (Exception eCdir) {
            // empty catch block
        }
        try {
            fileProperty = System.getProperty("FILE_PARAM");
            is = new FileInputStream(fileProperty);
            this.cgatProperties.load(is);
            Dbg.println(1, "Success :: loadProperties() :: " + fileProperty);
        }
        catch (Exception eFileParam) {
            // empty catch block
        }
        this.loadUserProperties();
        this.updateProperties();
    }

    public void setProperty(Properties prop) {
        this.cgatProperties = prop;
        this.updateProperties();
    }

    public void setProperty(String key, String val) {
        if (key == null || key.equals("")) {
            return;
        }
        this.cgatProperties.setProperty(key, val);
    }

    public Properties getProperty() {
        return new Properties(this.cgatProperties);
    }

    public String getProperty(String key) {
        if (key == null || key.equals("")) {
            return null;
        }
        return this.cgatProperties.getProperty(key);
    }

    public int getPropertyInt(String key) {
        if (key == null || key.equals("")) {
            return 0;
        }
        int v = 0;
        try {
            v = Integer.parseInt(this.cgatProperties.getProperty(key));
        }
        catch (NumberFormatException nfe) {
            System.err.println("NumberFormatException :: Property [" + key + "] :: " + this.cgatProperties.getProperty(key));
        }
        return v;
    }

    public int getPropertyInt(String key, int radix) {
        if (key == null || key.equals("")) {
            return 0;
        }
        int v = Integer.parseInt(this.cgatProperties.getProperty(key), radix);
        return v;
    }

    public void setCgatHome(String h) {
        this.CgatHome = h;
    }

    public String getCgatHome() {
        return this.CgatHome;
    }

    public void setBasePath(String b) {
        if (b != null && !b.endsWith("/")) {
            b = b + "/";
        }
        this.basePath = b;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setDocBase(String db) {
        this.docBase = db;
    }

    public String getDocBase() {
        return this.docBase;
    }

    public void setCodeBase(String cb) {
        this.codeBase = cb;
    }

    public String getCodeBase() {
        return this.codeBase;
    }

    public void setBase(String db, String cb) {
        this.setDocBase(db);
        this.setCodeBase(cb);
    }

    public void saveUserProperties() {
        try {
            String val;
            String key;
            int i;
            String sep = System.getProperty("file.separator");
            String dirHome = System.getProperty("user.home");
            File dirCgat = new File(dirHome + sep + ".cgat");
            dirCgat.mkdir();
            Properties userProperty = new Properties();
            String[] lstKey = new String[]{OPT_DIR_HOME, OPT_URL_PROXY, OPT_BG_DARK, OPT_BG_LIGHT, OPT_DP_FRAME_DARK, OPT_DP_FRAME_LIGHT, OPT_AL_SEQ_MAT_DARK, OPT_AL_SEQ_MIS_DARK, OPT_AL_SEQ_GAP_DARK, OPT_AL_SEQ_MAT_LIGHT, OPT_AL_SEQ_MIS_LIGHT, OPT_AL_SEQ_GAP_LIGHT, OPT_AL_ID_H_DARK, OPT_AL_ID_M_DARK, OPT_AL_ID_L_DARK, OPT_AL_ID_H_LIGHT, OPT_AL_ID_M_LIGHT, OPT_AL_ID_L_LIGHT, OPT_AL_ID_H_PERCENT, OPT_AL_ID_M_PERCENT, OPT_AL_ID_L_PERCENT, OPT_MAX_SEGMENTS, OPT_PANEL_ALIGN_H, OPT_PANEL_GENE_H, OPT_PANEL_SEGMENT_H};
            for (i = 0; i < lstKey.length; ++i) {
                key = lstKey[i];
                val = this.getProperty(key);
                if (val == null) continue;
                userProperty.setProperty(key, val);
            }
            for (i = 0; i < 10; ++i) {
                key = OPT_URL_HOME + i;
                val = this.getProperty(key);
                if (val == null) continue;
                userProperty.setProperty(key, val);
            }
            File fileCgat = new File(dirCgat + sep + "user.properties");
            userProperty.store(new FileOutputStream(fileCgat), "cgat user properties");
            Dbg.println(1, "Success :: storeProperties() :: " + fileCgat);
        }
        catch (Exception e) {
            Dbg.println(1, e.toString());
        }
    }

    public void loadUserProperties() {
        try {
            String sep = System.getProperty("file.separator");
            String dirHome = System.getProperty("user.home");
            File dirCgat = new File(dirHome + sep + ".cgat");
            File fileCgat = new File(dirCgat + sep + "user.properties");
            this.cgatProperties.load(new FileInputStream(fileCgat));
            Dbg.println(1, "Success :: loadProperties() :: " + fileCgat);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setProxy(String p) {
        if (p == null) {
            p = "";
        }
        this.proxy = p.trim();
        String host = "";
        String port = "80";
        if (p.startsWith("http")) {
            int idx = p.indexOf(":", 6);
            int idx0 = p.indexOf("//");
            idx0 = idx0 < 0 ? 0 : (idx0 += 2);
            host = p.substring(idx0, idx);
            port = p.substring(idx + 1);
        } else {
            host = p;
        }
        try {
            System.setProperty("http.proxyHost", host);
            System.setProperty("http.proxyPort", port);
            Dbg.println(0, "http.proxyHost :: " + host);
            Dbg.println(0, "http.proxyPort :: " + port);
        }
        catch (AccessControlException ace) {
            // empty catch block
        }
    }

    public String getProxy() {
        return this.proxy;
    }

    public boolean isFilterAlignment() {
        return this.isFilterAlignment;
    }

    public boolean isFilterGene() {
        return this.isFilterGene;
    }

    public boolean isFilterSegment(int idx) {
        return this.isFilterSegment[idx];
    }

    public void setDefaultCgiPrograms() {
        this.CGI_getAlign = "/cgi-bin/getAlign.cgi?";
        this.CGI_getColorTab = "/cgi-bin/getColorTab.cgi?";
        this.CGI_getSequence = "/cgi-bin/getSequence.cgi?";
        this.CGI_getRegInfoUrl = "/cgi-bin/getRegInfoUrl.cgi?";
        this.CGI_getGene = "/cgi-bin/getGene.cgi?";
        this.CGI_getGeneAttr = "/cgi-bin/getGeneAttr.cgi?";
        this.CGI_getSegment = "/cgi-bin/getSegment.cgi?";
    }

    public void setMbgdCgiPrograms(String clustid) {
        String opt = "clustid=" + clustid + "&";
        this.CGI_getAlign = "/htbin/CGAT/getAlign.cgi?" + opt;
        this.CGI_getColorTab = "/htbin/CGAT/getColorTab.cgi?" + opt;
        this.CGI_getSequence = "/htbin/CGAT/getSequence.cgi?" + opt;
        this.CGI_getRegInfoUrl = "/htbin/CGAT/getRegInfoUrl.cgi?" + opt;
        this.CGI_getGene = "/htbin/CGAT/getGene.cgi?" + opt;
        this.CGI_getGeneAttr = "/htbin/CGAT/getGeneAttr.cgi?" + opt;
        this.CGI_getSegment = "/htbin/CGAT/getSegment.cgi?" + opt;
    }

    private static interface LOADSTAT {
        public static final int NONE = 0;
        public static final int SPECNAME = 1;
        public static final int ALIGNMENT = 2;
        public static final int GENOME = 3;
        public static final int GENE = 4;
        public static final int GENEATTR = 5;
        public static final int SEGMENT = 6;
        public static final int DONE = 10;
    }
}

