/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.Dbg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PropertyDialog {
    protected Properties prop;
    protected boolean staSelect = false;
    protected JFrame frame;
    protected JTabbedPane tabPane;
    public final String TXT_RESET_BTN = "Use Default Values";
    public final int PANEL_LOCATION = 0;
    public final int PANEL_COLOR = 1;
    public final int PANEL_PANEL = 2;
    public final int PANEL_ALIGNMENT = 3;
    public final String[][] lstPanelPropKey = new String[][]{{"cgat.dir.home", "cgat.url.proxy"}, {"cgat.color.bg.dark", "cgat.color.bg.light", "cgat.color.dotplot.frame.dark", "cgat.color.dotplot.frame.light", "cgat.alignment.sequence.color.match.dark", "cgat.alignment.sequence.color.match.light", "cgat.alignment.sequence.color.mismatch.dark", "cgat.alignment.sequence.color.mismatch.light", "cgat.alignment.sequence.color.gap.dark", "cgat.alignment.sequence.color.gap.light", "cgat.alignment.identity.color.high.dark", "cgat.alignment.identity.color.high.light", "cgat.alignment.identity.high.percent", "cgat.alignment.identity.high.percent", "cgat.alignment.identity.color.middle.dark", "cgat.alignment.identity.color.middle.light", "cgat.alignment.identity.middle.percent", "cgat.alignment.identity.middle.percent", "cgat.alignment.identity.color.low.dark", "cgat.alignment.identity.color.low.light", "cgat.alignment.identity.low.percent", "cgat.alignment.identity.low.percent", "cgat.gene.attr.color.high.dark", "cgat.gene.attr.color.high.light", "cgat.gene.attr.color.low.dark", "cgat.gene.attr.color.low.light"}, {"cgat.max.segments", "cgat.panel.alignment.alignment.height", "cgat.panel.alignment.alignment.height", "cgat.panel.alignment.gene.height", "cgat.panel.alignment.gene.height", "cgat.panel.alignment.segment.height", "cgat.panel.alignment.segment.height"}, {"cgat.dp.match", "cgat.dp.match", "cgat.dp.mismatch", "cgat.dp.mismatch", "cgat.dp.opengap", "cgat.dp.opengap", "cgat.dp.extgap", "cgat.dp.extgap", "cgat.alignment.max.realignment"}};
    protected JTextField tfLocCgat;
    protected JTextField tfLocServer;
    protected JTextField tfLocProxy;
    protected JList lstLocServer;
    protected Vector vctLocServer = new Vector();
    protected JButton btnColorBackgroundDark;
    protected JButton btnColorBackgroundLight;
    protected JButton btnColorDotPlotFrameDark;
    protected JButton btnColorDotPlotFrameLight;
    protected JButton btnColorMatchDark;
    protected JButton btnColorMatchLight;
    protected JButton btnColorMismatchDark;
    protected JButton btnColorMismatchLight;
    protected JButton btnColorGapDark;
    protected JButton btnColorGapLight;
    protected JButton btnColorIdentityHiDark;
    protected JButton btnColorIdentityHiLight;
    protected JButton btnColorIdentityMdDark;
    protected JButton btnColorIdentityMdLight;
    protected JButton btnColorIdentityLoDark;
    protected JButton btnColorIdentityLoLight;
    protected JButton btnColorGeneAttrHiDark;
    protected JButton btnColorGeneAttrHiLight;
    protected JButton btnColorGeneAttrLoDark;
    protected JButton btnColorGeneAttrLoLight;
    protected JTextField tfColorIdentityHi;
    protected JTextField tfColorIdentityMd;
    protected JTextField tfColorIdentityLo;
    protected JSlider slColorIdentityHi;
    protected JSlider slColorIdentityMd;
    protected JSlider slColorIdentityLo;
    protected JComboBox lstPanelMaxSegmentLane;
    protected JTextField tfPanelHeightAlignment;
    protected JTextField tfPanelHeightGene;
    protected JTextField tfPanelHeightSegment;
    protected JSlider slPanelHeightAlignment;
    protected JSlider slPanelHeightGene;
    protected JSlider slPanelHeightSegment;
    protected JTextField tfAlignMatch;
    protected JTextField tfAlignMismatch;
    protected JTextField tfAlignOpenGap;
    protected JTextField tfAlignExtGap;
    protected JTextField tfAlignEdgeGap;
    protected JSlider slAlignMatch;
    protected JSlider slAlignMismatch;
    protected JSlider slAlignOpenGap;
    protected JSlider slAlignExtGap;
    protected JSlider slAlignEdgeGap;
    protected JComboBox lstAlignSizeRealign;
    protected Vector vctRealign;

    public PropertyDialog(JFrame f, Properties p) {
        this.prop = new Properties(p);
        this.frame = f;
        this.setup();
        this.setValues();
    }

    public void setup() {
        JPanel panelLocations = this.createPanelLocations();
        JPanel panelColor = this.createPanelColor();
        JPanel panelPanel = this.createPanelPanel();
        JPanel panelAlignment = this.createPanelAlignment();
        this.tabPane = new JTabbedPane();
        this.tabPane.addTab("Locations", panelLocations);
        this.tabPane.addTab("Color", panelColor);
        this.tabPane.addTab("Panel", panelPanel);
        this.tabPane.addTab("Alignment", panelAlignment);
    }

    public void setValues() {
        this.setValuePanelLocations();
        this.setValuePanelColor();
        this.setValuePanelPanel();
        this.setValuePanelAlignment();
    }

    public JButton createColorButton() {
        JButton button = new JButton("Change Color");
        button.setOpaque(false);
        ButtonActionChangeColor al = new ButtonActionChangeColor(this.frame, button);
        button.addActionListener(al);
        return button;
    }

    public void setColorButton(JButton button, Color bgc) {
        button.setBackground(bgc);
        BufferedImage bi = new BufferedImage(10, 10, 5);
        Graphics2D g2d = bi.createGraphics();
        g2d.setColor(bgc);
        g2d.fillRect(0, 0, 10, 10);
        ImageIcon ii = new ImageIcon(bi);
        button.setIcon(ii);
    }

    public JPanel createPanelLocations() {
        JButton btnSrvDown;
        JButton btnSrvDel;
        JButton btnSrvUp;
        JButton btnSrvAdd;
        JButton btnSelCgatHome;
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        int y = 1;
        panel = new JPanel(gbl);
        int x = 1;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = ++y;
        JLabel label = new JLabel("CGAT_HOME");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        JTextField textField = this.tfLocCgat = new JTextField(30);
        panel.add((Component)textField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y++;
        gbc.fill = 2;
        JButton button = btnSelCgatHome = new JButton("Choose");
        btnSelCgatHome.addActionListener(new ButtonActionChooseCgatHome(this.tfLocCgat));
        panel.add((Component)button, gbc);
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        label = new JLabel("Server URL");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        textField = this.tfLocServer = new JTextField(30);
        panel.add((Component)textField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y++;
        gbc.fill = 2;
        button = btnSrvAdd = new JButton("Add");
        panel.add((Component)button, gbc);
        x = 2;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        gbc.fill = 1;
        JList list = this.lstLocServer = new JList();
        JScrollPane jsp = new JScrollPane(list);
        panel.add((Component)jsp, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y++;
        gbc.fill = 2;
        JPanel panelBtn = new JPanel(new GridLayout(3, 1));
        button = btnSrvUp = new JButton("Up");
        panelBtn.add(btnSrvUp);
        button = btnSrvDel = new JButton("Remove");
        panelBtn.add(btnSrvDel);
        button = btnSrvDown = new JButton("Down");
        panelBtn.add(btnSrvDown);
        panel.add((Component)panelBtn, gbc);
        btnSrvAdd.addActionListener(new ButtonActionAddServer(list, this.vctLocServer, this.tfLocServer));
        btnSrvUp.addActionListener(new ButtonActionUpServer(list, this.vctLocServer));
        btnSrvDel.addActionListener(new ButtonActionDelServer(list, this.vctLocServer, this.tfLocServer));
        btnSrvDown.addActionListener(new ButtonActionDownServer(list, this.vctLocServer));
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        label = new JLabel("Proxy URL");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        textField = this.tfLocProxy = new JTextField(30);
        panel.add((Component)textField, gbc);
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new BorderLayout());
        basePanel.add((Component)panel, "Center");
        JPanel subPanel = new JPanel();
        button = new JButton("Use Default Values");
        subPanel.add(button);
        basePanel.add((Component)subPanel, "South");
        button.addActionListener(new ResetAllProperties(0));
        return basePanel;
    }

    public void setValuePanelLocations() {
        String val = this.prop.getProperty("cgat.dir.home");
        this.tfLocCgat.setText(val);
        this.tfLocServer.setText("");
        this.vctLocServer.clear();
        for (int i = 0; i < 10; ++i) {
            String key = "cgat.url.home" + i;
            val = this.prop.getProperty(key);
            if (val == null || "".equals(val = val.trim())) continue;
            this.vctLocServer.add(val);
        }
        this.lstLocServer.setListData(this.vctLocServer);
        val = this.prop.getProperty("cgat.url.proxy");
        this.tfLocProxy.setText(val);
    }

    public JPanel createPanelColor() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        int y = 1;
        panel = new JPanel(gbl);
        int x = 2;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        JLabel label = new JLabel("Dark");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y++;
        label = new JLabel("Light");
        panel.add((Component)label, gbc);
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        label = new JLabel("Background for Alignment/DotPlot");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        JButton button = this.btnColorBackgroundDark = this.createColorButton();
        panel.add((Component)button, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y++;
        button = this.btnColorBackgroundLight = this.createColorButton();
        panel.add((Component)button, gbc);
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        label = new JLabel("Viewing Frame for DotPlot");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        button = this.btnColorDotPlotFrameDark = this.createColorButton();
        panel.add((Component)button, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y++;
        button = this.btnColorDotPlotFrameLight = this.createColorButton();
        panel.add((Component)button, gbc);
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        label = new JLabel("Match");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        button = this.btnColorMatchDark = this.createColorButton();
        panel.add((Component)button, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y++;
        button = this.btnColorMatchLight = this.createColorButton();
        panel.add((Component)button, gbc);
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        label = new JLabel("Mismatch");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        button = this.btnColorMismatchDark = this.createColorButton();
        panel.add((Component)button, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y++;
        button = this.btnColorMismatchLight = this.createColorButton();
        panel.add((Component)button, gbc);
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        label = new JLabel("Gap");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        button = this.btnColorGapDark = this.createColorButton();
        panel.add((Component)button, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y++;
        button = this.btnColorGapLight = this.createColorButton();
        panel.add((Component)button, gbc);
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        gbc.gridheight = 2;
        label = new JLabel("Identity(High)");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        button = this.btnColorIdentityHiDark = this.createColorButton();
        panel.add((Component)button, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y++;
        button = this.btnColorIdentityHiLight = this.createColorButton();
        panel.add((Component)button, gbc);
        x = 2;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        gbc.gridwidth = 2;
        int slMin = 0;
        int slMax = 100;
        JSlider slider = this.slColorIdentityHi = new JSlider(slMin, slMax);
        slider.setMajorTickSpacing(50);
        slider.setMinorTickSpacing(10);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        panel.add((Component)slider, gbc);
        gbc = new GridBagConstraints();
        int n = ++x;
        ++x;
        gbc.gridx = n;
        gbc.gridy = y++;
        JTextField textField = this.tfColorIdentityHi = new JTextField(5);
        panel.add((Component)textField, gbc);
        textField.addActionListener(new TextFieldChanged(slMin, slMax, slider));
        slider.addChangeListener(new SliderStateChanged(textField));
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        gbc.gridheight = 2;
        label = new JLabel("Identity(Middle)");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        button = this.btnColorIdentityMdDark = this.createColorButton();
        panel.add((Component)button, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y++;
        button = this.btnColorIdentityMdLight = this.createColorButton();
        panel.add((Component)button, gbc);
        x = 2;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        gbc.gridwidth = 2;
        slMin = 0;
        slMax = 100;
        slider = this.slColorIdentityMd = new JSlider(slMin, slMax);
        slider.setMajorTickSpacing(50);
        slider.setMinorTickSpacing(10);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        panel.add((Component)slider, gbc);
        gbc = new GridBagConstraints();
        int n2 = ++x;
        ++x;
        gbc.gridx = n2;
        gbc.gridy = y++;
        textField = this.tfColorIdentityMd = new JTextField(5);
        panel.add((Component)textField, gbc);
        textField.addActionListener(new TextFieldChanged(slMin, slMax, slider));
        slider.addChangeListener(new SliderStateChanged(textField));
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        gbc.gridheight = 2;
        label = new JLabel("Identity(low)");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        button = this.btnColorIdentityLoDark = this.createColorButton();
        panel.add((Component)button, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y++;
        button = this.btnColorIdentityLoLight = this.createColorButton();
        panel.add((Component)button, gbc);
        x = 2;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        gbc.gridwidth = 2;
        slMin = 0;
        slMax = 100;
        slider = this.slColorIdentityLo = new JSlider(slMin, slMax);
        slider.setMajorTickSpacing(50);
        slider.setMinorTickSpacing(10);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        panel.add((Component)slider, gbc);
        gbc = new GridBagConstraints();
        int n3 = ++x;
        ++x;
        gbc.gridx = n3;
        gbc.gridy = y++;
        textField = this.tfColorIdentityLo = new JTextField(5);
        panel.add((Component)textField, gbc);
        textField.addActionListener(new TextFieldChanged(slMin, slMax, slider));
        slider.addChangeListener(new SliderStateChanged(textField));
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        label = new JLabel("Gene Attribute(High)");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        button = this.btnColorGeneAttrHiDark = this.createColorButton();
        panel.add((Component)button, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y++;
        button = this.btnColorGeneAttrHiLight = this.createColorButton();
        panel.add((Component)button, gbc);
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        label = new JLabel("Gene Attribute(Low)");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        button = this.btnColorGeneAttrLoDark = this.createColorButton();
        panel.add((Component)button, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        button = this.btnColorGeneAttrLoLight = this.createColorButton();
        panel.add((Component)button, gbc);
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new BorderLayout());
        basePanel.add((Component)panel, "Center");
        JPanel subPanel = new JPanel();
        button = new JButton("Use Default Values");
        subPanel.add(button);
        basePanel.add((Component)subPanel, "South");
        button.addActionListener(new ResetAllProperties(1));
        return basePanel;
    }

    public void setValuePanelColor() {
        Color c = new Color(Integer.parseInt(this.prop.getProperty("cgat.color.bg.dark"), 16));
        this.setColorButton(this.btnColorBackgroundDark, c);
        c = new Color(Integer.parseInt(this.prop.getProperty("cgat.color.bg.light"), 16));
        this.setColorButton(this.btnColorBackgroundLight, c);
        c = new Color(Integer.parseInt(this.prop.getProperty("cgat.color.dotplot.frame.dark"), 16));
        this.setColorButton(this.btnColorDotPlotFrameDark, c);
        c = new Color(Integer.parseInt(this.prop.getProperty("cgat.color.dotplot.frame.light"), 16));
        this.setColorButton(this.btnColorDotPlotFrameLight, c);
        c = new Color(Integer.parseInt(this.prop.getProperty("cgat.alignment.sequence.color.match.dark"), 16));
        this.setColorButton(this.btnColorMatchDark, c);
        c = new Color(Integer.parseInt(this.prop.getProperty("cgat.alignment.sequence.color.match.light"), 16));
        this.setColorButton(this.btnColorMatchLight, c);
        c = new Color(Integer.parseInt(this.prop.getProperty("cgat.alignment.sequence.color.mismatch.dark"), 16));
        this.setColorButton(this.btnColorMismatchDark, c);
        c = new Color(Integer.parseInt(this.prop.getProperty("cgat.alignment.sequence.color.mismatch.light"), 16));
        this.setColorButton(this.btnColorMismatchLight, c);
        c = new Color(Integer.parseInt(this.prop.getProperty("cgat.alignment.sequence.color.gap.dark"), 16));
        this.setColorButton(this.btnColorGapDark, c);
        c = new Color(Integer.parseInt(this.prop.getProperty("cgat.alignment.sequence.color.gap.light"), 16));
        this.setColorButton(this.btnColorGapLight, c);
        c = new Color(Integer.parseInt(this.prop.getProperty("cgat.alignment.identity.color.high.dark"), 16));
        this.setColorButton(this.btnColorIdentityHiDark, c);
        c = new Color(Integer.parseInt(this.prop.getProperty("cgat.alignment.identity.color.high.light"), 16));
        this.setColorButton(this.btnColorIdentityHiLight, c);
        String val = this.prop.getProperty("cgat.alignment.identity.high.percent");
        this.slColorIdentityHi.setValue(Integer.parseInt(val));
        val = this.prop.getProperty("cgat.alignment.identity.high.percent");
        this.tfColorIdentityHi.setText(val);
        c = new Color(Integer.parseInt(this.prop.getProperty("cgat.alignment.identity.color.middle.dark"), 16));
        this.setColorButton(this.btnColorIdentityMdDark, c);
        c = new Color(Integer.parseInt(this.prop.getProperty("cgat.alignment.identity.color.middle.light"), 16));
        this.setColorButton(this.btnColorIdentityMdLight, c);
        val = this.prop.getProperty("cgat.alignment.identity.middle.percent");
        this.slColorIdentityMd.setValue(Integer.parseInt(val));
        val = this.prop.getProperty("cgat.alignment.identity.middle.percent");
        this.tfColorIdentityMd.setText(val);
        c = new Color(Integer.parseInt(this.prop.getProperty("cgat.alignment.identity.color.low.dark"), 16));
        this.setColorButton(this.btnColorIdentityLoDark, c);
        c = new Color(Integer.parseInt(this.prop.getProperty("cgat.alignment.identity.color.low.light"), 16));
        this.setColorButton(this.btnColorIdentityLoLight, c);
        val = this.prop.getProperty("cgat.alignment.identity.low.percent");
        this.slColorIdentityLo.setValue(Integer.parseInt(val));
        val = this.prop.getProperty("cgat.alignment.identity.low.percent");
        this.tfColorIdentityLo.setText(val);
        c = new Color(Integer.parseInt(this.prop.getProperty("cgat.gene.attr.color.high.dark"), 16));
        this.setColorButton(this.btnColorGeneAttrHiDark, c);
        c = new Color(Integer.parseInt(this.prop.getProperty("cgat.gene.attr.color.high.light"), 16));
        this.setColorButton(this.btnColorGeneAttrHiLight, c);
        c = new Color(Integer.parseInt(this.prop.getProperty("cgat.gene.attr.color.low.dark"), 16));
        this.setColorButton(this.btnColorGeneAttrLoDark, c);
        c = new Color(Integer.parseInt(this.prop.getProperty("cgat.gene.attr.color.low.light"), 16));
        this.setColorButton(this.btnColorGeneAttrLoLight, c);
    }

    public JPanel createPanelPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        int y = 1;
        String[] listNumSeg = new String[]{"1", "2", "3", "4", "5"};
        panel = new JPanel(gbl);
        int x = 1;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        JLabel label = new JLabel("Maximan # of Segment Tracks");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y++;
        JComboBox<String> list = this.lstPanelMaxSegmentLane = new JComboBox<String>(listNumSeg);
        Dimension dim = list.getMinimumSize();
        dim.width = 40;
        list.setMinimumSize(dim);
        list.setPreferredSize(dim);
        panel.add(list, gbc);
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        label = new JLabel("Height of Alignment Area");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        gbc.gridwidth = 2;
        int slMin = 50;
        int slMax = 250;
        JSlider slider = this.slPanelHeightAlignment = new JSlider(slMin, slMax);
        slider.setMajorTickSpacing(50);
        slider.setMinorTickSpacing(10);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        panel.add((Component)slider, gbc);
        gbc = new GridBagConstraints();
        int n = ++x;
        ++x;
        gbc.gridx = n;
        gbc.gridy = y++;
        JTextField textField = this.tfPanelHeightAlignment = new JTextField(5);
        panel.add((Component)textField, gbc);
        textField.addActionListener(new TextFieldChanged(slMin, slMax, slider));
        slider.addChangeListener(new SliderStateChanged(textField));
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        label = new JLabel("Height of Gene Area");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        gbc.gridwidth = 2;
        slMin = 50;
        slMax = 250;
        slider = this.slPanelHeightGene = new JSlider(slMin, slMax);
        slider.setMajorTickSpacing(50);
        slider.setMinorTickSpacing(10);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        panel.add((Component)slider, gbc);
        gbc = new GridBagConstraints();
        int n2 = ++x;
        ++x;
        gbc.gridx = n2;
        gbc.gridy = y++;
        textField = this.tfPanelHeightGene = new JTextField(5);
        panel.add((Component)textField, gbc);
        textField.addActionListener(new TextFieldChanged(slMin, slMax, slider));
        slider.addChangeListener(new SliderStateChanged(textField));
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        label = new JLabel("Height of Segment Area");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        gbc.gridwidth = 2;
        slMin = 50;
        slMax = 250;
        slider = this.slPanelHeightSegment = new JSlider(slMin, slMax);
        slider.setMajorTickSpacing(50);
        slider.setMinorTickSpacing(10);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        panel.add((Component)slider, gbc);
        gbc = new GridBagConstraints();
        int n3 = ++x;
        ++x;
        gbc.gridx = n3;
        gbc.gridy = y;
        textField = this.tfPanelHeightSegment = new JTextField(5);
        panel.add((Component)textField, gbc);
        textField.addActionListener(new TextFieldChanged(slMin, slMax, slider));
        slider.addChangeListener(new SliderStateChanged(textField));
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new BorderLayout());
        basePanel.add((Component)panel, "Center");
        JPanel subPanel = new JPanel();
        JButton button = new JButton("Use Default Values");
        subPanel.add(button);
        basePanel.add((Component)subPanel, "South");
        button.addActionListener(new ResetAllProperties(2));
        return basePanel;
    }

    public void setValuePanelPanel() {
        String val = this.prop.getProperty("cgat.max.segments");
        this.lstPanelMaxSegmentLane.setSelectedIndex(Integer.parseInt(val) - 1);
        val = this.prop.getProperty("cgat.panel.alignment.alignment.height");
        this.slPanelHeightAlignment.setValue(Integer.parseInt(val));
        val = this.prop.getProperty("cgat.panel.alignment.alignment.height");
        this.tfPanelHeightAlignment.setText(val);
        val = this.prop.getProperty("cgat.panel.alignment.gene.height");
        this.slPanelHeightGene.setValue(Integer.parseInt(val));
        val = this.prop.getProperty("cgat.panel.alignment.gene.height");
        this.tfPanelHeightGene.setText(val);
        val = this.prop.getProperty("cgat.panel.alignment.segment.height");
        this.slPanelHeightSegment.setValue(Integer.parseInt(val));
        val = this.prop.getProperty("cgat.panel.alignment.segment.height");
        this.tfPanelHeightSegment.setText(val);
    }

    public JPanel createPanelAlignment() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        int y = 1;
        panel = new JPanel(gbl);
        int x = 1;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y++;
        JLabel label = new JLabel("Parameter for Dynamic Programming");
        panel.add((Component)label, gbc);
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        label = new JLabel("Match Score");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        gbc.gridwidth = 2;
        int slMin = 0;
        int slMax = 20;
        JSlider slider = this.slAlignMatch = new JSlider(slMin, slMax);
        slider.setMajorTickSpacing(5);
        slider.setMinorTickSpacing(1);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        panel.add((Component)slider, gbc);
        gbc = new GridBagConstraints();
        int n = ++x;
        ++x;
        gbc.gridx = n;
        gbc.gridy = y++;
        JTextField textField = this.tfAlignMatch = new JTextField(5);
        panel.add((Component)textField, gbc);
        textField.addActionListener(new TextFieldChanged(slMin, slMax, slider));
        slider.addChangeListener(new SliderStateChanged(textField, 0, 1));
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        label = new JLabel("Mismatch Score");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        gbc.gridwidth = 2;
        slMin = -20;
        slMax = 0;
        slider = this.slAlignMismatch = new JSlider(slMin, slMax);
        slider.setMajorTickSpacing(5);
        slider.setMinorTickSpacing(1);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        panel.add((Component)slider, gbc);
        gbc = new GridBagConstraints();
        int n2 = ++x;
        ++x;
        gbc.gridx = n2;
        gbc.gridy = y++;
        textField = this.tfAlignMismatch = new JTextField(5);
        panel.add((Component)textField, gbc);
        textField.addActionListener(new TextFieldChanged(slMin, slMax, slider));
        slider.addChangeListener(new SliderStateChanged(textField));
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        label = new JLabel("Open Gap Penalty");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        gbc.gridwidth = 2;
        slMin = -20;
        slMax = 0;
        slider = this.slAlignOpenGap = new JSlider(slMin, slMax);
        slider.setMajorTickSpacing(5);
        slider.setMinorTickSpacing(1);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        panel.add((Component)slider, gbc);
        gbc = new GridBagConstraints();
        int n3 = ++x;
        ++x;
        gbc.gridx = n3;
        gbc.gridy = y++;
        textField = this.tfAlignOpenGap = new JTextField(5);
        panel.add((Component)textField, gbc);
        textField.addActionListener(new TextFieldChanged(slMin, slMax, slider));
        slider.addChangeListener(new SliderStateChanged(textField));
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        label = new JLabel("Extension Gap Penalty");
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        gbc.gridwidth = 2;
        slMin = -20;
        slMax = 0;
        slider = this.slAlignExtGap = new JSlider(slMin, slMax);
        slider.setMajorTickSpacing(5);
        slider.setMinorTickSpacing(1);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        panel.add((Component)slider, gbc);
        gbc = new GridBagConstraints();
        int n4 = ++x;
        ++x;
        gbc.gridx = n4;
        gbc.gridy = y++;
        textField = this.tfAlignExtGap = new JTextField(5);
        panel.add((Component)textField, gbc);
        textField.addActionListener(new TextFieldChanged(slMin, slMax, slider));
        slider.addChangeListener(new SliderStateChanged(textField));
        x = 1;
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        label = new JLabel("Size of Realignment");
        panel.add((Component)label, gbc);
        this.vctRealign = new Vector();
        this.vctRealign.add("1000");
        this.vctRealign.add("2000");
        this.vctRealign.add("3000");
        this.vctRealign.add("5000");
        this.vctRealign.add("10000");
        gbc = new GridBagConstraints();
        gbc.gridx = x++;
        gbc.gridy = y;
        gbc.gridwidth = 2;
        ++x;
        JComboBox list = this.lstAlignSizeRealign = new JComboBox(this.vctRealign);
        panel.add(list, gbc);
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new BorderLayout());
        basePanel.add((Component)panel, "Center");
        JPanel subPanel = new JPanel();
        JButton button = new JButton("Use Default Values");
        subPanel.add(button);
        basePanel.add((Component)subPanel, "South");
        button.addActionListener(new ResetAllProperties(3));
        return basePanel;
    }

    public void setValuePanelAlignment() {
        String val = this.prop.getProperty("cgat.dp.match");
        this.slAlignMatch.setValue(Integer.parseInt(val));
        val = this.prop.getProperty("cgat.dp.match");
        this.tfAlignMatch.setText(val);
        val = this.prop.getProperty("cgat.dp.mismatch");
        this.slAlignMismatch.setValue(Integer.parseInt(val));
        val = this.prop.getProperty("cgat.dp.mismatch");
        this.tfAlignMismatch.setText(val);
        val = this.prop.getProperty("cgat.dp.opengap");
        this.slAlignOpenGap.setValue(Integer.parseInt(val));
        val = this.prop.getProperty("cgat.dp.opengap");
        this.tfAlignOpenGap.setText(val);
        val = this.prop.getProperty("cgat.dp.extgap");
        this.slAlignExtGap.setValue(Integer.parseInt(val));
        val = this.prop.getProperty("cgat.dp.extgap");
        this.tfAlignExtGap.setText(val);
        val = this.prop.getProperty("cgat.alignment.max.realignment");
        int idx = this.vctRealign.indexOf(val);
        if (idx < 0) {
            idx = 0;
        }
        this.lstAlignSizeRealign.setSelectedIndex(idx);
    }

    public void showDialog() {
        int ret = JOptionPane.showConfirmDialog(this.frame.getContentPane(), this.tabPane, "CGAT Properties", 2, -1);
        this.staSelect = false;
        if (ret == 0) {
            this.staSelect = true;
        }
    }

    public boolean getStaSelect() {
        return this.staSelect;
    }

    public void updateProperties() {
        String v = this.tfLocCgat.getText();
        this.prop.setProperty("cgat.dir.home", v);
        for (int i = 0; i < 10; ++i) {
            String key = "cgat.url.home" + i;
            try {
                v = (String)this.vctLocServer.get(i);
            }
            catch (Exception e) {
                v = "";
            }
            if (v == null) {
                v = "";
            }
            this.prop.setProperty(key, v);
        }
        v = this.tfLocProxy.getText();
        this.prop.setProperty("cgat.url.proxy", v);
        Color c = this.btnColorBackgroundDark.getBackground();
        this.prop.setProperty("cgat.color.bg.dark", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        c = this.btnColorBackgroundLight.getBackground();
        this.prop.setProperty("cgat.color.bg.light", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        c = this.btnColorDotPlotFrameDark.getBackground();
        this.prop.setProperty("cgat.color.dotplot.frame.dark", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        c = this.btnColorDotPlotFrameLight.getBackground();
        this.prop.setProperty("cgat.color.dotplot.frame.light", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        c = this.btnColorMatchDark.getBackground();
        this.prop.setProperty("cgat.alignment.sequence.color.match.dark", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        c = this.btnColorMatchLight.getBackground();
        this.prop.setProperty("cgat.alignment.sequence.color.match.light", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        c = this.btnColorMismatchDark.getBackground();
        this.prop.setProperty("cgat.alignment.sequence.color.mismatch.dark", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        c = this.btnColorMismatchLight.getBackground();
        this.prop.setProperty("cgat.alignment.sequence.color.mismatch.light", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        c = this.btnColorGapDark.getBackground();
        this.prop.setProperty("cgat.alignment.sequence.color.gap.dark", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        c = this.btnColorGapLight.getBackground();
        this.prop.setProperty("cgat.alignment.sequence.color.gap.light", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        c = this.btnColorIdentityHiDark.getBackground();
        this.prop.setProperty("cgat.alignment.identity.color.high.dark", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        c = this.btnColorIdentityHiLight.getBackground();
        this.prop.setProperty("cgat.alignment.identity.color.high.light", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        c = this.btnColorIdentityMdDark.getBackground();
        this.prop.setProperty("cgat.alignment.identity.color.middle.dark", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        c = this.btnColorIdentityMdLight.getBackground();
        this.prop.setProperty("cgat.alignment.identity.color.middle.light", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        c = this.btnColorIdentityLoDark.getBackground();
        this.prop.setProperty("cgat.alignment.identity.color.low.dark", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        c = this.btnColorIdentityLoLight.getBackground();
        this.prop.setProperty("cgat.alignment.identity.color.low.light", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        v = this.tfColorIdentityHi.getText();
        try {
            double d = Double.parseDouble(v);
            if (0.0 < d) {
                this.prop.setProperty("cgat.alignment.identity.high.percent", v);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        v = this.tfColorIdentityMd.getText();
        try {
            double d = Double.parseDouble(v);
            if (0.0 < d) {
                this.prop.setProperty("cgat.alignment.identity.middle.percent", v);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        v = this.tfColorIdentityLo.getText();
        try {
            double d = Double.parseDouble(v);
            if (0.0 < d) {
                this.prop.setProperty("cgat.alignment.identity.low.percent", v);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        c = this.btnColorGeneAttrHiDark.getBackground();
        this.prop.setProperty("cgat.gene.attr.color.high.dark", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        c = this.btnColorGeneAttrHiLight.getBackground();
        this.prop.setProperty("cgat.gene.attr.color.high.light", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        c = this.btnColorGeneAttrLoDark.getBackground();
        this.prop.setProperty("cgat.gene.attr.color.low.dark", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        c = this.btnColorGeneAttrLoLight.getBackground();
        this.prop.setProperty("cgat.gene.attr.color.low.light", Integer.toHexString(c.getRGB() & 0xFFFFFF));
        v = (String)this.lstPanelMaxSegmentLane.getSelectedItem();
        try {
            int i = Integer.parseInt(v);
            if (1 <= i && i <= 5) {
                this.prop.setProperty("cgat.max.segments", v);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        v = this.tfPanelHeightAlignment.getText();
        try {
            int i = Integer.parseInt(v);
            this.prop.setProperty("cgat.panel.alignment.alignment.height", v);
        }
        catch (Exception e) {
            // empty catch block
        }
        v = this.tfPanelHeightGene.getText();
        try {
            int i = Integer.parseInt(v);
            this.prop.setProperty("cgat.panel.alignment.gene.height", v);
        }
        catch (Exception e) {
            // empty catch block
        }
        v = this.tfPanelHeightSegment.getText();
        try {
            int i = Integer.parseInt(v);
            this.prop.setProperty("cgat.panel.alignment.segment.height", v);
        }
        catch (Exception e) {
            // empty catch block
        }
        v = this.tfAlignMatch.getText();
        try {
            int i = Integer.parseInt(v);
            this.prop.setProperty("cgat.dp.match", v);
        }
        catch (Exception e) {
            // empty catch block
        }
        v = this.tfAlignMismatch.getText();
        try {
            int i = Integer.parseInt(v);
            this.prop.setProperty("cgat.dp.mismatch", v);
        }
        catch (Exception e) {
            // empty catch block
        }
        v = this.tfAlignOpenGap.getText();
        try {
            int i = Integer.parseInt(v);
            this.prop.setProperty("cgat.dp.opengap", v);
        }
        catch (Exception e) {
            // empty catch block
        }
        v = this.tfAlignExtGap.getText();
        try {
            int i = Integer.parseInt(v);
            this.prop.setProperty("cgat.dp.extgap", v);
        }
        catch (Exception e) {
            // empty catch block
        }
        v = this.tfAlignOpenGap.getText();
        try {
            int i = Integer.parseInt(v);
            this.prop.setProperty("cgat.dp.edgegap", v);
        }
        catch (Exception e) {
            // empty catch block
        }
        v = (String)this.lstAlignSizeRealign.getSelectedItem();
        try {
            int i = Integer.parseInt(v);
            if (0 < i) {
                this.prop.setProperty("cgat.alignment.max.realignment", v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Properties getProperties() {
        return this.prop;
    }

    public void loadDefaultProperties(int idx) {
        String val;
        String key;
        int i;
        Properties tmpProp = new Properties();
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("cgat.properties");
            tmpProp.load(is);
            Dbg.println(1, "Success :: loadProperties()");
        }
        catch (Exception eDefault) {
            Dbg.println(1, "Error :: loadProperties()");
        }
        for (i = 0; i < this.lstPanelPropKey[idx].length; ++i) {
            key = this.lstPanelPropKey[idx][i];
            val = tmpProp.getProperty(key);
            this.prop.remove(key);
            if (val == null) continue;
            this.prop.setProperty(key, val);
        }
        if (idx == 0) {
            for (i = 0; i < 10; ++i) {
                key = "cgat.url.home" + i;
                val = tmpProp.getProperty(key);
                this.prop.remove(key);
                if (val == null) continue;
                this.prop.setProperty(key, val);
            }
        }
    }

    class ResetAllProperties
    implements ActionListener {
        protected int idxPanel;

        public ResetAllProperties(int idx) {
            this.idxPanel = idx;
        }

        public void actionPerformed(ActionEvent e) {
            PropertyDialog.this.loadDefaultProperties(this.idxPanel);
            switch (this.idxPanel) {
                case 0: {
                    PropertyDialog.this.setValuePanelLocations();
                    break;
                }
                case 1: {
                    PropertyDialog.this.setValuePanelColor();
                    break;
                }
                case 2: {
                    PropertyDialog.this.setValuePanelPanel();
                    break;
                }
                case 3: {
                    PropertyDialog.this.setValuePanelAlignment();
                    break;
                }
            }
            PropertyDialog.this.frame.validate();
        }
    }

    class SliderStateChanged
    implements ChangeListener {
        protected JTextField textfield;
        protected Integer ngVal = null;
        protected Integer okVal = null;

        public SliderStateChanged(JTextField tf) {
            this.textfield = tf;
        }

        public SliderStateChanged(JTextField tf, int ng, int ok) {
            this.textfield = tf;
            this.ngVal = new Integer(ng);
            this.okVal = new Integer(ok);
        }

        public void stateChanged(ChangeEvent e) {
            JSlider slider = (JSlider)e.getSource();
            int v = slider.getValue();
            if (this.ngVal != null && this.ngVal == v) {
                v = this.okVal;
                slider.setValue(v);
                slider.validate();
            }
            this.textfield.setText("" + v);
        }
    }

    class TextFieldChanged
    implements ActionListener {
        protected int slMin;
        protected int slMax;
        protected JSlider slider;

        public TextFieldChanged(int min, int max, JSlider s) {
            this.slMin = min;
            this.slMax = max;
            this.slider = s;
        }

        public void actionPerformed(ActionEvent e) {
            JTextField tf = (JTextField)e.getSource();
            String val = tf.getText();
            try {
                int v = Integer.parseInt(val);
                if (v < this.slMin) {
                    v = this.slMin;
                    tf.setText("" + v);
                }
                if (this.slMax < v) {
                    v = this.slMax;
                    tf.setText("" + v);
                }
                this.slider.setValue(v);
            }
            catch (Exception tfce) {
                tf.setText("" + this.slider.getValue());
            }
        }
    }

    class ButtonActionDownServer
    implements ActionListener {
        protected JList list;
        protected Vector vector;

        public ButtonActionDownServer(JList l, Vector v) {
            this.list = l;
            this.vector = v;
        }

        public void actionPerformed(ActionEvent e) {
            int selIdx = this.list.getSelectedIndex();
            if (selIdx < 0) {
                return;
            }
            if (selIdx == this.vector.size() - 1) {
                return;
            }
            String servSel = (String)this.vector.get(selIdx);
            this.vector.removeElementAt(selIdx);
            this.vector.insertElementAt(servSel, selIdx + 1);
            this.list.setListData(this.vector);
            this.list.setSelectedIndex(selIdx + 1);
        }
    }

    class ButtonActionDelServer
    implements ActionListener {
        protected JList list;
        protected Vector vector;
        protected JTextField text;

        public ButtonActionDelServer(JList l, Vector v, JTextField tf) {
            this.list = l;
            this.vector = v;
            this.text = tf;
        }

        public void actionPerformed(ActionEvent e) {
            int selIdx = this.list.getSelectedIndex();
            if (selIdx < 0) {
                return;
            }
            String serv = (String)this.vector.get(selIdx);
            this.vector.removeElementAt(selIdx);
            this.list.setListData(this.vector);
            this.text.setText(serv);
        }
    }

    class ButtonActionUpServer
    implements ActionListener {
        protected JList list;
        protected Vector vector;

        public ButtonActionUpServer(JList l, Vector v) {
            this.list = l;
            this.vector = v;
        }

        public void actionPerformed(ActionEvent e) {
            int selIdx = this.list.getSelectedIndex();
            if (selIdx < 0) {
                return;
            }
            if (selIdx == 0) {
                return;
            }
            String servSel = (String)this.vector.get(selIdx);
            this.vector.removeElementAt(selIdx);
            this.vector.insertElementAt(servSel, selIdx - 1);
            this.list.setListData(this.vector);
            this.list.setSelectedIndex(selIdx - 1);
        }
    }

    class ButtonActionAddServer
    implements ActionListener {
        protected JList list;
        protected Vector vector;
        protected JTextField text;

        public ButtonActionAddServer(JList l, Vector v, JTextField tf) {
            this.list = l;
            this.text = tf;
            this.vector = v;
        }

        public void actionPerformed(ActionEvent e) {
            String serv = this.text.getText().trim();
            if ("".equals(serv)) {
                return;
            }
            if (10 <= this.vector.size()) {
                return;
            }
            this.vector.add(serv);
            this.list.setListData(this.vector);
        }
    }

    class ButtonActionChooseCgatHome
    implements ActionListener {
        protected JFileChooser fc;
        protected JTextField text;

        public ButtonActionChooseCgatHome(JTextField tf) {
            this.text = tf;
            this.fc = new JFileChooser();
            this.fc.setFileSelectionMode(1);
        }

        public void actionPerformed(ActionEvent e) {
            int ret = this.fc.showOpenDialog(PropertyDialog.this.frame);
            if (ret == 0) {
                this.text.setText(this.fc.getSelectedFile().getPath());
            }
        }
    }

    class ButtonActionChangeColor
    implements ActionListener {
        protected JFrame ccFrame;
        protected JButton ccButton;

        public ButtonActionChangeColor(JFrame f, JButton b) {
            this.ccFrame = f;
            this.ccButton = b;
        }

        public void actionPerformed(ActionEvent e) {
            Color bgc = this.ccButton.getBackground();
            if ((bgc = JColorChooser.showDialog(PropertyDialog.this.frame, "Select Color", bgc)) != null) {
                PropertyDialog.this.setColorButton(this.ccButton, bgc);
            }
        }
    }
}

