/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.BaseFilterDialog;
import cgat.Dbg;
import cgat.MbgdDataMng;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SegmentFilterDialog
extends BaseFilterDialog
implements ActionListener {
    private static SegmentFilterDialog _instance = null;
    private JComboBox cbSegName = null;
    private JComboBox cbSegItem = null;
    private JComboBox cbCond = null;
    private JTextField tfInput = null;
    private String[] segmentName;
    private String[][] segmentItem;

    public static SegmentFilterDialog Instance(Frame f) {
        if (_instance == null) {
            _instance = new SegmentFilterDialog(f, true);
            _instance.setTitle("Filter Gene/Segment");
        }
        return _instance;
    }

    public static SegmentFilterDialog Instance() {
        if (_instance == null) {
            Dbg.println(0, "Error!! Can not create 'SegmentFilterDialog'");
        }
        return _instance;
    }

    private SegmentFilterDialog(Frame f, boolean sta) {
        super(f, sta);
        this.setVisible(false);
        this.setSize(500, 100);
        this.clear();
    }

    public void clear() {
        this.setStatus(-1);
        this.segmentName = null;
        this.segmentItem = null;
    }

    public void setGuiParts() {
        Container pane = this.getContentPane();
        pane.setLayout(new GridBagLayout());
        pane.removeAll();
        int x = 0;
        int y = 0;
        JPanel pCenter = new JPanel();
        this.cbSegName = new JComboBox<String>(this.segmentName);
        this.cbSegItem = new JComboBox<String>(this.segmentItem[0]);
        this.cbCond = new JComboBox<String>(CondValList);
        this.tfInput = new JTextField(20);
        Dimension d = this.tfInput.getMinimumSize();
        d.width = 200;
        this.tfInput.setMinimumSize(d);
        this.cbSegName.addActionListener(this);
        this.cbSegItem.addActionListener(this);
        this.updateSegItem();
        this.updateSegCond();
        GridBagLayout layout = new GridBagLayout();
        pCenter.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = x++;
        c.gridy = y;
        pCenter.add((Component)this.cbSegName, c);
        c = new GridBagConstraints();
        c.gridx = x++;
        c.gridy = y;
        pCenter.add((Component)this.cbSegItem, c);
        c = new GridBagConstraints();
        c.gridx = x++;
        c.gridy = y;
        pCenter.add((Component)this.cbCond, c);
        c = new GridBagConstraints();
        c.gridx = x++;
        c.gridy = y;
        pCenter.add((Component)this.tfInput, c);
        JPanel pSouth = new JPanel();
        JButton btnClearAll = new JButton("Reset All Filters");
        JButton btnClear = new JButton("Reset This Filter");
        JButton btnFilter = new JButton("Filter");
        JButton btnCancel = new JButton("Cancel");
        BaseFilterDialog.CmdClearAll cmdClearAll = new BaseFilterDialog.CmdClearAll(this);
        BaseFilterDialog.CmdClear cmdClear = new BaseFilterDialog.CmdClear(this);
        BaseFilterDialog.CmdFilter cmdFilter = new BaseFilterDialog.CmdFilter(this);
        BaseFilterDialog.CmdCancel cmdCancel = new BaseFilterDialog.CmdCancel(this);
        btnClearAll.addActionListener(cmdClearAll);
        btnClear.addActionListener(cmdClear);
        btnFilter.addActionListener(cmdFilter);
        btnCancel.addActionListener(cmdCancel);
        pSouth.add(btnClearAll);
        pSouth.add(btnClear);
        pSouth.add(btnFilter);
        pSouth.add(btnCancel);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        pane.add((Component)pCenter, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        pane.add((Component)pSouth, c);
    }

    public void setSegmentName(String[] segName) {
        int i;
        int n = 0;
        for (i = 0; i < segName.length; ++i) {
            if (segName[i] == null || "".equals(segName[i])) continue;
            ++n;
        }
        this.segmentName = new String[n];
        this.segmentItem = new String[n][];
        n = 0;
        for (i = 0; i < segName.length; ++i) {
            if (segName[i] == null || "".equals(segName[i])) continue;
            this.segmentName[n++] = segName[i];
        }
    }

    public void setSegmentItem(int segIdx, String[] segItem) {
        int i;
        int n = 0;
        for (i = 0; i < segItem.length; ++i) {
            if (segItem[i] == null || "".equals(segItem[i])) continue;
            ++n;
        }
        this.segmentItem[segIdx] = new String[n];
        n = 0;
        for (i = 0; i < segItem.length; ++i) {
            if (segItem[i] == null || "".equals(segItem[i])) continue;
            this.segmentItem[segIdx][n++] = segItem[i];
        }
    }

    public void actionPerformed(ActionEvent e) {
        JComboBox srcObj = (JComboBox)e.getSource();
        if (srcObj == this.cbSegName) {
            this.updateSegItem();
        }
        this.updateSegCond();
        Container pane = this.getContentPane();
        pane.validate();
    }

    public void updateSegItem() {
        int idxSegment = this.cbSegName.getSelectedIndex();
        if (idxSegment < 0) {
            return;
        }
        this.cbSegItem.removeAllItems();
        for (int i = 0; i < this.segmentItem[idxSegment].length; ++i) {
            this.cbSegItem.addItem(this.segmentItem[idxSegment][i]);
        }
    }

    public void updateSegCond() {
        MbgdDataMng mbgdDataMng = MbgdDataMng.Instance();
        int idxSegment = this.cbSegName.getSelectedIndex();
        if (idxSegment < 0) {
            return;
        }
        int idxSegmentItem = this.cbSegItem.getSelectedIndex();
        if (idxSegmentItem < 0) {
            return;
        }
        this.cbCond.removeAllItems();
        boolean attrType = idxSegment == 0 ? mbgdDataMng.getGeneAttrDataType(idxSegmentItem) : mbgdDataMng.getSegAttrDataType(idxSegment - 1, idxSegmentItem);
        if (!attrType) {
            for (int i = 0; i < CondValList.length; ++i) {
                this.cbCond.addItem(CondValList[i]);
            }
        } else {
            for (int i = 0; i < CondStrList.length; ++i) {
                this.cbCond.addItem(CondStrList[i]);
            }
        }
    }

    public String getSelectedSegmentName() {
        return (String)this.cbSegName.getSelectedItem();
    }

    public int getSelectedSegmentIndex() {
        return this.cbSegName.getSelectedIndex();
    }

    public String getSelectedSegmentItemName() {
        return (String)this.cbSegItem.getSelectedItem();
    }

    public int getSelectedSegmentItemIndex() {
        return this.cbSegItem.getSelectedIndex();
    }

    public String getSelectedSegmentItem() {
        return (String)this.cbSegItem.getSelectedItem();
    }

    public String getSelectedCondition() {
        return (String)this.cbCond.getSelectedItem();
    }

    public int getSelectedConditionIndex() {
        return this.cbCond.getSelectedIndex();
    }

    public String getInputTextValue() {
        return this.tfInput.getText();
    }
}

