/*
 * Decompiled with CFR 0.152.
 */
package cgat;

import cgat.Dbg;
import cgat.InfoGeneAttr;
import cgat.InfoSegments;
import cgat.MbgdDataMng;
import cgat.SelectSegment;
import cgat.SelectSegmentInfo;
import cgat.UrlFile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SelectSpecPairDialog {
    protected static SelectSpecPairDialog _instance = null;
    protected MbgdDataMng mbgdDataMng = MbgdDataMng.Instance();
    protected boolean staSelect;
    protected JFrame frame;
    protected JComboBox server;
    protected JComboBox spec;
    protected JComboBox attr;
    protected ArrayList alignFileList;
    protected InfoGeneAttr infoGeneAttr;
    protected InfoSegments infoSegments;
    protected HashMap selectSpecInfo;
    protected String selectGeneAttr;
    protected String selectGeneColorType;
    protected String[] selectSegName;
    protected String[] selectSegCgi;
    protected SelectSegmentInfo selectSegInfo;
    protected SelectSegment[] selectSeg;
    protected String defaultSp1 = "";
    protected String defaultSp2 = "";
    protected String defaultProg = "";

    public static SelectSpecPairDialog Instance(JFrame f) {
        if (_instance == null) {
            _instance = new SelectSpecPairDialog(f);
            _instance._update();
        }
        return _instance;
    }

    protected void addAlignData(String spec1, String spec2, String path, String file, String colorTab, ArrayList fileList) {
        HashMap<String, String> alignInfo = new HashMap<String, String>();
        alignInfo.put("SPEC1", spec1);
        alignInfo.put("SPEC2", spec2);
        alignInfo.put("PATH", path);
        alignInfo.put("ALIGN", file);
        alignInfo.put("FILE", file.substring(0, file.indexOf(".")));
        alignInfo.put("COLORTAB", colorTab);
        fileList.add(alignInfo);
    }

    protected SelectSpecPairDialog(JFrame f) {
        this.frame = f;
    }

    public void _init() {
        this.server = new JComboBox();
        this.spec = new JComboBox();
        this.attr = new JComboBox();
        for (int i = 0; i < 10; ++i) {
            String key = "cgat.url.home" + i;
            String val = this.mbgdDataMng.getProperty(key);
            if (val == null || "".equals(val = val.trim())) continue;
            this.server.addItem(val);
        }
        this.server.setSelectedIndex(0);
        this.server.addActionListener(new ListActionServer());
        String basePath = (String)this.server.getSelectedItem();
        this.mbgdDataMng.setBasePath(basePath);
        int maxSegNum = this.mbgdDataMng.getMaxSegNum();
        this.selectSegInfo = new SelectSegmentInfo();
        this.selectSeg = new SelectSegment[maxSegNum];
        for (int i = 0; i < maxSegNum; ++i) {
            this.selectSeg[i] = new SelectSegment(this.frame, this.selectSegInfo);
        }
    }

    public void _update() {
        this._init();
        this.setStaSelect(false, null, null, null, null, null);
        this._updateSpec();
    }

    public void _updateSpec() {
        int i;
        int selectedIdx = -1;
        int maxSegNum = this.mbgdDataMng.getMaxSegNum();
        this.spec.removeAllItems();
        this.attr.removeAllItems();
        this.alignFileList = this.getSpecList();
        String[] specList = new String[this.alignFileList.size()];
        if (specList.length != 0) {
            selectedIdx = 0;
        }
        for (int i2 = 0; i2 < this.alignFileList.size(); ++i2) {
            HashMap alignInfo = (HashMap)this.alignFileList.get(i2);
            String locate = ((String)alignInfo.get("PATH")).startsWith("http") ? "(Server)" : "";
            specList[i2] = alignInfo.get("ALIGN") + locate;
            this.spec.addItem(specList[i2]);
            if (selectedIdx >= 0 || !specList[i2].startsWith(this.defaultProg + "." + this.defaultSp1 + "-" + this.defaultSp2) && !specList[i2].startsWith(this.defaultProg + "." + this.defaultSp2 + "-" + this.defaultSp1)) continue;
            selectedIdx = i2;
        }
        this.spec.setSelectedIndex(selectedIdx);
        String path = this.mbgdDataMng.getBasePath();
        this.infoGeneAttr = new InfoGeneAttr();
        this.infoGeneAttr.load(path + "cgi-bin/geneAttr.cgi");
        try {
            String sep = System.getProperty("file.separator");
            String dirCgat = this.mbgdDataMng.getCgatHome();
            this.infoGeneAttr.load(dirCgat + sep + "geneattr");
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] attrList = new String[this.infoGeneAttr.size() + 1];
        attrList[0] = "Function Category";
        this.attr.addItem(attrList[0]);
        for (i = 0; i < this.infoGeneAttr.size(); ++i) {
            attrList[i + 1] = this.infoGeneAttr.getName(i);
            this.attr.addItem(attrList[i + 1]);
        }
        this.selectSegInfo.getListItem();
        for (i = 0; i < maxSegNum; ++i) {
            this.selectSeg[i].updateSegName();
        }
    }

    public void showDialog() {
        int maxSegNum = this.mbgdDataMng.getMaxSegNum();
        Object[] opt = new Object[2 + (2 + maxSegNum) * 2];
        int idx = 0;
        opt[idx++] = "Server URL";
        opt[idx++] = this.server;
        opt[idx++] = "Please select alignment data";
        opt[idx++] = this.spec;
        opt[idx++] = "Gene Attribute";
        opt[idx++] = this.attr;
        for (int i = 0; i < maxSegNum; ++i) {
            opt[idx++] = "Seg" + String.valueOf(i + 1);
            opt[idx++] = this.selectSeg[i];
        }
        this.setStaSelect(false, null, null, null, null, null);
        int ret = JOptionPane.showConfirmDialog(this.frame.getContentPane(), opt, "Select species pair", 2, -1);
        if (ret == 0) {
            String geneAttr = null;
            String geneColorType = null;
            String[] segName = new String[maxSegNum];
            String[] segCgi = new String[maxSegNum];
            idx = this.attr.getSelectedIndex();
            if (idx != 0) {
                geneAttr = (String)this.attr.getSelectedItem();
                geneColorType = this.infoGeneAttr.getType(idx - 1);
            }
            for (int i = 0; i < maxSegNum; ++i) {
                segName[i] = this.selectSeg[i].getSelectedSegName();
                segCgi[i] = this.selectSeg[i].getSelectedSegCgi();
            }
            int idxOk = 0;
            for (idx = 0; idx < maxSegNum; ++idx) {
                if (segCgi[idx].equals("")) continue;
                segName[idxOk] = segName[idx];
                segCgi[idxOk] = segCgi[idx];
                ++idxOk;
            }
            while (idxOk < maxSegNum) {
                segName[idxOk] = "";
                segCgi[idxOk] = "";
                ++idxOk;
            }
            int selIdx = this.spec.getSelectedIndex();
            this.setStaSelect(true, (HashMap)this.alignFileList.get(selIdx), geneAttr, geneColorType, segName, segCgi);
        }
    }

    public void setStaSelect(boolean sta, HashMap info, String geneAttr, String geneColorType, String[] segName, String[] segCgi) {
        this.staSelect = sta;
        this.selectSpecInfo = info;
        this.selectGeneAttr = geneAttr;
        this.selectGeneColorType = geneColorType;
        this.selectSegName = segName;
        this.selectSegCgi = segCgi;
    }

    public boolean getStaSelect() {
        return this.staSelect;
    }

    protected ArrayList getSpecList() {
        ArrayList alignFileList = new ArrayList();
        try {
            this.getSpecListUrl(alignFileList);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.getAlignFileListDisk(this.mbgdDataMng.getCgatHome(), alignFileList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return alignFileList;
    }

    protected void makeupSpecList(ArrayList alignFileList, ArrayList geneFileList) {
        for (int i = 0; i < alignFileList.size(); ++i) {
            HashMap alignInfo = (HashMap)alignFileList.get(i);
            alignInfo.put("SP1GENE", this.selectRegInfo(geneFileList, (String)alignInfo.get("SPEC1")));
            alignInfo.put("SP2GENE", this.selectRegInfo(geneFileList, (String)alignInfo.get("SPEC2")));
        }
    }

    protected void getSpecListUrl(ArrayList alignFileList) {
        this.getAlignFileListUrl(this.mbgdDataMng.getBasePath(), alignFileList);
    }

    protected void getAlignFileListUrl(String url, ArrayList fileList) {
        String alignUrl = url + "/cgi-bin";
        String filelist = alignUrl + "/filelist.cgi";
        try {
            String buf;
            UrlFile inAlign = new UrlFile(filelist);
            ArrayList<String> workFileList = new ArrayList<String>();
            String colorTab = "";
            while ((buf = inAlign.readLine()) != null) {
                if (buf.trim().equals("")) continue;
                workFileList.add(buf);
            }
            for (int i = 0; i < workFileList.size(); ++i) {
                String file = (String)workFileList.get(i);
                if (file.endsWith(".gz")) {
                    file = file.substring(0, file.length() - ".gz".length());
                }
                int sepIdx = file.indexOf("-");
                String spec1 = file.substring(file.indexOf(".") + 1, sepIdx);
                String spec2 = file.substring(sepIdx + 1);
                if (0 <= spec2.indexOf(".")) continue;
                this.addAlignData(spec1, spec2, url, file, colorTab, fileList);
            }
        }
        catch (Exception e) {
            Dbg.println(1, "Exception :: getAlignFileListUrl() :: " + filelist);
        }
    }

    protected void getGeneFileListUrl(String url, ArrayList fileList) {
        try {
            String buf;
            String geneUrl = url + "/gene";
            String filelist = geneUrl + "/filelist";
            DataInputStream in = new DataInputStream(new URL(filelist).openStream());
            BufferedReader inGene = new BufferedReader(new InputStreamReader(in));
            ArrayList<String> workFileList = new ArrayList<String>();
            String colorTabOrg = "";
            while ((buf = inGene.readLine()) != null) {
                workFileList.add(buf);
                if (!buf.equals("colorTab")) continue;
                colorTabOrg = geneUrl + "/colorTab";
            }
            for (int i = 0; i < workFileList.size(); ++i) {
                String file = (String)workFileList.get(i);
                if (!file.startsWith("gene.")) continue;
                String spec = file.substring("gene.".length());
                if (file.endsWith(".gz")) {
                    spec = spec.substring(0, spec.length() - ".gz".length());
                }
                if (0 <= spec.indexOf(".")) continue;
                String chromosome = geneUrl + "/chromosome." + spec;
                if (this.selectFile("chromosome." + spec, workFileList) == null) continue;
                String colorTab = geneUrl + "/colorTab." + spec;
                if (this.selectFile("colorTab." + spec, workFileList) == null) {
                    colorTab = colorTabOrg;
                }
                HashMap<String, String> geneInfo = new HashMap<String, String>();
                geneInfo.put("SPEC", spec);
                geneInfo.put("GENE", geneUrl + "/" + file);
                geneInfo.put("CHROMOSOME", chromosome);
                geneInfo.put("COLORTAB", colorTab);
                fileList.add(geneInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void getSegFileListUrl(String type2, String url, ArrayList fileList) {
        try {
            String buf;
            String segUrl = url + "/" + type2;
            String filelist = segUrl + "/filelist";
            DataInputStream in = new DataInputStream(new URL(filelist).openStream());
            BufferedReader inSeg = new BufferedReader(new InputStreamReader(in));
            ArrayList<String> workFileList = new ArrayList<String>();
            String colorTabOrg = "";
            while ((buf = inSeg.readLine()) != null) {
                workFileList.add(buf);
                if (!buf.equals("colorTab")) continue;
                colorTabOrg = segUrl + "/colorTab";
            }
            for (int i = 0; i < workFileList.size(); ++i) {
                String file = (String)workFileList.get(i);
                if (!file.startsWith("seg.")) continue;
                String spec = file.substring("seg.".length());
                if (file.endsWith(".gz")) {
                    spec = spec.substring(0, spec.length() - ".gz".length());
                }
                if (0 <= spec.indexOf(".")) continue;
                String colorTab = segUrl + "/colorTab." + spec;
                if (this.selectFile("colorTab." + spec, workFileList) == null) {
                    colorTab = colorTabOrg;
                }
                HashMap<String, String> segInfo = new HashMap<String, String>();
                segInfo.put("SPEC", spec);
                segInfo.put("SEG", segUrl + "/" + file);
                segInfo.put("COLORTAB", colorTab);
                fileList.add(segInfo);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void getAlignFileListDisk(String path, ArrayList fileList) {
        String sep = System.getProperty("file.separator");
        String dirDb = path + sep + "database";
        String dirAlign = dirDb + sep + "align";
        File alignDirFile = new File(dirAlign);
        if (!alignDirFile.isDirectory()) {
            return;
        }
        String colorTab = dirAlign + sep + "colorTab";
        File colorTabFile = new File(colorTab);
        if (!colorTabFile.isFile()) {
            colorTab = "";
        }
        Object[] alignFileList = alignDirFile.list();
        Arrays.sort(alignFileList);
        for (int i = 0; i < alignFileList.length; ++i) {
            int sepIdx;
            Object file = alignFileList[i];
            if (((String)file).startsWith(".")) continue;
            if (((String)file).endsWith(".gz")) {
                file = ((String)file).substring(0, ((String)file).length() - ".gz".length());
            }
            if ((sepIdx = ((String)file).indexOf("-")) < 0) continue;
            String spec1 = ((String)file).substring(((String)file).indexOf(".") + 1, sepIdx);
            String spec2 = ((String)file).substring(sepIdx + 1);
            if (0 <= spec2.indexOf(".")) continue;
            this.addAlignData(spec1, spec2, path, (String)file, colorTab, fileList);
        }
    }

    protected void getGeneFileListDisk(String path, ArrayList fileList) {
        String sep = System.getProperty("file.separator");
        String dirDb = path + sep + "database";
        String dirGene = dirDb + sep + "genes";
        File geneDirFile = new File(dirGene);
        if (!geneDirFile.isDirectory()) {
            return;
        }
        String colorTabOrg = dirDb + sep + "colorTab";
        File colorTabFile = new File(colorTabOrg);
        if (!colorTabFile.isFile()) {
            colorTabOrg = "";
        }
        String[] geneFileList = geneDirFile.list();
        for (int i = 0; i < geneFileList.length; ++i) {
            String chromosome;
            File chromosomeFile;
            if (!geneFileList[i].startsWith("gene.")) continue;
            String spec = geneFileList[i].substring("gene.".length());
            if (geneFileList[i].endsWith(".gz")) {
                spec = spec.substring(0, spec.length() - ".gz".length());
            }
            if (0 <= spec.indexOf(".") || !(chromosomeFile = new File(chromosome = dirGene + sep + "chromosome." + spec)).isFile()) continue;
            String colorTab = dirGene + sep + "colorTab." + spec;
            colorTabFile = new File(colorTab);
            if (!colorTabFile.isFile()) {
                colorTab = colorTabOrg;
            }
            HashMap<String, String> geneInfo = new HashMap<String, String>();
            geneInfo.put("SPEC", spec);
            geneInfo.put("GENE", dirGene + sep + geneFileList[i]);
            geneInfo.put("CHROMOSOME", chromosome);
            geneInfo.put("COLORTAB", colorTab);
            fileList.add(geneInfo);
        }
    }

    protected void getSegFileListDisk(String type2, String path, ArrayList fileList) {
        String sep = System.getProperty("file.separator");
        String dirDb = path + sep + "database";
        String dirSeg = dirDb + sep + type2;
        File segDirFile = new File(dirSeg);
        if (!segDirFile.isDirectory()) {
            return;
        }
        String colorTabOrg = dirSeg + sep + "colorTab";
        File colorTabFile = new File(colorTabOrg);
        if (!colorTabFile.isFile()) {
            colorTabOrg = "";
        }
        String[] segFileList = segDirFile.list();
        for (int i = 0; i < segFileList.length; ++i) {
            if (!segFileList[i].startsWith("seg.")) continue;
            String spec = segFileList[i].substring("seg.".length());
            if (segFileList[i].endsWith(".gz")) {
                spec = spec.substring(0, spec.length() - ".gz".length());
            }
            if (0 <= spec.indexOf(".")) continue;
            String colorTab = dirSeg + sep + "colorTab." + spec;
            colorTabFile = new File(colorTab);
            if (!colorTabFile.isFile()) {
                colorTab = colorTabOrg;
            }
            HashMap<String, String> segInfo = new HashMap<String, String>();
            segInfo.put("SPEC", spec);
            segInfo.put("SEG", dirSeg + sep + segFileList[i]);
            segInfo.put("COLORTAB", colorTab);
            fileList.add(segInfo);
        }
    }

    protected String selectFile(String filename, ArrayList fileList) {
        for (int i = 0; i < fileList.size(); ++i) {
            String file = (String)fileList.get(i);
            if (!file.equals(filename)) continue;
            return file;
        }
        return null;
    }

    protected HashMap selectRegInfo(ArrayList fileList, String spec) {
        HashMap selectInfo = null;
        for (int i = 0; i < fileList.size(); ++i) {
            HashMap info = (HashMap)fileList.get(i);
            if (!spec.equals((String)info.get("SPEC"))) continue;
            selectInfo = info;
            break;
        }
        if (selectInfo == null) {
            Dbg.println(1, "not found : " + spec);
        }
        return selectInfo;
    }

    public HashMap getSelectSpecInfo() {
        return this.selectSpecInfo;
    }

    public String getSelectGeneAttr() {
        return this.selectGeneAttr;
    }

    public String getSelectGeneColorType() {
        return this.selectGeneColorType;
    }

    public String getSelectSegName(int idx) {
        return this.selectSegName[idx];
    }

    public String getSelectSegCgi(int idx) {
        return this.selectSegCgi[idx];
    }

    public String getSelectSegType(int idx) {
        return this.selectSeg[idx].getSelectedSegName();
    }

    public void setDefault(String sp1, String sp2, String prog) {
        this.defaultSp1 = sp1;
        this.defaultSp2 = sp2;
        this.defaultProg = prog;
    }

    class ListActionServer
    implements ActionListener {
        ListActionServer() {
        }

        public void actionPerformed(ActionEvent e) {
            JComboBox jcb = (JComboBox)e.getSource();
            String basePath = (String)jcb.getSelectedItem();
            SelectSpecPairDialog.this.mbgdDataMng.setBasePath(basePath);
            SelectSpecPairDialog.this._updateSpec();
        }
    }
}

