/*
 * Decompiled with CFR 0.152.
 */
package cgat.seq;

import cgat.seq.Alphabet;
import cgat.seq.RawSequence;
import cgat.seq.Sequence;

public class ReversedRawSequence
extends Sequence {
    RawSequence _rawseq;

    ReversedRawSequence(RawSequence seq) {
        this._rawseq = seq;
    }

    public String getName() {
        return this._rawseq.getName();
    }

    public String getSeqString() {
        return this._getReversedString(this._rawseq.getSeqString());
    }

    public String getSubSeqString(int from, int to) {
        return this._getReversedString(this._rawseq.getSubSeqString(from, to));
    }

    private String _getReversedString(String str) {
        return this._getReversedSubString(str, 0, str.length() - 1);
    }

    private String _getReversedSubString(String str, int from, int to) {
        Alphabet alpha = this.getAlphabet();
        StringBuffer strbuf = new StringBuffer();
        for (int i = to; i >= from; --i) {
            char c = str.charAt(i);
            if (alpha != null) {
                c = alpha.complement(c);
            }
            strbuf.append(c);
        }
        return strbuf.toString();
    }

    public int getSubSeqStringLength(int from, int to) {
        return this._rawseq.getSubSeqStringLength(from, to);
    }

    public String getAltNameSequence() {
        return this.getAltNameSubSequence(1, this.length());
    }

    public String getAltNameSubSequence(int from, int to) {
        return this._getReversedAltNameSubSequence(this._rawseq.getSubSeqString(from, to));
    }

    private String _getReversedAltNameSubSequence(String str) {
        Alphabet alpha = this.getAlphabet();
        StringBuffer strbuf = new StringBuffer();
        for (int i = str.length() - 1; i >= 0; --i) {
            char c = str.charAt(i);
            if (alpha == null) continue;
            c = alpha.complement(c);
            String s = alpha.getName(c);
            strbuf.append(s);
        }
        return strbuf.toString();
    }

    public Alphabet getAlphabet() {
        return this._rawseq.getAlphabet();
    }

    public boolean isCircular() {
        return this._rawseq.isCircular();
    }

    public int length() {
        return this._rawseq.length();
    }

    public char charAt(int i) {
        return this.getAlphabet().complement(this._rawseq.charAt(this.length() - 1 - i));
    }

    public char symbolAt(int i) {
        Alphabet alpha = this.getAlphabet();
        System.out.println("i>" + i);
        return alpha.complement(this._rawseq.symbolAt(this.length() - i + 1));
    }

    public void reverse() {
    }

    public Sequence getReverse() {
        return this._rawseq;
    }
}

