#!/usr/bin/perl -s
use Sequence;
use Segment;
use GenomeFeature;
use CGAT_Data;
use File::Basename;
use CmdProc;

if (! @ARGV) {
	die "Usage: $0 [-TYPE=type,...] species ...\n   Types are by default taken from the 'mask' directory\n";
}

if ($TYPE) {
	@TYPES = split(/,/, $TYPE);
} elsif (-d "mask") {
	foreach $f (<mask/*>) {
		next if (-d $f);
		$type = basename($f);
		next if ($type =~ /^#/);
		next if ($type eq 'CVS');
		push(@TYPES, $type);
	}
}
if (! @TYPES) {
	print STDERR "No masking data is specified\n";
	exit(0);
}

$cmdproc = CmdProc->new($DIR_databaseWork);
foreach $sp (@ARGV) {
	$seqpath = &CGAT_Data::getGenomeSeqPath($sp, 'work', 'no_mask');
	$masked_seqpath = &CGAT_Data::getMaskedGenomeSeqPath($sp, 'work');
	my(@depend) = ($seqpath);
	foreach $type (@TYPES) {
		push(@depend, &getSegmentFilePath($sp, $type, '', 'work'));
	}

	my($command) = sub {
		$featListAll = SeqFeatureList->new;
		foreach $type (@TYPES) {
			my $gfeat = GenomeFeature->new($sp, $type, {mode=>'read', work=>1});
			$gfeat->read_table;
			$featList = $gfeat->getFeatureList;
		
			$featListAll->add($featList);
		}
		$seq = SeqFile->getSequence($seqpath);
		$maskedSeq = MaskSequence::maskedSeq($seq, $featListAll, 'n');
		
		SeqFile->outputSequence($maskedSeq, $masked_seqpath);
	};
	$cmdproc->execute([ {
		procname => $command,
		type => 'code',
		depend => \@depend,
		target => $masked_seqpath,
	} ]);
}
