
/**
 * ȥ:     cgat<p>
 * @version 1.0
 */
package cgat;

import java.applet.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import javax.swing.*;

///////////////////////////////////////////////////////////////////////////////
//
public class AlignmentViewer implements ActionListener {
    boolean packFrame = false;
    AlignmentViewerFrame frame;

    ///////////////////////////////////////////////////////////////////////////
    //ץꥱι
    public AlignmentViewer(String[] args, Applet applet) {
        MbgdDataMng mbgdDataMng = MbgdDataMng.Instance();
        int width  = 1000;
        int height =  850;
        boolean pairwise = false;
        String sp1 = "";
        int sp1chr = 1;
        String sp2 = "";
        int sp2chr = 1;
        String prog = "";
        String clustid = "";
        String basePath = null;
        String proxy = null;

        //
        for(int i = 0; i < args.length; i++) {
            if (args[i] == null) {
                break;
            }
Dbg.println(1, "ARGS :: " + args[i] + " :: " + args[i + 1]);
            if (args[i].equalsIgnoreCase("-applet")) {
                basePath = args[i + 1];
                i++;
            }
            else if (args[i].equalsIgnoreCase("-basepath")) {
              basePath = args[i + 1];
              i++;
            } else if (args[i].equalsIgnoreCase("-sp1")) {
              sp1 = args[i + 1]; i++;
            } else if (args[i].equalsIgnoreCase("-sp2")) {
              sp2 = args[i + 1]; i++;
            } else if (args[i].equalsIgnoreCase("-debug")) {
              try {
                  Dbg.setDbgLevel(Integer.parseInt(args[i + 1]));
              }
              catch (NumberFormatException nfe) {
              }
              i++;
            }
        }

        if (applet != null) {
            // HTML ǻꤵ줿 [default] 
            String pw = applet.getParameter("pairwise");
            if ((pw != null) && pw.equalsIgnoreCase("on")) {
                pairwise = true;
            }
            sp1     = applet.getParameter("sp1");
            sp2     = applet.getParameter("sp2");
            try {
                sp1chr  = Integer.parseInt(applet.getParameter("sp1chr"));
            }
            catch (NumberFormatException nfe) {
                sp1chr = 1;
            }
            mbgdDataMng.setSpecChr(0, sp1chr);

            try {
                sp2chr  = Integer.parseInt(applet.getParameter("sp2chr"));
            }
            catch (NumberFormatException nfe) {
                sp2chr = 1;
            }
            mbgdDataMng.setSpecChr(1, sp2chr);

            prog    = applet.getParameter("prog");
            clustid = applet.getParameter("clustid");
        }

        //
        if (basePath == null) {
            basePath = mbgdDataMng.getProperty(MbgdDataMng.OPT_URL_HOME);
        }
        proxy = mbgdDataMng.getProperty(MbgdDataMng.OPT_URL_PROXY);
        mbgdDataMng.setBasePath(basePath);
        mbgdDataMng.setProxy(proxy);

        MbgdData mbgdData = MbgdData.Instance(applet);
        frame = new AlignmentViewerFrame(sp1, sp2, prog);
        frame.setTitle("CGAT");
        if (pairwise) {
            // MenuBar ɽ
            frame.setVisibleMenuBar(false);
            mbgdDataMng.setMbgdCgiPrograms(clustid);

            // ǡμư
			URL u = applet.getCodeBase();
			String url = u.getProtocol() + "://" + u.getHost();
            int port = u.getPort();
            if (0 < port) {
				url += ":" + port;
            }
			String falign = "pairwise";
			String geneAttrDir = null;
			String geneAttrColorType = "";
			String segType[] = new String[MbgdDataMng.MAX_SEGS];
			String segCgi[]  = new String[MbgdDataMng.MAX_SEGS];
            for(int i = 0; i < MbgdDataMng.MAX_SEGS; i++) {
                segType[i] = segCgi[i] = null;
            }
            mbgdDataMng.load(frame, sp1, sp2,
                                    url,
                                    falign,
                                    geneAttrDir, geneAttrColorType,
                                    segType, segCgi);
        }

        // ̤Υåɽ
        BaseMessageDialog.Instance(frame);

        //validate() ϥĴ
        //pack() ͭʥ쥤Ȥʤɤ
        if (packFrame) {
            frame.pack();
        }
        else {
            frame.validate();
            frame.setVisible(true);
        }
    }

    ///////////////////////////////////////////////////////////////////////////
    //
    public void closeFrame() {
        frame.dispose();
        frame = null;
    }

    ///////////////////////////////////////////////////////////////////////////
    //
    public void setVisible(boolean sta) {
        frame.setVisible(sta);
    }

    ///////////////////////////////////////////////////////////////////////////
    //
    public void actionPerformed(ActionEvent e) {
        setVisible(true);
    }

    ///////////////////////////////////////////////////////////////////////////
    //Main ᥽å
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch(Exception e) {
            e.printStackTrace();
        }

        AlignmentViewer prog = new AlignmentViewer(args, null);
        prog.setVisible(true);
    }
}
