#!/usr/bin/perl -s

use Tools;
use Tools::HomologyParser;
use Sequence;
use Alignment;

###############################################################################
package Tools::Game;
###############################################################################
@ISA = qw(Tools);
@AHO = (a,b,c);
sub new {
	my($class) = @_;
	my($this) = {};
	bless $this, $class;
	$this->{parser} = Tools::GameParser->new;
	$this;
}
###############################################################################
package Tools::GameResult;
###############################################################################
@ISA = qw(Tools::HomologyResult);

###############################################################################
package Tools::GameHSP;
###############################################################################
@ISA = qw(Tools::HomologyHSP);

sub new {
	my($class, %values) = @_;
	my $this = {};
	bless $this, $class;
	$this->set_values(%values);
	return $this;
}
sub set_values {
	my($this, %values) = @_;
	foreach $k (keys %values) {
		$this->{$k} = $values{$k};
	}
}
#sub add_hsp {
#	my($this, $hsp) = @_;
#	push(@{$this->{hsp_list}}, $hsp);
#}
sub hsp_list {
	my($this) = @_;
	return ($this);
}

###############################################################################
package Tools::GameParser;
###############################################################################
@ISA = qw(Tools::HomologyParser);

use FileHandle;
sub new {
	my($class, @filenames) = @_;
	my $this = {};
	bless $this, $class;
	if (@filenames) {
		$this->set_filenames(\@filenames);
	}
	$this;
}
sub readfile {
	my($this) = @_;
	my($result) = Tools::GameResult->new;
	my($ln);
	my($status);
	while ($_ = $this->getline) {
		chomp();
		if (/^# File/) {
		}
		if (/^# FileName : 0 : (\S+)/) {
			$filename1 = $1;
			open (F, $filename1) || die "Can't open $filename1\n";
			my $line = <F>;
			close(F);
			if ($line =~ /^>\s*(\S+)/) {
				my $qname = $1;
				if ($this->set_queryname($result,$qname) < 0) {
					$this->save_current_line($_);
					return $result;
				}
			}
		} elsif (/^>/) {
			s/^>//;
			my($aliN,$from1,$len1,$from2,$len2,$dir,$score) = split;
			$hsp = Tools::GameHSP->new;
			$hsp->{from1} = $from1;
			$hsp->{to1} = $from1 + $len1 - 1;
			$hsp->{from2} = $from2;
			$hsp->{to2} = $from2 + $len2 - 1;
			$hsp->{dir1} = 1;
			$hsp->{dir2} = $dir eq '+' ? 1 : -1;
			$result->add_hit($hsp);
			$status = 1;
		} elsif ($status == 1 && /^\s*$/) {
			next;
		} else {
			($num, $aliseq) = split;
			if ($status == 1) {
				$hsp->{aliseq1} .= $aliseq;
			} elsif($status == 3) {
				$hsp->{aliseq2} .= $aliseq;
				$status = 0;
			}
			$status++;
		}
        }
	return $result;
}
###############################################################################
1;#
###############################################################################
###############################################################################
package main;
if ($0 eq __FILE__) {
	$parser = Tools::GameParser->new($ARGV[0]);
	while ($res = $parser->read) {
		foreach $hsp ($res->hsp_list) {
			my $output = $hsp->get_hsp_info([
				'from1','to1','from2','to2','dir1','dir2']);
			print join(' ', @{$output}),"\n";
		}
	}
}

###############################################################################
1;#
###############################################################################
