#!/usr/bin/perl -s

use FindBin;
use File::Basename;

die "Usage: $0 infile\n" if (! @ARGV);


$infile = $ARGV[0];

$outdir = dirname($infile);

$ENV{'PATH'} = "${FindBin::Bin}/../bin:${FindBin::Bin}";
$DataDir = "$FindBin::Bin/../data";

$orthotab = "$outdir/cluster.tab";
$newtab = "$outdir/cluster.newtab";
$alignout = "$outdir/corealign.out";
$psout = "$outdir/corealign.ps";
$genomes = "$outdir/genomes";


$CONS_RATIO = 0.5;
$NBR_WIN = 20;

$paramfile = "$outdir/param.ph" if (! $paramfile);
if (-f $paramfile) {
	do $paramfile;
}

system("prepare_data.pl -incfile=$paramfile -FILE_genomes=$genomes".
		" $infile $DataDir");
system("convtab.pl -count_all -MINCNT=1 -genomes=$genomes" .
		" -datapath=$DataDir $infile> $orthotab");


## construct a core structure alignment 
system("corealign.pl " .
	" -NBR_WIN=$NBR_WIN -CONS_RATIO=$CONS_RATIO " .
	" -genomes=$genomes -clusttab=$orthotab" .
	" -refsp=$refsp " .
	" -SpGrp=$SpGrp -OutGroup=$OutGroup" .
	" -clustout=$newtab" .
	" -alignout=$alignout" .
	" -datapath=$DataDir"
);

## graphical output 
system("corealign.pl -genomes=$genomes -clusttab=$newtab" .
	" -refsp=$refsp " .
	" -SpGrp=$SpGrp -OutGroup=$OutGroup" .
	" -alignin=$alignout -alignout=$psout" .
	" -output=postscript -landscape -paper=A4" .
	" -no_legend " .
	" -datapath=$DataDir"
);

