#!/usr/bin/perl -s

use FindBin;
use lib "$FindBin::Bin/../perllib";
use MBGD_access;

if ($orglist && @ARGV < 1 || @ARGV < 2) {
	die "Usage: $0 [-orglist=... | ClusterFile] OutputDir\n";
}

do $incfile if (-f $incfile);

$InFile = shift @ARGV if (! $InFile);
if ($orglist) {
	@species = split(/,/, $orglist);
} else {
	open(F, $InFile) || die;
	$header = <F>;
	close(F);
	@header = split(/\t/, $header);
	foreach $h (@header) {
		if ($h =~ /ClusterID|Size|Gene|Func/) {
		} else {
			push(@species, $h)
		}
	}
	$orglist = join(',', @species);
}

if (! $FILE_genomes) {
	$FILE_genomes = "genomes";
}

#if ($dbname) {
#	$getopt = "-dbname=$dbname";
#} else {
#	$dbname = 'mbgd';
#}

$GENEDIR = shift(@ARGV);
mkdir ($GENEDIR) if (! -d $GENEDIR);

foreach $sp (@species) {
	if (! -f "$GENEDIR/$sp.txt" || ! -f $FILE_genomes) {
		&create_genetab($sp);
	}

#	if (! -f "$GENEDIR/$sp.seq") {
#        	system("$PROGDIR/mbgdget -f $getopt $sp > $GENEDIR/$sp.seq");
#        	system("$PROGDIR/mbgdget -type=CDS -n $getopt $sp > $GENEDIR/$sp.ntseq");
#	}

}

#if (! -f "$HOMDIR/homology.$org") {
#	system(qq{wget -O $HOMDIR/homology.${org} } .
# qq{"http://mbgd.genome.ad.jp/htbin/getHomology?species=$orglist"});
#}

if (! -f $FILE_genomes) {
	$i = 1;
	foreach $sp (split(/,/, $orglist)) {
		$order{$sp} = $i++;
	}
	@genomes = MBGD_access::getData(table=>'genome', species=>$orglist);
	@genomes = sort {$order{$a->{sp}}<=>$order{$b->{sp}}} @genomes;
	open(O, ">$FILE_genomes") || die;
	foreach $g (@genomes) {
		$sp = $g->{sp};
		$abbrev = $g->{abbrev};
		$abb = substr($abbrev, 0, 5);
		print O "$sp $abb $TotLen{$sp} $order{$sp}\n";
	}
	close(O);
}


sub create_genetab {
	my($sp) = @_;
	my(@Length, @OffSet, %SeqNo);
	my(@chrom, @gene, $seqnum);
	my($GAP) = 1000;

	$TotLen{$sp} = 0;
	@chrom = MBGD_access::getData(table=>'chromosome', species=>$sp);
	foreach $chr (@chrom) {
		my($seqno) = $chr->{seqno};
		my($len) = $chr->{seq_length};
		next if ($chr->{type} ne 'chromosome');
		$SeqNo{$chr->{id}} = $seqno;
		$Length[$seqno] = $len;
		$ToeLen{$sp} += $GAP if ($TotLen{$sp});
		$TotLen{$sp} += $len;
		$seqnum++;
	}

	for ($i = 2; $i <= $seqnum; $i++) {
		for ($j = 1; $j < $i; $j++) {
			$OffSet[$i] += ($Length[$j] + $GAP);
		}
	}

	return if (-f "$GENEDIR/$sp.txt");

	open(OUT, ">$GENEDIR/$sp.txt");

	@gene = MBGD_access::getData(table=>'gene', species=>$sp);

	print OUT join("\t", 'sp','name','gene','from1','to1',
			'dir','type','descr'),"\n";
	foreach $g (@gene) {
		next if (! defined $SeqNo{$g->{chrid}});
		$offset = $OffSet[ $SeqNo{$g->{chrid}} ];
		print OUT join("\t", $sp,$g->{name},$g->{gene},
				$g->{from1}+$offset,$g->{to1}+$offset,
				$g->{dir},$g->{type},$g->{descr}),"\n";
	}
	close(OUT);
}
