/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.access;

import cgdp.recog.access.FileAccessExecuter;
import cgdp.recog.access.FileAccessExecuterFactory;
import cgdp.recog.access.FileAccessType;
import cgdp.recog.bean.ClusterMap;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.set.gene.GeneSet;
import java.awt.Component;
import java.awt.Frame;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class FileAccessFacade {
    private static FileAccessFacade FILE_ACCESS_FACADE;
    private Frame parent;
    private MediatorImpl mediator;

    private FileAccessFacade(Frame frame, MediatorImpl mediatorImpl) {
        this.parent = frame;
        this.mediator = mediatorImpl;
    }

    public static void createInstance(Frame frame, MediatorImpl mediatorImpl) {
        FILE_ACCESS_FACADE = new FileAccessFacade(frame, mediatorImpl);
    }

    public static FileAccessFacade getInstance() {
        return FILE_ACCESS_FACADE;
    }

    public void executeImport(int n, String string, ClusterTbl clusterTbl) throws Exception {
        FileAccessExecuter fileAccessExecuter = this.createImportExecuter(n, string, clusterTbl);
        fileAccessExecuter.execute();
    }

    private FileAccessExecuter createImportExecuter(int n, String string, ClusterTbl clusterTbl) {
        FileAccessExecuter fileAccessExecuter = null;
        if (FileAccessType.isDomClustFile(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createDomClustImportExecuter(this.parent, this.mediator, string);
        } else if (FileAccessType.isDomClustTabFile(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createDomClustTabImportExecuter(this.parent, this.mediator, string);
        } else if (FileAccessType.isGenePropertyGlobal(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createGenePropertyImportExecuterForGlobal(this.parent, this.mediator, string);
        } else if (FileAccessType.isGenePropertyProject(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createGenePropertyImportExecuterForProject(this.parent, this.mediator, string);
        } else if (FileAccessType.isClusterPropertyCluster(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createClusterPropertyImportExecuter(this.parent, this.mediator, n, clusterTbl.getClusterId(), -1);
        } else if (FileAccessType.isClusterPropertySubCluster(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createClusterPropertyImportExecuter(this.parent, this.mediator, n, clusterTbl.getClusterId(), -1);
        } else if (FileAccessType.isGeneSetGlobal(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createGeneSetImportExecuterForGlobal(this.parent, this.mediator, string);
        } else if (FileAccessType.isGeneSetProject(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createGeneSetImportExecuterForProject(this.parent, this.mediator, string);
        } else if (FileAccessType.isClusterSetProject(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createClusterSetImportExecuterForProject(this.parent, this.mediator, string, clusterTbl);
        } else if (FileAccessType.isOrganismDisplaySetting(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createOrganismDisplaySettingImportExecuter(this.parent, this.mediator, string);
        }
        return fileAccessExecuter;
    }

    public void executeByCluster(int n, String string, Collection collection, ClusterTbl clusterTbl) throws Exception {
        FileAccessExecuter fileAccessExecuter = this.createImportExecuterByClusterList(n, string, collection, clusterTbl);
        fileAccessExecuter.execute();
    }

    public void executeByCluster(Component component, int n, String string, List list, Collection collection, ClusterTbl clusterTbl) throws Exception {
        FileAccessExecuter fileAccessExecuter = this.createImportExecuterByClusterList(component, n, string, list, collection, clusterTbl);
        fileAccessExecuter.execute();
    }

    private FileAccessExecuter createImportExecuterByClusterList(int n, String string, Collection collection, ClusterTbl clusterTbl) {
        FileAccessExecuter fileAccessExecuter = null;
        List list = this.getClusterList(clusterTbl);
        if (FileAccessType.isGeneSetGlobal(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createGeneSetImportExecuterForGlobal(this.parent, this.mediator, string, list, collection);
        } else if (FileAccessType.isGeneSetProject(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createGeneSetImportExecuterForProject(this.parent, this.mediator, string, list, collection);
        } else if (FileAccessType.isClusterSetProjectByCluster(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createClusterSetImportExecuterForProject(this.parent, this.mediator, string, list, clusterTbl);
        }
        return fileAccessExecuter;
    }

    private FileAccessExecuter createImportExecuterByClusterList(Component component, int n, String string, List list, Collection collection, ClusterTbl clusterTbl) {
        FileAccessExecuter fileAccessExecuter = null;
        List list2 = clusterTbl.getClusterList(ClusterUtil.getClusterIdSet(list));
        if (FileAccessType.isGeneSetGlobal(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createGeneSetImportExecuterForGlobal(component, this.mediator, string, list2, collection);
        } else if (FileAccessType.isGeneSetProject(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createGeneSetImportExecuterForProject(component, this.mediator, string, list2, collection);
        } else if (FileAccessType.isClusterSetProjectByCluster(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createClusterSetImportExecuterForProject(component, this.mediator, string, list2, clusterTbl);
        }
        return fileAccessExecuter;
    }

    public void executeByCluster(int n, Collection collection, ClusterTbl clusterTbl, AbstractElementSet abstractElementSet) throws Exception {
        FileAccessExecuter fileAccessExecuter = this.createImportExecuterByClusterList(n, collection, clusterTbl, abstractElementSet);
        fileAccessExecuter.execute();
    }

    private FileAccessExecuter createImportExecuterByClusterList(int n, Collection collection, ClusterTbl clusterTbl, AbstractElementSet abstractElementSet) {
        FileAccessExecuter fileAccessExecuter = null;
        if (FileAccessType.isGeneSetAddGeneInfo(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createGeneSetImportExecuterForAddElement(this.parent, this.mediator, this.getClusterList(clusterTbl), collection, (GeneSet)abstractElementSet);
        } else if (FileAccessType.isClusterSetAddCluster(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createClusterSetImportExecuterForAddElement(this.parent, this.mediator, this.getClusterList(clusterTbl), (ClusterSet)abstractElementSet, clusterTbl);
        }
        return fileAccessExecuter;
    }

    public void executeByGeneInfo(Component component, int n, String string, List list) throws Exception {
        FileAccessExecuter fileAccessExecuter = this.createImportExecuterByGeneInfoList(component, n, string, list);
        fileAccessExecuter.execute();
    }

    private FileAccessExecuter createImportExecuterByGeneInfoList(Component component, int n, String string, List list) {
        FileAccessExecuter fileAccessExecuter = null;
        if (FileAccessType.isGeneSetByGeneInfo(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createGeneSetImportExecuterByGeneInfo(component, this.mediator, string, list);
        }
        return fileAccessExecuter;
    }

    public void executeExport(int n, ClusterTbl clusterTbl, ClusterMap clusterMap) throws Exception {
        FileAccessExecuter fileAccessExecuter = null;
        if (FileAccessType.isExportClustTab(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createClustTabExportExecuter(this.parent, this.mediator, clusterTbl);
        } else if (FileAccessType.isExportPdf(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createPpmPdfExportExexuter(this.parent, this.mediator, clusterTbl, clusterMap);
        } else if (FileAccessType.isExportOrganismDisplaySetting(n)) {
            fileAccessExecuter = FileAccessExecuterFactory.createOrganismDisplaySettingExportExecuter(this.parent, this.mediator, clusterTbl);
        }
        if (fileAccessExecuter != null) {
            fileAccessExecuter.execute();
        }
    }

    public void executeExport(ClusterTbl clusterTbl, AbstractElementSet abstractElementSet) throws Exception {
        FileAccessExecuter fileAccessExecuter = null;
        if (abstractElementSet.isGeneSet()) {
            fileAccessExecuter = FileAccessExecuterFactory.createGeneSetExportExecuter(this.parent, this.mediator, (GeneSet)abstractElementSet);
        } else if (abstractElementSet.isClusterSet()) {
            fileAccessExecuter = FileAccessExecuterFactory.createClusterSetExportExecuter(this.parent, this.mediator, clusterTbl, (ClusterSet)abstractElementSet);
        }
        if (fileAccessExecuter != null) {
            fileAccessExecuter.execute();
        }
    }

    public void executeExport(ClusterTbl clusterTbl, AbstractElementSet abstractElementSet, Map map, Map map2) throws Exception {
        FileAccessExecuter fileAccessExecuter = null;
        if (abstractElementSet.isGeneSet()) {
            fileAccessExecuter = FileAccessExecuterFactory.createGeneSetExportExecuter(this.parent, this.mediator, (GeneSet)abstractElementSet, map, map2);
        } else if (abstractElementSet.isClusterSet()) {
            fileAccessExecuter = FileAccessExecuterFactory.createClusterSetExportExecuter(this.parent, this.mediator, clusterTbl, (ClusterSet)abstractElementSet, map, map2);
        }
        if (fileAccessExecuter != null) {
            fileAccessExecuter.execute();
        }
    }

    private List getClusterList(ClusterTbl clusterTbl) {
        List list = null;
        if (clusterTbl != null) {
            list = clusterTbl.getPpmSelectionManager().getSelectedClusterList(clusterTbl);
        }
        return list;
    }

    public void setAfterProcess(Runnable runnable) {
    }
}

