/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.access;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.StringTool;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

class ImportMenuManager
implements ActionListener {
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private ImportSubItem clusterInfoImportItem;
    private ImportSubItem clusterSetImportItem;
    private ImportSubItem organismSettingImportItem;
    private ImportSubItem lastSelectItem;

    public ImportMenuManager(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
    }

    List getMenuList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new ImportSubItem(this, this.mediator, "DomClust file...", 1, null));
        arrayList.add(new ImportSubItem(this, this.mediator, "DomClust Tab file...", 17, null));
        JMenu jMenu = new JMenu("Gene propety file");
        arrayList.add(jMenu);
        jMenu.add(new ImportSubItem(this, this.mediator, "Current Project", 3, null));
        jMenu.add(new ImportSubItem(this, this.mediator, "Global", 2, "Global"));
        List list = ProjectAccesser.loadProject();
        jMenu.addSeparator();
        for (Object object : list) {
            jMenu.add(new ImportSubItem(this, this.mediator, ((Project)object).getProjectName(), 3, ((Project)object).getProjectName()));
        }
        this.clusterInfoImportItem = new ImportSubItem(this, this.mediator, "Cluster propety file", 15, null);
        this.clusterInfoImportItem.setEnabled(this.clusterTbl != null);
        arrayList.add(this.clusterInfoImportItem);
        JMenu jMenu2 = new JMenu("Gene set file");
        arrayList.add(jMenu2);
        jMenu2.add(new ImportSubItem(this, this.mediator, "Current Project", 5, null));
        jMenu2.add(new ImportSubItem(this, this.mediator, "Global", 4, "Global"));
        jMenu2.addSeparator();
        for (Project project : list) {
            jMenu2.add(new ImportSubItem(this, this.mediator, project.getProjectName(), 5, project.getProjectName()));
        }
        this.clusterSetImportItem = new ImportSubItem(this, this.mediator, "Cluster set file...", 7, null);
        this.clusterSetImportItem.setEnabled(this.clusterTbl != null);
        arrayList.add(this.clusterSetImportItem);
        this.organismSettingImportItem = new ImportSubItem(this, this.mediator, "Organism display setting...", 18, null);
        this.organismSettingImportItem.setEnabled(this.clusterTbl != null);
        arrayList.add(this.organismSettingImportItem);
        return arrayList;
    }

    ImportSubItem getLastSelectItem() {
        return this.lastSelectItem;
    }

    void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
        this.setEnableMenu(this.clusterTbl != null);
    }

    private void setEnableMenu(boolean bl) {
        this.clusterInfoImportItem.setEnabled(bl);
        this.clusterSetImportItem.setEnabled(bl);
        this.organismSettingImportItem.setEnabled(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ImportSubItem importSubItem = (ImportSubItem)actionEvent.getSource();
        importSubItem.execute();
        this.lastSelectItem = importSubItem;
    }

    class ImportSubItem
    extends JMenuItem
    implements CommandImpl {
        private MediatorImpl mediator;
        private int importType;
        private String location;

        ImportSubItem(ActionListener actionListener, MediatorImpl mediatorImpl, String string, int n, String string2) {
            super(string);
            this.mediator = mediatorImpl;
            this.importType = n;
            this.location = string2;
            this.addActionListener(actionListener);
        }

        @Override
        public void execute() {
            String string = this.location;
            if (StringTool.isNull(this.location)) {
                Project project = ProjectAccesser.getSelectedProject();
                string = project.getProjectName();
            }
            this.mediator.importer(this.importType, string);
        }
    }
}

