/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.CoreGeneAddPropertyItem;
import cgdp.recog.align.CoreGeneAddSetItem;
import cgdp.recog.align.GlobalAlignClickShowGeneInfoButton;
import cgdp.recog.align.GlobalAlignLeftTool;
import cgdp.recog.align.GlobalAlignMoveArrangementTool;
import cgdp.recog.align.GlobalAlignMoveNormalTool;
import cgdp.recog.align.GlobalAlignOriginRecoverTool;
import cgdp.recog.align.GlobalAlignPanel;
import cgdp.recog.align.GlobalAlignPreviewItem;
import cgdp.recog.align.GlobalAlignPrintDialog;
import cgdp.recog.align.GlobalAlignPrintItem;
import cgdp.recog.align.GlobalAlignRightTool;
import cgdp.recog.align.GlobalAlignViewModel;
import cgdp.recog.align.GlobalAlignViewUpdateItem;
import cgdp.recog.align.GlobalAlignZoominItem;
import cgdp.recog.align.GlobalAlignZoominTool;
import cgdp.recog.align.GlobalAlignZoomoutItem;
import cgdp.recog.align.GlobalAlignZoomoutTool;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.coregenome.CoreCommonParamDTO;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.util.ApplicationFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class GlobalAlignFrame
extends ApplicationFrame
implements ActionListener,
ComponentListener {
    private static final int WIDTH = 700;
    private static final int HEIGHT = 500;
    private static final String TITLE = "Genome Comparison Viewer";
    private Frame parent;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private GlobalAlignViewModel globalAlignViewModel;
    private GlobalAlignPanel globalAlignPanel;
    private JToolBar toolBar;

    public GlobalAlignFrame(Frame frame, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, GlobalAlignViewModel globalAlignViewModel) {
        super(TITLE);
        this.parent = frame;
        this.mediator = mediatorImpl;
        this.globalAlignViewModel = globalAlignViewModel;
        GlobalAlignPrintDialog.createInstance(this, mediatorImpl, globalAlignViewModel);
        this.init();
    }

    private void init() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GlobalAlignFrame.this.exit();
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                if (GlobalAlignFrame.this.globalAlignViewModel.updateByCoreCommonParamDTO()) {
                    GlobalAlignFrame.this.mediator.updateGlobalAlignMap(false);
                    GlobalAlignFrame.this.globalAlignViewModel.clearCoreCommonParamDTO();
                }
            }
        });
        this.addComponentListener(this);
        this.toolBar = this.createToolBar();
        this.getContentPane().add((Component)this.toolBar, "North");
        this.globalAlignPanel = new GlobalAlignPanel(this.mediator, this.clusterTbl, this.globalAlignViewModel);
        JScrollPane jScrollPane = new JScrollPane(this.globalAlignPanel, 20, 31);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.setJMenuBar(this.createMenuBar());
        this.globalAlignViewModel.notifyZoom();
        this.pack();
        this.setSize(new Dimension(700, 500));
        this.setLocationRelativeTo(this.parent);
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        jMenu.add(new GlobalAlignPreviewItem(this, this.mediator, this.globalAlignViewModel));
        jMenu.add(new GlobalAlignPrintItem(this, this.mediator, this.globalAlignViewModel));
        JMenu jMenu2 = new JMenu("View");
        GlobalAlignZoominItem globalAlignZoominItem = new GlobalAlignZoominItem(this, this.mediator, this.globalAlignViewModel);
        GlobalAlignZoomoutItem globalAlignZoomoutItem = new GlobalAlignZoomoutItem(this, this.mediator, this.globalAlignViewModel);
        this.globalAlignViewModel.addZoomListener(globalAlignZoominItem);
        this.globalAlignViewModel.addZoomListener(globalAlignZoomoutItem);
        jMenuBar.add(jMenu2);
        jMenu2.add(new GlobalAlignViewUpdateItem(this, this.mediator, this, this.globalAlignViewModel));
        jMenu2.addSeparator();
        jMenu2.add(globalAlignZoominItem);
        jMenu2.add(globalAlignZoomoutItem);
        JMenu jMenu3 = new JMenu("Property");
        jMenuBar.add(jMenu3);
        jMenu3.add(new CoreGeneAddPropertyItem((ActionListener)this, (Component)this, this.mediator, this.globalAlignViewModel.getGlobalAlign().getOrganismList(), this.globalAlignViewModel.getGlobalAlign().getGlobalAlignGroupList()));
        jMenu3.add(new CoreGeneAddSetItem((ActionListener)this, (Component)this, this.mediator, this.globalAlignViewModel.getGlobalAlign().getOrganismList(), this.globalAlignViewModel.getGlobalAlign().getGlobalAlignGroupList()));
        return jMenuBar;
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        GlobalAlignZoominTool globalAlignZoominTool = new GlobalAlignZoominTool(this, this.mediator, this.globalAlignViewModel);
        GlobalAlignZoomoutTool globalAlignZoomoutTool = new GlobalAlignZoomoutTool(this, this.mediator, this.globalAlignViewModel);
        this.globalAlignViewModel.addZoomListener(globalAlignZoominTool);
        this.globalAlignViewModel.addZoomListener(globalAlignZoomoutTool);
        GlobalAlignLeftTool globalAlignLeftTool = new GlobalAlignLeftTool(this, this);
        GlobalAlignRightTool globalAlignRightTool = new GlobalAlignRightTool(this, this);
        GlobalAlignOriginRecoverTool globalAlignOriginRecoverTool = new GlobalAlignOriginRecoverTool(this, this);
        GlobalAlignMoveNormalTool globalAlignMoveNormalTool = new GlobalAlignMoveNormalTool(this, this);
        GlobalAlignMoveArrangementTool globalAlignMoveArrangementTool = new GlobalAlignMoveArrangementTool(this, this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(globalAlignMoveNormalTool);
        buttonGroup.add(globalAlignMoveArrangementTool);
        globalAlignMoveNormalTool.setSelected(!this.globalAlignViewModel.isAdjustMode());
        globalAlignMoveArrangementTool.setSelected(this.globalAlignViewModel.isAdjustMode());
        GlobalAlignClickShowGeneInfoButton globalAlignClickShowGeneInfoButton = new GlobalAlignClickShowGeneInfoButton(this, this.globalAlignViewModel);
        globalAlignClickShowGeneInfoButton.setSelected(this.globalAlignViewModel.isShowGeneInfoOnBrowser());
        jToolBar.add(globalAlignLeftTool);
        jToolBar.add(globalAlignRightTool);
        jToolBar.addSeparator();
        jToolBar.add(globalAlignZoominTool);
        jToolBar.add(globalAlignZoomoutTool);
        jToolBar.addSeparator();
        jToolBar.add(globalAlignMoveNormalTool);
        jToolBar.add(globalAlignMoveArrangementTool);
        jToolBar.addSeparator();
        jToolBar.add(globalAlignClickShowGeneInfoButton);
        return jToolBar;
    }

    public void zoom(double d) {
        this.globalAlignPanel.zoom(d);
        this.globalAlignViewModel.notifyZoom();
    }

    public void moveLeft() {
        this.globalAlignPanel.moveLeft();
    }

    public void moveRight() {
        this.globalAlignPanel.moveRight();
    }

    void recoverCentralPosition() {
        this.globalAlignPanel.recoverCentralPosition();
    }

    public void updateGlobalAlign(boolean bl) {
        this.globalAlignViewModel.updatePositionForChangeReferenceGenome();
        this.globalAlignPanel.updateGlobalAlign();
        if (bl) {
            this.mediator.setCoreParamToCoreGenome(this.globalAlignViewModel.createCoreCommonParamDTO());
        }
    }

    public void selectOrthologGroup(String string) {
        this.globalAlignPanel.selectOrthologGroup(string);
    }

    public void selectOrthologGroup(List list) {
        this.globalAlignPanel.selectOrthologGroup(list);
    }

    public void changeCentralPosition(String string) {
        this.globalAlignPanel.changeCentralPosition(string);
    }

    public void setCoreParam(CoreCommonParamDTO coreCommonParamDTO) {
        this.globalAlignViewModel.setCoreCommonParamDTO(coreCommonParamDTO);
    }

    void changeMoveMode(boolean bl) {
        System.err.println(">>>AdjustMode:" + bl);
        if (this.globalAlignViewModel.isAdjustMode() == bl) {
            return;
        }
        this.globalAlignViewModel.setAdjustMode(bl);
        this.globalAlignViewModel.changeCoordinateGenePositionByChangeAdjustMode(bl);
        this.globalAlignPanel.updateGlobalAlign();
    }

    private void exit() {
        GlobalAlignPrintDialog globalAlignPrintDialog = GlobalAlignPrintDialog.getInstance();
        if (globalAlignPrintDialog != null) {
            globalAlignPrintDialog.setVisible(false);
            globalAlignPrintDialog.dispose();
        }
        this.mediator.closeGlobalAlignFrame();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.globalAlignPanel.isNeedUpdateByResize()) {
            this.globalAlignPanel.updateDrawWidth();
            this.globalAlignPanel.updateGlobalAlign();
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }
}

