/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.GlobalAlign;
import cgdp.recog.align.GlobalAlignElement;
import cgdp.recog.align.GlobalAlignGroup;
import cgdp.recog.align.GlobalAlignRange;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.coregenome.OrthologGroup;
import cgdp.recog.data.Chromosome;
import cgdp.recog.data.ChromosomeTbl;
import cgdp.recog.data.ChromosomeTypeComparator;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.Gene;
import cgdp.recog.data.GeneDomain;
import cgdp.recog.data.GeneTbl;
import cgdp.recog.organism.Organism;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GlobalAlignGenerater {
    private static final ApplicationLogger logger = new ApplicationLogger(GlobalAlignGenerater.class);
    private ClusterTbl clusterTbl;
    private GenomeAlign genomeAlign;
    private List organismList;
    private String referenceOrganismCode;
    private GlobalAlign globalAlign;
    private boolean error = false;
    private String errorMessage;
    private ProgressImpl progressImpl = new DummyProgressComponent();

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    public void setGenomeAlign(GenomeAlign genomeAlign) {
        this.genomeAlign = genomeAlign;
    }

    public void setOrganismList(List list) {
        this.organismList = list;
    }

    public void setProgressImpl(ProgressImpl progressImpl) {
        this.progressImpl = progressImpl;
    }

    public String getReferenceOrganismCode() {
        return this.referenceOrganismCode;
    }

    private boolean isGenomeAlign() {
        return this.genomeAlign != null;
    }

    public GlobalAlign getGlobalAlign() {
        return this.globalAlign;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean bl) {
        this.error = bl;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public void execute() throws Exception {
        this.progressImpl.setTotal(100);
        Map map = new HashMap();
        if (this.isGenomeAlign()) {
            map = this.getAlignGroupListFromGenomeAlign();
        }
        if (!this.setProgress(29)) {
            return;
        }
        List list = this.getAlignGroupListFromClusterTbl(this.organismList, map);
        list.addAll(map.values());
        if (list.isEmpty()) {
            this.progressImpl.setCount(99);
            this.progressImpl.increment();
            return;
        }
        Map map2 = this.createGeneTblMap(this.organismList);
        List list2 = this.getAlignGroupOfRna(this.organismList, map2);
        list.addAll(list2);
        if (!this.setProgress(39)) {
            return;
        }
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        if (!this.setProgress(59)) {
            return;
        }
        List list3 = this.setGeneInfo(this.organismList, list, hashMap, hashMap2, map2);
        list.addAll(this.createComplementAlignGroup(list3));
        if (!this.setProgress(69)) {
            return;
        }
        if (!this.setProgress(89)) {
            return;
        }
        this.globalAlign = new GlobalAlign();
        this.globalAlign.setOrganismList(this.organismList);
        this.globalAlign.setGlobalAlignGroupList(list);
        this.globalAlign.setOrganismGenomeLengthMap(hashMap);
        this.globalAlign.setChromosomeOrderMap(hashMap2);
        this.setProgress(99);
    }

    private boolean setProgress(int n) {
        if (this.progressImpl.isCanceled()) {
            return false;
        }
        this.progressImpl.setCount(n);
        this.progressImpl.increment();
        return true;
    }

    private Map createGeneTblMap(List list) throws Exception {
        HashMap<String, GeneTbl> hashMap = new HashMap<String, GeneTbl>();
        for (Organism organism : list) {
            GeneTbl geneTbl = new GeneTbl(organism.getOrganismCode());
            geneTbl.read();
            hashMap.put(organism.getOrganismCode(), geneTbl);
        }
        return hashMap;
    }

    private Map getAlignGroupListFromGenomeAlign() {
        HashMap<String, GlobalAlignGroup> hashMap = new HashMap<String, GlobalAlignGroup>();
        List list = this.genomeAlign.getOrganismList();
        List list2 = this.genomeAlign.getOrthologGroupList();
        for (OrthologGroup orthologGroup : list2) {
            GlobalAlignGroup globalAlignGroup = GlobalAlignGroup.createAlignGroup(list, orthologGroup);
            hashMap.put(orthologGroup.getConbineClusterId(), globalAlignGroup);
        }
        return hashMap;
    }

    private List getAlignGroupListFromClusterTbl(List list, Map map) {
        ArrayList<GlobalAlignGroup> arrayList = new ArrayList<GlobalAlignGroup>();
        List list2 = this.clusterTbl.getClusterList();
        HashSet hashSet = new HashSet();
        for (Cluster cluster : list2) {
            String string;
            GlobalAlignGroup globalAlignGroup;
            GlobalAlignGroup globalAlignGroup2 = GlobalAlignGroup.createNonCoreAlignGroup(list, cluster, globalAlignGroup = (GlobalAlignGroup)map.get(string = cluster.getConbinedClusterId()), hashSet);
            if (globalAlignGroup2 != null) {
                arrayList.add(globalAlignGroup2);
            }
            if (!this.clusterTbl.isOutgroup()) continue;
            for (String string2 : this.clusterTbl.getOutgroupSpList()) {
                hashSet.addAll(cluster.getOrgasnismLocusTagKeySet(string2));
            }
        }
        return arrayList;
    }

    private List getAlignGroupOfRna(List list, Map map) {
        ArrayList<GlobalAlignGroup> arrayList = new ArrayList<GlobalAlignGroup>();
        for (Organism organism : list) {
            GeneTbl geneTbl = (GeneTbl)map.get(organism.getOrganismCode());
            System.err.println(">>read gene table: " + organism.getOrganismCode());
            List list2 = geneTbl.getRNAList();
            if (CollectionUtil.isNull(list2)) continue;
            for (Gene gene : list2) {
                GlobalAlignGroup globalAlignGroup = GlobalAlignGroup.createRnaAlignGroup(organism, gene);
                if (globalAlignGroup == null) continue;
                arrayList.add(globalAlignGroup);
            }
        }
        return arrayList;
    }

    private List createComplementAlignGroup(List list) {
        ArrayList<GlobalAlignGroup> arrayList = new ArrayList<GlobalAlignGroup>();
        for (GlobalAlignElement globalAlignElement : list) {
            GlobalAlignGroup globalAlignGroup = GlobalAlignGroup.createComplementAlignGroup(globalAlignElement);
            arrayList.add(globalAlignGroup);
        }
        return arrayList;
    }

    private List setGeneInfo(List list, List list2, Map map, Map map2, Map map3) throws Exception {
        Map map4 = this.getGeneDomainMap();
        Map map5 = GlobalAlign.createGlobalAlignElementMap(list, list2);
        ArrayList<GlobalAlignElement> arrayList = new ArrayList<GlobalAlignElement>();
        for (Organism organism : list) {
            Object object;
            Object object22;
            ChromosomeTbl chromosomeTbl = new ChromosomeTbl(organism);
            chromosomeTbl.read();
            int n = 0;
            for (Object object22 : chromosomeTbl.keySet()) {
                object = (Chromosome)chromosomeTbl.get(object22);
                n += ((Chromosome)object).getLength();
            }
            map.put(organism.getOrganismCode(), new Integer(n));
            ArrayList arrayList2 = new ArrayList(chromosomeTbl.values());
            Collections.sort(arrayList2, new ChromosomeTypeComparator());
            map2.put(organism.getOrganismCode(), arrayList2);
            object22 = (GeneTbl)map3.get(organism.getOrganismCode());
            ((GeneTbl)object22).read();
            object = (List)map5.get(organism.getOrganismCode());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string;
                GeneDomain geneDomain;
                GlobalAlignElement globalAlignElement = (GlobalAlignElement)iterator.next();
                Gene gene = (Gene)((HashMap)object22).get(globalAlignElement.getLocusTagWithoutDomain());
                if (gene == null) continue;
                int n2 = gene.getStart();
                int n3 = gene.getEnd();
                boolean bl = true;
                if (globalAlignElement.isDomain() && (geneDomain = (GeneDomain)map4.get(string = GeneUtil.createOrganismLocusTagKey(organism.getOrganismCode(), globalAlignElement.getLocusTag()))) != null) {
                    if (gene.isPositive()) {
                        n3 = geneDomain.getTo() + n2;
                        n2 = geneDomain.getFrom() + n2 - 1;
                    } else {
                        n3 = gene.getLength() - geneDomain.getFrom() + n2;
                        n2 = gene.getLength() - geneDomain.getTo() + n2 - 1;
                    }
                    if (!geneDomain.isMaxDomain()) {
                        bl = false;
                    } else if (n3 != gene.getEnd()) {
                        GlobalAlignElement globalAlignElement2 = this.createComplementElement(organism, gene, geneDomain);
                        arrayList.add(globalAlignElement2);
                        bl = false;
                    }
                }
                globalAlignElement.setStart(n2);
                globalAlignElement.setEnd(n3);
                int n4 = (int)((double)(n2 + n3) / 2.0);
                globalAlignElement.setPosition(n4);
                globalAlignElement.setGeneDirection((short)gene.getDirection());
                globalAlignElement.setChromID(gene.getChromId());
                globalAlignElement.setShowArrow(bl);
                if (!gene.isJoin()) continue;
                globalAlignElement.setLocationList(this.getLocationList(gene.getLocation(), gene.getStart(), globalAlignElement));
            }
        }
        return arrayList;
    }

    private GlobalAlignElement createComplementElement(Organism organism, Gene gene, GeneDomain geneDomain) {
        GlobalAlignElement globalAlignElement = new GlobalAlignElement();
        globalAlignElement.setLocusTag(gene.getLocusTag() + "_C");
        globalAlignElement.setOrganism(organism);
        int n = geneDomain.getTo() + gene.getStart();
        int n2 = gene.getEnd();
        if (gene.isNegative()) {
            n2 = gene.getLength() - geneDomain.getTo() + gene.getStart();
            n = gene.getStart();
        }
        globalAlignElement.setStart(n);
        globalAlignElement.setEnd(n2);
        int n3 = (int)((double)(n + n2) / 2.0);
        globalAlignElement.setPosition(n3);
        globalAlignElement.setGeneDirection((short)gene.getDirection());
        globalAlignElement.setChromID(gene.getChromId());
        globalAlignElement.setShowArrow(true);
        return globalAlignElement;
    }

    private List getLocationList(String string, int n, GlobalAlignElement globalAlignElement) {
        List list = Gene.getExonRegionList(string);
        ArrayList<GlobalAlignRange> arrayList = new ArrayList<GlobalAlignRange>();
        for (Range range : list) {
            GlobalAlignRange globalAlignRange = new GlobalAlignRange(range.getX1() - n, range.getX2() - n - 1, globalAlignElement);
            arrayList.add(globalAlignRange);
        }
        return arrayList;
    }

    private Map getGeneDomainMap() {
        return this.clusterTbl.createGeneDomainMap();
    }
}

