/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.GlobalAlignArrangeOptionPanel;
import cgdp.recog.align.GlobalAlignColorOptionPanel;
import cgdp.recog.align.GlobalAlignScaleOptionPanel;
import cgdp.recog.align.GlobalAlignViewModel;
import cgdp.recog.align.GlobalAlignViewOptionPanel;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.TabDialog;
import java.awt.Frame;
import java.io.IOException;

public class GlobalAlignOptionDialog
extends TabDialog {
    private static final ApplicationLogger logger = new ApplicationLogger(GlobalAlignOptionDialog.class);
    private MediatorImpl mediator;
    private GlobalAlignViewModel globalAlignViewModel;

    public GlobalAlignOptionDialog(Frame frame, MediatorImpl mediatorImpl, GlobalAlignViewModel globalAlignViewModel) {
        super(frame);
        this.setShowDefaultButton(true);
        this.mediator = mediatorImpl;
        this.globalAlignViewModel = globalAlignViewModel;
        this.createComponents();
    }

    @Override
    protected void addTabPanel() {
        this.tabbedPane.add("View", new GlobalAlignViewOptionPanel(this, this.mediator, this.globalAlignViewModel));
        this.tabbedPane.add("Color", new GlobalAlignColorOptionPanel(this, this.mediator, this.globalAlignViewModel));
        this.tabbedPane.add("Arrange", new GlobalAlignArrangeOptionPanel(this, this.mediator, this.globalAlignViewModel));
        this.tabbedPane.add("Scale", new GlobalAlignScaleOptionPanel(this, this.mediator, this.globalAlignViewModel));
    }

    @Override
    protected boolean processApply() {
        this.globalAlignViewModel.processAfterUpdateOrganism();
        this.globalAlignViewModel.updateAlignGroupStatus();
        this.globalAlignViewModel.clearSelectGlobalAlignGroup();
        this.globalAlignViewModel.updateViewPosition();
        try {
            ApplicationPropertyFacade.saveProperty(this.globalAlignViewModel.getDomClustId(), this.globalAlignViewModel);
        }
        catch (IOException iOException) {
            String string = "Fail to save genome comparison viewer's options";
            logger.warn(string, iOException);
        }
        this.mediator.updateGlobalAlignMap(true);
        return true;
    }
}

