/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.GlobalAlignPrintable;
import cgdp.recog.align.GlobalAlignViewModel;
import cgdp.recog.process.DefaultThreadCancelListener;
import cgdp.recog.process.ThreadCancelListener;
import cgdp.recog.process.ThreadManager;
import cgdp.recog.util.ApplicationLogger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class GlobalAlignPreviewPanel
extends JPanel {
    private static final ApplicationLogger logger = new ApplicationLogger(GlobalAlignPreviewPanel.class);
    private static final double BASE_PANEL_SIZE = 200.0;
    private PageFormat pageFormat;
    private GlobalAlignViewModel globalAlignViewModel;
    private boolean zoomAuto = true;
    private double zoomSpecValue;
    private BufferedImage image;
    private Set taskSet = new HashSet();

    GlobalAlignPreviewPanel(GlobalAlignViewModel globalAlignViewModel, PageFormat pageFormat) {
        this.pageFormat = pageFormat;
        this.globalAlignViewModel = globalAlignViewModel;
        this.setPreferredSize(new Dimension(200, 200));
    }

    void updateValue(GlobalAlignViewModel globalAlignViewModel, PageFormat pageFormat) {
        if (this.pageFormat == null || this.globalAlignViewModel == null || this.globalAlignViewModel.getGlobalAlignRenderer() == null) {
            return;
        }
        this.pageFormat = pageFormat;
        this.globalAlignViewModel = globalAlignViewModel;
        this.zoomAuto = globalAlignViewModel.isPrintZoomAuto();
        this.zoomSpecValue = globalAlignViewModel.getPrintZoomSpecValue();
        this.createPreviewImage();
    }

    void updateValue(boolean bl, double d, PageFormat pageFormat) {
        if (this.pageFormat == null || this.globalAlignViewModel == null || this.globalAlignViewModel.getGlobalAlignRenderer() == null) {
            return;
        }
        this.pageFormat = pageFormat;
        this.zoomAuto = bl;
        this.zoomSpecValue = d;
        this.createPreviewImage();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.image == null) {
            return;
        }
        int n = (int)((200.0 - (double)this.getPreviewWidth()) / 2.0);
        int n2 = (int)((200.0 - (double)this.getPreviewHeight()) / 2.0);
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.drawImage(this.image, n, n2, null);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, this.getPreviewWidth() - 1, this.getPreviewHeight() - 1);
    }

    private double calcZoomScale() {
        double d = this.pageFormat.getWidth();
        double d2 = this.pageFormat.getHeight();
        double d3 = 1.0;
        d3 = d >= d2 ? 200.0 / d : 200.0 / d2;
        return d3;
    }

    private int getPreviewWidth() {
        double d = this.calcZoomScale();
        return (int)(this.pageFormat.getWidth() * d);
    }

    private int getPreviewHeight() {
        double d = this.calcZoomScale();
        return (int)(this.pageFormat.getHeight() * d);
    }

    private synchronized void createPreviewImage() {
        Object object2;
        for (Object object2 : this.taskSet) {
            ((PreviewImageUpdateTask)object2).cancel();
        }
        this.taskSet.clear();
        PreviewImageUpdateTask previewImageUpdateTask = new PreviewImageUpdateTask();
        object2 = ThreadManager.getInstance();
        ((ThreadManager)object2).execute(previewImageUpdateTask);
        this.taskSet.add(previewImageUpdateTask);
    }

    private class PreviewImageUpdateTask
    implements Runnable,
    ThreadCancelListener {
        private ThreadCancelListener threadCancelListener = new DefaultThreadCancelListener();

        private PreviewImageUpdateTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            if (this.threadCancelListener.isCancel()) {
                return;
            }
            double d = GlobalAlignPreviewPanel.this.calcZoomScale();
            BufferedImage bufferedImage = new BufferedImage(GlobalAlignPreviewPanel.this.getPreviewWidth(), GlobalAlignPreviewPanel.this.getPreviewHeight(), 5);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            try {
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, GlobalAlignPreviewPanel.this.getWidth(), GlobalAlignPreviewPanel.this.getHeight());
                graphics2D.scale(d, d);
                object = (GlobalAlignViewModel)GlobalAlignPreviewPanel.this.globalAlignViewModel.clone();
                ((GlobalAlignViewModel)object).setPrintZoomSpecValue(GlobalAlignPreviewPanel.this.zoomSpecValue);
                ((GlobalAlignViewModel)object).setPrintZoomAuto(GlobalAlignPreviewPanel.this.zoomAuto);
                GlobalAlignPrintable globalAlignPrintable = new GlobalAlignPrintable(GlobalAlignPreviewPanel.this.pageFormat, (GlobalAlignViewModel)object);
                globalAlignPrintable.print(graphics2D, GlobalAlignPreviewPanel.this.pageFormat, 0);
                graphics2D.scale(1.0 / d, 1.0 / d);
            }
            catch (PrinterException printerException) {
                logger.warn("Fail to show genome comparison viewer image.", printerException);
            }
            finally {
                graphics2D.dispose();
            }
            if (this.threadCancelListener.isCancel()) {
                return;
            }
            if (GlobalAlignPreviewPanel.this.image != null) {
                object = GlobalAlignPreviewPanel.this.image;
                synchronized (object) {
                    GlobalAlignPreviewPanel.this.image.flush();
                    GlobalAlignPreviewPanel.this.image = bufferedImage;
                }
            } else {
                GlobalAlignPreviewPanel.this.image = bufferedImage;
            }
            object = new Runnable(){

                @Override
                public void run() {
                    GlobalAlignPreviewPanel.this.repaint();
                }
            };
            SwingUtilities.invokeLater((Runnable)object);
        }

        @Override
        public void cancel() {
            this.threadCancelListener.cancel();
        }

        @Override
        public boolean isCancel() {
            return this.threadCancelListener.isCancel();
        }
    }
}

