/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.bean;

import cgdp.recog.access.ExportMenu;
import cgdp.recog.access.ExportTool;
import cgdp.recog.access.FileAccessFacade;
import cgdp.recog.access.ImportMenu;
import cgdp.recog.access.ImportTool;
import cgdp.recog.active.ColorActivation;
import cgdp.recog.active.FilterActivation;
import cgdp.recog.active.OrganismColumnActivation;
import cgdp.recog.align.CoreGenePropertyCreater;
import cgdp.recog.align.CoreGenePropertyDialog;
import cgdp.recog.align.CoreGeneSetAddDialog;
import cgdp.recog.align.CoreGeneSetCreater;
import cgdp.recog.align.CoreGeneTargetCondition;
import cgdp.recog.align.GlobalAlignFrame;
import cgdp.recog.align.GlobalAlignOptionDialog;
import cgdp.recog.align.GlobalAlignPrintable;
import cgdp.recog.align.GlobalAlignViewModel;
import cgdp.recog.align.GlobalAlignmentCommand;
import cgdp.recog.bean.ClusterArea;
import cgdp.recog.bean.ClusterHScrollBar;
import cgdp.recog.bean.ClusterList;
import cgdp.recog.bean.ClusterMap;
import cgdp.recog.bean.ClusterScrollPane;
import cgdp.recog.bean.ClusterVScrollBar;
import cgdp.recog.bean.Const;
import cgdp.recog.bean.GeneInfoList;
import cgdp.recog.bean.GeneNameList;
import cgdp.recog.bean.HeaderMap;
import cgdp.recog.bean.HeaderScrollPane;
import cgdp.recog.bean.InfoTabbedPane;
import cgdp.recog.bean.MainWindow;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.bean.ModePanel;
import cgdp.recog.bean.TreeOptionPanel;
import cgdp.recog.bean.TreeTabbedPane;
import cgdp.recog.calc.CoefCalcExecuter;
import cgdp.recog.calc.CoefCondition;
import cgdp.recog.calc.CoefDialog;
import cgdp.recog.color.ColorFacade;
import cgdp.recog.color.geneinfo.GeneColorCondition;
import cgdp.recog.color.geneinfo.GeneColorDialog;
import cgdp.recog.color.geneinfo.GeneColorExecuter;
import cgdp.recog.color.geneinfo.GeneColorItem;
import cgdp.recog.color.geneinfo.GeneColorTool;
import cgdp.recog.controltree.ControlTree;
import cgdp.recog.controltree.SetTree;
import cgdp.recog.coregenome.ConnectionUpdater;
import cgdp.recog.coregenome.CoreCommonParamDTO;
import cgdp.recog.coregenome.CoreGenomeAlignment;
import cgdp.recog.coregenome.CoreGenomeAlignmentCondition;
import cgdp.recog.coregenome.CoreGenomeAnalysis;
import cgdp.recog.coregenome.CoreGenomeExecuteDialog;
import cgdp.recog.coregenome.CoreGenomeExporter;
import cgdp.recog.coregenome.CoreGenomeFacade;
import cgdp.recog.coregenome.CoreGenomeFileFilter;
import cgdp.recog.coregenome.CoreGenomeFrame;
import cgdp.recog.coregenome.CoreGenomeItem;
import cgdp.recog.coregenome.CoreGenomePreviewDialog;
import cgdp.recog.coregenome.CoreGenomePrintable;
import cgdp.recog.coregenome.CoreGenomeTool;
import cgdp.recog.coregenome.CoreGenomeUpdateDialog;
import cgdp.recog.coregenome.CoreGenomeUploadExecuter;
import cgdp.recog.coregenome.CoreGenomeUtil;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.coregenome.FullCoreGenomeAlignment;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.data.AminoCodeTbl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterId;
import cgdp.recog.data.ClusterIdTbl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.ClusterTblCreater;
import cgdp.recog.data.ColorTbl;
import cgdp.recog.data.DataClearExecuter;
import cgdp.recog.data.DataFileDownloader;
import cgdp.recog.data.DataManager;
import cgdp.recog.data.Gene;
import cgdp.recog.data.GenomeTbl;
import cgdp.recog.data.InnerTbl;
import cgdp.recog.data.OuterTbl;
import cgdp.recog.data.PatternTbl;
import cgdp.recog.data.PublicSpecTbl;
import cgdp.recog.data.SpGroupTbl;
import cgdp.recog.domclust.AbstractDomClustImporter;
import cgdp.recog.domclust.DomClust;
import cgdp.recog.domclust.DomClustAnalysis;
import cgdp.recog.domclust.DomClustAnalysisListDownloadExecuter;
import cgdp.recog.domclust.DomClustCondition;
import cgdp.recog.domclust.DomClustDialog;
import cgdp.recog.domclust.DomClustExecuteValidator;
import cgdp.recog.domclust.DomClustFileOpenHelper;
import cgdp.recog.domclust.DomClustQuery;
import cgdp.recog.domclust.DomClustSaveExecuter;
import cgdp.recog.domclust.DomClustSaveServerItem;
import cgdp.recog.domclust.DomClustUploadExecuter;
import cgdp.recog.domclust.FileLoader;
import cgdp.recog.domclust.FileSaveItem;
import cgdp.recog.domclust.FileSaveTool;
import cgdp.recog.filefilter.FileExtension;
import cgdp.recog.filefilter.FileFilterFactory;
import cgdp.recog.filter.CountFilterCondition;
import cgdp.recog.filter.CountFilterDialog;
import cgdp.recog.filter.CountFilterItem;
import cgdp.recog.filter.FilterFacade;
import cgdp.recog.filter.FilterThresholdDialog;
import cgdp.recog.filter.GeneCountFilterCondition;
import cgdp.recog.filter.OrganismCountFilterCondition;
import cgdp.recog.filter.TaxFilterCondition;
import cgdp.recog.funccat.FuncCat;
import cgdp.recog.funccat.FuncCatTbl;
import cgdp.recog.funccat.FuncCatTool;
import cgdp.recog.funccat.FunctionCategoryDialog;
import cgdp.recog.gmap.GenomeMapFrame;
import cgdp.recog.gmap.GenomeScrollPane;
import cgdp.recog.hcluster.HClustCondition;
import cgdp.recog.hcluster.HClustDialog;
import cgdp.recog.hcluster.HClustExecuter;
import cgdp.recog.hcluster.HClustItem;
import cgdp.recog.hcluster.HClustTool;
import cgdp.recog.hcluster.HClustUtil;
import cgdp.recog.hcluster.MergeAllExecuteDialog;
import cgdp.recog.hcluster.tree.ClusterTreeMap;
import cgdp.recog.hcluster.tree.ClusterTreeScrollBar;
import cgdp.recog.hcluster.tree.ClusterTreeScrollPane;
import cgdp.recog.histogram.CategoryMap;
import cgdp.recog.histogram.CategoryScrollBar;
import cgdp.recog.histogram.CategoryScrollPane;
import cgdp.recog.histogram.HistogramCondition;
import cgdp.recog.histogram.HistogramDataCreater;
import cgdp.recog.histogram.HistogramDialog;
import cgdp.recog.histogram.HistogramItem;
import cgdp.recog.histogram.HistogramTool;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoListDialog;
import cgdp.recog.info.cell.CellInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoConvertCondition;
import cgdp.recog.info.cluster.ClusterInfoConvertDialog;
import cgdp.recog.info.cluster.ClusterInfoConvertItem;
import cgdp.recog.info.cluster.ClusterInfoConverter;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ServerClusterListDialog;
import cgdp.recog.info.gene.GeneFrame;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoListCreater;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.info.gene.ServerGeneListDialog;
import cgdp.recog.mapping.MapCondition;
import cgdp.recog.mapping.MapConf;
import cgdp.recog.mapping.MapEditDialog;
import cgdp.recog.mapping.MapExecuter;
import cgdp.recog.mapping.MapFacade;
import cgdp.recog.menu.AggregateModeItem;
import cgdp.recog.menu.AggregateModeTool;
import cgdp.recog.menu.AllClusterSelectItem;
import cgdp.recog.menu.ClusterModeItem;
import cgdp.recog.menu.ClusterModeTool;
import cgdp.recog.menu.ColorDialog2;
import cgdp.recog.menu.FunctionItem;
import cgdp.recog.menu.TaxonomyItem;
import cgdp.recog.mgmap.AlignmentFrame;
import cgdp.recog.mgmap.DrawFeatureMap;
import cgdp.recog.mgmap.RGMCondition;
import cgdp.recog.multiplealign.MultipleAlignment;
import cgdp.recog.multiplealign.MultipleAlignmentExecuter;
import cgdp.recog.multiplealign.MultipleAlignmentFrame;
import cgdp.recog.multiplealign.TreeCreater;
import cgdp.recog.neighbor.NeighborClustDialog;
import cgdp.recog.neighbor.NeighborClustGeneSortExecuter;
import cgdp.recog.neighbor.NeighborClustItem;
import cgdp.recog.neighbor.NeighborClustTool;
import cgdp.recog.neighbor.NeighboringClustCondition;
import cgdp.recog.neighbor.NeighboringClustExecuter;
import cgdp.recog.option.OptionDialog;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.organism.MergeOrganismReleaseItem;
import cgdp.recog.organism.ModifiedOrganismManager;
import cgdp.recog.organism.OrganismMergeExecuter;
import cgdp.recog.organism.OrganismSet;
import cgdp.recog.organism.OrganismSetDialog;
import cgdp.recog.organism.OrganismSetGroup;
import cgdp.recog.organism.OrganismSplitCondition;
import cgdp.recog.organism.OrganismSplitDialog2;
import cgdp.recog.organism.OrganismSplitExecuter;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.organism.SplitOrganismReleaseItem;
import cgdp.recog.pattern.Pattern;
import cgdp.recog.pattern.PatternEditDialog;
import cgdp.recog.pattern.PatternFactory;
import cgdp.recog.pattern.PatternUtil;
import cgdp.recog.ppm.MergeClusterReleaseItem;
import cgdp.recog.ppm.OrganismColumnDialog;
import cgdp.recog.ppm.PPMLabelCondition;
import cgdp.recog.ppm.PPMLabelConditionFactory;
import cgdp.recog.ppm.PPMLabelMenu;
import cgdp.recog.ppm.PPMLabelType;
import cgdp.recog.ppm.SplitClusterReleaseItem;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProcessImpl;
import cgdp.recog.process.ProgressDialog;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.process.ThreadManager;
import cgdp.recog.project.AnalysisUploadDialog;
import cgdp.recog.project.BaseClusterListDialog;
import cgdp.recog.project.DeleteDialog;
import cgdp.recog.project.MultiServerAnalysisDownloadExecuter;
import cgdp.recog.project.OpenDialog;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.project.ProjectEditDialog;
import cgdp.recog.project.ProjectListDialog;
import cgdp.recog.project.PublicSpeciesDownloader;
import cgdp.recog.project.ServerProjectListDialog;
import cgdp.recog.property.PropertyDialog;
import cgdp.recog.property.PropertyItem;
import cgdp.recog.property.PropertyMapCreater;
import cgdp.recog.ptree.bean.PtreeMainWindow;
import cgdp.recog.ptree.bean.Tree;
import cgdp.recog.ptree.bean.interfaces.RecogQueryImpl;
import cgdp.recog.search.ClusterSearchResultDialog;
import cgdp.recog.search.GeneSearchResultDialog;
import cgdp.recog.search.KeywordSearch;
import cgdp.recog.search.KeywordSearchDialog;
import cgdp.recog.search.KeywordSearchMainItem;
import cgdp.recog.search.KeywordSearchTool;
import cgdp.recog.search.SearchCondition;
import cgdp.recog.search.SearchResultGroup;
import cgdp.recog.seq.SeqDownloadCondition;
import cgdp.recog.seq.SeqDownloadDialog;
import cgdp.recog.seq.SeqDownloadExecuter;
import cgdp.recog.server.AccessServer;
import cgdp.recog.server.Server;
import cgdp.recog.server.ServerAccessCheckTask;
import cgdp.recog.server.ServerComparator;
import cgdp.recog.server.ServerEditDialog;
import cgdp.recog.server.ServerListDialog;
import cgdp.recog.server.ServerTbl;
import cgdp.recog.server.UploadDialog;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.AbstractElementSetFacade;
import cgdp.recog.set.ElementSetGroup;
import cgdp.recog.set.SetCombinationDialog;
import cgdp.recog.set.SetCondition;
import cgdp.recog.set.SetConditionUtil;
import cgdp.recog.set.SetFilterColorDialog;
import cgdp.recog.set.SetListDialog;
import cgdp.recog.set.SetType;
import cgdp.recog.set.SetUploadExecuter;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.set.cluster.ClusterSetCondition;
import cgdp.recog.set.cluster.ClusterSetConverter;
import cgdp.recog.set.cluster.ClusterSetFacade;
import cgdp.recog.set.cluster.ClusterSetImportDialog;
import cgdp.recog.set.cluster.ServerClusterSetDialog;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.set.gene.GeneSetCondition;
import cgdp.recog.set.gene.GeneSetFacade;
import cgdp.recog.set.gene.ServerGeneSetListDialog;
import cgdp.recog.sort.BasicSortCondition;
import cgdp.recog.sort.ClusterListSorter;
import cgdp.recog.sort.GeneInfoSortDialog;
import cgdp.recog.sort.PatternCoefClusteringExecuter;
import cgdp.recog.sort.PatternCoefDialog;
import cgdp.recog.sort.SortConditionFactory;
import cgdp.recog.sort.SortException;
import cgdp.recog.spgroup.SpGroup;
import cgdp.recog.spgroup.SpGroupTree;
import cgdp.recog.statusbar.StatusBar;
import cgdp.recog.system.property.ApplicationPropertyConf;
import cgdp.recog.system.property.ApplicationPropertyDialog;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.system.property.ApplicationPropertySaveAsItem;
import cgdp.recog.system.property.ApplicationPropertySaveItem;
import cgdp.recog.system.property.ApplicationPropertySaveProcess;
import cgdp.recog.taxonomy.RankSelectPanel;
import cgdp.recog.taxonomy.TaxSearchCondition;
import cgdp.recog.taxonomy.TaxTreeSearchExecuter;
import cgdp.recog.taxonomy.TaxonomyTree;
import cgdp.recog.taxonomy.TaxonomyTreeEx;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import cgdp.recog.taxonomy.map.TaxMapExecuteDialog;
import cgdp.recog.taxonomy.map.TaxMapExecuteItem;
import cgdp.recog.taxonomy.map.TaxMapExecuteTool;
import cgdp.recog.taxonomy.map.TaxMapExecuter;
import cgdp.recog.taxonomy.map.TaxMapFrame;
import cgdp.recog.taxonomy.map.TaxMapGenePropertyCreater;
import cgdp.recog.taxonomy.map.TaxMapGenePropertyCreater2;
import cgdp.recog.taxonomy.map.TaxMapGenomeScoreCalculater;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.taxonomy.map.TaxMapPropertyCondition;
import cgdp.recog.taxonomy.map.TaxMapPropertyDialog;
import cgdp.recog.update.AbstractDataUpdater;
import cgdp.recog.update.DataUpdateDialog;
import cgdp.recog.update.SysInfo;
import cgdp.recog.update.UpdateCheckExecuter;
import cgdp.recog.url.GeneUrlFacade;
import cgdp.recog.url.GeneUrlListDialog;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.AbstractFileFilter;
import cgdp.recog.util.AbstractPrintable;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.NameEditDialog;
import cgdp.recog.util.ResourceBandleWrapper;
import cgdp.recog.util.SimpleServerConnection;
import cgdp.recog.util.StringTool;
import com.centerkey.utils.BareBonesBrowserLaunch;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;

public class Mediator
implements MediatorImpl,
RecogQueryImpl {
    private static final ApplicationLogger logger = new ApplicationLogger(Mediator.class);
    OptionTbl m_optionTbl;
    FuncCatTbl m_funcCatTbl;
    ClusterIdTbl m_clusterIdTbl;
    ClusterTbl m_clusterTbl;
    OuterTbl m_outerTbl;
    InnerTbl m_innerTbl;
    PublicSpecTbl m_publicSpecTbl;
    AminoCodeTbl m_aminoCodeTbl;
    PatternTbl m_patternTbl;
    ServerTbl m_serverTbl;
    ColorTbl m_colorTbl;
    MainWindow m_mainWindow;
    InfoTabbedPane m_infoTabbedPane;
    TreeTabbedPane m_treeTabbedPane;
    TaxonomyTree m_taxonomyTree;
    TaxonomyTreeEx m_taxonomyTreeEx;
    DomClustAnalysis m_baseCluster = null;
    private ControlTree controlTree;
    private SetTree setTree;
    private TreeOptionPanel treeOptionPanel;
    HeaderMap m_headerMap;
    ClusterMap m_clusterMap;
    CategoryMap m_categoryMap;
    ClusterList m_clusterList;
    GeneNameList m_geneNameList;
    GeneInfoList m_geneInfoList;
    private AggregateModeItem aggregateModeItem;
    private AggregateModeTool aggregateModeTool;
    HeaderScrollPane m_headerScrollPane;
    ClusterScrollPane m_clusterScrollPane;
    CategoryScrollPane m_categoryScrollPane;
    CategoryScrollBar m_categoryScrollBar;
    AlignmentFrame m_alignmentFrame;
    private StatusBar statusBar;
    private ClusterModeItem clusterModeItem;
    private ClusterModeTool clusterModeTool;
    MultipleAlignmentFrame m_multipleAlignmentFrame;
    PtreeMainWindow m_pTreeMainWindow;
    ColorDialog2 m_colorDialog2;
    private GenomeMapFrame genomeMapFrame;
    GenomeScrollPane m_genomeScrollPane;
    private GeneFrame geneFrame;
    private KeywordSearchMainItem m_keywordSearchItem;
    private KeywordSearchTool m_keywordSearchTool;
    private CountFilterItem countFilterItem;
    ClusterVScrollBar m_clusterVScrollBar;
    ClusterHScrollBar m_clusterHScrollBar;
    FileSaveItem m_fileSaveItem;
    FileSaveTool m_fileSaveTool;
    private ExportMenu exportMenu;
    private ExportTool exportTool;
    TaxonomyItem m_taxonomyItem;
    FunctionItem m_functionItem;
    ClusterArea m_clusterArea;
    ClusterTreeMap m_clusterTreeMap;
    ClusterTreeScrollPane m_clusterTreeScrollPane;
    ClusterTreeScrollBar m_clusterTreeScrollBar;
    Cursor m_defaultCursor;
    Cursor m_waitCursor;
    boolean m_stat;
    private HClustTool upgmaTool;
    private HClustItem upgmaItem;
    private PageFormat m_pageFormat;
    private CoreGenomeFrame coreGenomeFrame;
    private CoreGenomeItem coreGenomeItem;
    private CoreGenomeTool coreGenomeTool;
    private SpGroupTree spGroupTree;
    private ModePanel modePanel;
    private SpGroupTbl spGroupTbl;
    private RankSelectPanel rankSelectPanel;
    private GlobalAlignFrame globalAlignFrame;
    private NeighborClustItem neighborClustItem;
    private NeighborClustTool neighborClustTool;
    private TaxMapExecuteTool taxMapExecuteTool;
    private FuncCatTool funcCatTool;
    private PropertyItem propertyItem;
    private GeneColorItem geneColorItem;
    private GeneColorTool geneColorTool;
    private HistogramItem histogramItem;
    private HistogramTool histogramTool;
    private PPMLabelMenu ppmLabelMenu;
    private AllClusterSelectItem allClusterSelectItem;
    private ImportMenu importMenu;
    private ImportTool importTool;
    private TaxMapExecuteItem taxMapExecuteItem;
    private MergeClusterReleaseItem mergeClusterReleaseItem;
    private SplitClusterReleaseItem splitClusterReleaseItem;
    private MergeOrganismReleaseItem mergeOrganismReleaseItem;
    private SplitOrganismReleaseItem splitOrganismReleaseItem;
    private Set taxMapFrameSet = new HashSet();
    private ApplicationPropertySaveItem applicationPropertySaveItem;
    private ApplicationPropertySaveAsItem applicationPropertySaveAsItem;
    private DomClustSaveServerItem domClustSaveServerItem;
    private ClusterInfoConvertItem clusterInfoConvertItem;

    public Mediator() {
        this.clear();
    }

    private void clear() {
        this.m_optionTbl = OptionTbl.getInstance();
        this.m_funcCatTbl = FuncCatTbl.getInstance();
        this.m_clusterIdTbl = ClusterIdTbl.getInstance();
        this.m_clusterTbl = null;
        this.m_outerTbl = OuterTbl.getInstance();
        this.m_innerTbl = InnerTbl.getInstance();
        this.m_publicSpecTbl = PublicSpecTbl.getInstance();
        this.m_baseCluster = null;
        this.m_aminoCodeTbl = AminoCodeTbl.getInstance();
        this.m_patternTbl = PatternTbl.getInstance();
        this.m_serverTbl = ServerTbl.getInstance();
        this.m_colorTbl = ColorTbl.getInstance();
        this.spGroupTbl = SpGroupTbl.getInstance();
        this.m_pTreeMainWindow = null;
        this.m_colorDialog2 = null;
        this.m_defaultCursor = new Cursor(0);
        this.m_waitCursor = new Cursor(3);
        this.m_stat = false;
        this.m_pageFormat = null;
    }

    private void deleteWorkDir(String string) {
        File[] fileArray = new File(string).listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.deleteWorkDir(fileArray[i].getAbsolutePath());
                    continue;
                }
                if (!fileArray[i].isFile()) continue;
                fileArray[i].delete();
            }
        }
        if (!string.equals(Const.WORK_DIR)) {
            new File(string).delete();
        }
    }

    private void resetMainWindow() {
        this.resetMainWindow(0, false);
    }

    private void resetMainWindow(boolean bl) {
        this.resetMainWindow(0, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetMainWindow(int n, boolean bl) {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            this.m_clusterTbl.clearSelection();
            this.m_clusterMap.createClusterMap(n);
            this.m_headerMap.repaint();
            this.m_clusterTreeMap.createClusterTreeMap(n);
            this.m_categoryMap.createCategoryMap(n);
            this.m_clusterList.clearClusterList();
            this.m_geneNameList.clearGeneNameList();
            this.m_geneInfoList.clearGeneInfoList();
            this.statusBar.showTaxonomyCount();
            this.statusBar.showPatternCount();
            if (bl) {
                this.closeDialog();
            } else {
                this.updatePropertyDialog();
            }
            this.m_mainWindow.setEnableClusteringTab(this.m_clusterTbl.isExistHClustResult());
            this.m_mainWindow.setEnableHistogramTab(this.m_optionTbl.getOptionValues().isIntensive());
            boolean bl2 = ProjectAccesser.getSelectedProject().isServer();
            this.m_mainWindow.setEnableBaseClustringSearchPanel(bl2);
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetMainWindowNotClearView() {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            this.m_clusterMap.createClusterMap();
            this.m_headerMap.repaint();
            this.m_clusterTreeMap.createClusterTreeMap();
            this.m_categoryMap.createCategoryMap();
            this.statusBar.showTaxonomyCount();
            this.statusBar.showPatternCount();
            this.updatePropertyDialog();
            this.m_mainWindow.setEnableClusteringTab(this.m_clusterTbl.isExistHClustResult());
            this.m_mainWindow.setEnableHistogramTab(this.m_optionTbl.getOptionValues().isIntensive());
            boolean bl = ProjectAccesser.getSelectedProject().isServer();
            this.m_mainWindow.setEnableBaseClustringSearchPanel(bl);
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    private void initMainWindow() throws IOException {
        if (this.m_clusterTbl != null) {
            this.m_clusterTbl.free();
            this.m_clusterTbl = null;
        }
        this.m_taxonomyTree.initTaxonomyTree();
        this.m_taxonomyTreeEx.initTaxonomyTree();
        this.m_treeTabbedPane.setSelectedIndex(0);
        this.setClusterTbl(null);
        this.m_clusterVScrollBar.setVisible(false);
        this.m_clusterHScrollBar.setVisible(false);
        this.m_clusterTreeScrollBar.setVisible(false);
        this.m_categoryScrollBar.setVisible(false);
        this.resizeClusterMap();
        this.m_clusterList.clearClusterList();
        this.m_geneNameList.clearGeneNameList();
        this.m_geneInfoList.clearGeneInfoList();
        this.statusBar.clearInfo();
        this.setVisibleForSubTree();
        this.closeDialog();
        this.setEnabledMenuButton(false);
        this.m_mainWindow.setEnableClusteringTab(false);
        boolean bl = ProjectAccesser.getSelectedProject().isServer();
        this.m_mainWindow.setEnableBaseClustringSearchPanel(bl);
        this.updateMemory();
    }

    private void closeDialog() {
        this.closeAlignmentFrame();
        this.closeMultipleAlignmentFrame();
        this.closeGenomeMapFrame();
        this.closeGeneFrame();
        this.closeCoreGenomeFrame();
        this.closeGlobalAlignFrame();
        this.closePropertyDialog();
        this.closeKeywordSearchDialog();
        this.closeTaxMapFrame();
    }

    private void setEnabledMenuButton(boolean bl) {
        this.m_keywordSearchItem.setEnabled(bl);
        this.m_keywordSearchTool.setEnabled(bl);
        this.countFilterItem.setEnabled(bl);
        this.m_fileSaveItem.setEnabled(bl);
        this.m_fileSaveTool.setEnabled(bl);
        this.exportMenu.setEnabled(bl);
        this.exportTool.setEnabled(bl);
        this.coreGenomeItem.setEnabled(bl);
        this.coreGenomeTool.setEnabled(bl);
        this.upgmaTool.setEnabled(bl);
        this.upgmaItem.setEnabled(bl);
        this.neighborClustItem.setEnabled(bl);
        this.neighborClustTool.setEnabled(bl);
        this.aggregateModeItem.setEnabled(bl);
        this.aggregateModeTool.setEnabled(bl);
        boolean bl2 = this.m_clusterTbl != null && bl;
        this.clusterModeItem.setEnabled(bl2);
        this.clusterModeTool.setEnabled(bl2);
        this.propertyItem.setEnabled(bl);
        this.geneColorItem.setEnabled(bl);
        this.geneColorTool.setEnabled(bl);
        this.histogramItem.setEnabled(bl);
        this.histogramTool.setEnabled(bl);
        this.ppmLabelMenu.setEnabled(bl);
        this.allClusterSelectItem.setEnabled(bl);
        this.clusterInfoConvertItem.setEnabled(bl);
        this.mergeClusterReleaseItem.setEnabled(bl);
        this.splitClusterReleaseItem.setEnabled(bl);
        this.mergeOrganismReleaseItem.setEnabled(bl);
        this.splitOrganismReleaseItem.setEnabled(bl);
        this.taxMapExecuteItem.setEnabled(bl);
        this.taxMapExecuteTool.setEnabled(bl);
        Project project = ProjectAccesser.getSelectedProject();
        if (project.isServer() && bl) {
            this.domClustSaveServerItem.setEnabled(true);
        } else {
            this.domClustSaveServerItem.setEnabled(false);
        }
    }

    private void initPage() {
        if (this.m_pageFormat == null) {
            this.m_pageFormat = PrinterJob.getPrinterJob().defaultPage();
            this.m_pageFormat.setOrientation(0);
        }
    }

    @Override
    public void exit() {
        Rectangle rectangle = this.m_mainWindow.getBounds();
        this.m_optionTbl.getOptionValues().setMainWindowX(rectangle.x);
        this.m_optionTbl.getOptionValues().setMainWindowY(rectangle.y);
        this.m_optionTbl.getOptionValues().setMainWindowW(rectangle.width);
        this.m_optionTbl.getOptionValues().setMainWindowH(rectangle.height);
        rectangle = this.m_alignmentFrame.getBounds();
        this.m_optionTbl.getOptionValues().setAlignmentFrameX(rectangle.x);
        this.m_optionTbl.getOptionValues().setAlignmentFrameY(rectangle.y);
        this.m_optionTbl.getOptionValues().setAlignmentFrameW(rectangle.width);
        this.m_optionTbl.getOptionValues().setAlignmentFrameH(rectangle.height);
        rectangle = this.m_multipleAlignmentFrame.getBounds();
        this.m_optionTbl.getOptionValues().setMultiFrameX(rectangle.x);
        this.m_optionTbl.getOptionValues().setMultiFrameY(rectangle.y);
        this.m_optionTbl.getOptionValues().setMultiFrameW(rectangle.width);
        this.m_optionTbl.getOptionValues().setMultiFrameH(rectangle.height);
        rectangle = this.genomeMapFrame.getBounds();
        this.m_optionTbl.getOptionValues().setGenomeMapX(rectangle.x);
        this.m_optionTbl.getOptionValues().setGenomeMapY(rectangle.y);
        this.m_optionTbl.getOptionValues().setGenomeMapW(rectangle.width);
        this.m_optionTbl.getOptionValues().setGenomeMapH(rectangle.height);
        rectangle = this.geneFrame.getBounds();
        this.m_optionTbl.getOptionValues().setGeneFrameX(rectangle.x);
        this.m_optionTbl.getOptionValues().setGeneFrameY(rectangle.y);
        this.m_optionTbl.getOptionValues().setGeneFrameW(rectangle.width);
        this.m_optionTbl.getOptionValues().setGeneFrameH(rectangle.height);
        this.m_optionTbl.getOptionValues().setDividerLocation1(this.m_mainWindow.getSplitPane1().getDividerLocation());
        this.m_optionTbl.getOptionValues().setDividerLocation2(this.m_mainWindow.getSplitPane2().getDividerLocation());
        this.m_optionTbl.getOptionValues().setDividerLocation3(this.m_mainWindow.getSplitPane3().getDividerLocation());
        this.m_optionTbl.getOptionValues().setDividerLocation4(this.m_mainWindow.getSplitPane4().getDividerLocation());
        this.m_optionTbl.getOptionValues().setDividerLocation5(this.m_mainWindow.getSplitPane5().getDividerLocation());
        try {
            ClusterTblCreater.saveCondition(this.m_clusterTbl);
            this.m_optionTbl.writeOption();
            this.m_clusterIdTbl.writeClusterId();
            this.m_innerTbl.writeInner();
            this.m_outerTbl.writeOuter();
            this.m_aminoCodeTbl.writeAminoCode();
            this.m_patternTbl.writePattern();
            this.m_serverTbl.writeServer();
            this.m_colorTbl.writeColor();
            ProjectAccesser.saveSelectProject();
            this.spGroupTbl.write();
        }
        catch (Exception exception) {
            String string = "Fail to save configuration files.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        catch (Error error) {
            String string = "Fail to save configuration files.";
            logger.warn(string, error);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        this.deleteWorkDir(Const.WORK_DIR);
        System.exit(0);
    }

    @Override
    public void newAnalysis() {
        try {
            ClusterTblCreater.saveCondition(this.m_clusterTbl);
            this.updateTaxonomyTreeAfterInitMainWindow();
        }
        catch (Exception exception) {
            String string = "Fail to initialize main window.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void openFile() {
        try {
            Object object;
            OpenDialog openDialog = OpenDialog.getInstance();
            openDialog.updateValue();
            openDialog.setVisible(true);
            if (openDialog.isCanceled()) {
                openDialog.dispose();
                return;
            }
            Project project = openDialog.getSelectedProject();
            File file = openDialog.getSelectedFile();
            Project project2 = ProjectAccesser.getSelectedProject();
            ClusterTblCreater.saveCondition(this.m_clusterTbl);
            if (this.m_clusterTbl != null && !ApplicationPropertyFacade.equalsConf(file, (ApplicationPropertyConf)(object = this.m_clusterTbl.getApplicationPropertyConf()))) {
                if (object == null) {
                    object = ApplicationPropertyConf.createDefaultConf(this.m_clusterTbl.getClusterId(), this.m_clusterTbl.getClusterViewId());
                }
                ApplicationPropertyFacade.saveConf(project2, (ApplicationPropertyConf)object);
            }
            if (!project.equalsProject(project2)) {
                ProjectAccesser.updateSelectProject(project);
            }
            object = null;
            if (FileExtension.isDomClustFile(file)) {
                object = FileLoader.createDomClustLoader((Component)this.m_mainWindow, (MediatorImpl)this, file);
            } else if (FileExtension.isCoreGenomeFile(file) && (object = FileLoader.createCoreGenomeLoader(this.m_mainWindow, this, this.m_clusterTbl, file.getAbsolutePath())) == null) {
                String string = "There is no corresponding domclust file.";
                MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
                return;
            }
            new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, 1, "Reading Cluster File...", false, (ProcessImpl)object);
        }
        catch (Exception exception) {
            String string = "Fail to show open dialog.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void deleteFile() {
        try {
            DeleteDialog deleteDialog = DeleteDialog.getInstance();
            deleteDialog.updateValue();
            deleteDialog.setVisible(true);
            deleteDialog.dispose();
        }
        catch (Exception exception) {
            String string = "Fail to show delete dialog.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void updateForLoadDomClust(ClusterTbl clusterTbl) {
        try {
            this.m_clusterTbl = clusterTbl;
            this.m_innerTbl.setInner(this.m_clusterTbl.getIngroupSpList());
            this.m_outerTbl.setOuter(this.m_clusterTbl.getOutgroupSpList());
            this.m_publicSpecTbl.clear();
            this.m_baseCluster = null;
            this.m_taxonomyTreeEx.setClusterTbl(this.m_clusterTbl);
            this.m_taxonomyTreeEx.readTaxonomyDat();
            this.m_taxonomyTreeEx.createTaxonomyTree();
            this.spGroupTree.updateTree();
            this.m_treeTabbedPane.setSelectedIndex(1);
            this.setClusterTbl(this.m_clusterTbl);
            this.setVisibleForSubTree();
            this.m_mainWindow.setEnableClusteringTab(false);
            this.setApplicationTitle();
            this.resetMainWindow(true);
            if (this.m_clusterTbl != null) {
                this.setEnabledMenuButton(true);
            }
            this.setClusterMode(this.m_clusterTbl.isOutgroup());
            this.updateMemory();
        }
        catch (Exception exception) {
            String string = "Fail to update main window.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void setBaseCluster(Project project) {
        MultiServerAnalysisDownloadExecuter multiServerAnalysisDownloadExecuter = new MultiServerAnalysisDownloadExecuter(this.m_mainWindow, project);
        multiServerAnalysisDownloadExecuter.addExeucuter(new DomClustAnalysisListDownloadExecuter(this.m_mainWindow, project, true));
        multiServerAnalysisDownloadExecuter.execute(new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, 1, "Download from server...", false, (ProcessImpl)multiServerAnalysisDownloadExecuter));
        List list = multiServerAnalysisDownloadExecuter.getServerAnalysisList();
        BaseClusterListDialog baseClusterListDialog = BaseClusterListDialog.getInstance();
        baseClusterListDialog.updateValue(project, list);
        baseClusterListDialog.setVisible(true);
        if (baseClusterListDialog.isCanceled()) {
            baseClusterListDialog.dispose();
            return;
        }
        DomClustAnalysis domClustAnalysis = baseClusterListDialog.getSelectedBaseCluster();
        baseClusterListDialog.dispose();
        if (domClustAnalysis == null) {
            this.m_baseCluster = null;
            this.m_publicSpecTbl.clear();
            this.updateTaxonomyTree();
        } else {
            Object object;
            Object object2;
            try {
                object2 = new PublicSpeciesDownloader(project);
                ((SimpleServerConnection)object2).execute();
                object = ((PublicSpeciesDownloader)object2).getPublicSpecList();
                this.m_publicSpecTbl.setPublicSprc((Collection)object);
            }
            catch (Exception exception) {
                String string = "Fail to read public species.";
                logger.warn(string, exception);
                MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
                return;
            }
            this.m_baseCluster = domClustAnalysis;
            object2 = this.m_baseCluster.getCommand();
            object = DomClustQuery.createDomClustCondition((String)object2);
            this.m_innerTbl.addInner(((DomClustCondition)object).getIngroupOrganismCodeSet());
            this.m_innerTbl.removeInner(((DomClustCondition)object).getOutgroupOrganismCodeSet());
            this.m_outerTbl.addOuter(((DomClustCondition)object).getOutgroupOrganismCodeSet());
            this.m_outerTbl.removeOuter(((DomClustCondition)object).getIngroupOrganismCodeSet());
            this.updateTaxonomyTree();
        }
    }

    @Override
    public void importer(int n, String string) {
        try {
            FileAccessFacade.getInstance().executeImport(n, string, this.m_clusterTbl);
        }
        catch (Exception exception) {
            String string2 = "Fail to import file.";
            logger.warn(string2, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string2);
        }
    }

    @Override
    public void registerSetByClusterList(int n, String string) {
        try {
            Set set = this.m_clusterTbl.getSelectedOrganismCodeSet();
            FileAccessFacade.getInstance().executeByCluster(n, string, set, this.m_clusterTbl);
        }
        catch (Exception exception) {
            String string2 = "Fail to register gene set / cluster set.";
            logger.warn(string2, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string2);
        }
    }

    @Override
    public void registerSetByClusterList(Component component, int n, String string, List list) {
        try {
            Set set = this.m_clusterTbl.getSelectedOrganismCodeSet();
            FileAccessFacade.getInstance().executeByCluster(component, n, string, list, set, this.m_clusterTbl);
        }
        catch (Exception exception) {
            String string2 = "Fail to register gene set / cluster set.";
            logger.warn(string2, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string2);
        }
    }

    @Override
    public void addElementByClusterList(int n, AbstractElementSet abstractElementSet) {
        try {
            Set set = this.m_clusterTbl.getSelectedOrganismCodeSet();
            FileAccessFacade.getInstance().executeByCluster(n, set, this.m_clusterTbl, abstractElementSet);
        }
        catch (Exception exception) {
            String string = "Fail to register gene set / cluster set.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void registerSetByGeneInfo(Component component, int n, String string, List list) {
        try {
            FileAccessFacade.getInstance().executeByGeneInfo(component, n, string, list);
        }
        catch (Exception exception) {
            String string2 = "Fail to register gene set / cluster set.";
            logger.warn(string2, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string2);
        }
    }

    @Override
    public void export(int n) {
        try {
            FileAccessFacade.getInstance().executeExport(n, this.m_clusterTbl, this.m_clusterMap);
        }
        catch (Exception exception) {
            String string = "Fail to export file.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void export(AbstractElementSet abstractElementSet) {
        try {
            FileAccessFacade.getInstance().executeExport(this.m_clusterTbl, abstractElementSet);
        }
        catch (Exception exception) {
            String string = "Fail to export file.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void export(AbstractElementSet abstractElementSet, Map map, Map map2) {
        try {
            FileAccessFacade.getInstance().executeExport(this.m_clusterTbl, abstractElementSet, map, map2);
        }
        catch (Exception exception) {
            String string = "Fail to export file.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void export(int n, List list) {
        AbstractElementSet abstractElementSet = SetType.isGeneSet(n) ? new GeneSet() : new ClusterSet();
        abstractElementSet.setElementList(list);
        this.export(abstractElementSet);
    }

    private void setClusterTbl(ClusterTbl clusterTbl) {
        this.m_clusterMap.setClusterTbl(clusterTbl);
        this.m_headerMap.setClusterTbl(clusterTbl);
        this.m_clusterTreeMap.setClusterTbl(clusterTbl);
        this.m_categoryMap.setClusterTbl(clusterTbl);
        this.m_clusterList.setClusterTbl(clusterTbl);
        this.m_geneNameList.setClusterTbl(clusterTbl);
        this.m_alignmentFrame.setClusterTbl(clusterTbl);
        this.ppmLabelMenu.setClusterTbl(clusterTbl);
        this.controlTree.setClusterTbl(clusterTbl);
        this.setTree.setClusterTbl(clusterTbl);
        this.importMenu.setClusterTbl(clusterTbl);
        this.importTool.setClusterTbl(clusterTbl);
        if (clusterTbl != null) {
            ClusterInfoFacade.setDomClustId(clusterTbl.getClusterId());
        } else {
            ClusterInfoFacade.setDomClustId(null);
        }
    }

    private String getUserLoadDir() {
        Project project = ProjectAccesser.getSelectedProject();
        String string = project.getDirectoryPath();
        return string;
    }

    private String getUserSaveDir() {
        OptionTbl optionTbl = OptionTbl.getInstance();
        return optionTbl.getOptionValues().getUserExportDir();
    }

    @Override
    public void save(boolean bl) {
        Object object;
        ApplicationPropertyConf applicationPropertyConf = this.m_clusterTbl.getApplicationPropertyConf();
        if (applicationPropertyConf == null || bl) {
            object = ApplicationPropertyDialog.getInstance();
            String string = applicationPropertyConf == null ? "" : applicationPropertyConf.getConfName();
            String string2 = applicationPropertyConf == null ? "" : applicationPropertyConf.getComment();
            ((ApplicationPropertyDialog)object).updateValue(string, string2);
            ((Dialog)object).show();
            if (((AbstractApplyDialog)object).isCanceled()) {
                return;
            }
            String string3 = ((ApplicationPropertyDialog)object).getName();
            String string4 = ((ApplicationPropertyDialog)object).getComment();
            if (applicationPropertyConf != null && applicationPropertyConf.equalsName(string3)) {
                if (!MessageManager.showConfirmOverwriteMessage(this.m_mainWindow, string3)) {
                    return;
                }
                applicationPropertyConf.setComment(string4);
            } else {
                applicationPropertyConf = ApplicationPropertyConf.createLocalConf(string3, this.m_clusterTbl.getClusterId(), this.m_clusterTbl.getClusterViewId(), string4);
            }
        }
        object = new ApplicationPropertySaveProcess(this.m_mainWindow, this.m_clusterTbl, applicationPropertyConf);
        ((ApplicationPropertySaveProcess)object).execute(new DummyProgressComponent());
        ((ApplicationPropertySaveProcess)object).done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveFile() {
        JFileChooser jFileChooser = new JFileChooser(this.getUserSaveDir());
        jFileChooser.setDialogTitle("Export DomClust file");
        jFileChooser.setFileFilter(FileFilterFactory.createDomClustFileFilter());
        if (jFileChooser.showSaveDialog(this.m_mainWindow) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        File file2 = new File(FileUtil.addExtension(file.getAbsolutePath(), ".dclst"));
        if (file2.exists() && !MessageManager.showConfirmOverwriteMessage(this.m_mainWindow, file2.getName())) {
            return;
        }
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            DomClustSaveExecuter domClustSaveExecuter = new DomClustSaveExecuter(this.m_clusterTbl.getFilepath(), file2.getAbsolutePath());
            domClustSaveExecuter.execute();
            this.m_optionTbl.getOptionValues().setUserExportDir(file2.getAbsolutePath());
        }
        catch (Exception exception) {
            String string = "Fail to export domclust file.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        catch (Error error) {
            String string = "Fail to export domclust file.";
            logger.warn(string, error);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    @Override
    public void scrollCategoryMap(int n) {
        if (this.isCategoryScrollBarVisible()) {
            this.setCategoryScrollBarValue(this.m_categoryScrollBar.getValue() + n * this.m_categoryScrollBar.getUnitIncrement());
        }
    }

    @Override
    public void updateSelectedClusterByLocusTag(Collection collection, boolean bl) {
        if (CollectionUtil.isNull(collection)) {
            this.updateSelectedCluster(null, null, null, bl);
            return;
        }
        HashSet hashSet = new HashSet(this.m_clusterTbl.getViewClusterList(collection));
        GeneInfo geneInfo = (GeneInfo)collection.iterator().next();
        String string = (String)geneInfo.getInfo(GeneInfoTitle.TITLE_ORGANISM_CODE);
        String string2 = geneInfo.getLocusTag();
        this.updateSelectedCluster(string, string2, hashSet, bl);
    }

    @Override
    public void updateSelectedCluster(String string, Collection collection, boolean bl) {
        this.updateSelectedCluster(string, null, collection, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSelectedCluster(String string, String string2, Collection collection, boolean bl) {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            if (bl) {
                this.m_clusterTbl.flipSelectedCluster(string, collection);
            } else {
                this.m_clusterTbl.setSelectedCluster(string, collection);
            }
            this.m_clusterMap.updateSelection();
            this.m_categoryMap.updateSelection();
            List list = this.m_clusterTbl.getSelectedClusterList();
            this.m_clusterList.createClusterList(string, list);
            if (!CollectionUtil.isNull(list)) {
                this.createGeneNameList(string, string2, new HashSet(list), false);
            } else {
                this.m_geneNameList.clearGeneNameList();
                this.m_geneInfoList.clearGeneInfoList();
            }
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
            this.updateMemory();
        }
    }

    @Override
    public void changeAggregateMode(boolean bl) {
        this.m_optionTbl.getOptionValues().setIntensive(bl);
        this.m_clusterMap.changePPMRenderer();
        this.aggregateModeTool.changeMode();
        this.aggregateModeItem.changeMode();
        if (this.m_clusterTbl != null) {
            this.resetMainWindow();
        }
        this.updateMemory();
    }

    @Override
    public void selectTaxonomyTreePathBoth(Collection collection) {
        this.m_taxonomyTree.setSelectNode(collection);
        this.m_taxonomyTreeEx.setSelectNode(collection);
    }

    @Override
    public void selectOrganismOnTaxonomyTreeBoth(Collection collection) {
        this.m_taxonomyTree.setSelectGenomeNode(collection);
        this.m_taxonomyTreeEx.setSelectGenomeNode(collection);
    }

    @Override
    public void selectOrganismOnTaxonomyTree(Collection collection) {
        this.m_taxonomyTree.setSelectGenomeNode(collection);
    }

    @Override
    public void selectOrganismOnTaxonomyTreeEx(Collection collection) {
        this.m_taxonomyTreeEx.setSelectGenomeNode(collection);
    }

    @Override
    public void setFilterCondition(Map map, int n, String string, long l) {
        boolean bl = FilterFacade.getInstance().setFilterCondition(this.m_mainWindow, map, n, string, l);
        this.updateForFilter(bl);
        if (!TaxFilterCondition.isExclude(n)) {
            this.controlTree.updateSelection(n, l);
        }
    }

    @Override
    public void setAnyFilterCondition(Map map, String string, double d, boolean bl, boolean bl2) {
        boolean bl3 = FilterFacade.getInstance().setAnyFilterCondition(map, string, d, bl, bl2);
        this.updateForFilter(bl3);
        this.treeOptionPanel.showControlTree();
        this.modePanel.setFilterMode();
        int n = 2;
        if (!TaxFilterCondition.isExclude(n)) {
            long l = -1L;
            this.controlTree.updateSelection(n, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusterSetCondition setFuncCatFilterCondition(String string, List list) {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            HashSet hashSet = new HashSet();
            for (int i = 0; i < list.size(); ++i) {
                FuncCat funcCat = (FuncCat)list.get(i);
                hashSet.addAll(this.m_clusterTbl.getClusterSetByFuncCat(funcCat));
            }
            ClusterSetCondition clusterSetCondition = this.setFuncCatFilter(new ArrayList(hashSet));
            return clusterSetCondition;
        }
        catch (Exception exception) {
            ClusterSetCondition clusterSetCondition = null;
            return clusterSetCondition;
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    @Override
    public void updateForFilter(boolean bl) {
        try {
            this.m_taxonomyTreeEx.repaint();
            this.updateFilterTree();
            if (this.m_clusterTbl != null) {
                this.m_clusterTbl.updateForFilter();
                if (bl) {
                    this.resetMainWindow();
                }
            }
            this.updateMemory();
        }
        catch (SortException sortException) {
            String string = "Fail to update main frame by filter.";
            logger.warn(string, sortException);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void setAnyThreshold(boolean bl, boolean bl2, double d) {
        try {
            FilterFacade.getInstance().setAnyThreshold(bl, bl2, d);
            this.m_clusterTbl.updateForFilter();
            this.updateFilterTree();
            this.resetMainWindow();
        }
        catch (SortException sortException) {
            String string = "Fail to update main frame by filter.";
            logger.warn(string, sortException);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void showAnyTresholdDialog(List list) {
        FilterThresholdDialog filterThresholdDialog = new FilterThresholdDialog((Frame)this.m_mainWindow, this);
        filterThresholdDialog.setFilterConditionList(list);
        filterThresholdDialog.setVisible(true);
        filterThresholdDialog.dispose();
    }

    @Override
    public void showFilterConditionNameEditDialog(TaxFilterCondition taxFilterCondition) {
        NameEditDialog nameEditDialog = new NameEditDialog(this.m_mainWindow);
        nameEditDialog.setEditName(taxFilterCondition.getName());
        nameEditDialog.setVisible(true);
        if (!nameEditDialog.isCanceled()) {
            taxFilterCondition.setName(nameEditDialog.getEditName());
            this.updateForFilter(false);
        }
        nameEditDialog.dispose();
    }

    @Override
    public void viewUrl(String string) {
        try {
            BareBonesBrowserLaunch.openURL(string);
        }
        catch (Exception exception) {
            logger.warn("Fail to show browser." + string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, exception.getMessage());
        }
        catch (Error error) {
            logger.warn("Fail to show browser." + string, error);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, error.getMessage());
        }
    }

    @Override
    public void drawFeatureMap(Collection collection) {
        if (collection == null) {
            this.closeAlignmentFrame();
            this.closeMultipleAlignmentFrame();
            return;
        }
        this.m_stat = false;
        if (this.m_alignmentFrame.isVisible()) {
            new ProgressDialog((Frame)this.m_alignmentFrame, (MediatorImpl)this, this.m_alignmentFrame.getViewCount(), "Draw Regional Genome Map...", false, (ProcessImpl)new DrawFeatureMap(this, collection));
        } else {
            String[] stringArray = new String[]{"Create Alignment Data...", "Draw Regional Genome Map..."};
            new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, this.m_clusterTbl.getClusterList().size(), stringArray, true, (ProcessImpl)new DrawFeatureMap(this, collection));
        }
    }

    @Override
    public void drawFeatureMap2() {
        this.drawFeatureMap2(null, new DummyProgressComponent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawFeatureMap2(Collection collection, ProgressImpl progressImpl) {
        if (this.m_alignmentFrame == null) {
            return;
        }
        this.m_alignmentFrame.setCursor(this.m_waitCursor);
        try {
            this.m_alignmentFrame.setProgressImpl(progressImpl);
            this.m_alignmentFrame.updateValue(this.m_clusterTbl.getClusterId());
            if (!this.m_alignmentFrame.isVisible()) {
                this.m_alignmentFrame.createGeneClassMap();
                if (progressImpl.isCanceled()) {
                    return;
                }
                progressImpl.nextProc();
                progressImpl.setEnabledCancelButton(false);
            }
            if (collection != null) {
                this.m_alignmentFrame.setGeneInfoList(collection);
            }
            progressImpl.setTotal(this.m_alignmentFrame.getViewCount());
            this.m_alignmentFrame.createAlignmentMap();
        }
        finally {
            this.m_alignmentFrame.setCursor(this.m_defaultCursor);
            this.m_alignmentFrame.setProgressImpl(null);
            this.m_stat = true;
            this.updateMemory();
        }
    }

    @Override
    public void drawFeatureMap3() {
        if (this.m_stat) {
            this.m_alignmentFrame.setVisible(true);
        }
    }

    @Override
    public Object getClusterIdColor(int n) {
        ClusterId clusterId = (ClusterId)this.m_clusterIdTbl.getClusterIdMap().get(new Integer(n));
        return clusterId == null ? Color.white : ColorUtil.str2Color(clusterId.getColor());
    }

    @Override
    public void changeViewRange(int n, RGMCondition rGMCondition, List list) {
        if (rGMCondition.getZoomRange() == n) {
            return;
        }
        try {
            rGMCondition.setZoomRange(n);
            ApplicationPropertyFacade.saveProperty(rGMCondition.getDomClustId(), rGMCondition);
        }
        catch (IOException iOException) {
            String string = "Fail to save regional genome map information. DomClust ID" + rGMCondition.getDomClustId() + " zoomRange = " + n;
            logger.warn(string, iOException);
        }
        this.drawFeatureMap2(list, new DummyProgressComponent());
    }

    @Override
    public void setSelectClusterOnGenomeMap(Cluster cluster) {
        if (!this.isExistDomClustResult()) {
            return;
        }
        if (cluster == null) {
            return;
        }
        HashSet<Cluster> hashSet = new HashSet<Cluster>();
        hashSet.add(cluster);
        this.setHighlightClusterOnGenomeMap(hashSet);
    }

    @Override
    public void setHighlightClusterOnGenomeMap(Collection collection) {
        if (!this.isExistDomClustResult()) {
            return;
        }
        if (!this.genomeMapFrame.isVisible()) {
            return;
        }
        this.genomeMapFrame.setHighlightCluster(collection);
    }

    @Override
    public void setHighlightLocusTagOnGenomeMap(String string, String string2) {
        if (!this.isExistDomClustResult()) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string2);
        this.genomeMapFrame.setHighlightLocusTag(string, hashSet);
    }

    @Override
    public void sortClusterList(BasicSortCondition basicSortCondition) {
        new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, 100, "Sort Phylogenetic Pattern Map...", false, (ProcessImpl)new ClusterListSorter(this, basicSortCondition));
    }

    @Override
    public void sortClusterList2(BasicSortCondition basicSortCondition, ProgressImpl progressImpl) {
        try {
            this.m_clusterTbl.sortClusterList(basicSortCondition, progressImpl);
            this.resetMainWindow();
            this.updateSortTree();
            this.updateMemory();
            NeighboringClustExecuter.reexecuteNeighborClustering(this.m_mainWindow, this.m_clusterTbl.isExistNeighboringCluster(), this.m_clusterTbl.getNeighboringClustCondition(), this);
        }
        catch (SortException sortException) {
            logger.warn(sortException.getMessage(), sortException);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, sortException.getMessage());
        }
        catch (Exception exception) {
            logger.warn("Fail to sort PPM. " + basicSortCondition.toString(), exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, "Fail to sort PPM");
        }
        catch (Error error) {
            logger.warn("Fail to sort PPM. " + basicSortCondition.toString(), error);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, "Fail to sort PPM");
        }
    }

    @Override
    public void showGeneInfoSortDialog(String string, int n) {
        GeneInfoSortDialog geneInfoSortDialog = GeneInfoSortDialog.getInstance();
        geneInfoSortDialog.updateValue(string, this.m_clusterTbl.getViewOrganismCodeList(), this.m_clusterTbl);
        geneInfoSortDialog.setVisible(true);
        if (!geneInfoSortDialog.isCanceled()) {
            this.sortClusterList(geneInfoSortDialog.createGeneInfoSortConditionGroup());
        }
    }

    @Override
    public void showGeneInfoColorDialog(Set set) {
        GeneColorCondition geneColorCondition = this.m_clusterTbl.getGeneColorCommonCondition(set);
        this.showGeneInfoColorDialog(this.m_mainWindow, set, geneColorCondition);
    }

    @Override
    public void showGeneInfoColorDialog(Component component, Set set, GeneColorCondition geneColorCondition) {
        GeneColorDialog geneColorDialog = GeneColorDialog.getInstance(component, this);
        geneColorDialog.updateValue(this.m_clusterTbl, set, this.m_clusterTbl.getViewOrganismList(), this.m_clusterTbl.getClusterList(), geneColorCondition);
        geneColorDialog.setVisible(true);
        if (!geneColorDialog.isCanceled()) {
            this.executeGeneInfoColor(geneColorDialog.createGeneColorCondition(), geneColorDialog.getCalcMethodType());
        }
    }

    @Override
    public void executeGeneInfoColor(GeneColorCondition geneColorCondition, int n) {
        GeneColorExecuter geneColorExecuter = new GeneColorExecuter(this.m_mainWindow, this, this.m_clusterTbl, this.m_clusterTbl.getClusterList(), geneColorCondition, null, n);
        new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, 1, "Color setting...", true, (ProcessImpl)geneColorExecuter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelGeneInfoColor(Set set) {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            this.m_clusterTbl.removeGeneColorCondition(set);
            this.resetMainWindow();
            this.updateMemory();
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateForGeneColor(GeneColorCondition geneColorCondition, int n) {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            this.m_clusterTbl.setGeneColorConditionInfo(n);
            this.m_clusterTbl.addGeneColorCondition(geneColorCondition);
            this.m_clusterTbl.setShowGeneColor(true);
            ColorFacade colorFacade = ColorFacade.getInstance();
            colorFacade.addGeneInfoColorDrawable();
            this.updateColorTree();
            this.resetMainWindow();
            this.updateMemory();
            this.m_clusterTbl.saveGeneColorConditionGroup();
        }
        catch (Exception exception) {
            String string = "Fail to save color condition by properties.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateForGeneColor(boolean bl) {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            this.m_clusterTbl.setShowGeneColor(bl);
            this.repaintControlTree();
            this.resetMainWindow();
            this.updateMemory();
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGeneColor() {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            this.m_clusterTbl.clearGeneColorCondition();
            ColorFacade.getInstance().removeGeneInfoColorDrawable();
            this.updateColorTree();
            this.resetMainWindow();
            this.updateMemory();
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    @Override
    public void showGeneUrlListDialog() {
        try {
            List list = GeneUrlFacade.getGeneUrlList();
            GeneUrlListDialog geneUrlListDialog = GeneUrlListDialog.getInstance();
            geneUrlListDialog.updateValue(list);
            geneUrlListDialog.setVisible(true);
            if (!geneUrlListDialog.isCanceled()) {
                GeneUrlFacade.saveGeneUrlList(geneUrlListDialog.getGeneUrlList());
            }
        }
        catch (Exception exception) {
            String string = "Fail to create url defined file.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void showFunctionCategoryDialog() {
        FunctionCategoryDialog functionCategoryDialog = FunctionCategoryDialog.createFunctionCategoryDialog(this.m_mainWindow, this);
        functionCategoryDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyFunctionCategoryColor(String string, List list) {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            this.m_funcCatTbl.clear();
            for (Object object : list) {
                this.m_funcCatTbl.put(((FuncCat)object).getFunctionCategoryNo(), object);
            }
            this.m_funcCatTbl.setFunctionCategoryType(string);
            this.m_funcCatTbl.writeFuncCat(string);
            this.m_funcCatTbl.updateDefaultFuncCat();
            this.m_optionTbl.getOptionValues().setFunctionCategoryType(string);
            this.updateForFunctionCategoryColor();
            for (Object object : this.taxMapFrameSet) {
                ((TaxMapFrame)object).updateGUI();
            }
        }
        catch (IOException iOException) {
            String string2 = "Fail to save function category file.";
            logger.warn(string2, iOException);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string2);
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreFunctionCategoryColor(String string) {
        block12: {
            if (!AccessServer.getInstance().isEnableAccess()) {
                boolean bl;
                while (bl = AccessServer.showAccessErrorMessageRetry(this.m_mainWindow)) {
                    ServerAccessCheckTask.getInstance().checkAccessServer(AccessServer.getInstance().getServerUrl());
                    if (!AccessServer.getInstance().isEnableAccess()) continue;
                    break block12;
                }
                return;
            }
        }
        if (!MessageManager.showConfirmMessage((Component)this.m_mainWindow, "Restore Default Color?")) {
            return;
        }
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            this.m_funcCatTbl.restore(string);
            this.updateForFunctionCategoryColor();
        }
        catch (ConnectException connectException) {
            String string2 = ResourceBandleWrapper.getMessage("error.access.server");
            logger.warn(string2, connectException);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string2);
        }
        catch (Exception exception) {
            logger.warn("Fail to restore color.", exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, "Fail to restore color.");
        }
        catch (Error error) {
            logger.warn("Fail to restore color.", error);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, "Fail to restore color.");
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    private void updateForFunctionCategoryColor() {
        if (this.m_clusterTbl != null) {
            if (!this.m_optionTbl.getOptionValues().isIntensive()) {
                this.m_clusterMap.drawLabelArea();
            }
            this.m_categoryMap.draw();
            this.m_categoryMap.repaint();
        }
        this.m_clusterList.repaint();
        if (this.m_alignmentFrame.isVisible()) {
            this.drawFeatureMap2(null, new DummyProgressComponent());
        }
        this.updateMemory();
    }

    @Override
    public void resizeHeaderMap() {
        Dimension dimension = this.m_headerScrollPane.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        this.m_mainWindow.setCursor(this.m_waitCursor);
        this.m_headerMap.resizeHeaderMap(dimension);
        this.m_mainWindow.setCursor(this.m_defaultCursor);
        this.updateMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resizeClusterMap() {
        Dimension dimension = this.m_clusterScrollPane.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            this.m_clusterMap.resizeClusterMap(dimension);
            this.m_headerMap.repaint();
            this.resizeCategoryMap();
            this.resizeClusterTreeMap();
            this.updateMemory();
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    @Override
    public void resizeCategoryMap() {
        Dimension dimension = this.m_categoryScrollPane.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        this.m_mainWindow.setCursor(this.m_waitCursor);
        Dimension dimension2 = this.m_clusterScrollPane.getSize();
        this.m_categoryMap.resizeCategoryMap(new Dimension(dimension.width, dimension2.height));
        this.m_mainWindow.setCursor(this.m_defaultCursor);
        this.updateMemory();
    }

    @Override
    public void setCategoryScrollBar(boolean bl, int n, int n2, int n3) {
        if (bl) {
            this.m_categoryScrollBar.setValues(n, n2, n3);
        }
        this.m_categoryScrollBar.setVisible(bl);
    }

    @Override
    public void setCategoryScrollBarValue(int n) {
        this.m_categoryScrollBar.setValue(n);
    }

    @Override
    public void setCategoryRow(int n) {
        this.m_categoryMap.setRow(n);
        this.setClusterVScrollBarValue(n);
        this.setClusterTreeScrollBarValue(n);
    }

    @Override
    public boolean isCategoryScrollBarVisible() {
        return this.m_categoryScrollBar.isVisible();
    }

    @Override
    public Object getCategoryScrollBarModel() {
        return this.m_categoryScrollBar.getModel();
    }

    @Override
    public void closeAlignmentFrame() {
        this.m_alignmentFrame.clear();
        this.m_alignmentFrame.setVisible(false);
        this.updateMemory();
    }

    @Override
    public void updateMemory() {
        this.statusBar.updateMemory();
    }

    @Override
    public void registerNewSystemInfo(Runnable runnable) {
        this.statusBar.addInfoRunTask(runnable);
    }

    @Override
    public void setGroup(Map map, int n) {
        this.updateGroup(n, map.values());
        this.m_taxonomyTree.nodeChanged(map.values());
        this.m_taxonomyTreeEx.nodeChanged(map.values());
        this.updateMemory();
    }

    @Override
    public void setAutoGroup(Map map, int n) {
        String string = this.rankSelectPanel.getSelectedRank();
        Set set = map.keySet();
        List list = this.m_taxonomyTree.getTaxonomyTreeNodeListByMaxSpecweight(string, set);
        Collection collection = map.values();
        this.updateGroup(0, collection);
        this.updateGroup(n, list);
        this.m_taxonomyTree.nodeChanged(map.values());
        this.m_taxonomyTreeEx.nodeChanged(map.values());
        this.updateMemory();
    }

    private Map removePublicOrganism(Map map) {
        if (this.m_publicSpecTbl.size() > 0) {
            Set set = this.m_publicSpecTbl.keySet();
            for (String string : set) {
                if (!map.containsKey(string)) continue;
                map.remove(string);
            }
        }
        return map;
    }

    private void updateGroup(int n, Collection collection) {
        for (TaxonomyTreeNode taxonomyTreeNode : collection) {
            if (n == 0) {
                this.m_outerTbl.remove(taxonomyTreeNode.getAbbreviation());
                this.m_innerTbl.remove(taxonomyTreeNode.getAbbreviation());
                continue;
            }
            if (n == 1) {
                this.m_outerTbl.put(taxonomyTreeNode.getAbbreviation(), "OK");
                this.m_innerTbl.remove(taxonomyTreeNode.getAbbreviation());
                continue;
            }
            this.m_outerTbl.remove(taxonomyTreeNode.getAbbreviation());
            this.m_innerTbl.put(taxonomyTreeNode.getAbbreviation(), "OK");
        }
    }

    @Override
    public String getOrganismName(String string) {
        return this.m_taxonomyTreeEx.getOrganismName(string);
    }

    @Override
    public void createGeneNameList(String string, Set set, boolean bl) {
        this.createGeneNameList(string, null, set, bl);
    }

    @Override
    public void createGeneNameList(String string, String string2, Set set, boolean bl) {
        this.m_geneNameList.createGeneNameList(string, string2, set);
        Gene gene = this.m_geneNameList.getSelectedGene();
        if (gene != null) {
            this.createGeneInfoList(gene.getOrganism(), gene.getLocusTag());
        } else {
            this.m_geneInfoList.clearGeneInfoList();
        }
    }

    @Override
    public List getSelectGeneInfoOnGeneNameList() {
        return this.m_geneNameList.getSelectedGeneInfoList();
    }

    @Override
    public List getSelectClusterOnClusterList() {
        return this.m_clusterList.getSelectedClusterList();
    }

    @Override
    public void createGeneInfoList(String string, String string2) {
        try {
            List list = GeneInfoFacade.createSelectableGeneInfoTitleList(string);
            list.add(0, GeneInfoTitle.TITLE_ORGANISM_CODE);
            GeneInfo geneInfo = GeneInfoFacade.createGeneInfo(string, string2, list);
            this.m_geneInfoList.createGeneInfoList(list, geneInfo);
        }
        catch (Exception exception) {
            this.m_geneInfoList.clearGeneInfoList();
            logger.warn("Fail to read gene or chromosome info file.", exception);
        }
    }

    @Override
    public void multipleAlignment(Collection collection) {
        String[] stringArray;
        block6: {
            if (!AccessServer.getInstance().isEnableAccess()) {
                boolean bl;
                while (bl = AccessServer.showAccessErrorMessageRetry(this.m_mainWindow)) {
                    ServerAccessCheckTask.getInstance().checkAccessServer(AccessServer.getInstance().getServerUrl());
                    if (!AccessServer.getInstance().isEnableAccess()) continue;
                    break block6;
                }
                return;
            }
        }
        if (!MessageManager.showConfirmMessage((Component)this.m_mainWindow, "Multiple Alignment?")) {
            return;
        }
        String string = this.m_optionTbl.getOptionValues().getClustalW();
        if (StringTool.isNull(string) || !new File(string).exists()) {
            stringArray = new JFileChooser(System.getProperty("user.dir"));
            stringArray.setDialogTitle("Select ClustalW Command");
            if (stringArray.showDialog(this.m_mainWindow, "OK") == 0) {
                string = stringArray.getSelectedFile().getAbsolutePath();
                this.m_optionTbl.getOptionValues().setClustalW(string);
            } else {
                return;
            }
        }
        this.m_stat = false;
        stringArray = new String[]{"Get Amino Acid Sequence...", "Multiple Alignment..."};
        new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, collection.size(), stringArray, true, (ProcessImpl)new MultipleAlignment(this, collection));
    }

    @Override
    public void multipleAlignment2(Collection collection, ProgressImpl progressImpl) {
        try {
            MultipleAlignmentExecuter multipleAlignmentExecuter = new MultipleAlignmentExecuter(this, this.m_clusterTbl, this.m_mainWindow);
            multipleAlignmentExecuter.setGeneInfoC(collection);
            int n = multipleAlignmentExecuter.executeMultipleAlignment(progressImpl);
            if (n < 2) {
                String string = "Two amino acid sequences or more are necessary to execute this processing.";
                MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
            } else if (!multipleAlignmentExecuter.isExistAlnFile()) {
                String string = "Fail to execute multiple alignment.";
                MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
            } else {
                this.m_multipleAlignmentFrame.setFiles(multipleAlignmentExecuter.getAlnFilepath());
                this.m_stat = true;
            }
        }
        catch (ConnectException connectException) {
            String string = ResourceBandleWrapper.getMessage("error.access.server");
            logger.warn(string, connectException);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        catch (Exception exception) {
            String string = "Fail to execute multiple alignment.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        catch (Error error) {
            String string = "Fail to execute multiple alignment.";
            logger.warn(string, error);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        this.updateMemory();
    }

    @Override
    public void multipleAlignment3() {
        if (this.m_stat) {
            this.m_multipleAlignmentFrame.setVisible(true);
        }
    }

    @Override
    public void closeMultipleAlignmentFrame() {
        this.m_multipleAlignmentFrame.setVisible(false);
        if (this.m_pTreeMainWindow != null && this.m_pTreeMainWindow.isDisplayable()) {
            this.m_pTreeMainWindow.done();
        }
        this.m_pTreeMainWindow = null;
        this.updateMemory();
    }

    @Override
    public void clustalTree() {
        if (!new File(this.m_multipleAlignmentFrame.getAlnFile()).isFile()) {
            MessageManager.showErrorMessage((Component)this.m_multipleAlignmentFrame, "ClustalW tree file(ph or phb) is not found.");
            return;
        }
        String[] stringArray = new String[]{"Create Tree...", "Load Tree File.."};
        new ProgressDialog((Frame)this.m_multipleAlignmentFrame, (MediatorImpl)this, 100, stringArray, true, (ProcessImpl)new TreeCreater(this));
    }

    @Override
    public void clustalTree2(final ProgressImpl progressImpl) {
        try {
            MultipleAlignmentExecuter multipleAlignmentExecuter = new MultipleAlignmentExecuter(this, this.m_clusterTbl, this.m_mainWindow);
            multipleAlignmentExecuter.createTreeFile(progressImpl, this.m_multipleAlignmentFrame.getAlnFile());
            progressImpl.nextProc();
            progressImpl.setCount(49);
            progressImpl.increment();
            if (progressImpl.isCanceled()) {
                logger.info("Cancel to create tree.");
                return;
            }
            final cgdp.recog.ptree.bean.interfaces.MediatorImpl mediatorImpl = cgdp.recog.ptree.bean.Mediator.createInstance(null, this);
            final Tree tree = mediatorImpl.createTreeFromFile(multipleAlignmentExecuter.getTreeFilepath());
            progressImpl.setCount(99);
            progressImpl.increment();
            if (progressImpl.isCanceled()) {
                logger.info("Cancel to create tree.");
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ((ProgressDialog)progressImpl).setVisible(false);
                        if (Mediator.this.m_pTreeMainWindow == null || !Mediator.this.m_pTreeMainWindow.isDisplayable()) {
                            Mediator.this.m_pTreeMainWindow = new PtreeMainWindow(mediatorImpl, (RecogQueryImpl)Mediator.this);
                            Mediator.this.m_pTreeMainWindow.setExitAction(1);
                        }
                        Mediator.this.m_pTreeMainWindow.updateTreeArea(tree);
                    }
                    catch (Exception exception) {
                        logger.warn("Fail to update tree view.", exception);
                    }
                    Mediator.this.updateMemory();
                }
            });
        }
        catch (Exception exception) {
            logger.warn("Fail to create tree.", exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, "Fail to create tree.");
        }
        catch (Error error) {
            logger.warn("Fail to create tree.", error);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, "Fail to create tree.");
        }
    }

    @Override
    public void colorDialog2() {
        new ColorDialog2(this.m_multipleAlignmentFrame, this);
    }

    @Override
    public void applyColor2() {
        this.m_colorDialog2.setAminoCodeColor();
        this.m_colorDialog2.dispose();
        this.m_multipleAlignmentFrame.setAminoCodeColor();
        this.updateMemory();
    }

    @Override
    public void updateForTaxonomySetting(boolean bl) {
        if (bl) {
            this.m_taxonomyTree.createTaxonomyTree();
            this.m_taxonomyTreeEx.createTaxonomyTree();
        }
        this.m_taxonomyTree.repaint();
        this.m_taxonomyTreeEx.repaint();
        this.updateMemory();
    }

    @Override
    public void updateFromPPMSetting() {
        try {
            this.resizeClusterMap();
            this.repaintFromColorChange();
        }
        catch (Exception exception) {
            logger.warn("Fail to register PPM Options.", exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, "Fail to register PPM Options.");
        }
        catch (Error error) {
            logger.warn("Fail to register PPM Options.", error);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, "Fail to register PPM Options.");
        }
        this.updateMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyAlignmentListColor(RGMCondition rGMCondition, String string, List list, List list2, List list3) {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            ApplicationPropertyFacade.saveProperty(rGMCondition.getDomClustId(), rGMCondition);
            this.m_funcCatTbl.readFuncCat(string);
            for (FuncCat funcCat : list) {
                ((FuncCat)this.m_funcCatTbl.get(funcCat.getFunctionCategoryNo())).setColor(funcCat.getColor());
            }
            this.m_funcCatTbl.writeFuncCat(string);
            this.m_optionTbl.getOptionValues().setFunctionCategoryType(string);
            this.m_clusterIdTbl.setClusterIdColor(list2);
            this.m_patternTbl.clear();
            this.m_patternTbl.addAll(list3);
            this.updateForFunctionCategoryColor();
        }
        catch (IOException iOException) {
            String string2 = "Fail to save function category file.";
            logger.warn(string2, iOException);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string2);
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    @Override
    public void showGenomeMap(int n, String string, boolean bl, int n2) {
        try {
            this.genomeMapFrame.updateValue(this.m_clusterTbl.getClusterId());
            this.genomeMapFrame.setChromosomeData(n, string, bl, n2, this.m_clusterTbl);
            this.genomeMapFrame.setRange(1, n2 > 10000 ? 10000 : n2);
            this.genomeMapFrame.showRange();
            this.genomeMapFrame.setHighlightCluster(this.m_clusterMap.getSelectedClusterList());
            this.genomeMapFrame.setVisible(true);
        }
        catch (Exception exception) {
            String string2 = "Fail to show the genome map.";
            logger.warn(string2, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string2);
        }
        catch (Error error) {
            String string3 = "Fail to show the genome map.";
            logger.warn(string3, error);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string3);
        }
    }

    @Override
    public boolean isVisibleGenomeMap() {
        return this.genomeMapFrame.isVisible();
    }

    @Override
    public void updateGenomeMap(int n, String string, boolean bl, int n2) {
        try {
            this.genomeMapFrame.setChromosomeData(n, string, bl, n2, this.m_clusterTbl);
            this.genomeMapFrame.updateRange();
            this.genomeMapFrame.showRange();
            this.genomeMapFrame.setHighlightCluster(this.m_clusterMap.getSelectedClusterList());
            this.genomeMapFrame.setVisible(true);
        }
        catch (Exception exception) {
            String string2 = "Fail to show the genome map.";
            logger.warn(string2, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string2);
        }
        catch (Error error) {
            String string3 = "Fail to show the genome map.";
            logger.warn(string3, error);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string3);
        }
    }

    @Override
    public void closeGenomeMapFrame() {
        this.genomeMapFrame.setVisible(false);
        this.updateMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resizeGenomeMap() {
        Dimension dimension = this.m_genomeScrollPane.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        this.genomeMapFrame.setCursor(this.m_waitCursor);
        try {
            this.genomeMapFrame.resizeGenomeMap(dimension);
            this.updateMemory();
        }
        finally {
            this.genomeMapFrame.setCursor(this.m_defaultCursor);
        }
    }

    @Override
    public void domClust() {
        Set set = this.m_taxonomyTree.getInnerSpSet();
        Set set2 = this.m_taxonomyTree.getOuterSpSet();
        this.domClust(set, set2, null);
    }

    @Override
    public void domClust(DomClustCondition domClustCondition) {
        this.domClust(domClustCondition.getIngroupOrganismCodeSet(), domClustCondition.getOutgroupOrganismCodeSet(), domClustCondition);
    }

    private void domClust(Set set, Set set2, DomClustCondition domClustCondition) {
        DomClustDialog domClustDialog;
        Object object;
        Object object2;
        DomClustExecuteValidator domClustExecuteValidator = new DomClustExecuteValidator(this.m_mainWindow);
        if (!domClustExecuteValidator.isEnableDomClust(set.size(), set2.size())) {
            return;
        }
        Set set3 = domClustExecuteValidator.getEnableBestHitCriterion();
        if (this.m_baseCluster != null) {
            object2 = this.m_baseCluster.getCommand();
            object = DomClustQuery.createDomClustCondition((String)object2);
            ((DomClustCondition)object).setBaseDomClustId(this.m_baseCluster.getDomClustId());
            domClustDialog = new DomClustDialog((Frame)this.m_mainWindow, (DomClustCondition)object);
            domClustDialog.setDefaultDomClustCondition((DomClustCondition)object);
        } else {
            domClustDialog = new DomClustDialog(this.m_mainWindow);
            domClustDialog.setDefaultDomClustCondition(domClustCondition);
            domClustDialog.setEnableBestHitCriterion(set3);
        }
        domClustDialog.setVisible(true);
        if (domClustDialog.isCanceled()) {
            domClustDialog.dispose();
            return;
        }
        object2 = domClustDialog.getDomClustCondition();
        ((DomClustCondition)object2).setIngroupOrganismCodeSet(set);
        ((DomClustCondition)object2).setOutgroupOrganismCodeSet(set2);
        if (domClustCondition != null) {
            ((DomClustCondition)object2).setDomClustViewId(domClustCondition.getDomClustViewId());
        }
        object = domClustDialog.getTaxMapOrganismCodeSet();
        ((DomClustCondition)object2).setTaxMapOrganismCodeSet((Set)object);
        if (this.m_baseCluster != null) {
            ((DomClustCondition)object2).setBaseDomClustId(this.m_baseCluster.getDomClustId());
        }
        domClustDialog.dispose();
        logger.info(DomClustQuery.getQueryOption((DomClustCondition)object2));
        this.m_stat = false;
        String[] stringArray = new String[]{"Update data...", "Ortholog Clustering (DomClust): Reading...", "Ortholog Clustering (DomClust): Sorting...", "Ortholog Clustering (DomClust): Indexing...", "Ortholog Clustering (DomClust): Clustering...", "Ortholog Clustering (DomClust): Create Result Table...", "Reading Cluster File..."};
        new ProgressDialog(this.m_mainWindow, this, 100, stringArray, true, true, new DomClust(this.m_mainWindow, this.statusBar, this, (DomClustCondition)object2));
    }

    @Override
    public boolean isExecuteUpgma() {
        return this.isExistDomClustResult();
    }

    @Override
    public boolean isExistDomClustResult() {
        return this.m_clusterTbl != null;
    }

    @Override
    public void upgma(int n) {
        HClustCondition hClustCondition;
        HClustDialog hClustDialog;
        block5: {
            hClustDialog = HClustDialog.getInstance();
            hClustDialog.updateValue(new HashSet(this.m_clusterTbl.getViewOrganismCodeList()), this.m_clusterTbl.isOutgroup(), this.m_clusterTbl.getHClustCondition());
            hClustDialog.setVisible(true);
            if (hClustDialog.isCanceled()) {
                return;
            }
            hClustCondition = hClustDialog.createHClustCondition();
            hClustCondition.setDomClustId(this.m_clusterTbl.getClusterId());
            hClustCondition.setDomClustName(this.m_clusterTbl.getDomClustName());
            hClustCondition.setRestruct(true);
            if (hClustCondition.isServer() && !AccessServer.getInstance().isEnableAccess()) {
                boolean bl;
                while (bl = AccessServer.showAccessErrorMessageRetry(this.m_mainWindow)) {
                    ServerAccessCheckTask.getInstance().checkAccessServer(AccessServer.getInstance().getServerUrl());
                    if (!AccessServer.getInstance().isEnableAccess()) continue;
                    break block5;
                }
                return;
            }
        }
        HClustExecuter hClustExecuter = new HClustExecuter(this.m_mainWindow, this, this.m_clusterTbl, hClustCondition);
        String[] stringArray = hClustCondition.isServer() ? new String[]{"Phylogenetic Pattern Clustering (PhyloPatClust)...", "Loading Phylogenetic Pattern Clustering Result..."} : new String[]{"Loading Property Data...", "Phylogenetic Pattern Clustering (PhyloPatClust)...", "Loading Phylogenetic Pattern Clustering Result..."};
        new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, this.m_clusterTbl.getViewOrderList().size() - 1, stringArray, true, (ProcessImpl)hClustExecuter);
        try {
            ApplicationPropertyFacade.saveProperty(hClustCondition.getDomClustId(), hClustCondition);
        }
        catch (IOException iOException) {
            logger.warn("Fail to save phylopat clustering condition.", iOException);
        }
        hClustDialog.dispose();
    }

    @Override
    public void updateForPhylopat() {
        this.resetMainWindow();
        this.resizeClusterTreeMap();
        this.m_mainWindow.setSelectClusteringTab();
        this.updateSortTree();
        NeighboringClustExecuter.reexecuteNeighborClustering(this.m_mainWindow, this.m_clusterTbl.isExistNeighboringCluster(), this.m_clusterTbl.getNeighboringClustCondition(), this);
    }

    @Override
    public int getViewCount() {
        if (this.m_clusterTbl == null) {
            return 0;
        }
        if (this.m_optionTbl.getOptionValues().isIntensive()) {
            return this.m_clusterTbl.getViewOrderList().size();
        }
        return this.m_clusterTbl.getViewClusterList().size();
    }

    @Override
    public int getTaxonomyCount() {
        return this.m_clusterTbl == null ? 0 : this.m_clusterTbl.getViewOrganismCount();
    }

    @Override
    public int getTabIndex(String string) {
        if (string == "Info") {
            return this.m_infoTabbedPane.getSelectedIndex();
        }
        return this.m_treeTabbedPane.getSelectedIndex();
    }

    @Override
    public ClusterTbl getCurrentClusterTbl() {
        return this.m_clusterTbl;
    }

    @Override
    public void restoreColor2() {
        if (!MessageManager.showConfirmMessage((Component)this.m_colorDialog2, "Restore Default Color?")) {
            return;
        }
        this.m_aminoCodeTbl.restore();
        this.m_colorDialog2.restoreAminoCodeColor();
        this.m_multipleAlignmentFrame.setAminoCodeColor();
        this.updateMemory();
    }

    @Override
    public void openGeneFrame(String string) {
        new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, 100, "Create Gene List...", true, (ProcessImpl)new GeneInfoListCreater(this, string, this.m_clusterTbl.getClusterList()));
    }

    @Override
    public void showGeneListFrame(String string, List list, List list2) {
        try {
            this.geneFrame.createGeneList(string, list, list2);
            this.geneFrame.setVisible(true);
        }
        catch (Exception exception) {
            String string2 = "Fail to show gene list.";
            logger.warn(string2, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string2);
        }
        catch (Error error) {
            String string3 = "Fail to show gene list.";
            logger.warn(string3, error);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string3);
        }
        System.gc();
        this.updateMemory();
    }

    @Override
    public void closeGeneFrame() {
        this.geneFrame.setVisible(false);
        this.geneFrame.clearTable();
        System.gc();
        this.updateMemory();
    }

    @Override
    public void saveGeneList() {
        if (!this.geneFrame.isShowTable()) {
            return;
        }
        String string = this.m_clusterTbl.getDomClustName() + ".txt";
        JFileChooser jFileChooser = new JFileChooser(this.getUserSaveDir());
        jFileChooser.setDialogTitle("Save gene list");
        jFileChooser.setSelectedFile(new File(string));
        if (jFileChooser.showSaveDialog(this.geneFrame) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (file.exists() && !MessageManager.showConfirmOverwriteMessage(this.geneFrame, file.getName())) {
            return;
        }
        try {
            this.geneFrame.saveGeneList(file);
            OptionTbl.getInstance().getOptionValues().setUserExportDir(file.getParent());
        }
        catch (Exception exception) {
            String string2 = "Fail to save gene list.";
            logger.warn(string2, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLimitNoList(List list) {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            if (this.m_optionTbl.getOptionValues().isIntensive()) {
                this.m_clusterTbl.setLimitNoListForAggregate(list);
            } else {
                this.m_clusterTbl.setLimitNoListForDisaggregate(list);
            }
            int n = this.m_clusterTreeMap.getOffsetStartRow() + (Integer)list.get(0);
            this.m_clusterTreeMap.setOffsetStartRow(n);
            this.resetMainWindow();
            this.updateMemory();
        }
        catch (SortException sortException) {
            String string = "Fail to update main frame by limit.";
            logger.warn(string, sortException);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    @Override
    public boolean isLimitNoListForAggregate() {
        return this.m_clusterTbl.isLimitNoListForAggregate();
    }

    @Override
    public boolean isLimitNoListForDisaggregate() {
        return this.m_clusterTbl.isLimitNoListForDisaggregate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void limitRelease() {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            if (this.m_optionTbl.getOptionValues().isIntensive()) {
                this.m_clusterTbl.limitReleaseForAggregate();
            } else {
                this.m_clusterTbl.limitReleaseForDisaggregate();
            }
            this.m_clusterTreeMap.setOffsetStartRow(0);
            this.resetMainWindow();
        }
        catch (SortException sortException) {
            String string = "Fail to update main frame by limit.";
            logger.warn(string, sortException);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    @Override
    public void setSelectedOrganism(Set set, Object object) {
        if (this.m_clusterTbl == null) {
            return;
        }
        if (set == null) {
            return;
        }
        if (object != this.m_clusterMap) {
            this.m_clusterMap.setSelectedOrganism(set);
        }
        if (object != this.m_taxonomyTree) {
            this.m_taxonomyTree.setSelectGenomeNode(set);
        }
        if (object != this.m_taxonomyTreeEx) {
            this.m_taxonomyTreeEx.setSelectGenomeNode(set);
        }
        if (!this.m_clusterTbl.isSyncOrganismSelect()) {
            return;
        }
        this.controlTree.setSelectOrganismColumn(set);
    }

    @Override
    public void expandTaxonomyTree() {
        this.m_taxonomyTree.expandByOneStep();
        this.m_taxonomyTreeEx.expandByOneStep();
    }

    @Override
    public void collapseTaxonomyTree() {
        this.m_taxonomyTree.collapseByOneStep();
        this.m_taxonomyTreeEx.collapseByOneStep();
    }

    @Override
    public void setClusterMode(boolean bl) {
        boolean bl2;
        boolean bl3 = this.m_clusterTbl != null;
        boolean bl4 = bl2 = this.m_clusterTbl != null && this.m_clusterTbl.isOutgroup();
        if (bl2) {
            this.m_optionTbl.getOptionValues().setClusterMode(bl);
        } else {
            this.m_optionTbl.getOptionValues().setClusterMode(true);
        }
        this.clusterModeItem.setEnabled(bl3);
        this.clusterModeTool.setEnabled(bl3);
        this.clusterModeItem.changeMode();
        this.clusterModeTool.changeMode();
        this.m_clusterTbl.updatePatternClusterMap();
    }

    @Override
    public void showKeywordSearchDialog() {
        KeywordSearchDialog keywordSearchDialog = KeywordSearchDialog.getInstance();
        keywordSearchDialog.updateValue(this.m_clusterTbl, null, this.m_clusterTbl.getViewOrganismCodeList());
        keywordSearchDialog.setVisible(true);
    }

    private void closeKeywordSearchDialog() {
        KeywordSearchDialog.getInstance().setVisible(false);
        GeneSearchResultDialog.getInstance().setVisible(false);
        ClusterSearchResultDialog.getInstance().setVisible(false);
    }

    @Override
    public void executeKeywordSearch(KeywordSearch keywordSearch) {
        keywordSearch.setMediator(this);
        keywordSearch.setClusterTbl(this.m_clusterTbl);
        keywordSearch.setParent(this.m_mainWindow);
        try {
            new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, this.getViewCount(), "Keyword Search...", true, (ProcessImpl)keywordSearch);
        }
        catch (Exception exception) {
            logger.warn("Fail to execute keyword search.", exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, "Fail to execute keyword search.");
        }
        catch (Error error) {
            logger.warn("Fail to execute keyword search.", error);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, "Fail to execute keyword search.");
        }
    }

    @Override
    public void setSearchResult(SearchCondition searchCondition, List list) {
        this.m_clusterTbl.setSearchResultList(searchCondition, list);
        ColorFacade colorFacade = ColorFacade.getInstance();
        colorFacade.addSearchColorDrawable();
        this.updateColorTree();
        this.updateFilterTree();
    }

    @Override
    public void showSearchResult() {
        SearchResultGroup searchResultGroup = this.m_clusterTbl.getSearchResultGroup();
        if (searchResultGroup == null || !searchResultGroup.isExistSearchResult()) {
            String string = "There is no search result.";
            MessageManager.showMessage((Component)this.m_mainWindow, string);
            return;
        }
        if (searchResultGroup.isCluster()) {
            ClusterSearchResultDialog clusterSearchResultDialog = ClusterSearchResultDialog.getInstance();
            clusterSearchResultDialog.updateValue(this.m_clusterTbl.isOutgroup(), searchResultGroup);
            clusterSearchResultDialog.setVisible(true);
        } else {
            GeneSearchResultDialog geneSearchResultDialog = GeneSearchResultDialog.getInstance();
            geneSearchResultDialog.updateValue(this.m_clusterTbl.isOutgroup(), searchResultGroup);
            geneSearchResultDialog.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showHighlightFilterSearchResult() {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            ClusterSearchResultDialog clusterSearchResultDialog;
            this.m_clusterTbl.filterHighlightBySearchResult();
            GeneSearchResultDialog geneSearchResultDialog = GeneSearchResultDialog.getInstance();
            if (geneSearchResultDialog.isVisible()) {
                geneSearchResultDialog.setFilterHighlightSearchResult(true, true);
            }
            if ((clusterSearchResultDialog = ClusterSearchResultDialog.getInstance()).isVisible()) {
                clusterSearchResultDialog.setFilterHighlightSearchResult(true, true);
            }
            this.repaintControlTree();
            this.resetMainWindow();
            this.updateMemory();
        }
        catch (SortException sortException) {
            String string = "Fail to update main frame by search results.";
            logger.warn(string, sortException);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearHighlightFilterSearchResult() {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            ClusterSearchResultDialog clusterSearchResultDialog;
            this.m_clusterTbl.clearFilterHighlightBySearchResult();
            GeneSearchResultDialog geneSearchResultDialog = GeneSearchResultDialog.getInstance();
            if (geneSearchResultDialog.isVisible()) {
                geneSearchResultDialog.setFilterHighlightSearchResult(false, false);
            }
            if ((clusterSearchResultDialog = ClusterSearchResultDialog.getInstance()).isVisible()) {
                clusterSearchResultDialog.setFilterHighlightSearchResult(false, false);
            }
            this.repaintControlTree();
            this.resetMainWindow();
            this.updateMemory();
        }
        catch (SortException sortException) {
            String string = "Fail to update main frame by search results.";
            logger.warn(string, sortException);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void highlightBySearchResult() {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            ClusterSearchResultDialog clusterSearchResultDialog;
            this.m_clusterTbl.highlightBySearchResult();
            GeneSearchResultDialog geneSearchResultDialog = GeneSearchResultDialog.getInstance();
            if (geneSearchResultDialog.isVisible()) {
                geneSearchResultDialog.setHighlightSearchResult(true);
            }
            if ((clusterSearchResultDialog = ClusterSearchResultDialog.getInstance()).isVisible()) {
                clusterSearchResultDialog.setHighlightSearchResult(true);
            }
            this.repaintControlTree();
            this.resetMainWindowNotClearView();
            this.updateMemory();
        }
        catch (SortException sortException) {
            String string = "Fail to update main frame by search results.";
            logger.warn(string, sortException);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearHighlightBySearchResult() {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            ClusterSearchResultDialog clusterSearchResultDialog;
            this.m_clusterTbl.clearHighlightBySearchResult();
            GeneSearchResultDialog geneSearchResultDialog = GeneSearchResultDialog.getInstance();
            if (geneSearchResultDialog.isVisible()) {
                geneSearchResultDialog.setHighlightSearchResult(false);
            }
            if ((clusterSearchResultDialog = ClusterSearchResultDialog.getInstance()).isVisible()) {
                clusterSearchResultDialog.setHighlightSearchResult(false);
            }
            this.repaintControlTree();
            this.resetMainWindowNotClearView();
            this.updateMemory();
        }
        catch (SortException sortException) {
            String string = "Fail to update main frame by search results.";
            logger.warn(string, sortException);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filterBySearchResult() {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            ClusterSearchResultDialog clusterSearchResultDialog;
            this.m_clusterTbl.filterBySearchResult();
            GeneSearchResultDialog geneSearchResultDialog = GeneSearchResultDialog.getInstance();
            if (geneSearchResultDialog.isVisible()) {
                geneSearchResultDialog.setFilterSearchResult(true);
            }
            if ((clusterSearchResultDialog = ClusterSearchResultDialog.getInstance()).isVisible()) {
                clusterSearchResultDialog.setFilterSearchResult(true);
            }
            this.repaintControlTree();
            this.resetMainWindow();
            this.updateMemory();
        }
        catch (SortException sortException) {
            String string = "Fail to update main frame by search results.";
            logger.warn(string, sortException);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFilterBySearchResult() {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            ClusterSearchResultDialog clusterSearchResultDialog;
            this.m_clusterTbl.clearFilterBySearchResult();
            GeneSearchResultDialog geneSearchResultDialog = GeneSearchResultDialog.getInstance();
            if (geneSearchResultDialog.isVisible()) {
                geneSearchResultDialog.setFilterSearchResult(false);
            }
            if ((clusterSearchResultDialog = ClusterSearchResultDialog.getInstance()).isVisible()) {
                clusterSearchResultDialog.setFilterSearchResult(false);
            }
            this.repaintControlTree();
            this.resetMainWindow();
            this.updateMemory();
        }
        catch (SortException sortException) {
            String string = "Fail to update main frame by search results.";
            logger.warn(string, sortException);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    @Override
    public void setClusterVScrollBar(boolean bl, int n, int n2, int n3) {
        if (bl) {
            this.m_clusterVScrollBar.setValues(n, n2, n3);
        }
        this.m_clusterVScrollBar.setVisible(bl);
    }

    @Override
    public void setClusterVScrollBarValue(int n) {
        this.m_clusterVScrollBar.setValue(n);
    }

    @Override
    public void setClusterHScrollBar(boolean bl, int n, int n2, int n3) {
        if (bl) {
            this.m_clusterHScrollBar.setValues(n, n2, n3);
            this.m_clusterArea.setSpace(this.m_clusterVScrollBar.isVisible());
        } else {
            this.m_clusterArea.setSpace(false);
        }
        this.m_clusterHScrollBar.setVisible(bl);
    }

    @Override
    public void grabFocusOnClusterArea() {
        this.m_clusterArea.requestFocus();
    }

    @Override
    public void setClusterRow(int n) {
        this.m_clusterMap.setStartRow(n);
        this.setCategoryScrollBarValue(n);
        this.setClusterTreeScrollBarValue(n);
    }

    @Override
    public void setClusterColumn(int n) {
        this.m_clusterMap.setColumn(n);
        this.m_headerMap.repaint();
    }

    @Override
    public boolean isClusterVScrollBarVisible() {
        return this.m_clusterVScrollBar.isVisible();
    }

    @Override
    public boolean isClusterHScrollBarVisible() {
        return this.m_clusterHScrollBar.isVisible();
    }

    @Override
    public Object getClusterVScrollBarModel() {
        return this.m_clusterVScrollBar.getModel();
    }

    @Override
    public Object getClusterHScrollBarModel() {
        return this.m_clusterHScrollBar.getModel();
    }

    @Override
    public void scrollClusterMap(int n) {
        if (this.isClusterVScrollBarVisible()) {
            this.m_clusterVScrollBar.setValue(this.m_clusterVScrollBar.getValue() + n * this.m_clusterVScrollBar.getUnitIncrement());
        }
    }

    @Override
    public void scrollHClusterMap(int n) {
        if (this.isClusterHScrollBarVisible()) {
            this.m_clusterHScrollBar.setValue(this.m_clusterHScrollBar.getValue() + n * this.m_clusterHScrollBar.getUnitIncrement());
        }
    }

    @Override
    public void pageUpClusterMap() {
        int n = this.m_optionTbl.getOptionValues().getClusterMapVPageStepSize();
        this.scrollClusterMap(-n);
    }

    @Override
    public void pageDownClusterMap() {
        int n = this.m_optionTbl.getOptionValues().getClusterMapVPageStepSize();
        this.scrollClusterMap(n);
    }

    @Override
    public void halfPageUpClusterMap() {
        int n = this.m_clusterMap.getRows();
        this.scrollClusterMap(-n / 2);
    }

    @Override
    public void halfPageDownClusterMap() {
        int n = this.m_clusterMap.getRows();
        this.scrollClusterMap(n / 2);
    }

    @Override
    public void scrollUpClusterMap() {
        int n = this.m_optionTbl.getOptionValues().getClusterMapVScrollStepSize();
        this.scrollClusterMap(-n);
    }

    @Override
    public void scrollDownClusterMap() {
        int n = this.m_optionTbl.getOptionValues().getClusterMapVScrollStepSize();
        this.scrollClusterMap(n);
    }

    @Override
    public void scrollLeftClusterMap() {
        int n = this.m_optionTbl.getOptionValues().getClusterMapHScrollStepSize();
        this.scrollHClusterMap(-n);
    }

    @Override
    public void scrollRightClusterMap() {
        int n = this.m_optionTbl.getOptionValues().getClusterMapHScrollStepSize();
        this.scrollHClusterMap(n);
    }

    @Override
    public void moveToHomeClusterMap() {
        if (this.isClusterVScrollBarVisible()) {
            this.m_clusterVScrollBar.setValue(0);
        }
    }

    @Override
    public void moveToEndClusterMap() {
        if (this.isClusterVScrollBarVisible()) {
            this.m_clusterVScrollBar.setValue(this.m_clusterVScrollBar.getMaximum());
        }
    }

    @Override
    public void verticalZoomClusterMap(int n) {
        int n2 = this.m_optionTbl.getOptionValues().getMinClusterH() + n;
        this.setVerticalZoomClusterMap(n2);
    }

    @Override
    public void setVerticalZoomClusterMap(int n) {
        this.setMinClusterH(n);
        this.m_mainWindow.getVZoomSlider().setValue(n);
        this.m_categoryScrollBar.setValue(this.m_clusterMap.getStartRow());
    }

    @Override
    public void horizontalZoomClusterMap(int n) {
        int n2 = this.m_optionTbl.getOptionValues().getMinClusterW() + n;
        this.setMinClusterW(n2);
        this.m_mainWindow.getHZoomSlider().setValue(n2);
    }

    @Override
    public void updateDatasWithConfirm() {
        block3: {
            if (!AccessServer.getInstance().isEnableAccess()) {
                boolean bl;
                while (bl = AccessServer.showAccessErrorMessageRetry(this.m_mainWindow)) {
                    ServerAccessCheckTask.getInstance().checkAccessServer(AccessServer.getInstance().getServerUrl());
                    if (!AccessServer.getInstance().isEnableAccess()) continue;
                    break block3;
                }
                return;
            }
        }
        DataUpdateDialog dataUpdateDialog = DataUpdateDialog.getInstance();
        dataUpdateDialog.setVisible(true);
        if (!dataUpdateDialog.isCanceled()) {
            int n = dataUpdateDialog.getUpdateType();
            this.updateDatas(n);
        }
    }

    @Override
    public void updateDatas(int n) {
        AbstractDataUpdater abstractDataUpdater = AbstractDataUpdater.createDataUpdater(n, this.m_mainWindow, this);
        new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, 1, abstractDataUpdater.getProgressMessages(), true, (ProcessImpl)abstractDataUpdater);
    }

    @Override
    public void updateTaxonomyTreeAfterInitMainWindow() {
        try {
            this.initMainWindow();
            this.m_taxonomyTree.readTaxonomyDat();
            this.m_taxonomyTreeEx.readTaxonomyDat();
            this.m_taxonomyTree.createTaxonomyTree();
        }
        catch (Exception exception) {
            String string = "Fail to update taxonomy tree.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void updateTaxonomyTree() {
        try {
            this.m_taxonomyTree.readTaxonomyDat();
            this.m_taxonomyTree.createTaxonomyTree();
            this.m_taxonomyTreeEx.readTaxonomyDat();
            this.m_taxonomyTreeEx.createTaxonomyTree();
        }
        catch (Exception exception) {
            String string = "Fail to update taxonomy tree.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void selectClusterOnPPM(String string, String string2) {
        Cluster cluster = this.m_clusterTbl.getViewCluster(string, string2);
        this.selectClusterOnPPM(string, string2, cluster);
    }

    @Override
    public void selectClusterOnPPM(String string, String string2, Cluster cluster) {
        HashSet<Cluster> hashSet = new HashSet<Cluster>();
        hashSet.add(cluster);
        this.updateSelectedCluster(string, string2, hashSet, false);
    }

    @Override
    public void setMinClusterH(int n) {
        if (this.m_optionTbl.getOptionValues().getMinClusterH() == n) {
            return;
        }
        this.m_optionTbl.getOptionValues().setMinClusterH(n);
        if (this.m_clusterTbl == null) {
            return;
        }
        this.resizeClusterMap();
        this.updateMemory();
    }

    @Override
    public void setMinClusterW(int n) {
        if (this.m_optionTbl.getOptionValues().getMinClusterW() == n) {
            return;
        }
        this.m_optionTbl.getOptionValues().setMinClusterW(n);
        if (this.m_clusterTbl == null) {
            return;
        }
        this.resizeClusterMap();
        this.updateMemory();
    }

    @Override
    public Object getClusterMapDrawInfo() {
        return this.m_clusterMap.getClusterMapDrawInfo();
    }

    @Override
    public void removeFilterConditions(Collection collection) {
        boolean bl = FilterFacade.getInstance().removeFilterConditions(collection);
        this.updateForFilter(bl);
    }

    @Override
    public void removeSpFromCondition(Map map) {
        boolean bl = false;
        for (Long l : map.keySet()) {
            long l2 = l;
            Set set = (Set)map.get(l);
            bl |= FilterFacade.getInstance().removeSpFromCondition(l2, set);
        }
        this.updateForFilter(bl);
    }

    @Override
    public boolean isViewUpper() {
        return this.modePanel.isSelectedSelectPanel();
    }

    @Override
    public void taxonomyView() {
        this.m_mainWindow.setTaxonomyView(this.m_taxonomyItem.getState(), true);
    }

    @Override
    public void functionView() {
        this.m_mainWindow.setFunctionView(this.m_functionItem.getState(), true);
    }

    @Override
    public void setPPMHeaderHeight(int n, int n2) {
        Dimension dimension = this.m_headerScrollPane.getPreferredSize();
        this.m_headerScrollPane.setMinimumSize(new Dimension(dimension.width, n + n2));
        this.m_headerScrollPane.setPreferredSize(new Dimension(dimension.width, n + n2));
        int n3 = this.m_treeTabbedPane.getComponentAt(2).getY() - n;
        this.m_clusterTreeMap.setMarginTop(n2 - n3);
        this.m_categoryMap.setMarginTop(n2 - n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Server showNewServerDialog() {
        Window window = null;
        try {
            Object object;
            window = new ServerEditDialog(this.m_mainWindow);
            ((Dialog)window).setVisible(true);
            Server server = null;
            if (!((AbstractApplyDialog)window).isCanceled()) {
                server = ((ServerEditDialog)window).getModifiedServer();
                object = ServerTbl.getInstance();
                ((ArrayList)object).add(server);
                Collections.sort(object, new ServerComparator());
                try {
                    ((ServerTbl)object).writeServer();
                }
                catch (IOException iOException) {
                    String string = "Fail to save server.";
                    MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
                    logger.warn(string, iOException);
                }
            }
            object = server;
            return object;
        }
        finally {
            window.dispose();
        }
    }

    @Override
    public void registerServerUrl(String string) throws Exception {
        String string2;
        ServerTbl serverTbl = ServerTbl.getInstance();
        if (!serverTbl.containsServer(string)) {
            serverTbl.addServer(string);
            serverTbl.writeServer();
        }
        DataFileDownloader dataFileDownloader = DataFileDownloader.getInstance();
        DataManager.createDataDirectory();
        dataFileDownloader.downloadTaxonomyData(false);
        String string3 = DataManager.getGenomeDat();
        if (!new File(string3).isFile()) {
            dataFileDownloader.downloadGenomeData();
        }
        if (!new File(string2 = DataManager.getGenomeParamDat()).isFile()) {
            dataFileDownloader.downloadGenomeParamData();
        }
        FuncCatTbl funcCatTbl = FuncCatTbl.getInstance();
        funcCatTbl.restoreAll(false);
        if (DataManager.isDataversionFilepath()) {
            AbstractDataUpdater.updateDataVersion();
        }
        try {
            this.m_innerTbl.initInner();
            this.m_outerTbl.initOuter();
            this.spGroupTbl.init();
            this.m_publicSpecTbl.clear();
            this.m_baseCluster = null;
        }
        catch (IOException iOException) {
            logger.warn("Fail to init Ingroup, Outgroup, SpGroup", iOException);
        }
    }

    @Override
    public void showServerListDialog() {
        ServerTbl serverTbl = ServerTbl.getInstance();
        serverTbl.updateSelectState(AccessServer.getInstance().getServerUrl());
        ServerListDialog serverListDialog = new ServerListDialog((Frame)this.m_mainWindow, (MediatorImpl)this, new ArrayList(serverTbl));
        serverListDialog.setVisible(true);
        if (!serverListDialog.isCanceled()) {
            List list = serverListDialog.getServerList();
            Collections.sort(list, new ServerComparator());
            serverTbl.clear();
            serverTbl.addAll(list);
            try {
                serverTbl.writeServer();
            }
            catch (IOException iOException) {
                String string = "Fail to save server.";
                MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
                logger.warn(string, iOException);
            }
            Server server = serverListDialog.getTargetServer();
            this.changeSelectServer(server);
        }
        serverListDialog.dispose();
    }

    @Override
    public void changeSelectServer(final Server server) {
        try {
            AccessServer accessServer = AccessServer.getInstance();
            String string = accessServer.getServerUrl();
            boolean bl = !accessServer.equalsServerUrl(server.getUrl());
            accessServer.setServerUrl(server.getUrl());
            try {
                this.registerServerUrl(server.getUrl());
            }
            catch (Exception exception) {
                String string2 = "Fail to change server. " + server.getUrl();
                logger.warn(string2, exception);
                accessServer.setServerUrl(string);
                MessageManager.showErrorMessage((Component)this.m_mainWindow, string2);
                return;
            }
            HashSet hashSet = new HashSet();
            if (this.m_clusterTbl != null) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DomClustFileOpenHelper.changeServerUrl(Mediator.this.m_clusterTbl.getFilepath(), server.getHost(), server.getPort());
                            Mediator.this.m_clusterTbl.setServerUrl(server.getUrl());
                        }
                        catch (IOException iOException) {
                            logger.warn("Fail to save server url to domclust file. " + Mediator.this.m_clusterTbl.getFilepath(), iOException);
                        }
                    }
                };
                ThreadManager.getInstance().execute(runnable);
                hashSet = new HashSet(this.m_clusterTbl.getOrganismCodeList());
            }
            if (bl) {
                this.updateTaxonomyTree();
                this.updateDataForDomClustOpen(hashSet);
                MapFacade.saveDefaultMap(hashSet);
                this.checkVersionUp();
            }
        }
        catch (Exception exception) {
            String string = "Fail to save server information.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void updateDataForDomClustOpen(Set set) throws Exception {
        Set set2 = DataManager.getOrganismCodeSetNotExistGeneChromosomeFile(set);
        if (set2.isEmpty()) {
            return;
        }
        String string = "Download gene/chromosome data?";
        if (!MessageManager.showConfirmMessage((Component)this.m_mainWindow, string)) {
            return;
        }
        AbstractDataUpdater abstractDataUpdater = AbstractDataUpdater.createDomClustGeneInfoDataUpdater(this.m_mainWindow, this, set);
        new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, 1, abstractDataUpdater.getProgressMessages(), true, (ProcessImpl)abstractDataUpdater);
    }

    @Override
    public void checkVersionUp() {
        ThreadManager threadManager = ThreadManager.getInstance();
        threadManager.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SysInfo.getInstance().clearFinishServerDataInfo();
                    UpdateCheckExecuter.createSimpleUpdateCheckExecuter(Mediator.this.m_mainWindow, Mediator.this).execute();
                }
                catch (IOException iOException) {
                    String string = "Fail to get new versions from global server.";
                    logger.warn(string, iOException);
                }
            }
        });
    }

    @Override
    public void setOrganismColor(Set set) {
        String string = (String)set.iterator().next();
        String string2 = (String)this.m_colorTbl.get(string);
        Color color = JColorChooser.showDialog(this.m_mainWindow, "Color palette", StringTool.isNull(string2) ? Color.black : ColorUtil.str2Color(string2));
        if (color != null) {
            String string3 = ColorUtil.color2Str(color);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.m_colorTbl.put((String)iterator.next(), string3);
            }
            this.m_headerMap.repaint();
            if (this.m_pTreeMainWindow != null && this.m_pTreeMainWindow.isDisplayable()) {
                this.m_pTreeMainWindow.updateView();
            }
        }
    }

    @Override
    public void clearOrganismColor(Set set) {
        boolean bl = false;
        for (String string : set) {
            bl |= this.m_colorTbl.remove(string) != null;
        }
        if (bl) {
            this.m_headerMap.repaint();
            if (this.m_pTreeMainWindow != null && this.m_pTreeMainWindow.isDisplayable()) {
                this.m_pTreeMainWindow.updateView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resizeClusterTreeMap() {
        Dimension dimension = this.m_clusterTreeScrollPane.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            Dimension dimension2 = this.m_clusterScrollPane.getSize();
            this.m_clusterTreeMap.resizeClusterTreeMap(new Dimension(dimension.width, dimension2.height));
            this.updateMemory();
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    @Override
    public void setClusterTreeScrollBar(boolean bl, int n, int n2, int n3) {
        if (bl) {
            this.m_clusterTreeScrollBar.setValues(n, n2, n3);
        }
        this.m_clusterTreeScrollBar.setVisible(bl);
    }

    @Override
    public void setClusterTreeScrollBarValue(int n) {
        this.m_clusterTreeScrollBar.setValue(n);
    }

    @Override
    public void setClusterTreeRow(int n) {
        this.m_clusterTreeMap.setRow(n);
        this.setClusterVScrollBarValue(n);
        this.setCategoryScrollBarValue(n);
    }

    @Override
    public boolean isClusterTreeScrollBarVisible() {
        return this.m_clusterTreeScrollBar.isVisible();
    }

    @Override
    public Object getClusterTreeScrollBarModel() {
        return this.m_clusterTreeScrollBar.getModel();
    }

    @Override
    public void scrollClusterTreeMap(int n) {
        if (this.isClusterTreeScrollBarVisible()) {
            this.setClusterTreeScrollBarValue(this.m_clusterTreeScrollBar.getValue() + n * this.m_clusterTreeScrollBar.getUnitIncrement());
        }
    }

    @Override
    public ClusterTreeMap getClusterTreeMap() {
        return this.m_clusterTreeMap;
    }

    @Override
    public CategoryMap getCategoryMap() {
        return this.m_categoryMap;
    }

    @Override
    public void pageSetup() {
        this.initPage();
        this.m_pageFormat = PrinterJob.getPrinterJob().pageDialog(this.m_pageFormat);
    }

    @Override
    public PageFormat getPageFormat() {
        this.initPage();
        return this.m_pageFormat;
    }

    @Override
    public Dimension getHeaderMapSize() {
        return this.m_headerMap.getSize();
    }

    @Override
    public void register(Object object) {
        if (object instanceof MainWindow) {
            this.m_mainWindow = (MainWindow)object;
        } else if (object instanceof InfoTabbedPane) {
            this.m_infoTabbedPane = (InfoTabbedPane)object;
        } else if (object instanceof TreeTabbedPane) {
            this.m_treeTabbedPane = (TreeTabbedPane)object;
        } else if (object instanceof SetTree) {
            this.setTree = (SetTree)object;
        } else if (object instanceof TaxonomyTreeEx) {
            this.m_taxonomyTreeEx = (TaxonomyTreeEx)object;
        } else if (object instanceof TaxonomyTree) {
            this.m_taxonomyTree = (TaxonomyTree)object;
        } else if (object instanceof HeaderMap) {
            this.m_headerMap = (HeaderMap)object;
        } else if (object instanceof ClusterMap) {
            this.m_clusterMap = (ClusterMap)object;
        } else if (object instanceof CategoryMap) {
            this.m_categoryMap = (CategoryMap)object;
        } else if (object instanceof ClusterList) {
            this.m_clusterList = (ClusterList)object;
        } else if (object instanceof GeneNameList) {
            this.m_geneNameList = (GeneNameList)object;
        } else if (object instanceof GeneInfoList) {
            this.m_geneInfoList = (GeneInfoList)object;
        } else if (object instanceof AggregateModeItem) {
            this.aggregateModeItem = (AggregateModeItem)object;
        } else if (object instanceof AggregateModeTool) {
            this.aggregateModeTool = (AggregateModeTool)object;
        } else if (object instanceof HeaderScrollPane) {
            this.m_headerScrollPane = (HeaderScrollPane)object;
        } else if (object instanceof ClusterScrollPane) {
            this.m_clusterScrollPane = (ClusterScrollPane)object;
        } else if (object instanceof CategoryScrollPane) {
            this.m_categoryScrollPane = (CategoryScrollPane)object;
        } else if (object instanceof CategoryScrollBar) {
            this.m_categoryScrollBar = (CategoryScrollBar)object;
        } else if (object instanceof AlignmentFrame) {
            this.m_alignmentFrame = (AlignmentFrame)object;
        } else if (object instanceof StatusBar) {
            this.statusBar = (StatusBar)object;
        } else if (object instanceof ClusterModeItem) {
            this.clusterModeItem = (ClusterModeItem)object;
        } else if (object instanceof ClusterModeTool) {
            this.clusterModeTool = (ClusterModeTool)object;
        } else if (object instanceof MultipleAlignmentFrame) {
            this.m_multipleAlignmentFrame = (MultipleAlignmentFrame)object;
        } else if (object instanceof ColorDialog2) {
            this.m_colorDialog2 = (ColorDialog2)object;
        } else if (object instanceof GenomeMapFrame) {
            this.genomeMapFrame = (GenomeMapFrame)object;
        } else if (object instanceof GenomeScrollPane) {
            this.m_genomeScrollPane = (GenomeScrollPane)object;
        } else if (object instanceof GeneFrame) {
            this.geneFrame = (GeneFrame)object;
        } else if (object instanceof KeywordSearchMainItem) {
            this.m_keywordSearchItem = (KeywordSearchMainItem)object;
        } else if (object instanceof KeywordSearchTool) {
            this.m_keywordSearchTool = (KeywordSearchTool)object;
        } else if (object instanceof CountFilterItem) {
            this.countFilterItem = (CountFilterItem)object;
        } else if (object instanceof ClusterVScrollBar) {
            this.m_clusterVScrollBar = (ClusterVScrollBar)object;
        } else if (object instanceof ClusterHScrollBar) {
            this.m_clusterHScrollBar = (ClusterHScrollBar)object;
        } else if (object instanceof FileSaveItem) {
            this.m_fileSaveItem = (FileSaveItem)object;
        } else if (object instanceof FileSaveTool) {
            this.m_fileSaveTool = (FileSaveTool)object;
        } else if (object instanceof ExportMenu) {
            this.exportMenu = (ExportMenu)object;
        } else if (object instanceof ExportTool) {
            this.exportTool = (ExportTool)object;
        } else if (object instanceof TaxonomyItem) {
            this.m_taxonomyItem = (TaxonomyItem)object;
        } else if (object instanceof FunctionItem) {
            this.m_functionItem = (FunctionItem)object;
        } else if (object instanceof ClusterArea) {
            this.m_clusterArea = (ClusterArea)object;
        } else if (object instanceof ClusterTreeMap) {
            this.m_clusterTreeMap = (ClusterTreeMap)object;
        } else if (object instanceof ClusterTreeScrollPane) {
            this.m_clusterTreeScrollPane = (ClusterTreeScrollPane)object;
        } else if (object instanceof ClusterTreeScrollBar) {
            this.m_clusterTreeScrollBar = (ClusterTreeScrollBar)object;
        } else if (object instanceof ControlTree) {
            this.controlTree = (ControlTree)object;
        } else if (object instanceof SetTree) {
            this.setTree = (SetTree)object;
        } else if (object instanceof TreeOptionPanel) {
            this.treeOptionPanel = (TreeOptionPanel)object;
        } else if (object instanceof CoreGenomeFrame) {
            this.coreGenomeFrame = (CoreGenomeFrame)object;
        } else if (object instanceof CoreGenomeItem) {
            this.coreGenomeItem = (CoreGenomeItem)object;
        } else if (object instanceof CoreGenomeTool) {
            this.coreGenomeTool = (CoreGenomeTool)object;
        } else if (object instanceof SpGroupTree) {
            this.spGroupTree = (SpGroupTree)object;
        } else if (object instanceof ModePanel) {
            this.modePanel = (ModePanel)object;
        } else if (object instanceof RankSelectPanel) {
            this.rankSelectPanel = (RankSelectPanel)object;
        } else if (object instanceof HClustTool) {
            this.upgmaTool = (HClustTool)object;
        } else if (object instanceof HClustItem) {
            this.upgmaItem = (HClustItem)object;
        } else if (object instanceof NeighborClustItem) {
            this.neighborClustItem = (NeighborClustItem)object;
        } else if (object instanceof NeighborClustTool) {
            this.neighborClustTool = (NeighborClustTool)object;
        } else if (object instanceof TaxMapExecuteTool) {
            this.taxMapExecuteTool = (TaxMapExecuteTool)object;
        } else if (object instanceof FuncCatTool) {
            this.funcCatTool = (FuncCatTool)object;
        } else if (object instanceof PropertyItem) {
            this.propertyItem = (PropertyItem)object;
        } else if (object instanceof GeneColorItem) {
            this.geneColorItem = (GeneColorItem)object;
        } else if (object instanceof GeneColorTool) {
            this.geneColorTool = (GeneColorTool)object;
        } else if (object instanceof HistogramItem) {
            this.histogramItem = (HistogramItem)object;
        } else if (object instanceof HistogramTool) {
            this.histogramTool = (HistogramTool)object;
        } else if (object instanceof PPMLabelMenu) {
            this.ppmLabelMenu = (PPMLabelMenu)object;
        } else if (object instanceof AllClusterSelectItem) {
            this.allClusterSelectItem = (AllClusterSelectItem)object;
        } else if (object instanceof ImportMenu) {
            this.importMenu = (ImportMenu)object;
        } else if (object instanceof ImportTool) {
            this.importTool = (ImportTool)object;
        } else if (object instanceof TaxMapExecuteItem) {
            this.taxMapExecuteItem = (TaxMapExecuteItem)object;
        } else if (object instanceof ApplicationPropertySaveAsItem) {
            this.applicationPropertySaveAsItem = (ApplicationPropertySaveAsItem)object;
        } else if (object instanceof ApplicationPropertySaveItem) {
            this.applicationPropertySaveItem = (ApplicationPropertySaveItem)object;
        } else if (object instanceof ClusterInfoConvertItem) {
            this.clusterInfoConvertItem = (ClusterInfoConvertItem)object;
        } else if (object instanceof MergeClusterReleaseItem) {
            this.mergeClusterReleaseItem = (MergeClusterReleaseItem)object;
        } else if (object instanceof SplitClusterReleaseItem) {
            this.splitClusterReleaseItem = (SplitClusterReleaseItem)object;
        } else if (object instanceof MergeOrganismReleaseItem) {
            this.mergeOrganismReleaseItem = (MergeOrganismReleaseItem)object;
        } else if (object instanceof SplitOrganismReleaseItem) {
            this.splitOrganismReleaseItem = (SplitOrganismReleaseItem)object;
        } else if (object instanceof DomClustSaveServerItem) {
            this.domClustSaveServerItem = (DomClustSaveServerItem)object;
        } else {
            logger.warn("Can't register: " + object.getClass());
        }
    }

    @Override
    public String getInGroupColor() {
        return this.m_optionTbl.getOptionValues().getIngroupFontColor();
    }

    @Override
    public String getOutGroupColor() {
        return this.m_optionTbl.getOptionValues().getOutgroupFontColor();
    }

    @Override
    public boolean isInGroup(String string) {
        if (this.m_clusterTbl == null) {
            return false;
        }
        return this.m_clusterTbl.isIngroup(string);
    }

    @Override
    public String getSpeciesColor(String string) {
        String string2 = (String)this.m_colorTbl.get(string);
        return StringTool.isNull(string2) ? "#000000" : string2;
    }

    @Override
    public void setVisibleForSubTree() {
        this.treeOptionPanel.updateComponents(this.modePanel.getMode());
    }

    @Override
    public void showCoreGenomeExecuteDialog() {
        block2: {
            if (!AccessServer.getInstance().isEnableAccess()) {
                boolean bl;
                while (bl = AccessServer.showAccessErrorMessageRetry(this.m_mainWindow)) {
                    ServerAccessCheckTask.getInstance().checkAccessServer(AccessServer.getInstance().getServerUrl());
                    if (!AccessServer.getInstance().isEnableAccess()) continue;
                    break block2;
                }
                return;
            }
        }
        List list = this.m_clusterTbl.getOrganismCodeList();
        List list2 = ModifiedOrganismManager.getInstance().convertSystemOrganismCodeList(list);
        GenomeTbl genomeTbl = new GenomeTbl();
        List list3 = genomeTbl.createOrganismList(list2);
        CoreGenomeUtil.setInOutgroupForOrganims(list3, this.m_clusterTbl.getIngroupSpList(), this.m_clusterTbl.getOutgroupSpList());
        CoreGenomeExecuteDialog coreGenomeExecuteDialog = new CoreGenomeExecuteDialog(this.m_mainWindow, this, list3, this.m_clusterTbl.getClusterId(), this.m_clusterTbl.getClusterViewId(), this.m_clusterTbl.getDomClustName());
        coreGenomeExecuteDialog.setVisible(true);
    }

    @Override
    public void alignCoreGenome(CoreGenomeAlignmentCondition coreGenomeAlignmentCondition) {
        GenomeTbl genomeTbl = new GenomeTbl();
        List list = genomeTbl.createOrganismList(this.m_clusterTbl.getViewOrganismCodeList());
        CoreGenomeUtil.setInOutgroupForOrganims(list, this.m_clusterTbl.getIngroupSpList(), this.m_clusterTbl.getOutgroupSpList());
        FullCoreGenomeAlignment fullCoreGenomeAlignment = CoreGenomeAlignment.createFullCoreGenomeAlignment(this, this.m_mainWindow, this.m_clusterTbl, list, coreGenomeAlignmentCondition);
        new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, 100, fullCoreGenomeAlignment.getProgressMessages(), true, (ProcessImpl)fullCoreGenomeAlignment);
    }

    @Override
    public void showCoreGenomeViewUpdateDialog(Frame frame, MediatorImpl mediatorImpl, CoreGenomeViewModel coreGenomeViewModel) {
        CoreGenomeUpdateDialog coreGenomeUpdateDialog = new CoreGenomeUpdateDialog(frame, mediatorImpl, coreGenomeViewModel);
        coreGenomeUpdateDialog.setVisible(true);
    }

    @Override
    public void updateCoreGenomeMap(CoreGenomeViewModel coreGenomeViewModel, CoreGenomeAlignmentCondition coreGenomeAlignmentCondition, boolean bl) {
        boolean bl2;
        boolean bl3 = !coreGenomeViewModel.equalsReferenceOrganism(coreGenomeAlignmentCondition.getReferenceOrganism());
        boolean bl4 = bl2 = !coreGenomeViewModel.equalsOrthologGroupLabelType(coreGenomeAlignmentCondition.getOrthologGroupLabelType());
        if (bl3 || !coreGenomeViewModel.equalsWindowSize(coreGenomeAlignmentCondition.getWindowSize())) {
            ConnectionUpdater connectionUpdater = CoreGenomeAlignment.createConnectionUpdater(this, this.m_mainWindow, this.m_clusterTbl, this.coreGenomeFrame, coreGenomeViewModel, coreGenomeAlignmentCondition);
            new ProgressDialog((Frame)this.coreGenomeFrame, (MediatorImpl)this, 100, ((CoreGenomeAlignment)connectionUpdater).getProgressMessages(), true, (ProcessImpl)connectionUpdater);
        } else {
            coreGenomeViewModel.setCondition(coreGenomeAlignmentCondition);
            this.coreGenomeFrame.fireUpadteCoreGenomeViewModel();
        }
        if (bl) {
            this.setCoreParamToGlobalAlign(coreGenomeAlignmentCondition.createCoreCommonParamDTO());
        }
        if (bl2 && PPMLabelType.isSelectableClusterMap(coreGenomeAlignmentCondition.getOrthologGroupLabelType())) {
            this.updatePPMLabel(PPMLabelConditionFactory.createPpmLabelCondition(coreGenomeAlignmentCondition.getOrthologGroupLabelType(), this.m_clusterTbl.getClusterList(), this.m_clusterTbl.isOutgroup()), false);
        }
    }

    @Override
    public void showCoreGenomeFrame(CoreGenomeViewModel coreGenomeViewModel) {
        if (this.coreGenomeFrame == null) {
            CoreGenomeFrame coreGenomeFrame = new CoreGenomeFrame(this.m_mainWindow, this, coreGenomeViewModel);
            coreGenomeFrame.setVisible(true);
        } else {
            this.coreGenomeFrame.fireUpadteCoreGenomeViewModel(coreGenomeViewModel);
            this.coreGenomeFrame.setVisible(true);
        }
        this.initGlobalAlign(coreGenomeViewModel);
    }

    @Override
    public void closeCoreGenomeFrame() {
        if (this.coreGenomeFrame == null) {
            return;
        }
        this.coreGenomeFrame.setVisible(false);
        this.coreGenomeFrame.deleteObservers();
        this.coreGenomeFrame.dispose();
        this.coreGenomeFrame = null;
        System.gc();
        this.updateMemory();
    }

    @Override
    public void saveCoreGenomeFile(CoreGenomeViewModel coreGenomeViewModel) {
        try {
            JFileChooser jFileChooser = new JFileChooser(this.getUserSaveDir());
            jFileChooser.setDialogTitle("Export Core Genome file");
            jFileChooser.setFileFilter(new CoreGenomeFileFilter());
            if (jFileChooser.showSaveDialog(this.coreGenomeFrame) != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (file.isFile() && !MessageManager.showConfirmOverwriteMessage(this.coreGenomeFrame, file.getName())) {
                return;
            }
            CoreGenomeExporter coreGenomeExporter = new CoreGenomeExporter();
            coreGenomeExporter.setBaseFile(new File(coreGenomeViewModel.getGenomeAlign().getFilepath()));
            coreGenomeExporter.setFile(file);
            coreGenomeExporter.setCoreGenomeViewModel(coreGenomeViewModel);
            coreGenomeExporter.write();
            this.m_optionTbl.getOptionValues().setUserExportDir(file.getParentFile().getAbsolutePath());
        }
        catch (IOException iOException) {
            String string = "Fail to export core genome file.";
            logger.warn(string, iOException);
            MessageManager.showErrorMessage((Component)this.coreGenomeFrame, string);
        }
    }

    @Override
    public void zoomCoreGenomeView(double d) {
        this.coreGenomeFrame.zoom(d);
    }

    @Override
    public void showCoreGenomePreviewDialog(CoreGenomeViewModel coreGenomeViewModel) {
        this.initPage();
        CoreGenomePreviewDialog coreGenomePreviewDialog = new CoreGenomePreviewDialog((Frame)this.coreGenomeFrame, this, this.m_pageFormat, coreGenomeViewModel);
        coreGenomePreviewDialog.setVisible(true);
        coreGenomePreviewDialog.dispose();
    }

    @Override
    public void printCoreGenomeAlignment(CoreGenomeViewModel coreGenomeViewModel) {
        this.initPage();
        CoreGenomePrintable coreGenomePrintable = new CoreGenomePrintable(this.m_pageFormat, coreGenomeViewModel);
        this.print(coreGenomePrintable);
    }

    private void print(final AbstractPrintable abstractPrintable) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Book book = new Book();
                for (int i = 0; i < abstractPrintable.getPageCount(); ++i) {
                    book.append(abstractPrintable, abstractPrintable.getPageFormat());
                }
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPageable(book);
                if (printerJob.printDialog()) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException printerException) {
                        String string = "Failed to print.";
                        logger.warn(string, printerException);
                        MessageManager.showErrorMessage((Component)Mediator.this.m_mainWindow, string);
                    }
                }
            }
        });
        thread.setPriority(1);
        thread.start();
    }

    @Override
    public void selectOrthologGroupOnCoreGenome(String string) {
        if (!this.isShowCoreGenomeView()) {
            return;
        }
        this.coreGenomeFrame.selectOrthologGroup(string);
    }

    @Override
    public void selectOrthologGroupOnCoreGenome(Cluster cluster) {
        if (!this.isShowCoreGenomeView()) {
            return;
        }
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        arrayList.add(cluster);
        this.coreGenomeFrame.selectOrthologGroup(arrayList);
    }

    @Override
    public void selectOrthologGroupOnCoreGenome(List list) {
        if (!this.isShowCoreGenomeView()) {
            return;
        }
        this.coreGenomeFrame.selectOrthologGroup(list);
    }

    @Override
    public void changeCentralPositionOnCoreGenome(String string) {
        if (!this.isShowCoreGenomeView()) {
            return;
        }
        this.coreGenomeFrame.changeCentralPosition(string);
    }

    @Override
    public void setCoreParamToGlobalAlign(CoreCommonParamDTO coreCommonParamDTO) {
        if (this.globalAlignFrame == null) {
            return;
        }
        this.globalAlignFrame.setCoreParam(coreCommonParamDTO);
    }

    @Override
    public void setCoreParamToCoreGenome(CoreCommonParamDTO coreCommonParamDTO) {
        this.coreGenomeFrame.setCoreParam(coreCommonParamDTO);
    }

    private boolean isShowCoreGenomeView() {
        return this.coreGenomeFrame != null && this.coreGenomeFrame.isVisible();
    }

    @Override
    public void addNewSpGroup(String string, Map map) {
        this.spGroupTbl.getSpGroups().removeSp(map.keySet());
        this.spGroupTbl.getSpGroups().createNewSpGroup(string, map);
        this.spGroupTree.updateTree();
        this.treeOptionPanel.showSpGroupTree();
        this.modePanel.setSpGroupMode();
    }

    @Override
    public void showSpGroupNameEditDialog(SpGroup spGroup) {
        NameEditDialog nameEditDialog = new NameEditDialog(this.m_mainWindow);
        nameEditDialog.setEditName(spGroup.getName());
        nameEditDialog.setVisible(true);
        if (!nameEditDialog.isCanceled()) {
            spGroup.setName(nameEditDialog.getEditName());
            this.spGroupTree.updateTree();
        }
        nameEditDialog.dispose();
    }

    @Override
    public void removeSpGroups(Set set) {
        this.spGroupTbl.getSpGroups().removeSpGroup(set);
        this.spGroupTree.updateTree();
    }

    @Override
    public void removeSpFromSpGroup(Map map) {
        boolean bl = this.spGroupTbl.getSpGroups().removeSpFromSpGroup(map);
        if (bl) {
            this.spGroupTree.updateTree();
        }
    }

    @Override
    public void addSpToSpGroup(Map map, SpGroup spGroup) {
        boolean bl = this.spGroupTbl.getSpGroups().removeSp(map.keySet());
        if (bl |= spGroup.addSpMap(map)) {
            this.spGroupTree.updateTree();
            this.treeOptionPanel.showSpGroupTree();
            this.modePanel.setSpGroupMode();
        }
    }

    @Override
    public void initGlobalAlign(CoreGenomeViewModel coreGenomeViewModel) {
        GlobalAlignmentCommand globalAlignmentCommand = new GlobalAlignmentCommand(this, this.m_mainWindow, this.m_clusterTbl, coreGenomeViewModel);
        new ProgressDialog((Frame)this.globalAlignFrame, (MediatorImpl)this, 100, globalAlignmentCommand.getProgressMessages(), true, (ProcessImpl)globalAlignmentCommand);
    }

    @Override
    public void showGlobalAlignFrame(GlobalAlignViewModel globalAlignViewModel) {
        if (this.globalAlignFrame != null) {
            this.closeGlobalAlignFrame();
        }
        this.globalAlignFrame = new GlobalAlignFrame(this.m_mainWindow, this, this.m_clusterTbl, globalAlignViewModel);
        this.globalAlignFrame.setVisible(true);
    }

    @Override
    public void showGlobalAlignViewUpdateDialog(Frame frame, MediatorImpl mediatorImpl, GlobalAlignViewModel globalAlignViewModel) {
        GlobalAlignOptionDialog globalAlignOptionDialog = new GlobalAlignOptionDialog(frame, mediatorImpl, globalAlignViewModel);
        globalAlignOptionDialog.setVisible(true);
    }

    @Override
    public void printGlobalAlign(GlobalAlignViewModel globalAlignViewModel) {
        this.initPage();
        GlobalAlignPrintable globalAlignPrintable = new GlobalAlignPrintable(this.m_pageFormat, globalAlignViewModel);
        this.print(globalAlignPrintable);
    }

    @Override
    public void updateGlobalAlignMap(boolean bl) {
        if (!this.isShowGlobalAlignView()) {
            return;
        }
        this.globalAlignFrame.updateGlobalAlign(bl);
    }

    @Override
    public void zoomGlobalAlignView(double d) {
        if (!this.isShowGlobalAlignView()) {
            return;
        }
        this.globalAlignFrame.zoom(d);
    }

    @Override
    public void selectOrthologGroupOnGlobalAlign(String string) {
        if (!this.isShowGlobalAlignView()) {
            return;
        }
        this.globalAlignFrame.selectOrthologGroup(string);
    }

    @Override
    public void selectOrthologGroupOnGlobalAlign(Cluster cluster) {
        if (!this.isShowGlobalAlignView()) {
            return;
        }
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        arrayList.add(cluster);
        this.selectOrthologGroupOnGlobalAlign(arrayList);
    }

    @Override
    public void selectOrthologGroupOnGlobalAlign(List list) {
        if (!this.isShowGlobalAlignView()) {
            return;
        }
        this.globalAlignFrame.selectOrthologGroup(list);
    }

    @Override
    public void changeCentralPositionOnGlobalAlign(String string) {
        if (!this.isShowGlobalAlignView()) {
            return;
        }
        this.globalAlignFrame.changeCentralPosition(string);
    }

    @Override
    public void closeGlobalAlignFrame() {
        if (this.globalAlignFrame == null) {
            return;
        }
        this.globalAlignFrame.setVisible(false);
        this.globalAlignFrame.dispose();
        this.globalAlignFrame = null;
        System.gc();
        this.updateMemory();
    }

    private boolean isShowGlobalAlignView() {
        return this.globalAlignFrame != null && this.globalAlignFrame.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showNewProjectDialog() {
        Window window = null;
        try {
            window = new ProjectEditDialog((Frame)this.m_mainWindow, this);
            ((Dialog)window).setVisible(true);
            if (!((AbstractApplyDialog)window).isCanceled()) {
                Project project = ((ProjectEditDialog)window).getModifiedProject();
                ProjectAccesser.updateProjectInfo(project);
                this.changeSelectProject(project);
            }
        }
        catch (Exception exception) {
            String string = "Fail to save project information.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        finally {
            if (window != null) {
                window.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showEditProjectDialog() {
        Window window = null;
        try {
            Project project = ProjectAccesser.getSelectedProject();
            window = new ProjectEditDialog((Frame)this.m_mainWindow, this, project);
            ((Dialog)window).setVisible(true);
            if (!((AbstractApplyDialog)window).isCanceled()) {
                project = ((ProjectEditDialog)window).getModifiedProject();
                ProjectAccesser.updateProjectInfo(project);
            }
        }
        catch (Exception exception) {
            String string = "Fail to save project information.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        finally {
            if (window != null) {
                window.dispose();
            }
        }
    }

    @Override
    public void showProjectListDialog() {
        List list = ProjectAccesser.loadProject();
        ProjectListDialog projectListDialog = new ProjectListDialog((Frame)this.m_mainWindow, (MediatorImpl)this, list);
        projectListDialog.setVisible(true);
        if (!projectListDialog.isCanceled()) {
            List list2 = projectListDialog.getProjectList();
            boolean bl = ProjectAccesser.isSameSelectedProject(list);
            ProjectAccesser.updateProjectInfo(list2);
            if (!bl) {
                Project project = ProjectAccesser.getSelectedProject();
                this.afterChangeSelectProjectCore(project);
            }
        }
    }

    @Override
    public void changeSelectProject(Project project) {
        Project project2 = ProjectAccesser.getSelectedProject();
        if (project.equalsProject(project2)) {
            return;
        }
        try {
            ClusterTblCreater.saveCondition(this.m_clusterTbl);
        }
        catch (IOException iOException) {
            logger.warn("Fail to save the application property information.", iOException);
        }
        ProjectAccesser.updateSelectProject(project);
        this.afterChangeSelectProjectCore(project);
    }

    private void afterChangeSelectProjectCore(Project project) {
        try {
            AccessServer accessServer = AccessServer.getInstance();
            if (!accessServer.equalsServerUrl(project.getServerUrl())) {
                accessServer.setServerUrl(project.getServerUrl());
                this.registerServerUrl(project.getServerUrl());
                this.checkVersionUp();
            } else {
                try {
                    this.m_innerTbl.initInner();
                    this.m_outerTbl.initOuter();
                    this.spGroupTbl.init();
                    this.m_publicSpecTbl.clear();
                    this.m_baseCluster = null;
                }
                catch (IOException iOException) {
                    logger.warn("Fail to init Ingroup, Outgroup, SpGroup", iOException);
                }
            }
        }
        catch (Exception exception) {
            logger.warn("Fail to change project", exception);
        }
        this.updateTaxonomyTreeAfterInitMainWindow();
        this.setApplicationTitle();
    }

    @Override
    public void showOptionDialog() {
        OptionDialog optionDialog = new OptionDialog((Frame)this.m_mainWindow, this);
        optionDialog.setVisible(true);
        optionDialog.dispose();
    }

    @Override
    public void showOptionDialog(String string) {
        OptionDialog optionDialog = new OptionDialog((Frame)this.m_mainWindow, this);
        optionDialog.setSelectedTab(string);
        optionDialog.setVisible(true);
        optionDialog.dispose();
    }

    @Override
    public void updateRankSelectPanel() {
        this.rankSelectPanel.updateRankItem();
    }

    @Override
    public void showBackgroundProgressBar(boolean bl) {
        this.statusBar.setVisibledProgressLabel(bl);
    }

    @Override
    public void setApplicationTitle() {
        String string = "RECOG version 1.1.28";
        Project project = ProjectAccesser.getSelectedProject();
        string = project != null && !StringTool.isNull(project.getProjectName()) ? string + " - " + project.getProjectName() : string + " - (no select project)";
        if (this.m_clusterTbl != null && !StringTool.isNull(this.m_clusterTbl.getDisplayDomClustName())) {
            string = string + " / " + this.m_clusterTbl.getDisplayDomClustName();
        }
        this.m_mainWindow.setTitle(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showNeighboringClusterDialog() {
        Window window = null;
        try {
            window = new NeighborClustDialog((Frame)this.m_mainWindow, this.m_clusterTbl);
            ((Dialog)window).setVisible(true);
            if (((AbstractApplyDialog)window).isCanceled()) {
                return;
            }
            NeighboringClustCondition neighboringClustCondition = ((NeighborClustDialog)window).createNeighboringClustCondition();
            this.executeNeighboringCluster(neighboringClustCondition, false);
        }
        finally {
            if (window != null) {
                window.dispose();
            }
        }
    }

    @Override
    public void executeNeighboringCluster(NeighboringClustCondition neighboringClustCondition, boolean bl) {
        NeighborClustGeneSortExecuter neighborClustGeneSortExecuter = new NeighborClustGeneSortExecuter(this.m_mainWindow, this, this.m_clusterTbl, neighboringClustCondition);
        neighborClustGeneSortExecuter.setRecalc(bl);
        new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, this.m_clusterTbl.getViewOrganismCodeList().size(), "Neighboring clusters...", true, (ProcessImpl)neighborClustGeneSortExecuter);
    }

    @Override
    public void clearNeighboringCluster() {
        this.m_clusterTbl.clearNeighboringCluster();
        this.resetMainWindow();
        this.updateMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateForNeighboringCluster(NeighboringClustCondition neighboringClustCondition, Map map, boolean bl) {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            this.m_clusterTbl.setNeighboringClustCondition(neighboringClustCondition);
            this.m_clusterTbl.setNeighboringClusterMap(map);
            this.m_clusterTbl.setShowNeighboringCluster(true);
            if (!bl) {
                ColorFacade colorFacade = ColorFacade.getInstance();
                colorFacade.addNeighboringColorDrawable();
                this.updateColorTree();
            }
            this.resetMainWindow();
            this.updateMemory();
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisibleNeighboringCluster(boolean bl) {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            this.m_clusterTbl.setShowNeighboringCluster(bl);
            this.resetMainWindow();
            this.updateMemory();
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHilightNeighboringGene(boolean bl) {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            this.m_clusterTbl.setHilightNeighboringGene(bl);
            this.resetMainWindow();
            this.updateMemory();
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    @Override
    public void showPropertyDialog() {
        this.updatePropertyDialog();
        PropertyDialog propertyDialog = PropertyDialog.getInstance();
        propertyDialog.setVisible(true);
    }

    private void updatePropertyDialog() {
        PropertyMapCreater propertyMapCreater = new PropertyMapCreater(this.m_clusterTbl);
        PropertyDialog propertyDialog = PropertyDialog.getInstance();
        propertyDialog.updateValue(propertyMapCreater.createPropertyMap());
    }

    private void closePropertyDialog() {
        PropertyDialog propertyDialog = PropertyDialog.getInstance();
        propertyDialog.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showPropertyListDialog(int n) {
        Window window = null;
        try {
            window = new InfoListDialog((Frame)this.m_mainWindow, this);
            ((InfoListDialog)window).updateValue(n, this.m_clusterTbl);
            ((Dialog)window).setVisible(true);
        }
        finally {
            if (window != null) {
                window.dispose();
            }
        }
    }

    @Override
    public void showHistgramDialog() {
        if (this.m_clusterTbl == null) {
            return;
        }
        this.showHistgramDialog(this.m_clusterTbl.getHistogramCondition());
    }

    @Override
    public void showHistgramDialog(HistogramCondition histogramCondition) {
        if (this.m_clusterTbl == null) {
            return;
        }
        HistogramDialog histogramDialog = HistogramDialog.getInstance();
        histogramDialog.updateValue(histogramCondition, this.m_clusterTbl.getViewOrganismList(), this.m_clusterTbl);
        histogramDialog.setVisible(true);
        if (!histogramDialog.isCanceled()) {
            HistogramCondition histogramCondition2 = histogramDialog.createHistogramCondition();
            this.executeHistogramProcess(histogramCondition2);
        }
    }

    @Override
    public void showHistgramDialog(String string) {
        HistogramDialog histogramDialog = HistogramDialog.getInstance();
        histogramDialog.updateValue(string, this.m_clusterTbl.getViewOrganismList(), this.m_clusterTbl);
        histogramDialog.setVisible(true);
        if (!histogramDialog.isCanceled()) {
            HistogramCondition histogramCondition = histogramDialog.createHistogramCondition();
            this.executeHistogramProcess(histogramCondition);
        }
    }

    private void executeHistogramProcess(HistogramCondition histogramCondition) {
        this.m_clusterTbl.setHistogramCondition(histogramCondition);
        HistogramDataCreater histogramDataCreater = new HistogramDataCreater(this.m_mainWindow, this, this.m_clusterTbl, this.m_clusterTbl.getClusterList(), histogramCondition);
        histogramDataCreater.setStartRow(this.m_clusterMap.getStartRow());
        new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, 100, "Load histogram data...", false, (ProcessImpl)histogramDataCreater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateForHistogram(HistogramCondition histogramCondition, int n) {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            this.m_clusterTbl.setHistogramCondition(histogramCondition);
            this.m_categoryMap.createCategoryMap(n);
            this.m_infoTabbedPane.setSelectedIndex(1);
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateForHistogram() {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            this.m_categoryMap.createCategoryMap();
            this.m_infoTabbedPane.setSelectedIndex(1);
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    @Override
    public void registerPPMLabel(PPMLabelCondition pPMLabelCondition) {
        this.m_clusterTbl.setPPMLabelCondition(pPMLabelCondition);
        this.updatePPMLabel(pPMLabelCondition, false);
    }

    @Override
    public void updatePPMLabel() {
        this.m_clusterTbl.initPPMLabel();
        if (!this.m_optionTbl.getOptionValues().isIntensive()) {
            this.m_clusterMap.drawLabelArea();
            this.m_clusterMap.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePPMLabel(PPMLabelCondition pPMLabelCondition, boolean bl) {
        this.m_mainWindow.setCursor(this.m_waitCursor);
        try {
            this.m_clusterTbl.setSelectedPpmLabelCondition(pPMLabelCondition);
            if (!this.m_optionTbl.getOptionValues().isIntensive()) {
                this.m_clusterMap.drawLabelArea();
                this.m_clusterMap.repaint();
            }
            if (this.isShowCoreGenomeView() && bl) {
                this.coreGenomeFrame.changeOrthologGroupLabel(pPMLabelCondition.getPpmLabelType());
            }
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    @Override
    public void showSetListDialog(int n) {
        SetListDialog setListDialog = new SetListDialog((Frame)this.m_mainWindow, this);
        setListDialog.updateValue(n, this.m_clusterTbl);
        setListDialog.setVisible(true);
        if (setListDialog.isCanceled()) {
            return;
        }
    }

    @Override
    public void removeGeneSet(Collection collection) {
        try {
            if (CollectionUtil.isNull(collection)) {
                return;
            }
            Object[] objectArray = new String[]{"Delete the following gene sets?", AbstractElementSetFacade.getElementSetNameString(collection)};
            if (!MessageManager.showConfirmMessage((Component)this.m_mainWindow, objectArray)) {
                return;
            }
            Set set = new HashSet();
            if (this.m_clusterTbl != null) {
                set = AbstractElementSetFacade.removeElementSetFromSetCondition(this.m_clusterTbl.getSetConditionGroup(), collection);
                this.m_clusterTbl.saveSetCondition();
            }
            this.updateColorTree();
            this.updateFilterTree();
            if (CollectionUtil.isNull(set)) {
                this.resizeClusterMap();
            } else {
                this.resetMainWindow();
            }
            GeneSetFacade.getInstance().deleteElementSet(collection);
            this.updateGeneSetTree();
        }
        catch (Exception exception) {
            String string = "Fail to delete gene set.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void removeClusterSet(Collection collection) {
        try {
            if (CollectionUtil.isNull(collection)) {
                return;
            }
            Object[] objectArray = new String[]{"Delete the following cluster sets?", AbstractElementSetFacade.getElementSetNameString(collection)};
            if (!MessageManager.showConfirmMessage((Component)this.m_mainWindow, objectArray)) {
                return;
            }
            Set set = new HashSet();
            if (this.m_clusterTbl != null) {
                set = AbstractElementSetFacade.removeElementSetFromSetCondition(this.m_clusterTbl.getSetConditionGroup(), collection);
                this.m_clusterTbl.saveSetCondition();
            }
            this.updateColorTree();
            this.updateFilterTree();
            if (CollectionUtil.isNull(set)) {
                this.resizeClusterMap();
            } else {
                this.resetMainWindow();
            }
            ClusterSetFacade.getInstance().deleteElementSet(collection);
            this.updateClusterSetTree();
        }
        catch (Exception exception) {
            String string = "Fail to delete cluster set.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void activeColor(ColorActivation colorActivation) {
        try {
            colorActivation.flipColorActive();
            this.updateForActiveColor();
            if (colorActivation.isSyncEnable()) {
                this.updateForActiveFilter();
            }
        }
        catch (Exception exception) {
            String string = "Fail to enable/disable color.";
            logger.warn(string, exception);
        }
    }

    @Override
    public void activeColor(List list, boolean bl) {
        try {
            boolean bl2 = false;
            for (ColorActivation colorActivation : list) {
                colorActivation.setColorActive(bl);
                bl2 |= colorActivation.isSyncEnable();
            }
            this.updateForActiveColor();
            if (bl2) {
                this.updateForActiveFilter();
            }
        }
        catch (Exception exception) {
            String string = "Fail to enable/disable color.";
            logger.warn(string, exception);
        }
    }

    private void updateForActiveColor() throws Exception {
        this.controlTree.repaint();
        this.resizeClusterMap();
        this.repaintFromColorChange();
        ColorFacade.getInstance().saveColor();
    }

    @Override
    public void repaintControlTree() {
        this.controlTree.repaint();
    }

    public void updateFilterTree() {
        this.controlTree.updateFilterTree();
    }

    @Override
    public void updateOrganismColumnTree() {
        this.controlTree.updateOrganismColumnTree();
    }

    @Override
    public void updateSortTree() {
        this.controlTree.updateSortTree();
    }

    @Override
    public void updateColorTree() {
        this.controlTree.updateColorTree();
        this.repaintFromColorChange();
    }

    @Override
    public void updateGeneSetCombinationTree() {
        this.setTree.updateGeneSetCombinationTree();
    }

    @Override
    public void updateClusterSetCombinationTree() {
        this.setTree.updateClusterSetCombinationTree();
    }

    private void repaintFromColorChange() {
        this.genomeMapFrame.repaintFromColorTree();
        if (this.m_alignmentFrame != null && this.m_alignmentFrame.isVisible()) {
            this.drawFeatureMap2();
        }
        if (this.globalAlignFrame != null && this.globalAlignFrame.isVisible()) {
            this.updateGlobalAlignMap(true);
        }
    }

    @Override
    public void updateGeneSetTree() {
        this.setTree.updateGeneSetTree();
    }

    @Override
    public void updateClusterSetTree() {
        this.setTree.updateClusterSetTree();
    }

    @Override
    public void showCountFilterDialog() {
        try {
            int n = this.m_clusterTbl.getOrganismCount();
            int n2 = this.m_clusterTbl.getMaxGeneCount();
            GeneCountFilterCondition geneCountFilterCondition = new GeneCountFilterCondition();
            OrganismCountFilterCondition organismCountFilterCondition = new OrganismCountFilterCondition();
            ArrayList<CountFilterCondition> arrayList = new ArrayList<CountFilterCondition>();
            arrayList.add(geneCountFilterCondition);
            arrayList.add(organismCountFilterCondition);
            ApplicationPropertyFacade.updateDomClustAccessable(this.m_clusterTbl.getClusterId(), arrayList);
            CountFilterDialog countFilterDialog = CountFilterDialog.getInstance();
            countFilterDialog.updateValue(n2, n, geneCountFilterCondition, organismCountFilterCondition);
            countFilterDialog.setVisible(true);
            if (!countFilterDialog.isCanceled()) {
                CountFilterCondition countFilterCondition = countFilterDialog.createOrganismCondition();
                CountFilterCondition countFilterCondition2 = countFilterDialog.createGeneCondition();
                FilterFacade filterFacade = FilterFacade.getInstance();
                filterFacade.setOrganismCountFilterCondition(countFilterCondition);
                filterFacade.setGeneCountFilterCondition(countFilterCondition2);
                this.updateForFilter(true);
                filterFacade.saveOrganismGeneFilterCondition();
            }
        }
        catch (Exception exception) {
            String string = "Fail to filter by gene/organism count.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void activeFilter(FilterActivation filterActivation) {
        ArrayList<FilterActivation> arrayList = new ArrayList<FilterActivation>();
        arrayList.add(filterActivation);
        this.activeFilter(arrayList, !filterActivation.isFilterActive());
    }

    @Override
    public void activeFilter(List list, boolean bl) {
        try {
            boolean bl2 = false;
            for (FilterActivation filterActivation : list) {
                filterActivation.setFilterActive(bl);
                bl2 |= filterActivation.isSyncEnable();
            }
            this.updateForActiveFilter();
            if (bl2) {
                this.updateForActiveColor();
            }
        }
        catch (Exception exception) {
            String string = "Fail to enable/disable filter.";
            logger.warn(string, exception);
        }
    }

    private void updateForActiveFilter() {
        FilterFacade.getInstance().saveFilterCondition();
        this.controlTree.repaint();
        this.updateForFilter(true);
    }

    @Override
    public void activeOrganismColumn(OrganismColumnActivation organismColumnActivation) {
        ArrayList<OrganismColumnActivation> arrayList = new ArrayList<OrganismColumnActivation>();
        arrayList.add(organismColumnActivation);
        this.activeOrganismColumn(arrayList, !organismColumnActivation.isOrganismColumnActive());
    }

    @Override
    public void activeOrganismColumn(List list, boolean bl) {
        for (OrganismColumnActivation organismColumnActivation : list) {
            organismColumnActivation.setOrganismColumnActive(bl);
        }
        this.m_clusterTbl.updateViewOrganismList();
        this.updateForOrganismColumn();
    }

    @Override
    public void chnageOrderOrganismColumn(List list) {
        this.m_clusterTbl.changeOrderOrganismList(list);
        this.updateForOrganismColumn();
    }

    @Override
    public void addOrganismColumn(Set set) {
        this.m_clusterTbl.addOrganismColumn(set);
        this.m_clusterTbl.updateViewOrganismList();
        this.updateForOrganismColumn();
    }

    @Override
    public void removeOrganismColumn(Set set) {
        this.m_clusterTbl.removeOrganismColumn(set);
        this.m_clusterTbl.updateViewOrganismList();
        this.updateForOrganismColumn();
    }

    @Override
    public void showOrganismColumnDialog() {
        OrganismColumnDialog organismColumnDialog = OrganismColumnDialog.getInstance();
        organismColumnDialog.updateValue(this.m_clusterTbl.getOrganismList(), this.m_clusterTbl.getViewOrganismList());
        organismColumnDialog.setVisible(true);
        if (!organismColumnDialog.isCanceled()) {
            this.m_clusterTbl.removeOrganismColumn(organismColumnDialog.getRemoveOrganismCodeList());
            this.m_clusterTbl.addOrganismColumn(organismColumnDialog.getSelectedOrganismCodeList());
            ArrayList arrayList = new ArrayList(organismColumnDialog.getSelectedOrganismCodeList());
            arrayList.addAll(organismColumnDialog.getRemoveOrganismCodeList());
            this.m_clusterTbl.changeOrderOrganismList(arrayList);
            this.updateForOrganismColumn();
        }
    }

    @Override
    public void restoreOrganismColumn() {
        try {
            AbstractDomClustImporter abstractDomClustImporter = AbstractDomClustImporter.createDomClustImporter(this.m_clusterTbl.getFilepath());
            abstractDomClustImporter.setParameterOnly(true);
            abstractDomClustImporter.execute();
            List list = abstractDomClustImporter.getOrganismCodeList();
            List list2 = ModifiedOrganismManager.getInstance().convertModifiedOrganismCodeList(list);
            this.chnageOrderOrganismColumn(list2);
        }
        catch (IOException iOException) {
            String string = "Fail to resotr default organism order.";
            logger.warn(string, iOException);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void setSyncOrganismSelect(boolean bl) {
        this.m_clusterTbl.setSyncOrganismSelect(bl);
        this.m_clusterTbl.saveOrganismColumn();
    }

    @Override
    public void updateForOrganismColumn() {
        this.m_clusterTbl.saveOrganismColumn();
        this.updateForHistogram();
        this.resizeClusterMap();
        this.updateOrganismColumnTree();
        this.updateMemory();
    }

    @Override
    public void showSeqDownloadDialog(Collection collection) {
        this.showSeqDownloadDialog(collection, null);
    }

    @Override
    public void showSeqDownloadDialog(Collection collection, Collection collection2) {
        if (this.m_clusterTbl == null) {
            return;
        }
        SeqDownloadDialog seqDownloadDialog = SeqDownloadDialog.getInstance();
        seqDownloadDialog.updateValue(CollectionUtil.isNull(collection2));
        seqDownloadDialog.setVisible(true);
        if (seqDownloadDialog.isCanceled()) {
            return;
        }
        JFileChooser jFileChooser = SeqDownloadDialog.getChooser();
        jFileChooser.setCurrentDirectory(new File(OptionTbl.getInstance().getOptionValues().getUserExportDir()));
        if (jFileChooser.showSaveDialog(this.m_mainWindow) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        String string = ((AbstractFileFilter)jFileChooser.getFileFilter()).modifiedExtension(file);
        file = new File(string);
        if (file.isFile() && !MessageManager.showConfirmOverwriteMessage(this.m_mainWindow, file.getName())) {
            return;
        }
        SeqDownloadCondition seqDownloadCondition = seqDownloadDialog.createCondition();
        seqDownloadCondition.setOutputFilepath(string);
        seqDownloadCondition.setDomClustId(this.m_clusterTbl.getClusterId());
        if (seqDownloadCondition.isTargetPPM()) {
            seqDownloadCondition.setClusterC(this.m_clusterTbl.getViewClusterList());
        } else {
            seqDownloadCondition.setClusterC(collection);
        }
        seqDownloadCondition.setGeneInfoC(collection2);
        SeqDownloadExecuter seqDownloadExecuter = new SeqDownloadExecuter(seqDownloadCondition);
        new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, 2, "Download Sequence File...", false, (ProcessImpl)seqDownloadExecuter);
        OptionTbl.getInstance().getOptionValues().setUserExportDir(file.getParent());
    }

    @Override
    public void setShowHomClustLabel(boolean bl) {
        this.m_clusterMap.setShowHomClustLabel(bl);
        this.resizeClusterMap();
    }

    @Override
    public boolean isShowHomClustLabel() {
        return this.m_clusterMap.isShowHomClustLabel();
    }

    @Override
    public void showSetFilterColorDialog(int n, List list) {
        if (this.m_clusterTbl == null) {
            return;
        }
        SetCombinationDialog setCombinationDialog = SetCombinationDialog.getInstance(this.m_mainWindow, this);
        setCombinationDialog.updateValue(list, this.m_clusterTbl.getSetConditionGroup(), this.m_clusterTbl);
        setCombinationDialog.setVisible(true);
        if (!setCombinationDialog.isCanceled()) {
            SetCondition setCondition = setCombinationDialog.createSetCondition();
            boolean bl = setCombinationDialog.isAddFilter();
            boolean bl2 = setCombinationDialog.isAddColor();
            this.updateNewSetCondition(setCondition, bl, bl2);
        }
    }

    @Override
    public void showSetFilterColorDialog(SetCondition setCondition) {
        SetCombinationDialog setCombinationDialog = SetCombinationDialog.getInstance(this.m_mainWindow, this);
        setCombinationDialog.updateValue(setCondition, this.m_clusterTbl.getSetConditionGroup(), this.m_clusterTbl);
        setCombinationDialog.setVisible(true);
        if (!setCombinationDialog.isCanceled()) {
            SetCondition setCondition2 = setCombinationDialog.createSetCondition();
            boolean bl = setCombinationDialog.isAddFilter();
            boolean bl2 = setCombinationDialog.isAddColor();
            this.updateEditSetCondition(setCondition, setCondition2, bl, bl2);
        }
    }

    @Override
    public void showSetFilterColorDialog(AbstractElementSet abstractElementSet, int n) {
        SetFilterColorDialog setFilterColorDialog = SetFilterColorDialog.getInstance();
        setFilterColorDialog.updateValue(abstractElementSet, this.m_clusterTbl.getSetConditionGroup(), n);
        setFilterColorDialog.setVisible(true);
        if (!setFilterColorDialog.isCanceled()) {
            SetCondition setCondition = setFilterColorDialog.createSetCondition();
            boolean bl = setFilterColorDialog.isAddFilter();
            boolean bl2 = setFilterColorDialog.isAddColor();
            this.updateNewSetCondition(setCondition, bl, bl2);
        }
    }

    @Override
    public void updateNewSetCondition(SetCondition setCondition, boolean bl, boolean bl2) {
        AbstractElementSetFacade.addSetCondition(this.m_clusterTbl.getSetConditionGroup(), setCondition, bl, bl2);
        this.m_clusterTbl.saveSetCondition();
        this.updateForFilter(true);
        this.updateColorTree();
        this.updateFilterTree();
        this.updateGeneSetCombinationTree();
        this.updateClusterSetCombinationTree();
    }

    @Override
    public void updateEditSetCondition(SetCondition setCondition, SetCondition setCondition2, boolean bl, boolean bl2) {
        AbstractElementSetFacade.editSetCondition(this.m_clusterTbl.getSetConditionGroup(), setCondition, setCondition2, bl, bl2);
        this.m_clusterTbl.saveSetCondition();
        this.updateForFilter(true);
        this.updateColorTree();
        this.updateFilterTree();
        this.updateGeneSetCombinationTree();
        this.updateClusterSetCombinationTree();
    }

    @Override
    public void addColorSetCondition(Collection collection) {
        ColorFacade.getInstance().addSetColorDrawable(collection);
        this.m_clusterTbl.saveSetCondition();
        this.resizeClusterMap();
        this.updateColorTree();
    }

    @Override
    public void removeColorSetCondition(SetCondition setCondition) {
        String string = "Delete [" + setCondition.getDisplayName() + "]?";
        if (!MessageManager.showConfirmMessage((Component)this.m_mainWindow, string)) {
            return;
        }
        ColorFacade.getInstance().removeSetColorDrawable(setCondition);
        if (!setCondition.isCombination() && !FilterFacade.getInstance().containsSetCondition(setCondition)) {
            this.m_clusterTbl.getSetConditionGroup().removeSetCondition(setCondition);
            this.updateGeneSetCombinationTree();
            this.updateClusterSetCombinationTree();
        }
        this.m_clusterTbl.saveSetCondition();
        this.resizeClusterMap();
        this.updateColorTree();
    }

    @Override
    public void addFilterSetCondition(Collection collection) {
        FilterFacade.getInstance().addSetCondition(collection);
        this.m_clusterTbl.saveSetCondition();
        this.updateForFilter(true);
        this.updateFilterTree();
    }

    @Override
    public void removeFilterSetCondition(SetCondition setCondition) {
        String string = "Delete [" + setCondition.getDisplayName() + "]?";
        if (!MessageManager.showConfirmMessage((Component)this.m_mainWindow, string)) {
            return;
        }
        FilterFacade.getInstance().removeSetCondition(setCondition);
        if (!setCondition.isCombination() && !ColorFacade.getInstance().containsSetCondition(setCondition)) {
            this.m_clusterTbl.getSetConditionGroup().removeSetCondition(setCondition);
            this.updateGeneSetCombinationTree();
            this.updateClusterSetCombinationTree();
        }
        this.m_clusterTbl.saveSetCondition();
        this.updateForFilter(true);
        this.updateFilterTree();
    }

    @Override
    public void removeSetCondition(Collection collection) {
        Object[] objectArray = new String[]{"Delete set combinations?", SetConditionUtil.createSetNameString(collection)};
        if (!MessageManager.showConfirmMessage((Component)this.m_mainWindow, objectArray)) {
            return;
        }
        AbstractElementSetFacade.removeSetCondition(this.m_clusterTbl.getSetConditionGroup(), collection);
        this.m_clusterTbl.saveSetCondition();
        this.updateForFilter(true);
        this.updateColorTree();
        this.updateFilterTree();
        this.updateGeneSetCombinationTree();
        this.updateClusterSetCombinationTree();
    }

    @Override
    public void removeElementGroupFromSetCondition(SetCondition setCondition, List list) {
        if (!MessageManager.showConfirmMessage((Component)this.m_mainWindow, "Delete condition?")) {
            return;
        }
        AbstractElementSetFacade.removeElementSetGroup(this.m_clusterTbl.getSetConditionGroup(), setCondition, list);
        this.m_clusterTbl.saveSetCondition();
        this.updateForFilter(true);
        this.updateColorTree();
        this.updateFilterTree();
        this.updateGeneSetCombinationTree();
        this.updateClusterSetCombinationTree();
    }

    @Override
    public void updateSelectedAllCluster() {
        this.updateSelectedCluster(null, null, this.m_clusterTbl.getViewClusterList(), false);
    }

    @Override
    public void showPatternRegisterDialog(Pattern pattern) {
        PatternEditDialog patternEditDialog = PatternEditDialog.getInstance();
        patternEditDialog.updateValue(pattern, this.m_clusterTbl.getOrganismList(), this.m_clusterTbl.getClusterId());
        patternEditDialog.setVisible(true);
        if (!patternEditDialog.isCanceled()) {
            Pattern pattern2 = patternEditDialog.getPattern();
            this.m_clusterTbl.addPatern(pattern2);
            this.m_clusterTbl.savePattern();
            this.updatePatternTree();
        }
    }

    @Override
    public void removePattern(Set set) {
        Object[] objectArray = new String[]{"Delete the patterns?", PatternUtil.getPatternNames(set)};
        if (!MessageManager.showConfirmMessage((Component)this.m_mainWindow, objectArray)) {
            return;
        }
        this.m_clusterTbl.removePattern(set);
        this.m_clusterTbl.savePattern();
        this.updatePatternTree();
    }

    @Override
    public void updatePatternTree() {
        this.controlTree.updatePatternTree();
    }

    @Override
    public void showCoefCalcDialog(Pattern pattern) {
        CoefDialog coefDialog = CoefDialog.getInstance();
        coefDialog.updateValue(pattern.getName(), new HashSet(this.m_clusterTbl.getOrganismCodeList()));
        coefDialog.setVisible(true);
        if (coefDialog.isCanceled()) {
            return;
        }
        CoefCondition coefCondition = coefDialog.createCoefCondition();
        coefCondition.addInfo(this.m_clusterTbl, pattern, null);
        CoefCalcExecuter coefCalcExecuter = new CoefCalcExecuter(this.m_mainWindow, this, this.m_clusterTbl.getClusterList(), coefCondition);
        new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, coefCalcExecuter.getPrograssTotal(), "Calculate " + coefCondition.getDistName() + "...", false, (ProcessImpl)coefCalcExecuter);
    }

    @Override
    public void showPatternEditDialog(Pattern pattern) {
        PatternEditDialog patternEditDialog = PatternEditDialog.getInstance();
        patternEditDialog.updateValue(pattern, this.m_clusterTbl.getOrganismList(), this.m_clusterTbl.getClusterId());
        patternEditDialog.setVisible(true);
        if (!patternEditDialog.isCanceled()) {
            Pattern pattern2 = patternEditDialog.getPattern();
            this.m_clusterTbl.replacePattern(pattern, pattern2);
            this.m_clusterTbl.savePattern();
            this.updatePatternTree();
        }
    }

    @Override
    public void showOrganismSetDialog(Set set) {
        OrganismSetDialog organismSetDialog = new OrganismSetDialog(this.m_mainWindow);
        organismSetDialog.updateValue(this.m_clusterTbl.getClusterId());
        organismSetDialog.setVisible(true);
        if (!organismSetDialog.isCanceled()) {
            List list = this.m_clusterTbl.getOrganismList(set);
            String string = organismSetDialog.getOrganismSetName();
            if (organismSetDialog.isNew()) {
                OrganismSet organismSet = OrganismSetGroup.createOrgansmSet(string, list);
                OrganismSetGroup organismSetGroup = OrganismSetGroup.getInstance();
                organismSetGroup.addOrganismSet(organismSet);
            } else if (organismSetDialog.isOverwrite()) {
                OrganismSet organismSet = OrganismSetGroup.getInstance().getOrganismSet(string);
                organismSet.setOrganismList(list);
            } else if (organismSetDialog.isAdd()) {
                OrganismSet organismSet = OrganismSetGroup.getInstance().getOrganismSet(string);
                organismSet.addAllOrganism(list);
            }
            OrganismSetGroup.getInstance().save(this.m_clusterTbl.getClusterId());
            this.updateOrganismSetTree();
        }
    }

    @Override
    public void showOrganismSetDialog(OrganismSet organismSet) {
        OrganismSetDialog organismSetDialog = new OrganismSetDialog(this.m_mainWindow);
        organismSetDialog.updateValue(organismSet, this.m_clusterTbl.getClusterId());
        organismSetDialog.setVisible(true);
        if (!organismSetDialog.isCanceled()) {
            String string = organismSetDialog.getOrganismSetName();
            organismSet.setName(string);
            organismSet.setOrganismList(organismSetDialog.getOrganismList());
            OrganismSetGroup.getInstance().save(this.m_clusterTbl.getClusterId());
            this.updateOrganismSetTree();
        }
    }

    @Override
    public void removeOrganismFromOrganismSet(OrganismSet organismSet, Collection collection) {
        OrganismSetGroup organismSetGroup = OrganismSetGroup.getInstance();
        organismSetGroup.removeOrganismFromOrganismSet(organismSet, collection);
        OrganismSetGroup.getInstance().save(this.m_clusterTbl.getClusterId());
        this.updateOrganismSetTree();
    }

    @Override
    public void removeOrganismSet(Collection collection) {
        Object[] objectArray = new String[]{"Delete organism set?", OrganismUtil.getOrganismSetNameString(collection)};
        if (!MessageManager.showConfirmMessage((Component)this.m_mainWindow, objectArray)) {
            return;
        }
        OrganismSetGroup organismSetGroup = OrganismSetGroup.getInstance();
        organismSetGroup.removeOrganism(collection);
        OrganismSetGroup.getInstance().save(this.m_clusterTbl.getClusterId());
        this.updateOrganismSetTree();
    }

    @Override
    public void addOrganismToOrganismSet(OrganismSet organismSet, Collection collection) {
        List list = this.m_clusterTbl.getOrganismList(collection);
        organismSet.addAllOrganism(list);
        OrganismSetGroup.getInstance().save(this.m_clusterTbl.getClusterId());
        this.updateOrganismSetTree();
    }

    @Override
    public void updateOrganismSetTree() {
        this.setTree.updateOrganismSetTree();
    }

    @Override
    public void showMappingEditDialog(String string) {
        MapFacade.createDataDirectory();
        MapEditDialog mapEditDialog = MapEditDialog.getInstance();
        mapEditDialog.updateValue(string, false);
        mapEditDialog.setVisible(true);
        if (!mapEditDialog.isCanceled()) {
            MapCondition mapCondition = mapEditDialog.createMapCondition();
            MapExecuter mapExecuter = new MapExecuter(mapCondition);
            new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, 2, "Create the mapping information file...", false, (ProcessImpl)mapExecuter);
        }
    }

    @Override
    public void editMappingEditDialog(String string) {
        MapFacade.createDataDirectory();
        MapEditDialog mapEditDialog = MapEditDialog.getInstance();
        mapEditDialog.updateValue(string, true);
        mapEditDialog.setVisible(true);
        if (!mapEditDialog.isCanceled()) {
            MapCondition mapCondition = mapEditDialog.createMapCondition();
            MapExecuter mapExecuter = new MapExecuter(mapCondition);
            new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, 2, "Create the mapping information file...", false, (ProcessImpl)mapExecuter);
        }
    }

    @Override
    public void selectMaping(MapConf mapConf) {
        try {
            MapFacade.selectMapping(mapConf);
        }
        catch (Exception exception) {
            String string = "Fail to save the selected state of the mapping information.";
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
            logger.warn(string, exception);
        }
    }

    private void addTaxMapFrame(TaxMapFrame taxMapFrame) {
        this.taxMapFrameSet.add(taxMapFrame);
    }

    @Override
    public void removeTaxMapFrame(TaxMapFrame taxMapFrame) {
        this.taxMapFrameSet.remove(taxMapFrame);
    }

    private void closeTaxMapFrame() {
        HashSet hashSet = new HashSet(this.taxMapFrameSet);
        for (TaxMapFrame taxMapFrame : hashSet) {
            taxMapFrame.exit();
        }
    }

    @Override
    public void showTaxMapDialog(Set set) {
        try {
            TaxMapFrame taxMapFrame = TaxMapFrame.getInstance(this.m_mainWindow, this);
            this.addTaxMapFrame(taxMapFrame);
            taxMapFrame.updateValue(set, this.m_clusterTbl.getViewOrganismCodeList(), this.m_clusterTbl);
            taxMapFrame.setVisible(true);
        }
        catch (Exception exception) {
            String string = "Fail to show the taxonomy mapping dialog.";
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
            logger.warn(string, exception);
        }
    }

    @Override
    public void setTaxMapFilter(List list) {
        Project project = ProjectAccesser.getSelectedProject();
        GeneSet geneSet = new GeneSet("Taxonomy Mapping Filter", project.getProjectName(), list.size());
        geneSet.setElementList(list);
        ElementSetGroup elementSetGroup = new ElementSetGroup();
        elementSetGroup.addElementSet(geneSet, false);
        GeneSetCondition geneSetCondition = new GeneSetCondition();
        geneSetCondition.setName("Taxonomy Mapping Filter");
        geneSetCondition.addElementSetGroup(elementSetGroup);
        FilterFacade.getInstance().setTaxMapSetCondition(geneSetCondition);
        this.updateForFilter(true);
        this.updateFilterTree();
    }

    @Override
    public void removeTaxMapFilter(SetCondition setCondition) {
        FilterFacade.getInstance().removeTaxMapSetCondition(setCondition);
        this.updateForFilter(true);
        this.updateFilterTree();
    }

    @Override
    public void showTaxMapExecuteDialog(Set set) {
        List list = this.m_clusterTbl.getOrganismList(new ArrayList(set));
        TaxMapExecuteDialog taxMapExecuteDialog = TaxMapExecuteDialog.getInstance();
        taxMapExecuteDialog.updateValue(this.m_clusterTbl.getOrganismList(), list);
        taxMapExecuteDialog.setVisible(true);
        if (!taxMapExecuteDialog.isCanceled()) {
            TaxMapExecuter taxMapExecuter = new TaxMapExecuter(this.m_mainWindow, this, this.m_clusterTbl.getClusterId(), taxMapExecuteDialog.getSelectedOrganismCodeSet());
            String[] stringArray = new String[]{"Ortholog Clustering (DomClust): Reading...", "Ortholog Clustering (DomClust): Sorting...", "Ortholog Clustering (DomClust): Indexing...", "Ortholog Clustering (DomClust): Clustering...", "Ortholog Clustering (DomClust): Create Result Table..."};
            new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, 100, stringArray, true, (ProcessImpl)taxMapExecuter);
        }
    }

    @Override
    public void executeTaxMapScoreCalculation(Set set) {
        int n = this.m_clusterTbl.isOutgroup() ? 1 : 2;
        TaxMapGenomeScoreCalculater taxMapGenomeScoreCalculater = new TaxMapGenomeScoreCalculater(this.m_mainWindow, this, this.m_clusterTbl, this.m_clusterTbl.getClusterId(), set, new HashSet(this.m_clusterTbl.getOrganismCodeList()), CellInfoFacade.getCellInfoTitle("tax_map_score", n), this.m_clusterTbl.getClusterList());
        String[] stringArray = new String[]{"Calculate score..."};
        new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, 100, stringArray, false, (ProcessImpl)taxMapGenomeScoreCalculater);
    }

    @Override
    public void showTaxMapGenePropertyDialog(Component component, List list, TaxMapModel taxMapModel) {
        Cloneable cloneable;
        Project project = ProjectAccesser.getSelectedProject();
        TaxMapPropertyDialog taxMapPropertyDialog = TaxMapPropertyDialog.getInstance(component);
        String string = "";
        if (!CollectionUtil.isNull(list) && list.size() == 1) {
            cloneable = (TaxonomyTreeNode)list.get(0);
            string = ((TaxonomyTreeNode)cloneable).getName();
        }
        cloneable = TaxMapGenePropertyCreater2.createTaxMapGeneInfoTitle(string);
        taxMapPropertyDialog.updateValue((GeneInfoTitle)cloneable, project.getProjectName(), taxMapModel.isLower());
        taxMapPropertyDialog.setVisible(true);
        if (taxMapPropertyDialog.isCanceled()) {
            return;
        }
        TaxMapPropertyCondition taxMapPropertyCondition = taxMapPropertyDialog.createCondition();
        TaxMapGenePropertyCreater taxMapGenePropertyCreater = new TaxMapGenePropertyCreater(this.m_mainWindow, taxMapPropertyCondition, taxMapModel);
        String[] stringArray = new String[]{"Register gene property..."};
        ProgressDialog.executeProgress(component, (MediatorImpl)this, 1, stringArray, true, (ProcessImpl)taxMapGenePropertyCreater);
    }

    @Override
    public ClusterSetCondition setFuncCatFilter(List list) {
        ClusterSet clusterSet = new ClusterSet();
        clusterSet.setElementList(list);
        ElementSetGroup elementSetGroup = new ElementSetGroup();
        elementSetGroup.addElementSet(clusterSet, false);
        ClusterSetCondition clusterSetCondition = new ClusterSetCondition();
        clusterSetCondition.setName("Function Category Filter");
        clusterSetCondition.addElementSetGroup(elementSetGroup);
        FilterFacade.getInstance().setFuncCatSetCondition(clusterSetCondition);
        this.updateForFilter(true);
        this.updateFilterTree();
        return clusterSetCondition;
    }

    @Override
    public void removeFuncCatFilter(SetCondition setCondition) {
        FilterFacade.getInstance().removeFuncCatSetCondition(setCondition);
        this.updateForFilter(true);
        this.updateFilterTree();
    }

    @Override
    public void clearDataCache() {
        if (!MessageManager.showConfirmMessage((Component)this.m_mainWindow, "Clear gene data? [" + AccessServer.getServerName() + "]")) {
            return;
        }
        DataClearExecuter dataClearExecuter = new DataClearExecuter(this);
        new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, 1, "Clear data file...", false, (ProcessImpl)dataClearExecuter);
    }

    @Override
    public void clearPhyloPatternData() {
        Project project = ProjectAccesser.getSelectedProject();
        if (!MessageManager.showConfirmMessage((Component)this.m_mainWindow, "Is it OK to clear phylogenetic pattern analysis results data files in this project " + project.getProjectName())) {
            return;
        }
        int n = HClustUtil.deleteFilesByClusterId(project, null);
        String string = n + " file(s) was deleted.";
        MessageManager.showMessage((Component)this.m_mainWindow, string);
    }

    @Override
    public void updateInfoTitle(Collection collection) {
        boolean bl = false;
        if (this.m_clusterTbl == null) {
            return;
        }
        for (AbstractInfoTitle abstractInfoTitle : collection) {
            bl |= this.m_clusterTbl.updateInfoTitle(abstractInfoTitle);
        }
        if (bl) {
            this.closeDialog();
            this.resetMainWindow();
            this.updateFilterTree();
            this.updateColorTree();
        }
    }

    @Override
    public void showPatternCoefDialog(int n, Cluster cluster) {
        PatternCoefDialog patternCoefDialog = PatternCoefDialog.getInstance();
        patternCoefDialog.updateValue(new HashSet(this.m_clusterTbl.getViewOrganismCodeList()));
        patternCoefDialog.setVisible(true);
        if (!patternCoefDialog.isCanceled()) {
            CoefCondition coefCondition = patternCoefDialog.createCoefCondition();
            this.executePatternCoefClustering(n, cluster, coefCondition);
        }
    }

    @Override
    public void executePatternCoefClustering(int n, Cluster cluster, CoefCondition coefCondition) {
        Pattern pattern = PatternFactory.createBasePattern((Collection)this.m_clusterTbl.getViewOrganismCodeList(), cluster);
        coefCondition.addInfo(this.m_clusterTbl, pattern, cluster);
        BasicSortCondition basicSortCondition = SortConditionFactory.createPatternCoefClusteringCondition(n, cluster, this.m_clusterTbl.getViewOrganismCodeList(), coefCondition, this.m_clusterTbl.isOutgroup());
        PatternCoefClusteringExecuter patternCoefClusteringExecuter = new PatternCoefClusteringExecuter(this.m_mainWindow, this, coefCondition, basicSortCondition, this.m_clusterTbl.getClusterList());
        String[] stringArray = new String[]{"Caluculating distance...", "Sorting..."};
        new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, 1, stringArray, false, (ProcessImpl)patternCoefClusteringExecuter);
    }

    @Override
    public void showClusterSetConvertDialog(Collection collection) {
        Project project = ProjectAccesser.getSelectedProject();
        ClusterSetImportDialog clusterSetImportDialog = ClusterSetImportDialog.getInstanse(this.m_mainWindow);
        clusterSetImportDialog.updateValue(project.getProjectName(), this.m_clusterTbl, false, true);
        clusterSetImportDialog.setVisible(true);
        if (!clusterSetImportDialog.isCanceled()) {
            ClusterSetConverter clusterSetConverter = new ClusterSetConverter(this.m_mainWindow, this, this.m_clusterTbl, collection, this.m_clusterTbl.getViewClusterList(), clusterSetImportDialog.createClusterSet(), clusterSetImportDialog.getMatchOption());
            String[] stringArray = new String[]{"Convert cluster set...", "Register cluster set..."};
            new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, 1, stringArray, true, (ProcessImpl)clusterSetConverter);
        }
    }

    @Override
    public void showClusterInfoConvertDialog() {
        int n = 3;
        if (this.m_clusterTbl.isOutgroup()) {
            n = 4;
        }
        ClusterInfoConvertDialog clusterInfoConvertDialog = ClusterInfoConvertDialog.getInstance();
        clusterInfoConvertDialog.updateValue(this.m_clusterTbl.getViewOrganismCodeList(), this.m_clusterTbl.getClusterId(), n);
        clusterInfoConvertDialog.setVisible(true);
        if (!clusterInfoConvertDialog.isCanceled()) {
            ClusterInfoConvertCondition clusterInfoConvertCondition = clusterInfoConvertDialog.createCondition();
            ClusterInfoConverter clusterInfoConverter = new ClusterInfoConverter(this.m_mainWindow, this, clusterInfoConvertCondition, this.m_clusterTbl.getClusterList());
            String[] stringArray = new String[]{"Calculate the cluster property..."};
            new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, 1, stringArray, true, (ProcessImpl)clusterInfoConverter);
        }
    }

    @Override
    public void showCoreGenePropertyDialog(Component component, List list, GenomeAlign genomeAlign) {
        Project project = ProjectAccesser.getSelectedProject();
        CoreGenePropertyDialog coreGenePropertyDialog = CoreGenePropertyDialog.getInstance(component);
        GeneInfoTitle geneInfoTitle = CoreGenePropertyCreater.createCoreGeneGeneInfoTitle("");
        coreGenePropertyDialog.updateValue(geneInfoTitle, project.getProjectName());
        coreGenePropertyDialog.setVisible(true);
        if (coreGenePropertyDialog.isCanceled()) {
            return;
        }
        GeneInfoTitle geneInfoTitle2 = coreGenePropertyDialog.getGeneInfoTitle();
        CoreGeneTargetCondition coreGeneTargetCondition = coreGenePropertyDialog.createCondition();
        CoreGenePropertyCreater coreGenePropertyCreater = new CoreGenePropertyCreater((Component)this.m_mainWindow, (MediatorImpl)this, this.m_clusterTbl, geneInfoTitle2, coreGeneTargetCondition, list, genomeAlign);
        String[] stringArray = new String[]{"Prepare...", "Create gene property...", "Save..."};
        ProgressDialog.executeProgress(component, (MediatorImpl)this, 1, stringArray, true, (ProcessImpl)coreGenePropertyCreater);
    }

    @Override
    public void showCoreGenePropertyDialog(Component component, List list, List list2) {
        Project project = ProjectAccesser.getSelectedProject();
        CoreGenePropertyDialog coreGenePropertyDialog = CoreGenePropertyDialog.getInstance(component);
        GeneInfoTitle geneInfoTitle = CoreGenePropertyCreater.createCoreGeneGeneInfoTitle("");
        coreGenePropertyDialog.updateValue(geneInfoTitle, project.getProjectName());
        coreGenePropertyDialog.setVisible(true);
        if (coreGenePropertyDialog.isCanceled()) {
            return;
        }
        GeneInfoTitle geneInfoTitle2 = coreGenePropertyDialog.getGeneInfoTitle();
        CoreGeneTargetCondition coreGeneTargetCondition = coreGenePropertyDialog.createCondition();
        CoreGenePropertyCreater coreGenePropertyCreater = new CoreGenePropertyCreater((Component)this.m_mainWindow, (MediatorImpl)this, this.m_clusterTbl, geneInfoTitle2, coreGeneTargetCondition, list, list2);
        String[] stringArray = new String[]{"Prepare...", "Create gene property...", "Save..."};
        ProgressDialog.executeProgress(component, (MediatorImpl)this, 1, stringArray, true, (ProcessImpl)coreGenePropertyCreater);
    }

    @Override
    public void showCoreGeneSetDialog(Component component, List list, GenomeAlign genomeAlign) {
        Project project = ProjectAccesser.getSelectedProject();
        CoreGeneSetAddDialog coreGeneSetAddDialog = CoreGeneSetAddDialog.getInstanse(component);
        coreGeneSetAddDialog.updateValue(project.getProjectName());
        coreGeneSetAddDialog.setVisible(true);
        if (coreGeneSetAddDialog.isCanceled()) {
            return;
        }
        GeneSet geneSet = coreGeneSetAddDialog.createGeneSet();
        CoreGeneTargetCondition coreGeneTargetCondition = coreGeneSetAddDialog.createCondition();
        CoreGeneSetCreater coreGeneSetCreater = new CoreGeneSetCreater((Component)this.m_mainWindow, (MediatorImpl)this, this.m_clusterTbl, geneSet, coreGeneTargetCondition, list, genomeAlign);
        String[] stringArray = new String[]{"Prepare...", "Create gene set...", "Save..."};
        ProgressDialog.executeProgress(component, (MediatorImpl)this, 1, stringArray, true, (ProcessImpl)coreGeneSetCreater);
    }

    @Override
    public void showCoreGeneSetDialog(Component component, List list, List list2) {
        Project project = ProjectAccesser.getSelectedProject();
        CoreGeneSetAddDialog coreGeneSetAddDialog = CoreGeneSetAddDialog.getInstanse(component);
        coreGeneSetAddDialog.updateValue(project.getProjectName());
        coreGeneSetAddDialog.setVisible(true);
        if (coreGeneSetAddDialog.isCanceled()) {
            return;
        }
        GeneSet geneSet = coreGeneSetAddDialog.createGeneSet();
        CoreGeneTargetCondition coreGeneTargetCondition = coreGeneSetAddDialog.createCondition();
        CoreGeneSetCreater coreGeneSetCreater = new CoreGeneSetCreater((Component)this.m_mainWindow, (MediatorImpl)this, this.m_clusterTbl, geneSet, coreGeneTargetCondition, list, list2);
        String[] stringArray = new String[]{"Prepare...", "Create gene set...", "Save..."};
        ProgressDialog.executeProgress(component, (MediatorImpl)this, 1, stringArray, true, (ProcessImpl)coreGeneSetCreater);
    }

    @Override
    public void searchTaxonomyTreePath(TaxSearchCondition taxSearchCondition) {
        TaxonomyTreeNode taxonomyTreeNode = (TaxonomyTreeNode)this.m_taxonomyTree.getModel().getRoot();
        TaxTreeSearchExecuter taxTreeSearchExecuter = new TaxTreeSearchExecuter(this, this.m_mainWindow, taxSearchCondition, taxonomyTreeNode);
        taxTreeSearchExecuter.execute(new DummyProgressComponent());
        taxTreeSearchExecuter.done();
    }

    @Override
    public void mergeCluster(Collection collection) {
        try {
            Cluster cluster = this.m_clusterTbl.mergeCluster(collection);
            this.resetMainWindowNotClearView();
            this.selectClusterOnPPM(this.m_clusterTbl.getSelectedOrganismCode(), null, cluster);
        }
        catch (Exception exception) {
            String string = "Fail to merge cluster.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void releaseMergeCluster(Collection collection) {
        try {
            if (!this.removeClusterSetRelatedCluster(collection)) {
                return;
            }
            Set set = this.m_clusterTbl.releaseMergeCluster(collection);
            this.resetMainWindowNotClearView();
            this.updateSelectedCluster(this.m_clusterTbl.getSelectedOrganismCode(), null, set, false);
        }
        catch (Exception exception) {
            String string = "Fail to relase merge cluster.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showMergeDialog() {
        if (!this.m_clusterTbl.isExistHClustResult()) {
            MessageManager.showMessage((Component)this.m_mainWindow, "There is no PhyloPatClust");
            return;
        }
        double d = 0.0;
        double d2 = this.m_clusterTbl.get_hClustMaxDist();
        MergeAllExecuteDialog mergeAllExecuteDialog = new MergeAllExecuteDialog(this.m_mainWindow, this, this.m_clusterTbl, d, d2);
        mergeAllExecuteDialog.setVisible(true);
        if (mergeAllExecuteDialog.isCanceled()) {
            return;
        }
        double d3 = mergeAllExecuteDialog.getThreshold();
        try {
            this.m_mainWindow.setCursor(this.m_waitCursor);
            this.m_clusterTbl.mergeAllCluster(d3);
            this.resetMainWindowNotClearView();
        }
        catch (Exception exception) {
            String string = "Fail to merge all clusters.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releasePPCMergeCluster() {
        try {
            this.m_mainWindow.setCursor(this.m_waitCursor);
            this.m_clusterTbl.releaseMergeCluster4All();
            this.resetMainWindowNotClearView();
        }
        catch (Exception exception) {
            String string = "Fail to relase merge clusters.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    @Override
    public void releaseAllMergeCluster() {
        try {
            List list = this.m_clusterTbl.getMergeClusterList();
            if (!this.removeClusterSetRelatedCluster(list)) {
                return;
            }
            Set set = this.m_clusterTbl.releaseAllMergeCluster();
            this.resetMainWindowNotClearView();
            this.updateSelectedCluster(this.m_clusterTbl.getSelectedOrganismCode(), null, set, false);
        }
        catch (Exception exception) {
            String string = "Fail to relase merge clusters.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    private boolean removeClusterSetRelatedCluster(Collection collection) throws Exception {
        Set set = ClusterSetFacade.getClusterSetIncludeCluster(collection);
        if (!CollectionUtil.isNull(set)) {
            String string = AbstractElementSetFacade.createElementSetNameString(set);
            Object[] objectArray = new String[]{"Remove cluster set included merge/split clusters as follow?", string};
            if (!MessageManager.showConfirmMessage((Component)this.m_mainWindow, objectArray)) {
                return false;
            }
            ClusterSetFacade.getInstance().deleteElementSet(set);
            this.updateClusterSetTree();
        }
        return true;
    }

    @Override
    public void splitCluster(Cluster cluster, Collection collection) {
        try {
            List list = this.m_clusterTbl.splitCluster(cluster, collection);
            this.resetMainWindowNotClearView();
            this.updateSelectedCluster(this.m_clusterTbl.getSelectedOrganismCode(), list, false);
        }
        catch (Exception exception) {
            String string = "Fail to split cluster.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void releaseSplitCluster(Collection collection) {
        try {
            if (!this.removeClusterSetRelatedCluster(collection)) {
                return;
            }
            Set set = this.m_clusterTbl.releaseSplitCluster(collection);
            this.resetMainWindowNotClearView();
            this.updateSelectedCluster(this.m_clusterTbl.getSelectedOrganismCode(), set, false);
        }
        catch (Exception exception) {
            String string = "Fail to relase split cluster.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void releaseAllSplitCluster() {
        try {
            List list = this.m_clusterTbl.getSplitClusterList();
            if (!this.removeClusterSetRelatedCluster(list)) {
                return;
            }
            Set set = this.m_clusterTbl.releaseAllSplitCluster();
            this.resetMainWindowNotClearView();
            this.updateSelectedCluster(this.m_clusterTbl.getSelectedOrganismCode(), set, false);
        }
        catch (Exception exception) {
            String string = "Fail to relase split cluster.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void mergeOrganism(Collection collection) {
        try {
            OrganismMergeExecuter organismMergeExecuter = new OrganismMergeExecuter(this.m_mainWindow, this, this.m_clusterTbl, collection);
            String[] stringArray = new String[]{"Split organism..."};
            ProgressDialog.executeProgress((Component)this.m_mainWindow, (MediatorImpl)this, 100, stringArray, true, (ProcessImpl)organismMergeExecuter);
        }
        catch (Exception exception) {
            String string = "Fail to merge organisms. " + OrganismUtil.getOrganismCodeList(collection);
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void releaseMergeOrganism(Collection collection) {
        try {
            this.m_clusterTbl.releaseMergeOrganism(collection);
            this.resetMainWindowNotClearView();
            this.updateTaxonomyTree();
            this.updateOrganismColumnTree();
            this.updatePatternTree();
            this.updateOrganismSetTree();
        }
        catch (Exception exception) {
            String string = "Fail to relase merge organism. " + OrganismUtil.getOrganismCodeList(collection);
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void releaseAllMergeOrganism() {
        try {
            List list = ModifiedOrganismManager.getInstance().getMergeOrganismList();
            this.releaseMergeOrganism(list);
            this.resetMainWindowNotClearView();
            this.updateTaxonomyTree();
            this.updateOrganismColumnTree();
            this.updatePatternTree();
            this.updateOrganismSetTree();
        }
        catch (Exception exception) {
            String string = "Fail to relase merge organism.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void splitOrganism(String string) {
        OrganismSplitDialog2 organismSplitDialog2 = new OrganismSplitDialog2(this.m_mainWindow);
        organismSplitDialog2.updateValue(this.m_clusterTbl.getOrganism(string), this.m_clusterTbl.getViewOrganismList(), this.m_clusterTbl.getClusterList());
        organismSplitDialog2.setVisible(true);
        if (organismSplitDialog2.isCanceled()) {
            return;
        }
        List list = organismSplitDialog2.getSearchConditionList();
        OrganismSplitCondition organismSplitCondition = new OrganismSplitCondition();
        organismSplitCondition.setOrganism(this.m_clusterTbl.getOrganism(string));
        organismSplitCondition.setSearchConditionList(list);
        OrganismSplitExecuter organismSplitExecuter = new OrganismSplitExecuter(this.m_mainWindow, this, this.m_clusterTbl, organismSplitCondition);
        String[] stringArray = new String[]{"Split organism..."};
        ProgressDialog.executeProgress((Component)this.m_mainWindow, (MediatorImpl)this, 100, stringArray, true, (ProcessImpl)organismSplitExecuter);
    }

    @Override
    public void releaseSplitOrganism(Collection collection) {
        try {
            this.m_clusterTbl.releaseSplitOrganism(collection);
            this.resetMainWindowNotClearView();
            this.updateTaxonomyTree();
            this.updateOrganismColumnTree();
            this.updatePatternTree();
            this.updateOrganismSetTree();
        }
        catch (Exception exception) {
            String string = "Fail to relase split organisms. " + OrganismUtil.getOrganismCodeList(collection);
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void releaseAllSplitOrganisms() {
        try {
            List list = ModifiedOrganismManager.getInstance().getSplitOrganismList();
            this.releaseSplitOrganism(list);
        }
        catch (Exception exception) {
            String string = "Fail to relase split organisms.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void showServerGeneInfoListDialog(Component component) {
        try {
            Project project;
            List list;
            HashSet hashSet = new HashSet();
            if (this.m_clusterTbl != null) {
                hashSet.addAll(ModifiedOrganismManager.getInstance().convertSystemOrganismCodeList(this.m_clusterTbl.getOrganismCodeList()));
            }
            if (CollectionUtil.isNull(list = GeneInfoFacade.downloadGeneInfoTitleList(hashSet, project = ProjectAccesser.getSelectedProject()))) {
                MessageManager.showMessage(component, "There is no gene property on server.");
                return;
            }
            ServerGeneListDialog serverGeneListDialog = ServerGeneListDialog.createInstance(component, this, hashSet);
            serverGeneListDialog.updateValue(list);
            serverGeneListDialog.setVisible(true);
        }
        catch (Exception exception) {
            String string = "Fail to download gene property list from server.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage(component, string);
        }
    }

    @Override
    public void showServerClusterInfoListDialog(Component component) {
        try {
            Project project = ProjectAccesser.getSelectedProject();
            List list = ClusterInfoFacade.downloadClusterInfoTitleList(this.m_clusterTbl.getClusterId(), project);
            if (CollectionUtil.isNull(list)) {
                MessageManager.showMessage(component, "There is no cluster property on server.");
                return;
            }
            ServerClusterListDialog serverClusterListDialog = ServerClusterListDialog.createInstance(component, this);
            serverClusterListDialog.updateValue(list, this.m_clusterTbl);
            serverClusterListDialog.setVisible(true);
        }
        catch (Exception exception) {
            String string = "Fail to download cluster property list from server.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage(component, string);
        }
    }

    @Override
    public void showServerGeneSetListDialog(Component component) {
        try {
            Project project = ProjectAccesser.getSelectedProject();
            List list = GeneSetFacade.downloadGeneSetList(project);
            if (CollectionUtil.isNull(list)) {
                MessageManager.showMessage(component, "There is no gene set on server.");
                return;
            }
            ServerGeneSetListDialog serverGeneSetListDialog = ServerGeneSetListDialog.getInstance(component, this);
            serverGeneSetListDialog.updateValue(list);
            serverGeneSetListDialog.setVisible(true);
        }
        catch (Exception exception) {
            String string = "Fail to download gene set list from server.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage(component, string);
        }
    }

    @Override
    public void showServerClusterSetListDialog(Component component) {
        try {
            if (this.m_clusterTbl == null) {
                return;
            }
            Project project = ProjectAccesser.getSelectedProject();
            List list = ClusterSetFacade.downloadClusterSetList(this.m_clusterTbl, project);
            if (CollectionUtil.isNull(list)) {
                MessageManager.showMessage(component, "There is no cluster set on server.");
                return;
            }
            ServerClusterSetDialog serverClusterSetDialog = ServerClusterSetDialog.createInstance(component, this);
            serverClusterSetDialog.updateValue(list, this.m_clusterTbl);
            serverClusterSetDialog.setVisible(true);
        }
        catch (Exception exception) {
            String string = "Fail to download cluster set list from server.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage(component, string);
        }
    }

    @Override
    public void uploadGeneSet(Component component, Collection collection, Runnable runnable) {
        if (CollectionUtil.isNull(collection)) {
            return;
        }
        List list = AbstractElementSetFacade.getElementSetNameList(collection);
        UploadDialog uploadDialog = UploadDialog.createInstance(component);
        uploadDialog.updateValue("gene set", list);
        uploadDialog.setVisible(true);
        if (uploadDialog.isCanceled()) {
            return;
        }
        Project project = ProjectAccesser.getSelectedProject();
        SetUploadExecuter setUploadExecuter = new SetUploadExecuter(component, collection, project);
        setUploadExecuter.setAfterRunnable(runnable);
        if (component instanceof Dialog) {
            new ProgressDialog((Dialog)component, (MediatorImpl)this, 1, "Upload gene set...", false, (ProcessImpl)setUploadExecuter);
        } else if (component instanceof Frame) {
            new ProgressDialog((Frame)component, (MediatorImpl)this, 1, "Upload gene set...", false, (ProcessImpl)setUploadExecuter);
        }
    }

    @Override
    public void uploadClusterSet(Component component, Collection collection, Runnable runnable) {
        List list = new ArrayList();
        try {
            list = ClusterSetFacade.filterClusterSetListByServer(collection);
        }
        catch (Exception exception) {
            String string = "Fail to read cluster set information.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage(component, string);
            return;
        }
        if (CollectionUtil.isNull(list)) {
            return;
        }
        List list2 = AbstractElementSetFacade.getElementSetNameList(list);
        UploadDialog uploadDialog = UploadDialog.createInstance(component);
        uploadDialog.updateValue("cluster set", list2);
        uploadDialog.setVisible(true);
        if (uploadDialog.isCanceled()) {
            return;
        }
        Project project = ProjectAccesser.getSelectedProject();
        SetUploadExecuter setUploadExecuter = new SetUploadExecuter(component, list, project);
        setUploadExecuter.setAfterRunnable(runnable);
        if (component instanceof Dialog) {
            new ProgressDialog((Dialog)component, (MediatorImpl)this, 1, "Upload cluster set...", false, (ProcessImpl)setUploadExecuter);
        } else if (component instanceof Frame) {
            new ProgressDialog((Frame)component, (MediatorImpl)this, 1, "Upload cluster set...", false, (ProcessImpl)setUploadExecuter);
        }
    }

    @Override
    public void showServerProjectList() {
        try {
            List list = ProjectAccesser.downloadProjectList();
            if (CollectionUtil.isNull(list)) {
                String string = "There is no project on server. [" + AccessServer.getInstance().getServerUrl() + "]";
                MessageManager.showMessage((Component)this.m_mainWindow, string);
                return;
            }
            ServerProjectListDialog serverProjectListDialog = new ServerProjectListDialog(this.m_mainWindow);
            serverProjectListDialog.updateValue(list);
            serverProjectListDialog.setVisible(true);
            if (serverProjectListDialog.isCanceled()) {
                return;
            }
            Project project = serverProjectListDialog.getSelectedProject();
            String string = AccessServer.getInstance().getServerUrl();
            Project project2 = ProjectAccesser.getProjectById(project.getProjectId());
            if (project2 != null && project2.getServerUrl() != null && !project2.getServerUrl().equals(string)) {
                project2 = null;
            }
            Project project3 = ProjectAccesser.getProject(project.getProjectName());
            Project project4 = null;
            if (project2 != null && !project.getProjectName().equals(project2.getProjectName())) {
                Object[] objectArray = new String[]{"The project [#Id " + project.getProjectId4Server() + "] name was changed from [" + project2.getProjectName() + "] to [" + project.getProjectName() + "]", "Overwrite this project?"};
                if (!MessageManager.showConfirmMessage((Component)this.m_mainWindow, objectArray)) {
                    return;
                }
                project4 = project2;
            } else if (project2 == null && project3 != null) {
                if (!MessageManager.showConfirmMessage((Component)this.m_mainWindow, "Overwrite project [" + project.getProjectName() + "]?")) {
                    return;
                }
                project4 = project3;
            } else if (project2 != null) {
                if (!MessageManager.showConfirmMessage((Component)this.m_mainWindow, "Overwrite project [" + project.getProjectName() + "]?")) {
                    return;
                }
                project4 = project2;
            }
            ProjectAccesser.updateProjectInfo(project4, project);
            this.changeSelectProject(project);
        }
        catch (Exception exception) {
            String string = "Fail to download project list from server. " + AccessServer.getInstance().getServerUrl();
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string);
        }
    }

    @Override
    public void uploadDomClust() {
        try {
            AnalysisUploadDialog analysisUploadDialog = AnalysisUploadDialog.createInstance(this.m_mainWindow, true);
            String string = "Upload domclust results on server";
            analysisUploadDialog.updateValue(this.m_clusterTbl.getDomClustName(), "", string);
            analysisUploadDialog.setVisible(true);
            if (analysisUploadDialog.isCanceled()) {
                return;
            }
            boolean bl = analysisUploadDialog.isOverwrite();
            boolean bl2 = analysisUploadDialog.isViewParameters();
            String string2 = analysisUploadDialog.getAnalysisName();
            String string3 = analysisUploadDialog.getDescription();
            DomClustAnalysis domClustAnalysis = this.m_clusterTbl.createDomClustProperty();
            domClustAnalysis.setName(string2);
            domClustAnalysis.setDescription(string3);
            DomClustUploadExecuter domClustUploadExecuter = new DomClustUploadExecuter(this.m_mainWindow, this.m_clusterTbl, domClustAnalysis, bl, bl2);
            new ProgressDialog((Frame)this.m_mainWindow, (MediatorImpl)this, 1, "Upload domclust on server...", false, (ProcessImpl)domClustUploadExecuter);
        }
        catch (Exception exception) {
            String string = "Fail to register the domclust file on this project.";
            logger.warn(string, exception);
        }
    }

    @Override
    public void uploadCoreGenome(final Component component, final GenomeAlign genomeAlign) {
        try {
            final CoreGenomeAnalysis coreGenomeAnalysis = genomeAlign.getCoreGenomeAnalysis();
            AnalysisUploadDialog analysisUploadDialog = AnalysisUploadDialog.createInstance(component, false);
            String string = "Upload core genome alignment results on server";
            analysisUploadDialog.updateValue(coreGenomeAnalysis.getName(), coreGenomeAnalysis.getDescription(), string);
            analysisUploadDialog.setVisible(true);
            if (analysisUploadDialog.isCanceled()) {
                return;
            }
            boolean bl = analysisUploadDialog.isOverwrite();
            String string2 = analysisUploadDialog.getAnalysisName();
            String string3 = analysisUploadDialog.getDescription();
            final Project project = ProjectAccesser.getSelectedProject();
            final CoreGenomeAnalysis coreGenomeAnalysis2 = CoreGenomeFacade.createCoreGenomeAnalysis(string2, string3, this.m_clusterTbl.getClusterId(), genomeAlign.getCoreGenomeId());
            coreGenomeAnalysis2.setProject(project);
            CoreGenomeUploadExecuter coreGenomeUploadExecuter = new CoreGenomeUploadExecuter(component, coreGenomeAnalysis2, bl);
            coreGenomeUploadExecuter.setAfterRunnable(new Runnable(){

                @Override
                public void run() {
                    try {
                        CoreGenomeFacade.saveCoreGenomeAnalysis(project, coreGenomeAnalysis, coreGenomeAnalysis2);
                        String string = CoreGenomeFacade.renameCoreGenomeFile(project, coreGenomeAnalysis.getName(), coreGenomeAnalysis2.getName());
                        genomeAlign.setCoreGenomeAnalysis(coreGenomeAnalysis2);
                        genomeAlign.setFilepath(string);
                    }
                    catch (IOException iOException) {
                        String string = "Fail to upload core genome alignment.";
                        logger.warn(string, iOException);
                        MessageManager.showErrorMessage(component, string);
                    }
                }
            });
            new ProgressDialog((Frame)component, (MediatorImpl)this, 1, "Uplod core genome alignment on server...", false, (ProcessImpl)coreGenomeUploadExecuter);
        }
        catch (Exception exception) {
            String string = "Fail to upload core genome alignment result.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage(component, string);
        }
    }

    @Override
    public boolean isOpenedDomClust(Project project, File file) throws IOException {
        String string;
        String string2 = ProjectAccesser.getSelectedProject().getProjectName();
        if (project.getProjectName().compareTo(string2) != 0) {
            return false;
        }
        if (this.m_clusterTbl != null) {
            string = this.m_clusterTbl.getFilepath();
            if (string != null && file.getCanonicalPath().compareToIgnoreCase(string) == 0) {
                return true;
            }
            String string3 = this.m_clusterTbl.getDisplayDomClustName();
            if (FileUtil.removeExtension(file.getName()).compareTo(string3) == 0) {
                return true;
            }
        }
        if (this.coreGenomeFrame != null) {
            string = this.coreGenomeFrame.getCoreGenomeViewModel().getGenomeAlign().getFilepath();
            if (string == null) {
                return false;
            }
            if (file.getAbsolutePath().compareTo(string) == 0) {
                return true;
            }
        }
        return false;
    }
}

