/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.color.geneinfo;

import cgdp.recog.color.ColorFacade;
import cgdp.recog.color.geneinfo.GeneColorCondition;
import cgdp.recog.color.geneinfo.GeneColorExporter;
import cgdp.recog.color.geneinfo.GeneColorImporter;
import cgdp.recog.controltree.NodeLabel;
import cgdp.recog.data.AbstractMultiCluster;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.SuperCluster;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.project.Project;
import cgdp.recog.system.property.ApplicationPropertyAccessable;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.MapUtil;
import cgdp.recog.util.StringTool;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GeneColorConditionGroup
implements NodeLabel,
ApplicationPropertyAccessable {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneColorConditionGroup.class);
    public static final String PROPERTY_FILE_NAME = "propertyColor";
    static final int CALC_METHOD_NO_SELECT = -1;
    public static final int CALC_METHOD_ALL_SPECIES = 1;
    static final int CALC_METHOD_EVERY_SPECIES = 2;
    private Map organismColorCondMap = new HashMap();
    private boolean showGeneColor = false;
    private int calcMethodType = -1;

    public void clear() {
        this.organismColorCondMap = new HashMap();
        this.showGeneColor = false;
        this.calcMethodType = -1;
    }

    public void addGeneColorCondition(GeneColorCondition geneColorCondition) {
        Set set = geneColorCondition.getOrganismCodeSet();
        for (String string : set) {
            GeneColorCondition geneColorCondition2 = (GeneColorCondition)this.organismColorCondMap.get(string);
            if (geneColorCondition2 != null) {
                geneColorCondition2.removeOrganismCode(string);
            }
            this.organismColorCondMap.put(string, geneColorCondition);
        }
    }

    private GeneColorCondition getGeneColorCondition(String string) {
        return (GeneColorCondition)this.organismColorCondMap.get(string);
    }

    public AbstractInfoTitle getInfoTitle(String string) {
        GeneColorCondition geneColorCondition = this.getGeneColorCondition(string);
        if (geneColorCondition == null) {
            return null;
        }
        return geneColorCondition.getInfoTitle();
    }

    public Set getInfoTitleSet() {
        HashSet<AbstractInfoTitle> hashSet = new HashSet<AbstractInfoTitle>();
        for (GeneColorCondition geneColorCondition : this.organismColorCondMap.values()) {
            hashSet.add(geneColorCondition.getInfoTitle());
        }
        return hashSet;
    }

    public boolean containsInfoTitle(AbstractInfoTitle abstractInfoTitle) {
        for (String string : this.organismColorCondMap.keySet()) {
            GeneColorCondition geneColorCondition = (GeneColorCondition)this.organismColorCondMap.get(string);
            if (!geneColorCondition.getInfoTitle().equals(abstractInfoTitle)) continue;
            return true;
        }
        return false;
    }

    public Color getColor(Cluster cluster, String string, String string2) {
        GeneColorCondition geneColorCondition = this.getGeneColorCondition(string);
        if (geneColorCondition == null) {
            return ColorFacade.getInstance().getBlankColor(string);
        }
        if (geneColorCondition.getInfoTitle().isGene()) {
            return this.getColor(string, string2);
        }
        if (geneColorCondition.getInfoTitle().isCell()) {
            return this.getColorByCell(string, cluster);
        }
        return this.getColor(string, cluster);
    }

    public Color getColorByCell(String string, Cluster cluster) {
        Object object;
        Cluster cluster2 = cluster;
        if (cluster instanceof SuperCluster) {
            object = ((SuperCluster)cluster).getSubClusterList();
            if (CollectionUtil.isNull((Collection)object)) {
                return ColorFacade.getInstance().getBlankColor(string);
            }
            cluster2 = (Cluster)object.get(0);
        }
        if ((object = this.getGeneColorCondition(string)) == null) {
            return ColorFacade.getInstance().getBlankColor(string);
        }
        Color color = ((GeneColorCondition)object).getColor(string, cluster2);
        if (color == null) {
            color = ColorFacade.getInstance().getBlankColor(string);
        }
        return color;
    }

    public Color getColor(String string, Cluster cluster) {
        GeneColorCondition geneColorCondition = this.getGeneColorCondition(string);
        if (geneColorCondition == null) {
            return ColorFacade.getInstance().getBlankColor(string);
        }
        Color color = geneColorCondition.getColor(cluster);
        if (color == null) {
            color = ColorFacade.getInstance().getBlankColor(string);
        }
        return color;
    }

    public Color getColor(String string, String string2) {
        GeneColorCondition geneColorCondition = this.getGeneColorCondition(string);
        if (geneColorCondition == null) {
            return ColorFacade.getInstance().getBlankColor(string);
        }
        Color color = geneColorCondition.getColor(string, string2);
        if (color == null) {
            color = ColorFacade.getInstance().getBlankColor(string);
        }
        return color;
    }

    public GeneColorCondition getGeneColorCommonCondition(Set set) {
        GeneColorCondition geneColorCondition = null;
        for (String string : set) {
            GeneColorCondition geneColorCondition2 = (GeneColorCondition)this.organismColorCondMap.get(string);
            if (geneColorCondition2 == null) {
                return null;
            }
            if (geneColorCondition == null) {
                geneColorCondition = geneColorCondition2;
                continue;
            }
            if (geneColorCondition.equalsCondition(geneColorCondition2)) continue;
            return null;
        }
        return geneColorCondition;
    }

    public boolean isShowGeneColor() {
        return this.showGeneColor;
    }

    public boolean isEnableShow() {
        return this.isShowGeneColor() && this.isExistGeneColor();
    }

    public boolean isExistGeneColor() {
        return !MapUtil.isNull(this.organismColorCondMap);
    }

    public void setShowGeneColor(boolean bl) {
        this.showGeneColor = bl;
    }

    public void removeGeneColorCondition(Set set) {
        for (String string : set) {
            GeneColorCondition geneColorCondition = (GeneColorCondition)this.organismColorCondMap.remove(string);
            geneColorCondition.removeOrganismCode(string);
        }
    }

    public Map getClusterColorMapByCell(String string, Cluster cluster) {
        return null;
    }

    public Map getClusterColorMap(String string, Cluster cluster) {
        List list;
        Object object;
        if (cluster instanceof SuperCluster) {
            object = (SuperCluster)cluster;
            list = ((AbstractMultiCluster)object).getSubClusterList();
        } else {
            list = new ArrayList<Cluster>();
            list.add(cluster);
        }
        object = new LinkedHashMap();
        for (Cluster cluster2 : list) {
            Color color = this.getColor(string, cluster2);
            object.put(cluster2, color);
        }
        return object;
    }

    public Map getColorLocusTagMap(String string, List list) {
        LinkedHashMap<Color, ArrayList<String>> linkedHashMap = new LinkedHashMap<Color, ArrayList<String>>();
        for (String string2 : list) {
            Color color = this.getColor(string, GeneUtil.removeDomainNo(string2));
            ArrayList<String> arrayList = (ArrayList<String>)linkedHashMap.get(color);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                linkedHashMap.put(color, arrayList);
            }
            arrayList.add(string2);
        }
        return linkedHashMap;
    }

    public int getCalcMethodType() {
        return this.calcMethodType;
    }

    public void setCalcMethodType(int n) {
        this.calcMethodType = n;
    }

    public static boolean isAllSpecies(int n) {
        return n == 1;
    }

    public static boolean isEverySpecies(int n) {
        return n == 2;
    }

    Map getOrganismColorCondMap() {
        return this.organismColorCondMap;
    }

    Set getGeneColorConditionSet() {
        return new HashSet(this.organismColorCondMap.values());
    }

    @Override
    public String getLabel() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GeneColorCondition geneColorCondition : this.getGeneColorConditionSet()) {
            arrayList.add(geneColorCondition.getInfoTitle().getName());
        }
        return StringTool.conbineStrList(arrayList, ",");
    }

    private static String getPropertyFilepath(Project project, String string) {
        String string2 = ApplicationPropertyFacade.getPropertyDirectory(project, string) + PROPERTY_FILE_NAME;
        return string2;
    }

    public static String getPropertyFilepath(String string) {
        return new File(string, PROPERTY_FILE_NAME).getAbsolutePath();
    }

    @Override
    public String getCategory() {
        return "ColorGeneInfo";
    }

    @Override
    public List getPropertyList(Project project, String string) {
        String string2 = GeneColorConditionGroup.getPropertyFilepath(project, string);
        try {
            GeneColorExporter geneColorExporter = new GeneColorExporter(string2, this);
            geneColorExporter.execute();
        }
        catch (IOException iOException) {
            String string3 = "Fail to save set condition group information. " + string2;
            logger.warn(string3, iOException);
        }
        return null;
    }

    @Override
    public int getPropertyType() {
        return 2;
    }

    @Override
    public void updateProperty(Map map, Project project, String string) {
        String string2 = GeneColorConditionGroup.getPropertyFilepath(project, string);
        if (StringTool.isNull(string2)) {
            return;
        }
        if (!new File(string2).isFile()) {
            return;
        }
        try {
            GeneColorImporter geneColorImporter = new GeneColorImporter(string2, this);
            geneColorImporter.execute();
        }
        catch (IOException iOException) {
            String string3 = "Fail to load set condition group information. " + string2;
            logger.warn(string3, iOException);
        }
    }
}

