/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.color.geneinfo;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.geneinfo.ColorBarPanel;
import cgdp.recog.color.geneinfo.ColorValue;
import cgdp.recog.color.geneinfo.GeneColorCondition;
import cgdp.recog.color.geneinfo.GeneColorPalette;
import cgdp.recog.color.geneinfo.GenePropertySummary;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoOptionLinkLabel;
import cgdp.recog.info.InfoTitleComboBox;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.info.cell.CellInfoFacade;
import cgdp.recog.info.cell.CellInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.organism.AbstractMultiOrganism;
import cgdp.recog.organism.MultiOrganism;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismComboBox;
import cgdp.recog.organism.OrganismFactory;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.process.ThreadManager;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.BasicLabelColor;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.ColorLegendPanel;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.LabelColor;
import cgdp.recog.util.LabelColorTable;
import cgdp.recog.util.MathUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.RestrictTextField;
import cgdp.recog.util.StringTool;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Color;
import java.awt.Component;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GeneColorDialog
extends AbstractApplyDialog
implements ItemListener {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneColorDialog.class);
    private static final Dimension ENUM_TABLE_SIZE = new Dimension(510, 160);
    private static final String TITLE = "Color genes by properties";
    private static final int MIN_COLOR_PANEL_COUNT = 2;
    private static final int MAX_COLOR_PANEL_COUNT = 4;
    private static final String NO_COND_KEY = "#NONE#";
    private MediatorImpl mediator;
    private OrganismComboBox organismComboBox;
    private InfoTitleComboBox infoTitleComboBox;
    private InfoOptionLinkLabel infoOptionLinkLabel;
    private ColorBarPanel colorBarPanel;
    private JPanel colorSetPanel;
    private List colorValueList = new ArrayList();
    private JPanel orderPanel;
    private GenePropertySummary nowSummary;
    private Map cacheBasicInfoMap = new HashMap();
    private JPanel numColorPanel;
    private JButton addColorButton;
    private JButton removeColorButton;
    private JButton autoValueButton;
    private JCheckBox autoUpdateValueCheckBox;
    private JPanel enumColorPanel;
    private LabelColorTable enumColorTable;
    private JRadioButton rankButton;
    private JRadioButton valueButton;
    private JRadioButton allSpeciesButton;
    private JRadioButton everySpeciesButton;
    private List organismList = new ArrayList();
    private List clusterList = new ArrayList();
    private ClusterTbl clusterTbl;

    private GeneColorDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    private GeneColorDialog(Dialog dialog, MediatorImpl mediatorImpl) {
        super(dialog);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    public static GeneColorDialog getInstance(Component component, MediatorImpl mediatorImpl) {
        if (component instanceof Dialog) {
            return new GeneColorDialog((Dialog)component, mediatorImpl);
        }
        if (component instanceof Frame) {
            return new GeneColorDialog((Frame)component, mediatorImpl);
        }
        return null;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        JLabel jLabel = new JLabel("Organism");
        this.organismComboBox = new OrganismComboBox();
        this.organismComboBox.addItemListener(this);
        JLabel jLabel2 = new JLabel("Property");
        this.infoTitleComboBox = new InfoTitleComboBox(){

            @Override
            protected void processItemStateChanged(ItemEvent itemEvent) {
                GeneColorDialog.this.setVisibleColorPanel();
                if (GeneColorDialog.this.isAutoUpdateValue()) {
                    GeneColorDialog.this.initColorValue(true);
                }
            }
        };
        this.infoOptionLinkLabel = new InfoOptionLinkLabel("Option...", this, this.infoTitleComboBox);
        this.infoOptionLinkLabel.setVisible(false);
        this.orderPanel = this.createColorByPanel();
        this.numColorPanel = this.createNumColorPanel();
        this.enumColorPanel = this.createEnumColorPanel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.numColorPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.enumColorPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder("Color"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.organismComboBox, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 5, 15), 0, 0));
        this.getContentPane().add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.infoTitleComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 5, 15), 0, 0));
        this.getContentPane().add((Component)this.infoOptionLinkLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 15), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 15, 10, 15), 0, 0));
        this.getContentPane().add((Component)this.orderPanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 0, new Insets(5, 15, 5, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 5, 3, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 10, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createNumColorPanel() {
        this.addColorButton = new JButton("Add color");
        this.addColorButton.addActionListener(this);
        this.removeColorButton = new JButton("Remove color");
        this.removeColorButton.addActionListener(this);
        this.autoValueButton = new JButton("Auto value");
        this.autoValueButton.addActionListener(this);
        this.addColorButton.setPreferredSize(this.removeColorButton.getPreferredSize());
        this.autoValueButton.setPreferredSize(this.removeColorButton.getPreferredSize());
        this.autoUpdateValueCheckBox = new JCheckBox("automatically update value");
        this.autoUpdateValueCheckBox.setSelected(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.addColorButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.removeColorButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.autoValueButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.colorBarPanel = new ColorBarPanel();
        this.colorSetPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)this.colorBarPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 0, 0), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(1, 0, 1, 2, 0.0, 1.0, 11, 2, new Insets(5, 10, 0, 10), 0, 0));
        jPanel2.add((Component)this.colorSetPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 0, 0), 0, 0));
        return jPanel2;
    }

    private JPanel createEnumColorPanel() {
        this.enumColorTable = new LabelColorTable();
        JScrollPane jScrollPane = new JScrollPane(this.enumColorTable, 20, 31);
        jScrollPane.setPreferredSize(ENUM_TABLE_SIZE);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 5, 10), 0, 0));
        return jPanel;
    }

    private JPanel createColorByPanel() {
        JLabel jLabel = new JLabel("Color by");
        this.rankButton = new JRadioButton("Rank");
        this.rankButton.addActionListener(this);
        this.valueButton = new JRadioButton("Value");
        this.valueButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rankButton);
        buttonGroup.add(this.valueButton);
        this.valueButton.setSelected(true);
        JLabel jLabel2 = new JLabel("The method for assigning a rank");
        this.allSpeciesButton = new JRadioButton("All species");
        this.everySpeciesButton = new JRadioButton("Every species");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.allSpeciesButton);
        buttonGroup2.add(this.everySpeciesButton);
        this.allSpeciesButton.setSelected(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.valueButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.rankButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.allSpeciesButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.everySpeciesButton, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return jPanel;
    }

    private void updateColorPanel() {
        this.colorSetPanel.removeAll();
        this.colorSetPanel.setLayout(new GridBagLayout());
        int n = 0;
        for (ColorValue colorValue : this.colorValueList) {
            ColorValuePanel colorValuePanel = new ColorValuePanel(n);
            colorValuePanel.updateValue(colorValue.getValueAsDouble(), colorValue.getColor());
            this.colorSetPanel.add((Component)colorValuePanel, new GridBagConstraints(n / 2, n % 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
            ++n;
        }
        this.colorSetPanel.add((Component)this.orderPanel, new GridBagConstraints(0, n / 2 + 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.colorSetPanel.add((Component)this.autoUpdateValueCheckBox, new GridBagConstraints(0, n / 2 + 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.colorBarPanel.updateValue(this.colorValueList, this.nowSummary);
        ContainerOrderFocusTraversalPolicy containerOrderFocusTraversalPolicy = new ContainerOrderFocusTraversalPolicy(){

            @Override
            protected boolean accept(Component component) {
                if (component instanceof JPanel) {
                    return false;
                }
                if (component instanceof JLabel) {
                    return false;
                }
                if (component instanceof JLayeredPane) {
                    return false;
                }
                if (component instanceof JRootPane) {
                    return false;
                }
                if (component instanceof JDialog) {
                    return false;
                }
                return super.accept(component);
            }
        };
        this.setFocusTraversalPolicy(containerOrderFocusTraversalPolicy);
        this.getContentPane().validate();
        this.getContentPane().repaint();
        this.pack();
    }

    private List getColorValueList() {
        if (this.getInfoTitle().isNumeric()) {
            return this.colorValueList;
        }
        ArrayList<ColorValue> arrayList = new ArrayList<ColorValue>();
        List list = this.enumColorTable.getLabelColorList();
        for (LabelColor labelColor : list) {
            ColorValue colorValue = new ColorValue(labelColor.getLabel(), labelColor.getColor());
            arrayList.add(colorValue);
        }
        return arrayList;
    }

    private List getCopyColorValueList() {
        List list = this.getColorValueList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ColorValue colorValue : list) {
            arrayList.add(colorValue.clone());
        }
        return arrayList;
    }

    public void updateValue(ClusterTbl clusterTbl, Set set, List list, List list2, GeneColorCondition geneColorCondition) {
        Object object2;
        Iterator iterator;
        this.clusterTbl = clusterTbl;
        this.clusterList = list2;
        this.cacheBasicInfoMap.clear();
        this.organismList = new ArrayList(list);
        MultiOrganism multiOrganism = OrganismFactory.createAllOrganism(this.organismList);
        this.organismList.add(0, multiOrganism);
        ArrayList<BasicLabelColor> arrayList = OrganismFactory.createMetagenomeOrganism(this.organismList);
        if (arrayList != null) {
            this.organismList.add(1, arrayList);
        }
        if (CollectionUtil.isNull(set)) {
            this.organismComboBox.removeItemListener(this);
            this.organismComboBox.updateValueByOrganism(this.organismList);
            this.organismComboBox.setSelectedIndex(0);
            this.organismComboBox.addItemListener(this);
        } else if (set.size() == 1) {
            this.organismComboBox.removeItemListener(this);
            this.organismComboBox.updateValueByOrganism(this.organismList);
            arrayList = (String)set.iterator().next();
            this.organismComboBox.setSelectedOrganismCode((String)((Object)arrayList));
            this.organismComboBox.addItemListener(this);
        } else {
            arrayList = new ArrayList(set);
            Collections.sort(arrayList);
            iterator = OrganismUtil.getOrganismList(arrayList);
            object2 = OrganismFactory.createSetOrganism();
            ((AbstractMultiOrganism)object2).setOrganismList((List)((Object)iterator));
            this.organismList.add(1, object2);
            this.organismComboBox.removeItemListener(this);
            this.organismComboBox.updateValueByOrganism(this.organismList);
            this.organismComboBox.setSelectedOrganismCode(((MultiOrganism)object2).getOrganismCode());
            this.organismComboBox.addItemListener(this);
        }
        this.updateGeneInfoTitleItems();
        if (geneColorCondition != null) {
            this.infoTitleComboBox.removeItemListener(this.infoTitleComboBox);
            this.infoTitleComboBox.setSelectedItem(geneColorCondition.getInfoTitle().getName());
            this.infoTitleComboBox.addItemListener(this.infoTitleComboBox);
            if (geneColorCondition.getInfoTitle().isNumeric()) {
                this.colorValueList.clear();
                this.colorValueList.addAll(geneColorCondition.getCopyColorValueList());
                if (GeneColorCondition.isOrder(geneColorCondition.getOrderType())) {
                    this.rankButton.setSelected(true);
                } else {
                    this.valueButton.setSelected(true);
                }
            } else {
                arrayList = new ArrayList<BasicLabelColor>();
                for (Object object2 : geneColorCondition.getColorValueList()) {
                    BasicLabelColor basicLabelColor = new BasicLabelColor(String.valueOf(((ColorValue)object2).getValue()), ((ColorValue)object2).getColor());
                    arrayList.add(basicLabelColor);
                }
                this.enumColorTable.setLabelColorList(arrayList);
            }
            if (geneColorCondition.getInfoTitle().isNumeric()) {
                this.runCreateSummary(this.getInfoTitle());
            }
        } else {
            this.colorValueList.clear();
            arrayList = GeneColorPalette.getColorList(2);
            iterator = new ColorValue(1.0, (Color)arrayList.get(0));
            object2 = new ColorValue(100.0, (Color)arrayList.get(1));
            this.colorValueList.add(iterator);
            this.colorValueList.add(object2);
            this.initColorValue(true);
        }
        this.setVisibleColorPanel();
        this.pack();
    }

    private void setVisibleColorPanel() {
        AbstractInfoTitle abstractInfoTitle = this.getInfoTitle();
        if (abstractInfoTitle.isNumeric()) {
            this.numColorPanel.setVisible(true);
            this.enumColorPanel.setVisible(false);
        } else {
            this.numColorPanel.setVisible(false);
            this.enumColorPanel.setVisible(true);
        }
    }

    private void updateGeneInfoTitleItems() {
        Organism organism = this.organismComboBox.getSelectedOrganism();
        HashSet<String> hashSet = new HashSet<String>();
        if (organism instanceof MultiOrganism) {
            hashSet.addAll(((MultiOrganism)organism).getOrganismCodeList());
        } else {
            hashSet.add(organism.getOrganismCode());
        }
        List list = this.getInfoTitleList(hashSet);
        this.infoTitleComboBox.updateInfoTitleItems(list);
    }

    private List getInfoTitleList(Set set) {
        List list = GeneInfoFacade.getGeneInfoTitleList(set);
        HashSet hashSet = new HashSet(InfoUtil.filterByType(list, 1));
        hashSet.addAll(InfoUtil.filterByType(list, 3));
        list.retainAll(hashSet);
        list.addAll(ClusterInfoFacade.getInfoTitleListByAnalysisKey("UseGeneColor", this.clusterTbl));
        list.addAll(CellInfoFacade.getInfoTitleListByAnalysisKey("UseGeneColor", this.clusterTbl));
        return list;
    }

    private AbstractInfoTitle getInfoTitle() {
        return this.infoTitleComboBox.getSelectedInfoTitle();
    }

    private Set getOrganismCodeSet() {
        if (this.getInfoTitle().isGene() || this.getInfoTitle().isCell()) {
            return this.organismComboBox.getSelectedOrganismCodeSet();
        }
        return new HashSet(OrganismUtil.getOrganismCodeList(this.organismList));
    }

    public int getCalcMethodType() {
        int n = this.allSpeciesButton.isSelected() ? 1 : 2;
        return n;
    }

    private int getOrderType() {
        if (this.getInfoTitle().isNumeric()) {
            int n = 1;
            if (this.valueButton.isSelected()) {
                n = 2;
            }
            return n;
        }
        return 2;
    }

    private boolean isOrder() {
        return this.getOrderType() == 1;
    }

    private boolean isAutoUpdateValue() {
        return this.autoUpdateValueCheckBox.isSelected();
    }

    public GeneColorCondition createGeneColorCondition() {
        GeneColorCondition geneColorCondition = new GeneColorCondition();
        geneColorCondition.setOrganismCodeSet(this.getOrganismCodeSet());
        geneColorCondition.setInfoTitle(this.getInfoTitle());
        geneColorCondition.setOrderType(this.getOrderType());
        geneColorCondition.setColorValueList(this.getCopyColorValueList());
        geneColorCondition.setMultiInfoType(this.getInfoTitle().getMultiInfoType());
        return geneColorCondition;
    }

    @Override
    protected boolean check() {
        if (this.getInfoTitle().isNumeric()) {
            double d = -3.4028234663852886E38;
            for (ColorValue colorValue : this.colorValueList) {
                if (!StringTool.isDouble(String.valueOf(colorValue.getValue()))) {
                    MessageManager.showErrorMessage((Component)this, "Input value.");
                    return false;
                }
                if (d > colorValue.getValueAsDouble()) {
                    MessageManager.showErrorMessage((Component)this, "Invalid value. " + d + " > " + colorValue.getValueAsDouble());
                    return false;
                }
                d = colorValue.getValueAsDouble();
            }
        }
        return true;
    }

    @Override
    protected boolean apply() {
        return true;
    }

    private void addColor() {
        double d;
        if (this.colorValueList.size() >= 4) {
            return;
        }
        ColorValue colorValue = (ColorValue)this.colorValueList.get(0);
        ColorValue colorValue2 = (ColorValue)this.colorValueList.get(1);
        if (this.isOrder()) {
            double d2 = this.nowSummary.getValue(colorValue.getValueAsDouble(), 1);
            double d3 = this.nowSummary.getValue(colorValue2.getValueAsDouble(), 1);
            int n = (int)((d2 + d3) / 2.0);
            d = this.nowSummary.getValue(n);
        } else {
            d = MathUtil.roundDecimal((colorValue.getValueAsDouble() + colorValue2.getValueAsDouble()) / 2.0, 1);
        }
        ColorValue colorValue3 = new ColorValue();
        colorValue3.setValue(new Float(d));
        this.colorValueList.add(1, colorValue3);
        List list = GeneColorPalette.getColorList(this.colorValueList.size());
        for (int i = 0; i < this.colorValueList.size(); ++i) {
            Color color = (Color)list.get(i % list.size());
            ColorValue colorValue4 = (ColorValue)this.colorValueList.get(i);
            colorValue4.setColor(color);
        }
        this.updateColorPanel();
    }

    private void removeColor() {
        if (this.colorValueList.size() <= 2) {
            return;
        }
        this.colorValueList.remove(1);
        this.updateColorPanel();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.addColorButton) {
            this.addColor();
        } else if (actionEvent.getSource() == this.removeColorButton) {
            this.removeColor();
        } else if (actionEvent.getSource() == this.autoValueButton) {
            this.initColorValue(true);
        } else if (actionEvent.getSource() == this.rankButton) {
            if (this.isAutoUpdateValue()) {
                this.initColorValue(true);
            }
        } else if (actionEvent.getSource() == this.valueButton && this.isAutoUpdateValue()) {
            this.initColorValue(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.organismComboBox && this.isAutoUpdateValue()) {
            this.updateGeneInfoTitleItems();
            this.initColorValue(false);
        }
    }

    private void initColorValue(final boolean bl) {
        final AbstractInfoTitle abstractInfoTitle = this.getInfoTitle();
        if (abstractInfoTitle == null || abstractInfoTitle.equalsKey(NO_COND_KEY)) {
            return;
        }
        if (abstractInfoTitle.isNumeric()) {
            ThreadManager threadManager = ThreadManager.getInstance();
            threadManager.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        GeneColorDialog.this.createSummary(abstractInfoTitle);
                        if (bl) {
                            if (GeneColorDialog.this.isOrder()) {
                                int n = GeneColorDialog.this.nowSummary.getValueListSize();
                                double d = (double)n / (double)(GeneColorDialog.this.colorValueList.size() - 1);
                                for (int i = 0; i < GeneColorDialog.this.colorValueList.size(); ++i) {
                                    ColorValue colorValue = (ColorValue)GeneColorDialog.this.colorValueList.get(i);
                                    int n2 = (int)(d * (double)i);
                                    if (i == GeneColorDialog.this.colorValueList.size() - 1) {
                                        n2 = n - 1;
                                    }
                                    double d2 = MathUtil.roundDecimal(GeneColorDialog.this.nowSummary.getValue(n2), 1);
                                    colorValue.setValue(new Float(d2));
                                }
                            } else {
                                double d = GeneColorDialog.this.nowSummary.getMin();
                                double d3 = GeneColorDialog.this.nowSummary.getMax();
                                double d4 = (d3 - d) / (double)(GeneColorDialog.this.colorValueList.size() - 1);
                                for (int i = 0; i < GeneColorDialog.this.colorValueList.size(); ++i) {
                                    ColorValue colorValue = (ColorValue)GeneColorDialog.this.colorValueList.get(i);
                                    double d5 = i == 0 ? MathUtil.roundDecimal(d, 1) : (i == GeneColorDialog.this.colorValueList.size() - 1 ? MathUtil.roundDecimal(d3, 1) : MathUtil.roundDecimal(d4 * (double)i + d, 1));
                                    colorValue.setValue(new Float(d5));
                                }
                            }
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GeneColorDialog.this.updateColorPanel();
                            }
                        });
                    }
                    catch (Exception exception) {
                        String string = "Fail to calc gene property summary.";
                        logger.warn(string, exception);
                    }
                }
            });
        } else {
            List list = abstractInfoTitle.getElementList();
            List list2 = GeneColorPalette.getMultiColorList();
            ArrayList<BasicLabelColor> arrayList = new ArrayList<BasicLabelColor>();
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                Color color = (Color)list2.get(i % list2.size());
                BasicLabelColor basicLabelColor = new BasicLabelColor(string, color);
                arrayList.add(basicLabelColor);
            }
            this.enumColorTable.setLabelColorList(arrayList);
        }
    }

    private void runCreateSummary(final AbstractInfoTitle abstractInfoTitle) {
        ThreadManager threadManager = ThreadManager.getInstance();
        threadManager.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GeneColorDialog.this.createSummary(abstractInfoTitle);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GeneColorDialog.this.updateColorPanel();
                        }
                    });
                }
                catch (Exception exception) {
                    String string = "Fail to calc gene property summary.";
                    logger.warn(string, exception);
                }
            }
        });
    }

    private void createSummary(AbstractInfoTitle abstractInfoTitle) throws Exception {
        String string = StringTool.conbineStrList(this.getOrganismCodeSet(), ":");
        GenePropertySummary genePropertySummary = (GenePropertySummary)this.cacheBasicInfoMap.get(string = string + ":" + abstractInfoTitle.getKey());
        if (genePropertySummary == null) {
            List list = new ArrayList();
            if (abstractInfoTitle.isGene()) {
                list = this.getValueListForGeneInfo(abstractInfoTitle);
            } else if (abstractInfoTitle.isCluster()) {
                list = this.getValueListForClusterInfo(abstractInfoTitle);
            } else if (abstractInfoTitle.isCell()) {
                list = this.getValueListForCellInfo(abstractInfoTitle);
            }
            list = CollectionUtil.removeNaNInfinity(list);
            Collections.sort(list);
            double d = ((Float)list.get(0)).doubleValue();
            double d2 = ((Float)list.get(list.size() - 1)).doubleValue();
            double d3 = CollectionUtil.average(list);
            double d4 = ((Float)CollectionUtil.median(list)).doubleValue();
            int n = 0;
            int n2 = -1;
            int n3 = -1;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                double d5 = ((Float)iterator.next()).doubleValue();
                if (d5 > d3) {
                    n2 = n;
                    break;
                }
                ++n;
            }
            if (n2 == -1) {
                n2 = n;
            }
            if (n3 == -1) {
                n3 = list.size() / 2;
            }
            genePropertySummary = new GenePropertySummary(this.getOrderType(), list.size(), d, d2, d3, d4, n2, n3, list);
            this.cacheBasicInfoMap.put(string, genePropertySummary);
        }
        genePropertySummary.setOrderType(this.getOrderType());
        this.nowSummary = genePropertySummary;
    }

    private List getValueListForClusterInfo(AbstractInfoTitle abstractInfoTitle) throws Exception {
        List list = ClusterInfoFacade.createValueList(this.clusterList, (ClusterInfoTitle)abstractInfoTitle, this.clusterTbl.getClusterId());
        list = this.adjustMultiValue(abstractInfoTitle, list);
        return list;
    }

    private List getValueListForCellInfo(AbstractInfoTitle abstractInfoTitle) throws Exception {
        ArrayList arrayList = new ArrayList();
        for (String string : this.getOrganismCodeSet()) {
            List list = CellInfoFacade.createValueList(string, this.clusterList, (CellInfoTitle)abstractInfoTitle);
            list = this.adjustMultiValue(abstractInfoTitle, list);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private List getValueListForGeneInfo(AbstractInfoTitle abstractInfoTitle) throws Exception {
        ArrayList arrayList = new ArrayList();
        for (String string : this.getOrganismCodeSet()) {
            List list = GeneInfoFacade.createValueList(this.clusterList, string, (GeneInfoTitle)abstractInfoTitle);
            list = this.adjustMultiValue(abstractInfoTitle, list);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private List adjustMultiValue(AbstractInfoTitle abstractInfoTitle, List list) {
        if (abstractInfoTitle.isMulti()) {
            ArrayList arrayList = new ArrayList();
            for (Object e : list) {
                arrayList.addAll(AbstractInfoTitle.splitMultiData(e, abstractInfoTitle.getType()));
            }
            return arrayList;
        }
        return list;
    }

    private class ColorValuePanel
    extends JPanel {
        private int index;
        private JLabel titleLabel;
        private ColorLegendPanel colorPanel;
        private RestrictTextField valueTextField;

        ColorValuePanel(int n) {
            this.index = n;
            this.createComponents();
        }

        private void createComponents() {
            this.titleLabel = new JLabel(String.valueOf(this.index + 1));
            this.colorPanel = new ColorLegendPanel(Color.green){

                @Override
                protected void afterAction() {
                    ColorValue colorValue = (ColorValue)GeneColorDialog.this.colorValueList.get(ColorValuePanel.this.index);
                    colorValue.setColor(this.getBackground());
                    GeneColorDialog.this.colorBarPanel.updateValue(GeneColorDialog.this.colorValueList, GeneColorDialog.this.nowSummary);
                    GeneColorDialog.this.repaint();
                }
            };
            this.valueTextField = new RestrictTextField(8);
            this.valueTextField.setNegative(true);
            this.valueTextField.setDecimal(true);
            this.valueTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    ColorValuePanel.this.updateColorValue();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    ColorValuePanel.this.updateColorValue();
                }
            });
            this.setLayout(new GridBagLayout());
            this.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.colorPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)this.valueTextField, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        }

        void updateValue(double d, Color color) {
            this.colorPanel.setColor(ColorUtil.color2Str(color));
            this.valueTextField.setText(String.valueOf(d));
        }

        Color getColor() {
            return ColorUtil.str2Color(this.colorPanel.getColor());
        }

        double getValue() {
            return Double.parseDouble(this.valueTextField.getText());
        }

        private void updateColorValue() {
            double d;
            ColorValue colorValue = (ColorValue)GeneColorDialog.this.colorValueList.get(this.index);
            try {
                d = this.getValue();
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            if (colorValue.getValueAsDouble() == d) {
                return;
            }
            colorValue.setValue(new Float(d));
            GeneColorDialog.this.colorBarPanel.updateValue(GeneColorDialog.this.colorValueList, GeneColorDialog.this.nowSummary);
            GeneColorDialog.this.repaint();
        }
    }
}

