/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.controltree;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.controltree.AbstractControlTree;
import cgdp.recog.controltree.ControlTitleNode;
import cgdp.recog.controltree.ControlTitleType;
import cgdp.recog.controltree.ControlTree;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.organism.OrganismSetTreeController;
import cgdp.recog.set.SetCombinationTreeController;
import cgdp.recog.set.cluster.ClusterSetCombinationTreeController;
import cgdp.recog.set.cluster.ClusterSetTreeController;
import cgdp.recog.set.gene.GeneSetCombinationTreeController;
import cgdp.recog.set.gene.GeneSetTreeController;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class SetTree
extends AbstractControlTree {
    private GeneSetTreeController geneSetTreeController;
    private ClusterSetTreeController clusterSetTreeController;
    private SetCombinationTreeController geneSetCombinationTreeController;
    private SetCombinationTreeController clusterSetCombinationTreeController;
    private OrganismSetTreeController organismSetTreeController;

    public SetTree(Frame frame, MediatorImpl mediatorImpl) {
        super(frame, mediatorImpl);
    }

    @Override
    protected void createComponents() {
        this.geneSetTreeController = new GeneSetTreeController(this.parent, this.mediator);
        this.clusterSetTreeController = new ClusterSetTreeController(this.parent, this.mediator);
        this.geneSetCombinationTreeController = new GeneSetCombinationTreeController(this.parent, this.mediator);
        this.clusterSetCombinationTreeController = new ClusterSetCombinationTreeController(this.parent, this.mediator);
        this.organismSetTreeController = new OrganismSetTreeController(this.parent, this.mediator);
    }

    @Override
    protected MutableTreeNode createTreeStructure() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        defaultMutableTreeNode.setUserObject("root");
        ControlTitleNode controlTitleNode = ControlTree.createControlTitleNode("Gene Set", 50);
        defaultMutableTreeNode.add(controlTitleNode);
        this.geneSetTreeController.createTree(controlTitleNode);
        ControlTitleNode controlTitleNode2 = ControlTree.createControlTitleNode("Gene Set Combination", 70);
        defaultMutableTreeNode.add(controlTitleNode2);
        this.geneSetCombinationTreeController.createTree(controlTitleNode2);
        ControlTitleNode controlTitleNode3 = ControlTree.createControlTitleNode("Cluster Set", 60);
        defaultMutableTreeNode.add(controlTitleNode3);
        this.clusterSetTreeController.createTree(controlTitleNode3);
        ControlTitleNode controlTitleNode4 = ControlTree.createControlTitleNode("Cluster Set Combination", 80);
        defaultMutableTreeNode.add(controlTitleNode4);
        this.clusterSetCombinationTreeController.createTree(controlTitleNode4);
        ControlTitleNode controlTitleNode5 = ControlTree.createControlTitleNode("Organism Set", 82);
        defaultMutableTreeNode.add(controlTitleNode5);
        this.organismSetTreeController.createTree(controlTitleNode5);
        return defaultMutableTreeNode;
    }

    @Override
    protected void setVisibleRoot() {
        this.setRootVisible(false);
    }

    @Override
    protected void showPopup(Point point) {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        int n = this.getControlTitleType();
        JPopupMenu jPopupMenu = this.createPopupMenu(n);
        if (jPopupMenu != null) {
            jPopupMenu.show(this, point.x, point.y);
        }
    }

    @Override
    protected JPopupMenu createPopupMenu(int n) {
        JPopupMenu jPopupMenu = null;
        if (ControlTitleType.isGeneSet(n)) {
            jPopupMenu = this.geneSetTreeController.createPopupMenu(this, this);
        } else if (ControlTitleType.isClusterSet(n)) {
            jPopupMenu = this.clusterSetTreeController.createPopupMenu(this, this);
        } else if (ControlTitleType.isGeneSetCombination(n)) {
            jPopupMenu = this.geneSetCombinationTreeController.createPopupMenu(this, this);
        } else if (ControlTitleType.isClusterSetCombination(n)) {
            jPopupMenu = this.clusterSetCombinationTreeController.createPopupMenu(this, this);
        } else if (ControlTitleType.isOrganismSet(n)) {
            jPopupMenu = this.organismSetTreeController.createPopupMenu(this, this);
        }
        return jPopupMenu;
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterSetTreeController.setClusterTbl(clusterTbl);
        this.geneSetCombinationTreeController.setClusterTbl(clusterTbl);
        this.clusterSetCombinationTreeController.setClusterTbl(clusterTbl);
        this.organismSetTreeController.setClusterTbl(clusterTbl);
        this.updateTree();
    }

    public void updateGeneSetTree() {
        ControlTitleNode controlTitleNode = this.getTitleNode(50);
        controlTitleNode.removeAllChildren();
        this.geneSetTreeController.createTree(controlTitleNode);
        this.reload();
    }

    public void updateClusterSetTree() {
        ControlTitleNode controlTitleNode = this.getTitleNode(60);
        controlTitleNode.removeAllChildren();
        this.clusterSetTreeController.createTree(controlTitleNode);
        this.reload();
    }

    public void updateGeneSetCombinationTree() {
        ControlTitleNode controlTitleNode = this.getTitleNode(70);
        controlTitleNode.removeAllChildren();
        this.geneSetCombinationTreeController.createTree(controlTitleNode);
        this.reload();
    }

    public void updateClusterSetCombinationTree() {
        ControlTitleNode controlTitleNode = this.getTitleNode(80);
        controlTitleNode.removeAllChildren();
        this.clusterSetCombinationTreeController.createTree(controlTitleNode);
        this.reload();
    }

    public void updateOrganismSetTree() {
        ControlTitleNode controlTitleNode = this.getTitleNode(82);
        controlTitleNode.removeAllChildren();
        this.organismSetTreeController.createTree(controlTitleNode);
        this.reload();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.actionAfterDoubleClick();
        } else {
            this.actionAfterClick();
        }
    }

    private void actionAfterDoubleClick() {
        TreePath treePath = this.getSelectionPath();
        if (treePath == null) {
            return;
        }
        int n = this.getControlTitleType();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (ControlTitleType.isGeneSet(n)) {
            this.geneSetTreeController.actionAfterDoubleClick(defaultMutableTreeNode);
        } else if (ControlTitleType.isClusterSet(n)) {
            this.clusterSetTreeController.actionAfterDoubleClick(defaultMutableTreeNode);
        } else if (ControlTitleType.isGeneSetCombination(n)) {
            this.geneSetCombinationTreeController.actionAfterDoubleClick(defaultMutableTreeNode);
        } else if (ControlTitleType.isClusterSetCombination(n)) {
            this.clusterSetCombinationTreeController.actionAfterDoubleClick(defaultMutableTreeNode);
        } else if (ControlTitleType.isOrganismSet(n)) {
            this.organismSetTreeController.actionAfterDoubleClick(defaultMutableTreeNode);
        }
    }

    private void actionAfterClick() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return;
        }
        int n = this.getControlTitleType();
        List list = this.getTreeNodeList(treePathArray);
        if (ControlTitleType.isOrganismSet(n)) {
            this.organismSetTreeController.actionAfterClick(list);
        }
    }
}

